/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.datasource.PooledDataSourceFactory;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.datasource.ClientConnectionFactoryWrapper;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.DataSourceCreateException;
import org.apache.geode.internal.datasource.FacetsJCAConnectionManagerImpl;
import org.apache.geode.internal.datasource.GemFireBasicDataSource;
import org.apache.geode.internal.datasource.GemFireTransactionDataSource;
import org.apache.geode.internal.datasource.JCAConnectionManagerImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.logging.log4j.Logger;

public class DataSourceFactory {
    private static final Logger logger = LogService.getLogger();
    private static final String DEFAULT_CONNECTION_POOL_DS_CLASS = "org.apache.geode.connectors.jdbc.JdbcPooledDataSourceFactory";
    private static final String POOL_PREFIX = "pool.";
    @MutableForTesting
    private static String TEST_CONNECTION_URL = null;
    @MutableForTesting
    private static String TEST_CONNECTION_HOST = null;
    @MutableForTesting
    private static String TEST_CONNECTION_PORT = null;

    public DataSource getSimpleDataSource(Map configMap) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = this.createDataSourceProperties(configMap);
        if (configs.getURL() == null) {
            logger.error("DataSourceFactory::getSimpleDataSource:URL String to Database is null");
            throw new DataSourceCreateException("DataSourceFactory::getSimpleDataSource:URL String to Database is null");
        }
        try {
            return new GemFireBasicDataSource(configs);
        }
        catch (Exception ex) {
            logger.error(String.format("DataSourceFactory::getSimpleDataSource:Exception while creating GemfireBasicDataSource.Exception String=%s", ex.getLocalizedMessage()), (Throwable)ex);
            throw new DataSourceCreateException(String.format("DataSourceFactory::getSimpleDataSource:Exception while creating GemfireBasicDataSource.Exception String=%s", ex.getLocalizedMessage()), ex);
        }
    }

    public ClientConnectionFactoryWrapper getManagedDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        Object cf = null;
        ManagedConnectionFactory mcf = null;
        ConfiguredDataSourceProperties configs = this.createDataSourceProperties(configMap);
        if (configs.getMCFClass() == null) {
            logger.error("DataSourceFactory::getManagedDataSource:Managed Connection factory class is not available");
            throw new DataSourceCreateException("DataSourceFactory::getManagedDataSource:Managed Connection factory class is not available");
        }
        try {
            Class<?> cl = ClassPathLoader.getLatest().forName(configs.getMCFClass());
            mcf = (ManagedConnectionFactory)cl.newInstance();
            this.invokeAllMethods(cl, mcf, props);
        }
        catch (Exception ex) {
            logger.error(String.format("DataSourceFactory::getManagedDataSource: Exception in creating managed connection factory. Exception string, %s", ex));
            throw new DataSourceCreateException(String.format("DataSourceFactory::getManagedDataSource: Exception in creating managed connection factory. Exception string, %s", ex));
        }
        Object cm = null;
        cm = configs.getMCFClass().equals("org.apache.persistence.connection.internal.ConnFactory") ? new FacetsJCAConnectionManagerImpl(mcf, configs) : new JCAConnectionManagerImpl(mcf, configs);
        try {
            cf = mcf.createConnectionFactory((ConnectionManager)cm);
        }
        catch (Exception ex) {
            logger.error("DataSourceFactory::getManagedDataSource: Exception in creating managed connection factory. Exception string, %s", (Object)ex.toString());
            throw new DataSourceCreateException(String.format("DataSourceFactory::getManagedDataSource: Exception in creating managed connection factory. Exception string, %s", ex));
        }
        return new ClientConnectionFactoryWrapper(cf, cm);
    }

    public DataSource getPooledDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = this.createDataSourceProperties(configMap);
        String connpoolClassName = configs.getConnectionPoolDSClass();
        if (connpoolClassName == null) {
            connpoolClassName = DEFAULT_CONNECTION_POOL_DS_CLASS;
        }
        try {
            Properties poolProperties = DataSourceFactory.createPoolProperties(configMap, props);
            Properties dataSourceProperties = DataSourceFactory.createDataSourceProperties(props);
            Class<?> cl = ClassPathLoader.getLatest().forName(connpoolClassName);
            PooledDataSourceFactory factory = (PooledDataSourceFactory)cl.newInstance();
            return factory.createDataSource(poolProperties, dataSourceProperties);
        }
        catch (Exception ex) {
            String exception = String.format("DataSourceFactory::getPooledDataSource:Exception creating ConnectionPoolDataSource.Exception string=%s", ex);
            logger.error(String.format("DataSourceFactory::getPooledDataSource:Exception creating ConnectionPoolDataSource.Exception string=%s", ex), (Throwable)ex);
            throw new DataSourceCreateException(exception, ex);
        }
    }

    static Properties createPoolProperties(Map<String, String> configMap, List<ConfigProperty> props) {
        Properties result = new Properties();
        if (props != null) {
            for (ConfigProperty configProperty : props) {
                if (!configProperty.getName().toLowerCase().startsWith(POOL_PREFIX)) continue;
                String poolName = configProperty.getName().substring(POOL_PREFIX.length());
                result.setProperty(poolName, configProperty.getValue());
            }
        }
        if (configMap != null) {
            for (Map.Entry entry : configMap.entrySet()) {
                if (entry.getValue() == null || ((String)entry.getValue()).equals("") || ((String)entry.getKey()).equals("type") || ((String)entry.getKey()).equals("jndi-name") || ((String)entry.getKey()).equals("transaction-type") || ((String)entry.getKey()).equals("conn-pooled-datasource-class") || ((String)entry.getKey()).equals("managed-conn-factory-class") || ((String)entry.getKey()).equals("xa-datasource-class")) continue;
                result.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }

    static Properties createDataSourceProperties(List<ConfigProperty> props) {
        Properties result = new Properties();
        if (props != null) {
            for (ConfigProperty prop : props) {
                if (prop.getName().toLowerCase().startsWith(POOL_PREFIX)) continue;
                result.setProperty(prop.getName(), prop.getValue());
            }
        }
        return result;
    }

    public DataSource getTranxDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = this.createDataSourceProperties(configMap);
        String xaClassName = configs.getXADSClass();
        if (xaClassName == null) {
            logger.error("DataSourceFactory::getTranxDataSource:XADataSource class name for the ResourceManager is not available");
            throw new DataSourceCreateException("DataSourceFactory::getTranxDataSource:XADataSource class name for the ResourceManager is not available");
        }
        if (TEST_CONNECTION_HOST != null) {
            props.add(new ConfigProperty("serverName", TEST_CONNECTION_HOST, "java.lang.String"));
        }
        if (TEST_CONNECTION_PORT != null) {
            props.add(new ConfigProperty("portNumber", TEST_CONNECTION_PORT, "int"));
        }
        try {
            Class<?> cl = ClassPathLoader.getLatest().forName(xaClassName);
            Object Obj = cl.newInstance();
            this.invokeAllMethods(cl, Obj, props);
            return new GemFireTransactionDataSource((XADataSource)Obj, configs);
        }
        catch (Exception ex) {
            String exception = String.format("DataSourceFactory::getTranxDataSource:Exception in creating GemFireTransactionDataSource. Exception string=%s", ex);
            logger.error(String.format("DataSourceFactory::getTranxDataSource:Exception in creating GemFireTransactionDataSource. Exception string=%s", ex), (Throwable)ex);
            throw new DataSourceCreateException(exception, ex);
        }
    }

    private ConfiguredDataSourceProperties createDataSourceProperties(Map configMap) {
        ConfiguredDataSourceProperties configs = new ConfiguredDataSourceProperties();
        for (Map.Entry entry : configMap.entrySet()) {
            String name = (String)entry.getKey();
            Object obj = entry.getValue();
            if (name.equals("connection-url")) {
                configs.setURL((String)obj);
                continue;
            }
            if (name.equals("user-name")) {
                configs.setUser((String)obj);
                continue;
            }
            if (name.equals("password")) {
                configs.setPassword(PasswordUtil.decrypt((String)obj));
                continue;
            }
            if (name.equals("jdbc-driver-class")) {
                configs.setJDBCDriver((String)obj);
                continue;
            }
            if (name.equals("init-pool-size")) {
                configs.setInitialPoolSize(Integer.parseInt(obj == null ? String.valueOf(10) : obj));
                continue;
            }
            if (name.equals("max-pool-size")) {
                configs.setMaxPoolSize(Integer.parseInt(obj == null ? String.valueOf(30) : obj));
                continue;
            }
            if (name.equals("idle-timeout-seconds")) {
                configs.setConnectionExpirationTime(Integer.parseInt(obj == null ? String.valueOf(600) : obj));
                continue;
            }
            if (name.equals("blocking-timeout-seconds")) {
                configs.setConnectionTimeOut(Integer.parseInt(obj == null ? String.valueOf(120) : obj));
                continue;
            }
            if (name.equals("login-timeout-seconds")) {
                configs.setLoginTimeOut(Integer.parseInt(obj == null ? String.valueOf(30) : obj));
                continue;
            }
            if (name.equals("conn-pooled-datasource-class")) {
                configs.setConnectionPoolDSClass((String)obj);
                continue;
            }
            if (name.equals("xa-datasource-class")) {
                configs.setXADSClass((String)obj);
                continue;
            }
            if (name.equals("managed-conn-factory-class")) {
                configs.setMCFClass((String)obj);
                continue;
            }
            if (!name.equals("transaction-type")) continue;
            configs.setTransactionType((String)obj);
        }
        if (TEST_CONNECTION_URL != null) {
            configs.setURL(TEST_CONNECTION_URL);
        }
        return configs;
    }

    public static void setTestConnectionUrl(String url) {
        TEST_CONNECTION_URL = url;
    }

    public static void setTestConnectionHost(String host) {
        TEST_CONNECTION_HOST = host;
    }

    public static void setTestConnectionPort(String port) {
        TEST_CONNECTION_PORT = port;
    }

    private void invokeAllMethods(Class c, Object cpdsObj, List props) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String key = null;
        String value = null;
        String type = null;
        String methodName = null;
        Method m = null;
        for (ConfigProperty cp : props) {
            String exception;
            key = cp.getName();
            value = cp.getValue();
            type = cp.getType();
            if (key.indexOf("password") != -1) {
                value = PasswordUtil.decrypt(String.valueOf(value));
            }
            methodName = new StringBuffer("set").append(Character.toUpperCase(key.charAt(0))).append(key.length() > 1 ? key.substring(1) : "").toString();
            try {
                Class<Integer> cl = null;
                Class<Integer> realClass = null;
                if ("int".equals(type)) {
                    cl = Integer.TYPE;
                    realClass = Integer.class;
                } else {
                    cl = ClassPathLoader.getLatest().forName(type);
                    realClass = cl;
                }
                Constructor cr = realClass.getConstructor(String.class);
                Object ob = cr.newInstance(value);
                m = c.getMethod(methodName, cl);
                m.invoke(cpdsObj, ob);
            }
            catch (ClassNotFoundException ex) {
                exception = String.format("DataSourceFactory::invokeAllMethods: Exception in creating Class with the given config-property-type classname. Exception string=%s", ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                exception = String.format("DataSourceFactory::invokeAllMethods: Exception in creating method using config-property-name property. Exception string=%s", ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                exception = String.format("DataSourceFactory::invokeAllMethods: Exception in creating instance of the class using the constructor with a String parameter. Exception string=%s", ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
        }
    }
}

