/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.util.Gateway;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.logging.log4j.Logger;

public class GatewaySenderAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private DistributedLockService lockService;
    private volatile boolean isPrimary;
    private final Object primaryLock = new Object();
    private final String lockToken;
    private Thread lockObtainingThread;
    private AbstractGatewaySender sender;

    private GatewaySenderAdvisor(DistributionAdvisee sender) {
        super(sender);
        this.sender = (AbstractGatewaySender)sender;
        this.lockToken = this.getDLockServiceName() + "-token";
    }

    public static GatewaySenderAdvisor createGatewaySenderAdvisor(DistributionAdvisee sender) {
        GatewaySenderAdvisor advisor = new GatewaySenderAdvisor(sender);
        advisor.initialize();
        return advisor;
    }

    public String getDLockServiceName() {
        return this.getClass().getName() + "_" + this.sender.getId();
    }

    public Thread getLockObtainingThread() {
        return this.lockObtainingThread;
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new GatewaySenderProfile(memberId, version);
    }

    @Override
    public void profileCreated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            this.checkCompatibility(sp);
        }
    }

    private void checkCompatibility(GatewaySenderProfile sp) {
        if (sp.remoteDSId != this.sender.getRemoteDSId()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with remote ds id %s because another cache has the same Gateway Sender defined with remote ds id %s.", sp.Id, sp.remoteDSId, this.sender.remoteDSId));
        }
        if (sp.isParallel && !this.sender.isParallel()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s as parallel gateway sender because another cache has the same sender as serial gateway sender", sp.Id));
        }
        if (!sp.isParallel && this.sender.isParallel()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s as serial gateway sender because another cache has the same sender as parallel gateway sender", sp.Id));
        }
        if (sp.isBatchConflationEnabled != this.sender.isBatchConflationEnabled()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with isBatchConflationEnabled %s because another cache has the same Gateway Sender defined with isBatchConflationEnabled %s", sp.Id, sp.isBatchConflationEnabled, this.sender.isBatchConflationEnabled()));
        }
        if (sp.isPersistenceEnabled != this.sender.isPersistenceEnabled()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with isPersistentEnabled %s because another cache has the same Gateway Sender defined with isPersistentEnabled %s", sp.Id, sp.isPersistenceEnabled, this.sender.isPersistenceEnabled()));
        }
        if (sp.alertThreshold != this.sender.getAlertThreshold()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with alertThreshold %s because another cache has the same Gateway Sender defined with alertThreshold %s", sp.Id, sp.alertThreshold, this.sender.getAlertThreshold()));
        }
        if (!this.sender.isParallel() && sp.manualStart != this.sender.isManualStart()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with manual start %s because another cache has the same Gateway Sender defined with manual start %s", sp.Id, sp.manualStart, this.sender.isManualStart()));
        }
        if (!sp.isParallel && sp.orderPolicy != this.sender.getOrderPolicy()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with orderPolicy %s because another cache has the same Gateway Sender defined with orderPolicy %s", new Object[]{sp.Id, sp.orderPolicy, this.sender.getOrderPolicy()}));
        }
        ArrayList<String> senderEventFilterClassNames = new ArrayList<String>();
        for (GatewayEventFilter gatewayEventFilter : this.sender.getGatewayEventFilters()) {
            senderEventFilterClassNames.add(gatewayEventFilter.getClass().getName());
        }
        if (sp.eventFiltersClassNames.size() != senderEventFilterClassNames.size()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with GatewayEventFilters %s because another cache has the same Gateway Sender defined with GatewayEventFilters %s", sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        for (String string : senderEventFilterClassNames) {
            if (sp.eventFiltersClassNames.contains(string)) continue;
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with GatewayEventFilters %s because another cache has the same Gateway Sender defined with GatewayEventFilters %s", sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        LinkedHashSet<String> senderTransportFilterClassNames = new LinkedHashSet<String>();
        for (GatewayTransportFilter filter : this.sender.getGatewayTransportFilters()) {
            senderTransportFilterClassNames.add(filter.getClass().getName());
        }
        if (sp.transFiltersClassNames.size() != senderTransportFilterClassNames.size()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with GatewayTransportFilters %s because another cache has the same Gateway Sender defined with GatewayTransportFilters %s", sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        Iterator<String> iterator = sp.transFiltersClassNames.iterator();
        Iterator i2 = senderTransportFilterClassNames.iterator();
        while (iterator.hasNext() && i2.hasNext()) {
            if (iterator.next().equals(i2.next())) continue;
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with GatewayTransportFilters %s because another cache has the same Gateway Sender defined with GatewayTransportFilters %s", sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AsyncEventListener listener : this.sender.getAsyncEventListeners()) {
            arrayList.add(listener.getClass().getName());
        }
        if (sp.senderEventListenerClassNames.size() != arrayList.size()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with AsyncEventListeners %s because another cache has the same Gateway Sender defined with AsyncEventListener %s", sp.Id, sp.senderEventListenerClassNames, arrayList));
        }
        for (String listenerName : arrayList) {
            if (sp.senderEventListenerClassNames.contains(listenerName)) continue;
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with AsyncEventListeners %s because another cache has the same Gateway Sender defined with AsyncEventListener %s", sp.Id, sp.senderEventListenerClassNames, arrayList));
        }
        if (sp.isDiskSynchronous != this.sender.isDiskSynchronous()) {
            throw new IllegalStateException(String.format("Cannot create Gateway Sender %s with isDiskSynchronous %s because another cache has the same Gateway Sender defined with isDiskSynchronous %s", sp.Id, sp.isDiskSynchronous, this.sender.isDiskSynchronous()));
        }
    }

    @Override
    public void profileUpdated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (!sp.isRunning) {
                    if (this.advisePrimaryGatewaySender() != null) {
                        return;
                    }
                    if (!this.sender.isPrimary()) {
                        if (!this.adviseEldestGatewaySender()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                            }
                            return;
                        }
                        this.launchLockObtainingVolunteerThread();
                    }
                } else if (sp.serverLocation != null) {
                    this.sender.setServerLocation(sp.serverLocation);
                }
            }
        }
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (this.advisePrimaryGatewaySender() != null) {
                    return;
                }
                if (!this.sender.isPrimary()) {
                    if (!this.adviseEldestGatewaySender()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                        }
                        return;
                    }
                    this.launchLockObtainingVolunteerThread();
                }
            }
        }
    }

    public boolean isPrimary() {
        return this.sender.isParallel() || this.isPrimary;
    }

    public void initDLockService() {
        InternalDistributedSystem ds = this.sender.getCache().getInternalDistributedSystem();
        String dlsName = this.getDLockServiceName();
        this.lockService = DistributedLockService.getServiceNamed(dlsName);
        if (this.lockService == null) {
            this.lockService = DLockService.create(dlsName, ds, true, true, true);
        }
        Assert.assertTrue(this.lockService != null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Obtained DistributedLockService: {}", (Object)this, (Object)this.lockService);
        }
    }

    public boolean volunteerForPrimary() {
        if (logger.isDebugEnabled()) {
            logger.debug("Sender : {} is volunteering for Primary ", (Object)this.sender.getId());
        }
        if (this.advisePrimaryGatewaySender() == null) {
            if (!this.adviseEldestGatewaySender()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", (Object)this.sender);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Sender : {} no Primary available. So going to acquire distributed lock", (Object)this.sender);
            }
            this.lockService.lock(this.lockToken, 10000L, -1L);
            return this.lockService.isHeldByCurrentThread(this.lockToken);
        }
        return false;
    }

    private boolean adviseEldestGatewaySender() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        TreeSet<Long> senderStartTimes = new TreeSet<Long>();
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            senderStartTimes.add(sp.startTime);
        }
        return senderStartTimes.isEmpty() || this.sender.isRunning() && this.sender.startTime <= (Long)senderStartTimes.first();
    }

    private InternalDistributedMember adviseEldestGatewaySenderNode() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        InternalDistributedMember node = null;
        DistributionAdvisor.Profile eldestProfile = null;
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            if (eldestProfile == null) {
                eldestProfile = sp;
            }
            if (sp.startTime >= ((GatewaySenderProfile)eldestProfile).startTime) continue;
            eldestProfile = sp;
        }
        if (eldestProfile != null) {
            node = eldestProfile.getDistributedMember();
        }
        return node;
    }

    public void makePrimary() {
        logger.info("{} : Starting as primary", (Object)this.sender);
        AbstractGatewaySenderEventProcessor eventProcessor = this.sender.getEventProcessor();
        if (eventProcessor != null) {
            eventProcessor.removeCacheListener();
        }
        logger.info("{} : Becoming primary gateway sender", (Object)this.sender);
        this.notifyAndBecomePrimary();
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAndBecomePrimary() {
        Object object = this.primaryLock;
        synchronized (object) {
            this.setIsPrimary(true);
            this.notifyPrimaryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPrimaryLock() {
        Object object = this.primaryLock;
        synchronized (object) {
            this.primaryLock.notifyAll();
        }
    }

    public void makeSecondary() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Did not obtain the lock on {}. Starting as secondary gateway sender.", (Object)this.sender, (Object)this.lockToken);
        }
        logger.info("{} starting as secondary because primary gateway sender is available on member :{}", new Object[]{this.sender.getId(), this.advisePrimaryGatewaySender()});
        this.isPrimary = false;
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    public void launchLockObtainingVolunteerThread() {
        String threadName = "Gateway Sender Primary Lock Acquisition Thread Volunteer";
        this.lockObtainingThread = new LoggingThread(threadName, () -> {
            this.sender.getLifeCycleLock().readLock().lock();
            try {
                if (!this.sender.isRunning()) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Obtaining the lock on {}", (Object)this, (Object)this.lockToken);
                }
                if (this.volunteerForPrimary()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Obtained the lock on {}", (Object)this, (Object)this.lockToken);
                    }
                    logger.info("{} is becoming primary gateway Sender.", (Object)this);
                    this.makePrimary();
                }
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                if (!this.sender.getStopper().isCancelInProgress()) {
                    logger.fatal(String.format("%s: The thread to obtain the failover lock was interrupted. This gateway sender will never become the primary.", this), (Throwable)e);
                }
            }
            finally {
                this.sender.getLifeCycleLock().readLock().unlock();
            }
        });
        this.lockObtainingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBecomePrimary(AbstractGatewaySenderEventProcessor callingProcessor) throws InterruptedException {
        if (this.isPrimary()) {
            return;
        }
        Object object = this.primaryLock;
        synchronized (object) {
            logger.info("{} : Waiting to become primary gateway", (Object)this.sender.getId());
            while (!this.isPrimary()) {
                this.primaryLock.wait(1000L);
                if (this.sender.getEventProcessor() == null || !callingProcessor.isStopped()) continue;
                logger.info("The event processor is stopped, not to wait for being primary any more.");
                return;
            }
        }
    }

    public InternalDistributedMember advisePrimaryGatewaySender() {
        DistributionAdvisor.Profile[] snapshot;
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isPrimary) continue;
            return sp.getDistributedMember();
        }
        return null;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Override
    public void close() {
        new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
        super.close();
    }

    public static class GatewaySenderProfile
    extends DistributionAdvisor.Profile {
        public String Id;
        public long startTime;
        public int remoteDSId;
        public boolean isRunning;
        public boolean isPrimary;
        public boolean isParallel;
        public boolean isBatchConflationEnabled;
        public boolean isPersistenceEnabled;
        public int alertThreshold;
        public boolean manualStart;
        public ArrayList<String> eventFiltersClassNames = new ArrayList();
        public ArrayList<String> transFiltersClassNames = new ArrayList();
        public ArrayList<String> senderEventListenerClassNames = new ArrayList();
        public boolean isDiskSynchronous;
        public int dispatcherThreads;
        public GatewaySender.OrderPolicy orderPolicy;
        public ServerLocation serverLocation;
        @Immutable
        private static final Version[] serializationVersions = new Version[]{Version.GFE_80};

        public GatewaySenderProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public GatewaySenderProfile() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            Gateway.OrderPolicy oldOrderPolicy;
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_90) < 0 ? ((oldOrderPolicy = (Gateway.OrderPolicy)((Object)DataSerializer.readObject(in))) != null ? (oldOrderPolicy.name().equals(GatewaySender.OrderPolicy.KEY.name()) ? GatewaySender.OrderPolicy.KEY : (oldOrderPolicy.name().equals(GatewaySender.OrderPolicy.THREAD.name()) ? GatewaySender.OrderPolicy.THREAD : GatewaySender.OrderPolicy.PARTITION)) : null) : (GatewaySender.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            out.writeInt(this.dispatcherThreads);
            if (InternalDataSerializer.getVersionForDataStream(out).compareTo(Version.GFE_90) < 0 && this.orderPolicy != null) {
                String orderPolicyName = this.orderPolicy.name();
                if (orderPolicyName.equals(Gateway.OrderPolicy.KEY.name())) {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.KEY, out);
                } else if (orderPolicyName.equals(Gateway.OrderPolicy.THREAD.name())) {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.THREAD, out);
                } else {
                    DataSerializer.writeObject((Object)Gateway.OrderPolicy.PARTITION, out);
                }
            } else {
                DataSerializer.writeObject((Object)this.orderPolicy, out);
            }
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = (GatewaySender.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            if (this.isParallel) {
                out.writeInt(1);
            } else if (this.orderPolicy == null) {
                out.writeInt(1);
            } else {
                out.writeInt(this.dispatcherThreads);
            }
            if (this.isParallel) {
                DataSerializer.writeObject(null, out);
            } else {
                DataSerializer.writeObject((Object)this.orderPolicy, out);
            }
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        @Override
        public Version[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public int getDSFID() {
            return 2144;
        }

        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            InternalCache cache = dm.getCache();
            if (cache != null) {
                AbstractGatewaySender sender = (AbstractGatewaySender)cache.getGatewaySender(adviseePath);
                this.handleDistributionAdvisee(sender, removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; id=" + this.Id);
            sb.append("; remoteDSName=" + this.remoteDSId);
            sb.append("; isRunning=" + this.isRunning);
            sb.append("; isPrimary=" + this.isPrimary);
        }
    }
}

