/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class RemoteContainsKeyValueMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private boolean valueCheck;
    private Object key;
    protected static final short VALUE_CHECK = 64;

    public RemoteContainsKeyValueMessage() {
    }

    public RemoteContainsKeyValueMessage(InternalDistributedMember recipient, String regionPath, DirectReplyProcessor processor, Object key, boolean valueCheck) {
        super(recipient, regionPath, processor);
        this.valueCheck = valueCheck;
        this.key = key;
    }

    public static RemoteContainsKeyValueResponse send(InternalDistributedMember recipient, LocalRegion r, Object key, boolean valueCheck) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "recipient can not be NULL");
        RemoteContainsKeyValueResponse p = new RemoteContainsKeyValueResponse(r.getSystem(), recipient, key);
        RemoteContainsKeyValueMessage m = new RemoteContainsKeyValueMessage(recipient, r.getFullPath(), p, key, valueCheck);
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws CacheException, RemoteOperationException {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "DistributedRemoteContainsKeyValueMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        if (!(r instanceof PartitionedRegion)) {
            r.waitOnInitialization();
        }
        boolean replyVal = this.valueCheck ? r.containsValueForKey(this.key) : r.containsKey(this.key);
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace("DistributedRemoteContainsKeyValueMessage sending reply back using processorId: {}", (Object)this.getProcessorId());
        }
        RemoteContainsKeyValueReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm), replyVal);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; valueCheck=").append(this.valueCheck).append("; key=").append(this.key);
    }

    @Override
    public int getDSFID() {
        return -27;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.valueCheck = (this.flags & 0x40) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.valueCheck) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    public static class RemoteContainsKeyValueResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile boolean returnValue;
        private volatile boolean returnValueReceived;
        final Object key;

        public RemoteContainsKeyValueResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, Object key) {
            super(ds, recipient, false);
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof RemoteContainsKeyValueReplyMessage) {
                    RemoteContainsKeyValueReplyMessage reply = (RemoteContainsKeyValueReplyMessage)msg;
                    this.returnValue = reply.doesItContainKeyValue();
                    this.returnValueReceived = true;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "ContainsKeyValueResponse return value is {}", (Object)this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean waitForContainsResult() throws RemoteOperationException {
            try {
                this.waitForRemoteResponse();
            }
            catch (CacheException ce) {
                logger.debug("ContainsKeyValueResponse got remote CacheException", (Throwable)ce);
                throw new RemoteOperationException("RemoteContainsKeyResponse got remote CacheException; triggering RemoteOperationException.", ce);
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException("no return value received");
            }
            return this.returnValue;
        }
    }

    public static class RemoteContainsKeyValueReplyMessage
    extends ReplyMessage {
        private boolean containsKeyValue;

        public RemoteContainsKeyValueReplyMessage() {
        }

        private RemoteContainsKeyValueReplyMessage(int processorId, boolean containsKeyValue) {
            this.processorId = processorId;
            this.containsKeyValue = containsKeyValue;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, boolean containsKeyValue) {
            Assert.assertTrue(recipient != null, "ContainsKeyValueReplyMessage NULL reply message");
            RemoteContainsKeyValueReplyMessage m = new RemoteContainsKeyValueReplyMessage(processorId, containsKeyValue);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "ContainsKeyValueReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -26;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.containsKeyValue = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.containsKeyValue);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ContainsKeyValueReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning containsKeyValue=").append(this.doesItContainKeyValue());
            return sb.toString();
        }

        public boolean doesItContainKeyValue() {
            return this.containsKeyValue;
        }
    }
}

