/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class Put61
extends BaseCommand {
    @Immutable
    private static final Put61 singleton = new Put61();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long p_start) throws IOException, InterruptedException {
        LocalRegion region;
        boolean isDebugEnabled;
        CacheServerStats stats;
        Object key;
        String regionName;
        Part valuePart;
        long start;
        block46: {
            start = p_start;
            Part regionNamePart = null;
            Part keyPart = null;
            valuePart = null;
            Part callbackArgPart = null;
            regionName = null;
            Object callbackArg = null;
            key = null;
            Part eventPart = null;
            StringBuilder errMessage = new StringBuilder();
            boolean isDelta = false;
            CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
            stats = serverConnection.getCacheServerStats();
            serverConnection.setAsTrue(2);
            long oldStart = start;
            start = DistributionStats.getStatTime();
            stats.incReadPutRequestTime(start - oldStart);
            regionNamePart = clientMessage.getPart(0);
            keyPart = clientMessage.getPart(1);
            try {
                isDelta = (Boolean)clientMessage.getPart(2).getObject();
            }
            catch (Exception e) {
                Put61.writeException(clientMessage, 70, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            valuePart = clientMessage.getPart(3);
            eventPart = clientMessage.getPart(4);
            if (clientMessage.getNumberOfParts() > 5) {
                callbackArgPart = clientMessage.getPart(5);
                try {
                    callbackArg = callbackArgPart.getObject();
                }
                catch (Exception e) {
                    Put61.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            regionName = regionNamePart.getString();
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                Put61.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("{}: Received 6.1{}put request ({} bytes) from {} for region {} key {}", (Object)serverConnection.getName(), (Object)(isDelta ? " delta " : " "), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key);
            }
            if (key == null || regionName == null) {
                String putMsg;
                if (key == null) {
                    putMsg = " The input key for the 6.1 put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)putMsg);
                    }
                    errMessage.append(putMsg);
                }
                if (regionName == null) {
                    putMsg = " The input region name for the 6.1 put request is null";
                    if (isDebugEnabled) {
                        logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)putMsg);
                    }
                    errMessage.append(putMsg);
                }
                Put61.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
            if (region == null) {
                String reason = " was not found during 6.1 put request";
                Put61.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (valuePart.isNull() && region.containsKey(key)) {
                String putMsg = " Attempted to 6.1 put a null value for existing key " + key;
                if (isDebugEnabled) {
                    logger.debug("{}:{}", (Object)serverConnection.getName(), (Object)putMsg);
                }
                errMessage.append(putMsg);
                Put61.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
            try {
                Object value = null;
                if (!isDelta) {
                    value = valuePart.getSerializedForm();
                }
                boolean isObject = valuePart.isObject();
                boolean isMetaRegion = region.isUsedForMetaRegion();
                clientMessage.setMetaRegion(isMetaRegion);
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key.toString());
                AuthorizeRequest authzRequest = null;
                if (!isMetaRegion) {
                    authzRequest = serverConnection.getAuthzRequest();
                }
                if (authzRequest != null) {
                    if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                        authzRequest.createRegionAuthorize((String)key);
                    } else {
                        PutOperationContext putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg);
                        value = putContext.getValue();
                        isObject = putContext.isObject();
                        callbackArg = putContext.getCallbackArg();
                    }
                }
                boolean result = false;
                if (value == null && !isDelta) {
                    result = region.basicBridgeCreate(key, null, true, callbackArg, serverConnection.getProxyID(), true, new EventIDHolder(eventId), false);
                } else {
                    byte[] delta = null;
                    if (isDelta) {
                        delta = valuePart.getSerializedForm();
                    }
                    result = region.basicBridgePut(key, value, delta, isObject, callbackArg, serverConnection.getProxyID(), true, new EventIDHolder(eventId));
                }
                if (result) {
                    serverConnection.setModificationInfo(true, regionName, key);
                    break block46;
                }
                String message = serverConnection.getName() + ": Failed to 6.1 put entry for region " + regionName + " key " + key + " value " + valuePart;
                if (isDebugEnabled) {
                    logger.debug(message);
                }
                throw new Exception(message);
            }
            catch (RegionDestroyedException rde) {
                Put61.writeException(clientMessage, rde, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            catch (ResourceException re) {
                Put61.writeException(clientMessage, re, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            catch (InvalidDeltaException ide) {
                logger.info("Error applying delta for key {} of region {}: {}", key, (Object)regionName, (Object)ide.getMessage());
                Put61.writeException(clientMessage, 70, ide, false, serverConnection);
                serverConnection.setAsTrue(1);
                region.getCachePerfStats().incDeltaFullValuesRequested();
                return;
            }
            catch (Exception ce) {
                Put61.checkForInterrupt(serverConnection, ce);
                Put61.writeException(clientMessage, ce, false, serverConnection);
                serverConnection.setAsTrue(1);
                if (ce instanceof GemFireSecurityException) {
                    if (isDebugEnabled) {
                        logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)ce);
                    }
                } else if (isDebugEnabled) {
                    logger.debug("{}: Unexpected Exception", (Object)serverConnection.getName(), (Object)ce);
                }
                return;
            }
            finally {
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessPutTime(start - oldStart2);
            }
        }
        if (region instanceof PartitionedRegion) {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
            } else {
                this.writeReply(clientMessage, serverConnection);
            }
        } else {
            this.writeReply(clientMessage, serverConnection);
        }
        serverConnection.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent 6.1 put response back to {} for region {} key {} value {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart);
        }
        stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
    }
}

