/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class GetClientPartitionAttributesCommand
extends BaseCommand {
    @Immutable
    private static final GetClientPartitionAttributesCommand singleton = new GetClientPartitionAttributesCommand();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        regionFullPath = clientMessage.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            errMessage = "The input region path for the GetClientPartitionAttributes request is null";
            logger.warn(errMessage);
            GetClientPartitionAttributesCommand.writeErrorResponse(clientMessage, 76, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Region region = serverConnection.getCache().getRegion(regionFullPath);
        if (region == null) {
            logger.warn("Region was not found during GetClientPartitionAttributes request for region path : {}", (Object)regionFullPath);
            errMessage = "Region was not found during GetClientPartitionAttributes request for region path : " + regionFullPath;
            GetClientPartitionAttributesCommand.writeErrorResponse(clientMessage, 76, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            Message responseMsg = serverConnection.getResponseMessage();
            responseMsg.setTransactionId(clientMessage.getTransactionId());
            responseMsg.setMessageType(74);
            PartitionedRegion prRgion = (PartitionedRegion)region;
            PartitionResolver partitionResolver = prRgion.getPartitionResolver();
            int numParts = 2;
            if (partitionResolver != null) {
                ++numParts;
            }
            responseMsg.setNumberOfParts(numParts);
            responseMsg.addObjPart(prRgion.getTotalNumberOfBuckets());
            if (partitionResolver != null) {
                responseMsg.addObjPart(partitionResolver.getClass().toString().substring(6));
            }
            String leaderRegionPath = null;
            PartitionedRegion leaderRegion = null;
            String leaderRegionName = prRgion.getColocatedWith();
            if (leaderRegionName != null) {
                InternalCache cache = prRgion.getCache();
                while (leaderRegionName != null) {
                    leaderRegion = (PartitionedRegion)cache.getRegion(leaderRegionName);
                    if (leaderRegion.getColocatedWith() == null) {
                        leaderRegionPath = leaderRegion.getFullPath();
                        break;
                    }
                    leaderRegionName = leaderRegion.getColocatedWith();
                }
            }
            responseMsg.addObjPart(leaderRegionPath);
            responseMsg.send();
            clientMessage.clearParts();
        }
        catch (Exception e) {
            GetClientPartitionAttributesCommand.writeException(clientMessage, e, false, serverConnection);
        }
        finally {
            serverConnection.setAsTrue(1);
        }
    }
}

