/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.HashSet;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteRegionFunction
extends BaseCommand {
    @Immutable
    private static final ExecuteRegionFunction singleton = new ExecuteRegionFunction();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteRegionFunction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CachedRegionHelper crHelper;
        byte hasResult;
        HashSet<Object> filter;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        String regionName;
        block34: {
            regionName = null;
            function = null;
            args = null;
            memberMappedArg = null;
            filter = null;
            hasResult = 0;
            int filterSize = 0;
            int partNumber = 0;
            crHelper = serverConnection.getCachedRegionHelper();
            try {
                Object obj;
                hasResult = clientMessage.getPart(0).getSerializedForm()[0];
                if (hasResult == 1) {
                    serverConnection.setAsTrue(2);
                    serverConnection.setAsTrue(3);
                }
                regionName = clientMessage.getPart(1).getString();
                function = clientMessage.getPart(2).getStringOrObject();
                args = clientMessage.getPart(3).getObject();
                Part part = clientMessage.getPart(4);
                if (part != null && (obj = part.getObject()) instanceof MemberMappedArgument) {
                    memberMappedArg = (MemberMappedArgument)obj;
                }
                if ((filterSize = clientMessage.getPart(5).getInt()) != 0) {
                    filter = new HashSet<Object>();
                    partNumber = 6;
                    for (int i = 0; i < filterSize; ++i) {
                        filter.add(clientMessage.getPart(partNumber + i).getStringOrObject());
                    }
                }
            }
            catch (ClassNotFoundException exception) {
                logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)exception);
                if (hasResult != 1) break block34;
                ExecuteRegionFunction.writeChunkedException(clientMessage, exception, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (function == null || regionName == null) {
            String message = null;
            if (function == null) {
                message = String.format("The input %s for the execute function request is null", "function");
            }
            if (regionName == null) {
                message = String.format("The input %s for the execute function request is null", "region");
            }
            logger.warn("{}: {}", (Object)serverConnection.getName(), message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        Region region = crHelper.getRegion(regionName);
        if (region == null) {
            String message = String.format("The region named %s was not found during execute Function request.", regionName);
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        ServerSideHandshake handshake = serverConnection.getHandshake();
        int earlierClientReadTimeout = handshake.getClientReadTimeout();
        handshake.setClientReadTimeout(0);
        ServerToClientFunctionResultSender resultSender = null;
        Function functionObject = null;
        try {
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = String.format("The function, %s, has not been registered", function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            functionObject.getRequiredPermissions(regionName, args).forEach(securityService::authorize);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            String functionName = functionObject.getId();
            String regionPath = region.getFullPath();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionName, regionPath, filter, args, functionObject.optimizeForWrite());
            }
            AbstractExecution execution = (AbstractExecution)FunctionService.onRegion(region);
            ChunkedMessage m = serverConnection.getFunctionResponseMessage();
            m.setTransactionId(clientMessage.getTransactionId());
            resultSender = new ServerToClientFunctionResultSender(m, 60, serverConnection, functionObject, executeContext);
            execution = execution instanceof PartitionedRegionFunctionExecutor ? new PartitionedRegionFunctionExecutor((PartitionedRegion)region, filter, args, memberMappedArg, resultSender, null, false) : new DistributedRegionFunctionExecutor((DistributedRegion)region, filter, args, memberMappedArg, resultSender);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on Server: {} with Execution: {}", (Object)functionObject.getId(), (Object)serverConnection, (Object)execution);
            }
            if (hasResult == 1) {
                if (function instanceof String) {
                    execution.execute((String)function).getResult();
                } else {
                    execution.execute(functionObject).getResult();
                }
            } else if (function instanceof String) {
                execution.execute((String)function);
            } else {
                execution.execute(functionObject);
            }
        }
        catch (IOException ioe) {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)ioe);
            String message = "Server could not send the reply";
            this.sendException(hasResult, clientMessage, "Server could not send the reply", serverConnection, ioe);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Exception on server while executing function: %s", function), (Throwable)internalfunctionException);
            }
            String message = internalfunctionException.getMessage();
            this.sendException(hasResult, clientMessage, message, serverConnection, internalfunctionException);
        }
        catch (FunctionException fe) {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)fe);
            String message = fe.getMessage();
            this.sendException(hasResult, clientMessage, message, serverConnection, fe);
        }
        catch (Exception e) {
            logger.warn(String.format("Exception on server while executing function : %s", function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, clientMessage, message, serverConnection, e);
        }
        finally {
            handshake.setClientReadTimeout(earlierClientReadTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction.writeFunctionResponseException(msg, 2, serverConnection, e);
                serverConnection.setAsTrue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction.writeFunctionResponseError(msg, 61, message, serverConnection);
                serverConnection.setAsTrue(1);
            }
        }
    }
}

