/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.TransactionInDoubtException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class CommitCommand
extends BaseCommand {
    @Immutable
    private static final CommitCommand singleton = new CommitCommand();

    public static Command getCommand() {
        return singleton;
    }

    private CommitCommand() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        serverConnection.setAsTrue(2);
        TXManagerImpl txMgr = (TXManagerImpl)serverConnection.getCache().getCacheTransactionManager();
        InternalDistributedMember client = (InternalDistributedMember)serverConnection.getProxyID().getDistributedMember();
        int uniqId = clientMessage.getTransactionId();
        TXId txId = new TXId(client, uniqId);
        TXCommitMessage commitMsg = txMgr.getRecentlyCompletedMessage(txId);
        if (commitMsg != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX: returning a recently committed txMessage for tx: {}", (Object)txId);
            }
            if (!txMgr.isExceptionToken(commitMsg)) {
                CommitCommand.writeCommitResponse(commitMsg, clientMessage, serverConnection);
                commitMsg.setClientVersion(null);
                serverConnection.setAsTrue(1);
            } else {
                this.sendException(clientMessage, serverConnection, txMgr.getExceptionForToken(commitMsg, txId));
            }
            txMgr.removeHostedTXState(txId);
            return;
        }
        boolean wasInProgress = txMgr.setInProgress(true);
        TXStateProxy txProxy = txMgr.getTXState();
        Assert.assertTrue(txProxy != null);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: committing client tx: {}", (Object)txId);
        }
        this.commitTransaction(clientMessage, serverConnection, txMgr, wasInProgress, txProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitTransaction(Message clientMessage, ServerConnection serverConnection, TXManagerImpl txMgr, boolean wasInProgress, TXStateProxy txProxy) throws IOException {
        block18: {
            Exception txException = null;
            TXCommitMessage commitMsg = null;
            TXId txId = txProxy.getTxId();
            try {
                txProxy.setCommitOnBehalfOfRemoteStub(true);
                txMgr.commit();
                commitMsg = txProxy.getCommitMessage();
                logger.debug("Sending commit response to client: {}", (Object)commitMsg);
                CommitCommand.writeCommitResponse(commitMsg, clientMessage, serverConnection);
                serverConnection.setAsTrue(1);
            }
            catch (Exception e) {
                txException = e;
            }
            finally {
                if (txId != null) {
                    txMgr.removeHostedTXState(txId);
                }
                if (!wasInProgress) {
                    txMgr.setInProgress(false);
                }
                if (commitMsg != null) {
                    commitMsg.setClientVersion(null);
                }
            }
            if (txException != null) {
                DistributedMember target = txProxy.getTarget();
                try {
                    if (!(txException instanceof TransactionInDoubtException) || !(txException.getCause() instanceof CancelException)) break block18;
                    int timeToWait = serverConnection.getHandshake().getClientReadTimeout() / 2;
                    if (timeToWait < 0) {
                        return;
                    }
                    logger.info("Waiting up to {}ms for departure of {} before throwing TransactionInDoubtException.", (Object)timeToWait, (Object)target);
                    try {
                        serverConnection.getCache().getDistributionManager().getMembershipManager().waitForDeparture(target, timeToWait);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    logger.info("Done waiting.  Transaction host {} in the cluster.", (Object)(serverConnection.getCache().getDistributionManager().isCurrentMember(target) ? "is still" : "is no longer"));
                }
                finally {
                    this.sendException(clientMessage, serverConnection, txException);
                }
            }
        }
    }

    protected static void writeCommitResponse(TXCommitMessage response, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.setNumberOfParts(1);
        if (response != null) {
            response.setClientVersion(servConn.getClientVersion());
        }
        responseMsg.addObjPart(response, false);
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: sending a nonNull response for transaction: {}", (Object)new TXId((InternalDistributedMember)servConn.getProxyID().getDistributedMember(), origMsg.getTransactionId()));
        }
        responseMsg.send(servConn);
        origMsg.clearParts();
    }

    private void sendException(Message msg, ServerConnection servConn, Throwable e) throws IOException {
        CommitCommand.writeException(msg, 2, e, false, servConn);
        servConn.setAsTrue(1);
    }
}

