/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class VersionedObjectList
extends ObjectPartList
implements Externalizable {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -8384671357532347892L;
    ArrayList<VersionTag> versionTags;
    private boolean regionIsVersioned;
    private boolean serializeValues;
    @Immutable
    private static final Version[] serializationVersions = new Version[]{Version.GFE_80};
    static final byte FLAG_NULL_TAG = 0;
    static final byte FLAG_FULL_TAG = 1;
    static final byte FLAG_TAG_WITH_NEW_ID = 2;
    static final byte FLAG_TAG_WITH_NUMBER_ID = 3;

    public void addKeyAndVersion(Object key, VersionTag versionTag) {
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "VersionedObjectList.addKeyAndVersion({}; {})", key, (Object)versionTag);
        }
        if (this.objects.size() > 0) {
            throw new IllegalStateException("attempt to add key/version to a list containing objects");
        }
        this.keys.add(key);
        if (this.regionIsVersioned) {
            this.versionTags.add(versionTag);
        }
    }

    @Override
    public void addPart(Object key, Object value, byte objectType, VersionTag versionTag) {
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "addPart({}; {}; {}; {}", key, value, (Object)objectType, (Object)versionTag);
        }
        super.addPart(key, value, objectType, versionTag);
        if (this.regionIsVersioned) {
            int tagsSize = this.versionTags.size();
            if (this.keys != null && tagsSize != this.keys.size() - 1) {
                throw new InternalGemFireException();
            }
            if (this.objects != null && this.objects.size() > 0 && tagsSize != this.objects.size() - 1) {
                throw new InternalGemFireException();
            }
            this.versionTags.add(versionTag);
        }
    }

    public void addObject(Object key, Object value, VersionTag versionTag) {
        this.addPart(key, value, (byte)1, versionTag);
    }

    public VersionedObjectList() {
        this.versionTags = new ArrayList();
    }

    public VersionedObjectList(boolean serializeValues) {
        this();
        this.serializeValues = serializeValues;
    }

    public VersionedObjectList(int maxSize, boolean hasKeys, boolean regionIsVersioned) {
        this(maxSize, hasKeys, regionIsVersioned, false);
    }

    public VersionedObjectList(int maxSize, boolean hasKeys, boolean regionIsVersioned, boolean serializeValues) {
        super(maxSize, hasKeys);
        if (regionIsVersioned) {
            this.versionTags = new ArrayList(maxSize);
            this.regionIsVersioned = true;
        } else {
            this.versionTags = new ArrayList();
        }
        this.serializeValues = serializeValues;
    }

    public void replaceNullIDs(DistributedMember sender) {
        for (VersionTag versionTag : this.versionTags) {
            if (versionTag == null) continue;
            versionTag.replaceNullIDs((InternalDistributedMember)sender);
        }
    }

    @Override
    public void addObjectPartForAbsentKey(Object key, Object value) {
        this.addPart(key, value, (byte)3, null);
    }

    public void addObjectPartForAbsentKey(Object key, Object value, VersionTag version) {
        this.addPart(key, value, (byte)3, version);
    }

    @Override
    public void addAll(ObjectPartList other) {
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "VOL.addAll(other={}; this={}", (Object)other, (Object)this);
        }
        int myTypeArrayLength = this.hasKeys ? this.keys.size() : this.objects.size();
        int otherTypeArrayLength = other.hasKeys ? other.keys.size() : other.objects.size();
        super.addAll(other);
        VersionedObjectList vother = (VersionedObjectList)other;
        this.regionIsVersioned |= vother.regionIsVersioned;
        this.versionTags.addAll(vother.versionTags);
        if (myTypeArrayLength > 0 || otherTypeArrayLength > 0) {
            int newSize = myTypeArrayLength + otherTypeArrayLength;
            if (this.objectTypeArray != null) {
                if (this.objectTypeArray.length < (newSize = Math.max(newSize, this.objectTypeArray.length))) {
                    byte[] temp = this.objectTypeArray;
                    this.objectTypeArray = new byte[newSize];
                    System.arraycopy(temp, 0, this.objectTypeArray, 0, temp.length);
                }
            } else {
                this.objectTypeArray = new byte[newSize];
            }
            if (other.objectTypeArray != null) {
                System.arraycopy(other.objectTypeArray, 0, this.objectTypeArray, myTypeArrayLength, otherTypeArrayLength);
            }
        }
    }

    public List<VersionTag> getVersionTags() {
        return Collections.unmodifiableList(this.versionTags);
    }

    public boolean hasVersions() {
        return this.versionTags.size() > 0;
    }

    public void clearVersions() {
        this.versionTags = new ArrayList(Math.max(50, this.size()));
    }

    public void addVersion(VersionTag tag) {
        this.versionTags.add(tag);
    }

    public void saveVersions(Map<Object, VersionTag> vault) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (e.getVersionTag() == null && vault.containsKey(e.getKey())) continue;
            vault.put(e.getKey(), e.getVersionTag());
        }
    }

    public boolean regionIsVersioned() {
        return this.regionIsVersioned;
    }

    public void addAllKeys(Collection<?> keys) {
        if (!this.hasKeys) {
            this.hasKeys = true;
            this.keys = new ArrayList(keys);
        } else {
            this.keys.addAll(keys);
        }
    }

    @Override
    public void reinit(int maxSize) {
        super.reinit(maxSize);
        this.versionTags.clear();
    }

    public VersionedObjectList setKeys(List newKeys) {
        this.keys = newKeys;
        this.hasKeys = this.keys != null;
        return this;
    }

    public void clearObjects() {
        this.objects = Collections.emptyList();
        this.objectTypeArray = new byte[0];
    }

    @Override
    public void clear() {
        super.clear();
        this.versionTags.clear();
    }

    public void processVersionTags(InternalDistributedMember sender) {
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        this.getCanonicalIDs();
        this.toData(out);
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    private void getCanonicalIDs() {
        DistributionManager dm;
        if (this.versionTags != null && (dm = InternalDistributedSystem.getConnectedInstance().getDistributionManager()) != null) {
            for (VersionTag tag : this.versionTags) {
                if (tag == null) continue;
                tag.setCanonicalIDs(dm);
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toData(out, 0, this.regionIsVersioned ? this.versionTags.size() : this.size(), true, true);
    }

    void toData(DataOutput out, int startIndex, int numEntries, boolean sendKeys, boolean sendObjects) throws IOException {
        int flags = 0;
        boolean hasObjects = false;
        boolean hasTags = false;
        if (sendKeys && this.hasKeys) {
            flags |= 1;
        }
        if (sendObjects && !this.objects.isEmpty()) {
            flags |= 2;
            hasObjects = true;
        }
        if (this.versionTags.size() > 0) {
            flags |= 4;
            hasTags = true;
            for (VersionTag tag : this.versionTags) {
                if (tag == null) continue;
                if (!(tag instanceof DiskVersionTag)) break;
                flags |= 0x20;
                break;
            }
        }
        if (this.regionIsVersioned) {
            flags |= 8;
        }
        if (this.serializeValues) {
            flags |= 0x10;
        }
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "serializing {} with flags 0x{} startIndex={} numEntries={}", (Object)this, (Object)Integer.toHexString(flags), (Object)startIndex, (Object)numEntries);
        }
        out.writeByte(flags);
        if (sendKeys && this.hasKeys) {
            int numToWrite = numEntries;
            if (numToWrite + startIndex > this.keys.size()) {
                numToWrite = Math.max(0, this.keys.size() - startIndex);
            }
            InternalDataSerializer.writeUnsignedVL(numToWrite, out);
            int index = startIndex;
            int i = 0;
            while (i < numToWrite) {
                DataSerializer.writeObject(this.keys.get(index), out);
                ++i;
                ++index;
            }
        }
        if (sendObjects && hasObjects) {
            int numToWrite = numEntries;
            if (numToWrite + startIndex > this.objects.size()) {
                numToWrite = Math.max(0, this.objects.size() - startIndex);
            }
            InternalDataSerializer.writeUnsignedVL(numToWrite, out);
            int idx = 0;
            int index = startIndex;
            int i = 0;
            while (i < numToWrite) {
                this.writeObject(this.objects.get(index), idx++, out);
                ++i;
                ++index;
            }
        }
        if (hasTags) {
            int numToWrite = numEntries;
            if (numToWrite + startIndex > this.versionTags.size()) {
                numToWrite = Math.max(0, this.versionTags.size() - startIndex);
            }
            InternalDataSerializer.writeUnsignedVL(numToWrite, out);
            HashMap ids = new HashMap(numToWrite);
            int idCount = 0;
            int index = startIndex;
            int i = 0;
            while (i < numToWrite) {
                VersionTag tag = this.versionTags.get(index);
                if (tag == null) {
                    out.writeByte(0);
                } else {
                    Object id = tag.getMemberID();
                    if (id == null) {
                        out.writeByte(1);
                        InternalDataSerializer.invokeToData(tag, out);
                    } else {
                        Integer idNumber = (Integer)ids.get(id);
                        if (idNumber == null) {
                            out.writeByte(2);
                            idNumber = idCount++;
                            ids.put(id, idNumber);
                            InternalDataSerializer.invokeToData(tag, out);
                        } else {
                            out.writeByte(3);
                            tag.toData(out, false);
                            tag.setMemberID(id);
                            InternalDataSerializer.writeUnsignedVL(idNumber.intValue(), out);
                        }
                    }
                }
                ++i;
                ++index;
            }
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        boolean persistent;
        boolean isDebugEnabled_VOL = logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE);
        byte flags = in.readByte();
        this.hasKeys = (flags & 1) == 1;
        boolean hasObjects = (flags & 2) == 2;
        boolean hasTags = (flags & 4) == 4;
        this.regionIsVersioned = (flags & 8) == 8;
        this.serializeValues = (flags & 0x10) == 16;
        boolean bl = persistent = (flags & 0x20) == 32;
        if (isDebugEnabled_VOL) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "deserializing a VersionedObjectList with flags 0x{}", (Object)Integer.toHexString(flags));
        }
        if (this.hasKeys) {
            size = (int)InternalDataSerializer.readUnsignedVL(in);
            this.keys = new ArrayList(size);
            if (isDebugEnabled_VOL) {
                logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "reading {} keys", (Object)size);
            }
            for (i = 0; i < size; ++i) {
                this.keys.add(DataSerializer.readObject(in));
            }
        }
        if (hasObjects) {
            size = (int)InternalDataSerializer.readUnsignedVL(in);
            if (isDebugEnabled_VOL) {
                logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "reading {} objects", (Object)size);
            }
            this.objects = new ArrayList(size);
            this.objectTypeArray = new byte[size];
            for (i = 0; i < size; ++i) {
                this.readObject(i, in);
            }
        } else {
            this.objects = new ArrayList();
        }
        if (hasTags) {
            size = (int)InternalDataSerializer.readUnsignedVL(in);
            if (isDebugEnabled_VOL) {
                logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "reading {} version tags", (Object)size);
            }
            this.versionTags = new ArrayList(size);
            ArrayList ids = new ArrayList(size);
            block8: for (int i2 = 0; i2 < size; ++i2) {
                byte entryType = in.readByte();
                switch (entryType) {
                    case 0: {
                        this.versionTags.add(null);
                        continue block8;
                    }
                    case 1: {
                        this.versionTags.add(VersionTag.create(persistent, in));
                        continue block8;
                    }
                    case 2: {
                        VersionTag tag = VersionTag.create(persistent, in);
                        ids.add(tag.getMemberID());
                        this.versionTags.add(tag);
                        continue block8;
                    }
                    case 3: {
                        VersionTag tag = VersionTag.create(persistent, in);
                        int idNumber = (int)InternalDataSerializer.readUnsignedVL(in);
                        tag.setMemberID((VersionSource)ids.get(idNumber));
                        this.versionTags.add(tag);
                    }
                }
            }
        } else {
            this.versionTags = new ArrayList();
        }
    }

    private void writeObject(Object value, int index, DataOutput out) throws IOException {
        byte objectType = this.objectTypeArray[index];
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "writing object {} of type {}: {}", (Object)index, (Object)objectType, value);
        }
        out.writeByte(objectType);
        if (objectType == 1 && value instanceof byte[]) {
            if (this.serializeValues) {
                DataSerializer.writeByteArray((byte[])value, out);
            } else {
                out.write((byte[])value);
            }
        } else if (objectType == 2) {
            DataSerializer.writeByteArray(CacheServerHelper.serialize(value), out);
            DataSerializer.writeString(value.toString(), out);
        } else if (this.serializeValues) {
            DataSerializer.writeObjectAsByteArray(value, out);
        } else {
            DataSerializer.writeObject(value, out);
        }
    }

    private void readObject(int index, DataInput in) throws IOException, ClassNotFoundException {
        Object value;
        boolean isException;
        this.objectTypeArray[index] = in.readByte();
        if (logger.isTraceEnabled(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE)) {
            logger.trace(LogMarker.VERSIONED_OBJECT_LIST_VERBOSE, "reading object {} of type {}", (Object)index, (Object)this.objectTypeArray[index]);
        }
        boolean bl = isException = this.objectTypeArray[index] == 2;
        if (isException) {
            byte[] exBytes = DataSerializer.readByteArray(in);
            value = CacheServerHelper.deserialize(exBytes);
            DataSerializer.readString(in);
        } else {
            value = this.serializeValues ? (Object)DataSerializer.readByteArray(in) : DataSerializer.readObject(in);
        }
        this.objects.add(value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.toData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public int getDSFID() {
        return 7;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder();
        desc.append("VersionedObjectList(regionVersioned=").append(this.regionIsVersioned).append("; hasKeys=").append(this.hasKeys).append("; keys=").append(this.keys == null ? "null" : String.valueOf(this.keys.size())).append("; objects=").append(this.objects.size()).append("; isobject=").append(this.objectTypeArray == null ? "null" : Integer.valueOf(this.objectTypeArray.length)).append("; ccEnabled=").append(this.regionIsVersioned).append("; versionTags=").append(String.valueOf(this.versionTags.size())).append(")\n");
        Iterator entries = this.iterator();
        while (entries.hasNext()) {
            desc.append(entries.next()).append("\n");
        }
        return desc.toString();
    }

    public Set keySet() {
        if (!this.hasKeys) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(this.keys);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public static class Chunker
    implements DataSerializableFixedID {
        private int index = 0;
        private VersionedObjectList list;
        private int chunkSize;
        private boolean sendKeys;
        private boolean sendObjects;

        public Chunker(VersionedObjectList list, int chunkSize, boolean sendKeys, boolean sendObjects) {
            this.list = list;
            this.chunkSize = chunkSize;
            this.sendKeys = sendKeys;
            this.sendObjects = sendObjects;
        }

        @Override
        public int getDSFID() {
            return 7;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            int startIndex = this.index;
            this.index += this.chunkSize;
            this.list.toData(out, startIndex, this.chunkSize, this.sendKeys, this.sendObjects);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new IOException("this fromData method should never be invoked");
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            if (this.index == 0) {
                this.list.getCanonicalIDs();
            }
            this.toData(out);
        }

        @Override
        public Version[] getSerializationVersions() {
            return this.list.getSerializationVersions();
        }
    }

    public class Iterator
    implements java.util.Iterator {
        int index = 0;
        int size = VersionedObjectList.this.size();

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        public Entry next() {
            return new Entry(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Entry
    implements Map.Entry {
        int index;

        Entry(int idx) {
            this.index = idx;
        }

        public Object getKey() {
            if (VersionedObjectList.this.hasKeys) {
                return VersionedObjectList.this.keys.get(this.index);
            }
            return null;
        }

        public Object getObject() {
            return VersionedObjectList.this.objects.get(this.index);
        }

        public VersionTag getVersionTag() {
            if (this.index < VersionedObjectList.this.versionTags.size()) {
                return VersionedObjectList.this.versionTags.get(this.index);
            }
            return null;
        }

        public byte getObjectType() {
            return VersionedObjectList.this.objectTypeArray[this.index];
        }

        public boolean isKeyNotOnServer() {
            return VersionedObjectList.this.objectTypeArray[this.index] == 3;
        }

        public boolean isBytes() {
            return VersionedObjectList.this.objectTypeArray[this.index] == 0;
        }

        public boolean isException() {
            return VersionedObjectList.this.objectTypeArray[this.index] == 2;
        }

        public Object getValue() {
            if (this.index < VersionedObjectList.this.objects.size()) {
                return VersionedObjectList.this.objects.get(this.index);
            }
            return null;
        }

        public Object setValue(Object value) {
            Object result = VersionedObjectList.this.objects.get(this.index);
            VersionedObjectList.this.objects.set(this.index, value);
            return result;
        }

        public String toString() {
            return "[key=" + this.getKey() + ",value=" + this.getValue() + ",v=" + this.getVersionTag() + "]";
        }
    }
}

