/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.IncomingGatewayStatus;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifierStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerConnectionCollection;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.util.JavaWorkarounds;
import org.apache.logging.log4j.Logger;

public class ClientHealthMonitor {
    private static final Logger logger = LogService.getLogger();
    public static final String CLIENT_HEALTH_MONITOR_INTERVAL_PROPERTY = "geode.client-health-monitor-interval";
    private Map<ClientProxyMembershipID, Long> _clientHeartbeats = Collections.emptyMap();
    private final Object _clientHeartbeatsLock = new Object();
    private final InternalCache _cache;
    private final int maximumTimeBetweenPings;
    private final ClientHealthMonitorThread _clientMonitor;
    @MakeNotStatic
    static ClientHealthMonitor _instance;
    @MakeNotStatic
    private static int refCount;
    private static final long DEFAULT_CLIENT_MONITOR_INTERVAL_IN_MILLIS = 1000L;
    private final CacheClientNotifierStats stats;
    private final HashMap<ServerSideHandshake, MutableInt> cleanupTable = new HashMap();
    private final HashMap<ClientProxyMembershipID, MutableInt> cleanupProxyIdTable = new HashMap();
    private final HashMap<ClientProxyMembershipID, ServerConnectionCollection> proxyIdConnections = new HashMap();
    AtomicIntegerArray numOfClientsPerVersion = new AtomicIntegerArray(101);
    private long monitorInterval;

    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public static ClientHealthMonitor getInstance(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ClientHealthMonitor.createInstance(cache, maximumTimeBetweenPings, stats);
        return _instance;
    }

    public static ClientHealthMonitor getInstance() {
        return _instance;
    }

    public static synchronized void shutdownInstance() {
        --refCount;
        if (_instance == null) {
            return;
        }
        if (refCount > 0) {
            return;
        }
        _instance.shutdown();
        boolean interrupted = false;
        try {
            if (ClientHealthMonitor._instance._clientMonitor != null) {
                ClientHealthMonitor._instance._clientMonitor.join();
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
            if (logger.isDebugEnabled()) {
                logger.debug(":Interrupted joining with the ClientHealthMonitor Thread", (Throwable)e);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        _instance = null;
        refCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(ClientProxyMembershipID proxyID) {
        boolean registerClient = false;
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            Map<ClientProxyMembershipID, Long> oldClientHeartbeats = this._clientHeartbeats;
            if (!oldClientHeartbeats.containsKey(proxyID)) {
                HashMap<ClientProxyMembershipID, Long> newClientHeartbeats = new HashMap<ClientProxyMembershipID, Long>(oldClientHeartbeats);
                newClientHeartbeats.put(proxyID, System.currentTimeMillis());
                this._clientHeartbeats = newClientHeartbeats;
                registerClient = true;
            }
        }
        if (registerClient) {
            if (this.stats != null) {
                this.stats.incClientRegisterRequests();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ClientHealthMonitor: Registering client with member id {}", (Object)proxyID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterClient(ClientProxyMembershipID proxyID, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        boolean unregisterClient = false;
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            Map<ClientProxyMembershipID, Long> oldClientHeartbeats = this._clientHeartbeats;
            if (oldClientHeartbeats.containsKey(proxyID)) {
                unregisterClient = true;
                HashMap<ClientProxyMembershipID, Long> newClientHeartbeats = new HashMap<ClientProxyMembershipID, Long>(oldClientHeartbeats);
                newClientHeartbeats.remove(proxyID);
                this._clientHeartbeats = newClientHeartbeats;
            }
        }
        if (unregisterClient) {
            if (clientDisconnectedCleanly) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ClientHealthMonitor: Unregistering client with member id {}", (Object)proxyID);
                }
            } else {
                logger.warn("ClientHealthMonitor: Unregistering client with member id {} due to: {}", new Object[]{proxyID, clientDisconnectException == null ? "Unknown reason" : clientDisconnectException.getLocalizedMessage()});
            }
            if (this.stats != null) {
                this.stats.incClientUnRegisterRequests();
            }
            this.expireTXStates(proxyID);
        }
    }

    public void unregisterClient(ClientProxyMembershipID proxyID, AcceptorImpl acceptor, boolean clientDisconnectedCleanly, Throwable clientDisconnectException) {
        CacheClientNotifier ccn;
        this.unregisterClient(proxyID, clientDisconnectedCleanly, clientDisconnectException);
        if (acceptor != null && (ccn = acceptor.getCacheClientNotifier()) != null) {
            try {
                ccn.unregisterClient(proxyID, clientDisconnectedCleanly);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    public Set<TXId> getScheduledToBeRemovedTx() {
        TXManagerImpl txMgr = (TXManagerImpl)this._cache.getCacheTransactionManager();
        return txMgr.getScheduledToBeRemovedTx();
    }

    private void expireTXStates(ClientProxyMembershipID proxyID) {
        TXManagerImpl txMgr = (TXManagerImpl)this._cache.getCacheTransactionManager();
        Set<TXId> txIds = txMgr.getTransactionsForClient((InternalDistributedMember)proxyID.getDistributedMember());
        if (this._cache.isClosed()) {
            return;
        }
        if (!txIds.isEmpty()) {
            txMgr.expireDisconnectedClientTransactions(txIds, true);
        }
    }

    public void removeAllConnectionsAndUnregisterClient(ClientProxyMembershipID proxyID, Throwable t) {
        this.cleanupClientThreads(proxyID, false);
        this.unregisterClient(proxyID, false, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnectionCollection addConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.getProxyIdCollection(proxyID);
            collection.addConnection(connection);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ClientProxyMembershipID proxyID, ServerConnection connection) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            if (collection != null) {
                collection.removeConnection(connection);
                if (collection.getConnections().isEmpty()) {
                    this.proxyIdConnections.remove(proxyID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedPing(ClientProxyMembershipID proxyID) {
        if (this._clientMonitor == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ClientHealthMonitor: Received ping from client with member id {}", (Object)proxyID);
        }
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            if (!this._clientHeartbeats.containsKey(proxyID)) {
                this.registerClient(proxyID);
            } else {
                this._clientHeartbeats.put(proxyID, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object[]> getConnectedClients(Set filterProxies) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                if (filterProxies != null && !filterProxies.contains(proxyID)) continue;
                String membershipID = null;
                Set<ServerConnection> connections = entry.getValue().getConnections();
                int socketPort = 0;
                InetAddress socketAddress = null;
                Iterator<ServerConnection> iterator = connections.iterator();
                if (iterator.hasNext()) {
                    ServerConnection sc = iterator.next();
                    socketPort = sc.getSocketPort();
                    socketAddress = sc.getSocketAddress();
                    membershipID = sc.getMembershipID();
                }
                int connectionCount = connections.size();
                String clientString = null;
                clientString = socketAddress == null ? "client member id=" + membershipID : "host name=" + socketAddress.toString() + " host ip=" + socketAddress.getHostAddress() + " client port=" + socketPort + " client member id=" + membershipID;
                Object[] data = null;
                data = (Object[])map.get(membershipID);
                if (data == null) {
                    map.put(membershipID, new Object[]{clientString, connectionCount});
                    continue;
                }
                data[1] = (Integer)data[1] + connectionCount;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ClientProxyMembershipID, CacheClientStatus> getStatusForAllClients() {
        HashMap<ClientProxyMembershipID, CacheClientStatus> result = new HashMap<ClientProxyMembershipID, CacheClientStatus>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            block3: for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                CacheClientStatus cci = new CacheClientStatus(proxyID);
                Set<ServerConnection> connections = entry.getValue().getConnections();
                if (connections == null) continue;
                String memberId = null;
                for (ServerConnection sc : connections) {
                    if (!sc.isClientServerConnection()) continue;
                    memberId = sc.getMembershipID();
                    cci.setMemberId(memberId);
                    cci.setNumberOfConnections(connections.size());
                    result.put(proxyID, cci);
                    continue block3;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillInClientInfo(Map<ClientProxyMembershipID, CacheClientStatus> allClients) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, CacheClientStatus> entry : allClients.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                CacheClientStatus cci = entry.getValue();
                ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
                Set<ServerConnection> connections = collection != null ? collection.getConnections() : null;
                if (connections == null) continue;
                String memberId = null;
                cci.setNumberOfConnections(connections.size());
                ArrayList<Integer> socketPorts = new ArrayList<Integer>();
                ArrayList<InetAddress> socketAddresses = new ArrayList<InetAddress>();
                for (ServerConnection sc : connections) {
                    socketPorts.add(sc.getSocketPort());
                    socketAddresses.add(sc.getSocketAddress());
                    memberId = sc.getMembershipID();
                }
                cci.setMemberId(memberId);
                cci.setSocketPorts(socketPorts);
                cci.setSocketAddresses(socketAddresses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IncomingGatewayStatus> getConnectedIncomingGateways() {
        HashMap<String, IncomingGatewayStatus> connectedIncomingGateways = new HashMap<String, IncomingGatewayStatus>();
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            for (Map.Entry<ClientProxyMembershipID, ServerConnectionCollection> entry : this.proxyIdConnections.entrySet()) {
                ClientProxyMembershipID proxyID = entry.getKey();
                Set<ServerConnection> connections = entry.getValue().getConnections();
                for (ServerConnection sc : connections) {
                    if (!sc.getCommunicationMode().isWAN()) continue;
                    IncomingGatewayStatus status = new IncomingGatewayStatus(proxyID.getDSMembership(), sc.getSocketAddress(), sc.getSocketPort());
                    connectedIncomingGateways.put(proxyID.getDSMembership(), status);
                }
            }
        }
        return connectedIncomingGateways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanupClientThreads(ClientProxyMembershipID proxyID, boolean timedOut) {
        boolean result = false;
        Set<ServerConnection> serverConnections = null;
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.remove(proxyID);
            if (collection != null) {
                serverConnections = collection.getConnections();
            }
        }
        if (serverConnections != null) {
            result = true;
            for (ServerConnection serverConnection : serverConnections) {
                serverConnection.handleTermination(timedOut);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToTerminateIfNoConnectionIsProcessing(ClientProxyMembershipID proxyID) {
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            if (collection == null) {
                return true;
            }
            if (collection.connectionsProcessing.get() == 0) {
                collection.isTerminating = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateThreads(ClientProxyMembershipID proxyID) {
        HashSet<ServerConnection> serverConnections;
        HashMap<ClientProxyMembershipID, ServerConnectionCollection> hashMap = this.proxyIdConnections;
        synchronized (hashMap) {
            ServerConnectionCollection collection = this.proxyIdConnections.get(proxyID);
            serverConnections = collection != null ? new HashSet<ServerConnection>(collection.getConnections()) : Collections.emptySet();
        }
        for (ServerConnection serverConnection : serverConnections) {
            if (!serverConnection.hasBeenTimedOutOnClient()) continue;
            logger.warn("{} is being terminated because its client timeout of {} has expired.", new Object[]{serverConnection, serverConnection.getClientReadTimeout()});
            try {
                serverConnection.handleTermination(true);
            }
            finally {
                this.removeConnection(proxyID, serverConnection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ClientProxyMembershipID, Long> getClientHeartbeats() {
        Object object = this._clientHeartbeatsLock;
        synchronized (object) {
            return new HashMap<ClientProxyMembershipID, Long>(this._clientHeartbeats);
        }
    }

    protected synchronized void shutdown() {
        if (this._clientMonitor != null) {
            this._clientMonitor.stopMonitoring();
        }
    }

    protected static synchronized void createInstance(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        ++refCount;
        if (_instance != null) {
            return;
        }
        _instance = new ClientHealthMonitor(cache, maximumTimeBetweenPings, stats);
    }

    private ClientHealthMonitor(InternalCache cache, int maximumTimeBetweenPings, CacheClientNotifierStats stats) {
        this._cache = cache;
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
        this.monitorInterval = Long.getLong(CLIENT_HEALTH_MONITOR_INTERVAL_PROPERTY, 1000L);
        logger.debug("Setting monitorInterval to {}", (Object)this.monitorInterval);
        if (maximumTimeBetweenPings > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initializing client health monitor thread", (Object)this);
            }
            this._clientMonitor = new ClientHealthMonitorThread(maximumTimeBetweenPings);
            this._clientMonitor.start();
        } else {
            logger.info("Client health monitor thread disabled due to maximumTimeBetweenPings setting: {}", (Object)maximumTimeBetweenPings);
            this._clientMonitor = null;
        }
        this.stats = stats;
    }

    public String toString() {
        return "ClientHealthMonitor@" + Integer.toHexString(System.identityHashCode(this));
    }

    public ServerConnectionCollection getProxyIdCollection(ClientProxyMembershipID proxyID) {
        return JavaWorkarounds.computeIfAbsent(this.proxyIdConnections, proxyID, key -> new ServerConnectionCollection());
    }

    public Map<ClientProxyMembershipID, MutableInt> getCleanupProxyIdTable() {
        return this.cleanupProxyIdTable;
    }

    public Map<ServerSideHandshake, MutableInt> getCleanupTable() {
        return this.cleanupTable;
    }

    public int getNumberOfClientsAtOrAboveVersion(Version version) {
        int number = 0;
        for (int i = version.ordinal(); i < this.numOfClientsPerVersion.length(); ++i) {
            number += this.numOfClientsPerVersion.get(i);
        }
        return number;
    }

    public boolean hasDeltaClients() {
        return this.getNumberOfClientsAtOrAboveVersion(Version.GFE_61) > 0;
    }

    void testUseCustomHeartbeatCheck(HeartbeatTimeoutCheck check) {
        this._clientMonitor.overrideHeartbeatTimeoutCheck(check);
    }

    static {
        refCount = 0;
    }

    class ClientHealthMonitorThread
    extends LoggingThread {
        private HeartbeatTimeoutCheck checkHeartbeat;
        protected final int _maximumTimeBetweenPings;
        protected volatile boolean _isStopped;

        protected void overrideHeartbeatTimeoutCheck(HeartbeatTimeoutCheck newCheck) {
            this.checkHeartbeat = newCheck;
        }

        protected ClientHealthMonitorThread(int maximumTimeBetweenPings) {
            super("ClientHealthMonitor Thread");
            this.checkHeartbeat = (currentTime, lastHeartbeat, allowedInterval) -> currentTime - lastHeartbeat > allowedInterval;
            this._isStopped = false;
            this._maximumTimeBetweenPings = maximumTimeBetweenPings;
            logger.info("ClientHealthMonitorThread maximum allowed time between pings: {}", (Object)this._maximumTimeBetweenPings);
            if (maximumTimeBetweenPings == 0 && logger.isDebugEnabled()) {
                logger.debug("zero ping interval detected", (Throwable)new Exception("stack trace"));
            }
        }

        protected synchronized void stopMonitoring() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopping monitoring", (Object)ClientHealthMonitor.this);
            }
            this._isStopped = true;
            this.interrupt();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Stopped dispatching", (Object)ClientHealthMonitor.this);
            }
        }

        protected boolean isStopped() {
            return this._isStopped;
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Beginning to monitor clients", (Object)ClientHealthMonitor.this);
            }
            while (!this._isStopped) {
                SystemFailure.checkFailure();
                try {
                    Thread.sleep(ClientHealthMonitor.this.monitorInterval);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Monitoring {} client(s)", (Object)ClientHealthMonitor.this.getClientHeartbeats().size());
                    }
                    long currentTime = System.currentTimeMillis();
                    if (logger.isTraceEnabled()) {
                        logger.trace("{} starting sweep at {}", (Object)ClientHealthMonitor.this, (Object)currentTime);
                    }
                    for (Map.Entry<ClientProxyMembershipID, Long> entry : ClientHealthMonitor.this.getClientHeartbeats().entrySet()) {
                        ClientProxyMembershipID proxyID = entry.getKey();
                        ClientHealthMonitor.this.validateThreads(proxyID);
                        Long latestHeartbeatValue = entry.getValue();
                        if (latestHeartbeatValue == null) continue;
                        long latestHeartbeat = latestHeartbeatValue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("{} ms have elapsed since the latest heartbeat for client with member id {}", (Object)(currentTime - latestHeartbeat), (Object)proxyID);
                        }
                        if (this.checkHeartbeat.timedOut(currentTime, latestHeartbeat, this._maximumTimeBetweenPings)) {
                            if (ClientHealthMonitor.this.prepareToTerminateIfNoConnectionIsProcessing(proxyID)) {
                                if (!ClientHealthMonitor.this.cleanupClientThreads(proxyID, true)) continue;
                                logger.warn("Monitoring client with member id {}. It had been {} ms since the latest heartbeat. Max interval is {}. Terminated client.", new Object[]{entry.getKey(), currentTime - latestHeartbeat, this._maximumTimeBetweenPings});
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client would have been terminated but at least one of its threads is processing a message.", (Object)entry.getKey(), (Object)(currentTime - latestHeartbeat));
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Monitoring client with member id {}. It has been {} ms since the latest heartbeat. This client is healthy.", (Object)entry.getKey(), (Object)(currentTime - latestHeartbeat));
                    }
                }
                catch (InterruptedException e) {
                    if (this._isStopped) break;
                    logger.warn("Unexpected interrupt, exiting", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    if (this._isStopped) continue;
                    logger.fatal(ClientHealthMonitor.this.toString() + ": An unexpected Exception occurred", (Throwable)e);
                }
            }
        }
    }

    static interface HeartbeatTimeoutCheck {
        public boolean timedOut(long var1, long var3, long var5);
    }
}

