/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.persistence.RevokedPersistentDataException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PersistentMemberManager {
    private static final Logger logger = LogService.getLogger();
    private final Set<MemberRevocationListener> revocationListeners = new HashSet<MemberRevocationListener>();
    private final Map<PersistentMemberPattern, Object> revokedMembers = new ConcurrentHashMap<PersistentMemberPattern, Object>();
    private Map<PersistentMemberPattern, PendingRevokeListener> pendingRevokes = new HashMap<PersistentMemberPattern, PendingRevokeListener>();
    private static final Object TOKEN = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeMember(PersistentMemberPattern pattern) {
        this.cancelRevoke(pattern);
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            if (this.revokedMembers.put(pattern, TOKEN) == null) {
                logger.info("The following persistent member has been revoked: {}", (Object)pattern);
                for (MemberRevocationListener listener : this.revocationListeners) {
                    listener.revoked(pattern);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentMemberPattern> addRevocationListener(MemberRevocationListener listener, Set<PersistentMemberPattern> recoveredRevokedMembers) {
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            for (PersistentMemberPattern pattern : this.pendingRevokes.keySet()) {
                if (!listener.matches(pattern)) continue;
                throw new RevokedPersistentDataException(String.format("The persistent member id %s has been revoked in this distributed system. You cannot recover from disk files which have been revoked.", pattern));
            }
            for (PersistentMemberPattern pattern : this.revokedMembers.keySet()) {
                if (!listener.matches(pattern)) continue;
                throw new RevokedPersistentDataException(String.format("The persistent member id %s has been revoked in this distributed system. You cannot recover from disk files which have been revoked.", pattern));
            }
            for (PersistentMemberPattern pattern : recoveredRevokedMembers) {
                this.revokedMembers.put(pattern, TOKEN);
            }
            this.revocationListeners.add(listener);
            return new HashSet<PersistentMemberPattern>(this.revokedMembers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevocationListener(ProfileListener listener) {
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            this.revocationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<PersistentMemberPattern> getRevokedMembers() {
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            return new HashSet<PersistentMemberPattern>(this.revokedMembers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<PersistentMemberID>> getWaitingRegions() {
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            HashMap<String, Set<PersistentMemberID>> missingMemberIds = new HashMap<String, Set<PersistentMemberID>>();
            for (MemberRevocationListener listener : this.revocationListeners) {
                String regionPath = listener.getRegionPath();
                Set<PersistentMemberID> ids = listener.getMissingMemberIds();
                Set<PersistentMemberID> allIds = (Set<PersistentMemberID>)missingMemberIds.get(regionPath);
                if (ids == null) continue;
                if (allIds != null) {
                    allIds.addAll(ids);
                    continue;
                }
                allIds = ids;
                missingMemberIds.put(regionPath, allIds);
            }
            return missingMemberIds;
        }
    }

    public boolean isRevoked(String regionPath, PersistentMemberID id) {
        for (PersistentMemberPattern member : this.revokedMembers.keySet()) {
            if (!member.matches(id)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareRevoke(PersistentMemberPattern pattern, DistributionManager dm, InternalDistributedMember sender) {
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing revoke if pattern {}", (Object)pattern);
        }
        PendingRevokeListener membershipListener = new PendingRevokeListener(pattern, sender, dm);
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            for (MemberRevocationListener listener : this.revocationListeners) {
                if (!listener.matches(pattern)) continue;
                return false;
            }
            this.pendingRevokes.put(pattern, membershipListener);
        }
        Set<InternalDistributedMember> members = dm.addMembershipListenerAndGetDistributionManagerIds(membershipListener);
        if (!members.contains(sender) && sender.equals(dm.getId())) {
            this.cancelRevoke(pattern);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRevoke(PersistentMemberPattern pattern) {
        PendingRevokeListener listener;
        PersistentMemberManager persistentMemberManager = this;
        synchronized (persistentMemberManager) {
            listener = this.pendingRevokes.remove(pattern);
        }
        if (listener != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cancelling revoke of id {}", (Object)pattern);
            }
            listener.remove();
        }
    }

    public class PendingRevokeListener
    implements MembershipListener {
        InternalDistributedMember sender;
        private PersistentMemberPattern pattern;
        private DistributionManager dm;

        public PendingRevokeListener(PersistentMemberPattern pattern, InternalDistributedMember sender, DistributionManager dm) {
            this.dm = dm;
            this.pattern = pattern;
            this.sender = sender;
        }

        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            if (id.equals(this.sender)) {
                PersistentMemberManager.this.cancelRevoke(this.pattern);
            }
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        public void remove() {
            this.dm.removeAllMembershipListener(this);
        }
    }

    public static interface MemberRevocationListener {
        public void revoked(PersistentMemberPattern var1);

        public boolean matches(PersistentMemberPattern var1);

        public Set<PersistentMemberID> getMissingMemberIds();

        public String getRegionPath();
    }
}

