/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.apache.geode.CancelCriterion;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.persistence.InternalPersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.lang.SystemPropertyHelper;

public class MembershipChangeListener
implements MembershipListener,
PersistentStateListener {
    private static final int POLL_INTERVAL_MILLIS = 100;
    private final Runnable warning;
    private final BooleanSupplier cancelCondition;
    private final Duration pollDuration;
    private final Duration warningDelay;
    private boolean membershipChanged;
    private boolean warned;

    public MembershipChangeListener(InternalPersistenceAdvisor persistenceAdvisor) {
        this.warningDelay = this.warningDelay(persistenceAdvisor);
        this.cancelCondition = MembershipChangeListener.cancelCondition(persistenceAdvisor);
        this.warning = persistenceAdvisor::logWaitingForMembers;
        this.pollDuration = MembershipChangeListener.pollDuration();
    }

    private Duration warningDelay(InternalPersistenceAdvisor persistenceAdvisor) {
        return Duration.ofSeconds(persistenceAdvisor.getCacheDistributionAdvisor().getDistributionManager().getConfig().getAckWaitThreshold());
    }

    public synchronized void waitForChange() throws InterruptedException {
        Instant now = Instant.now();
        Instant timeoutTime = now.plus(this.pollDuration);
        Instant warningTime = now.plus(this.warningDelay);
        while (!this.membershipChanged && !this.cancelCondition.getAsBoolean() && Instant.now().isBefore(timeoutTime)) {
            this.warnOnceAfter(warningTime);
            this.wait(100L);
        }
        this.membershipChanged = false;
    }

    private void warnOnceAfter(Instant warningTime) {
        if (!this.warned && warningTime.isBefore(Instant.now())) {
            this.warning.run();
            this.warned = true;
        }
    }

    private synchronized void afterMembershipChange() {
        this.membershipChanged = true;
        this.notifyAll();
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        this.afterMembershipChange();
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        this.afterMembershipChange();
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberOffline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.afterMembershipChange();
    }

    @Override
    public void memberOnline(InternalDistributedMember member, PersistentMemberID persistentID) {
        this.afterMembershipChange();
    }

    @Override
    public void memberRemoved(PersistentMemberID id, boolean revoked) {
        this.afterMembershipChange();
    }

    private static BooleanSupplier cancelCondition(InternalPersistenceAdvisor persistenceAdvisor) {
        CancelCriterion cancelCriterion = persistenceAdvisor.getCacheDistributionAdvisor().getAdvisee().getCancelCriterion();
        return () -> {
            persistenceAdvisor.checkInterruptedByShutdownAll();
            cancelCriterion.checkCancelInProgress(null);
            return persistenceAdvisor.isClosed();
        };
    }

    private static Duration pollDuration() {
        return Duration.ofSeconds(SystemPropertyHelper.getProductIntegerProperty("PERSISTENT_VIEW_RETRY_TIMEOUT_SECONDS").orElse(5).intValue());
    }
}

