/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class BucketBackupMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public BucketBackupMessage() {
    }

    private BucketBackupMessage(Set recipients, int regionId, int bucketId) {
        super(recipients, regionId, null);
        this.bucketId = bucketId;
    }

    public static void send(Set recipients, PartitionedRegion r, int bucketId) {
        Assert.assertTrue(recipients != null, "BucketBackupMessage NULL sender list");
        BucketBackupMessage m = new BucketBackupMessage(recipients, r.getPRId(), bucketId);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
    }

    @Override
    protected boolean failIfRegionMissing() {
        return false;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        PartitionedRegionDataStore ds;
        if (pr == null || !pr.isInitialized()) {
            return false;
        }
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "BucketBackupMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        if ((ds = pr.getDataStore()) != null) {
            pr.getRedundancyProvider().finishIncompleteBucketCreation(this.bucketId);
        } else {
            logger.warn("BucketBackupMessage: data store not configured for this member");
        }
        pr.getPrStats().endPartitionMessagesProcessing(startTime);
        return false;
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public int getDSFID() {
        return 39;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }
}

