/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.LockGrantorId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.locks.TXLessorDepartureHandler;
import org.apache.geode.internal.cache.locks.TXLockBatch;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.cache.locks.TXLockIdImpl;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.locks.TXLockUpdateParticipantsMessage;
import org.apache.geode.internal.cache.locks.TXRecoverGrantorMessageProcessor;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.concurrent.StoppableReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public class TXLockServiceImpl
extends TXLockService {
    private static final Logger logger = LogService.getLogger();
    private static final long TIMEOUT_MILLIS = -1L;
    private static final long LEASE_MILLIS = -1L;
    private DLockService dlock;
    protected List txLockIdList = new ArrayList();
    private volatile boolean recovering = false;
    private final StoppableReentrantReadWriteLock recoveryLock;
    private final InternalDistributedSystem system;

    TXLockServiceImpl(String name, InternalDistributedSystem sys) {
        if (sys == null) {
            throw new IllegalStateException("TXLockService cannot be created until connected to distributed system.");
        }
        sys.getCancelCriterion().checkCancelInProgress(null);
        this.system = sys;
        this.recoveryLock = new StoppableReentrantReadWriteLock(sys.getCancelCriterion());
        this.dlock = (DLockService)DLockService.create(name, sys, true, true, true);
        this.dlock.setDLockRecoverGrantorMessageProcessor(new TXRecoverGrantorMessageProcessor());
        this.dlock.setDLockLessorDepartureHandler(new TXLessorDepartureHandler());
    }

    @Override
    public boolean isLockGrantor() {
        return this.dlock.isLockGrantor();
    }

    @Override
    public void becomeLockGrantor() {
        this.dlock.becomeLockGrantor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TXLockId txLock(List regionLockReqs, Set txParticipants) throws CommitConflictException {
        if (regionLockReqs == null) {
            throw new IllegalArgumentException("regionLockReqs must not be null");
        }
        Set participants = txParticipants;
        if (participants == null) {
            participants = Collections.EMPTY_SET;
        }
        boolean gotLocks = false;
        TXLockIdImpl txLockId = null;
        try {
            List list = this.txLockIdList;
            synchronized (list) {
                txLockId = new TXLockIdImpl(this.dlock.getDistributionManager().getId());
                this.txLockIdList.add(txLockId);
            }
            TXLockBatch batch = new TXLockBatch(txLockId, regionLockReqs, participants);
            logger.debug("[TXLockServiceImpl.txLock] acquire try-locks for {}", (Object)batch);
            Object[] keyIfFail = new Object[1];
            gotLocks = this.dlock.acquireTryLocks(batch, -1L, -1L, keyIfFail);
            if (!gotLocks) {
                if (keyIfFail[0] != null) {
                    throw new CommitConflictException(String.format("Concurrent transaction commit detected %s", keyIfFail[0]));
                }
                throw new CommitConflictException(String.format("Failed to request try locks from grantor: %s", this.dlock.getLockGrantorId()));
            }
            this.acquireRecoveryReadLock();
            logger.debug("[TXLockServiceImpl.txLock] gotLocks is {}, returning txLockId:{}", (Object)gotLocks, (Object)txLockId);
            return txLockId;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("[TXLockServiceImpl.txLock] was interrupted", (Throwable)e);
            if (gotLocks) {
                List list = this.txLockIdList;
                synchronized (list) {
                    this.txLockIdList.remove(txLockId);
                }
            }
            throw new CommitConflictException("Concurrent transaction commit detected because request was interrupted.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateParticipants(TXLockId txLockId, Set updatedParticipants) {
        List list = this.txLockIdList;
        synchronized (list) {
            if (!this.txLockIdList.contains(txLockId)) {
                IllegalArgumentException e = new IllegalArgumentException(String.format("Invalid txLockId not found: %s", txLockId));
                this.system.getDistributionManager().getCancelCriterion().checkCancelInProgress(e);
                InternalCache cache = this.system.getCache();
                if (cache != null) {
                    cache.getCancelCriterion().checkCancelInProgress(e);
                }
                throw e;
            }
        }
        if (updatedParticipants == null) {
            throw new IllegalArgumentException("Invalid updatedParticipants, null");
        }
        if (updatedParticipants.isEmpty()) {
            return;
        }
        if (!this.recovering) {
            if (this.dlock.isLockGrantor()) {
                TXLockUpdateParticipantsMessage.updateParticipants(this.dlock, txLockId, updatedParticipants);
            } else {
                LockGrantorId lockGrantorId = txLockId.getLockGrantorId();
                if (lockGrantorId == null || !this.dlock.isLockGrantorId(lockGrantorId)) {
                    return;
                }
                InternalDistributedMember grantorId = lockGrantorId.getLockGrantorMember();
                ReplyProcessor21 processor = new ReplyProcessor21(this.dlock.getDistributionManager(), grantorId);
                TXLockUpdateParticipantsMessage dlup = new TXLockUpdateParticipantsMessage(txLockId, this.dlock.getName(), updatedParticipants, processor.getProcessorId());
                dlup.setRecipient(grantorId);
                this.dlock.getDistributionManager().putOutgoing(dlup);
                this.dlock.getDistributionManager().getCancelCriterion().checkCancelInProgress(null);
                try {
                    processor.waitForRepliesUninterruptibly();
                }
                catch (ReplyException e) {
                    e.handleCause();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(TXLockId txLockId) {
        List list = this.txLockIdList;
        synchronized (list) {
            if (!this.txLockIdList.contains(txLockId)) {
                throw new IllegalArgumentException(String.format("Invalid txLockId not found: %s", txLockId));
            }
            this.dlock.releaseTryLocks(txLockId, () -> this.recovering);
            this.txLockIdList.remove(txLockId);
            this.releaseRecoveryReadLock();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.dlock.isDestroyed() || this.system.getCancelCriterion().isCancelInProgress();
    }

    boolean isRecovering() {
        return this.recovering;
    }

    void acquireRecoveryWriteLock() throws InterruptedException {
        this.recovering = true;
        this.recoveryLock.writeLock().lockInterruptibly();
    }

    void releaseRecoveryWriteLock() {
        this.recoveryLock.writeLock().unlock();
        this.recovering = false;
    }

    private void acquireRecoveryReadLock() throws InterruptedException {
        this.recoveryLock.readLock().lockInterruptibly();
    }

    private void releaseRecoveryReadLock() {
        this.recoveryLock.readLock().unlock();
    }

    public DLockService getInternalDistributedLockService() {
        return this.dlock;
    }

    @Override
    void basicDestroy() {
        this.dlock.destroyAndRemove();
    }
}

