/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.AbstractUpdateOperation;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class UpdateOperation
extends AbstractUpdateOperation {
    private static final Logger logger = LogService.getLogger();

    public UpdateOperation(EntryEventImpl event, long lastModifiedTime) {
        super(event, lastModifiedTime);
    }

    @Override
    protected boolean supportsDeltaPropagation() {
        return true;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        EntryEventImpl ev = this.getEvent();
        if (ev.isBridgeEvent()) {
            UpdateWithContextMessage mssgwithContxt = new UpdateWithContextMessage();
            mssgwithContxt.clientID = ev.getContext();
            return mssgwithContxt;
        }
        return new UpdateMessage();
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor p) {
        EntryEventImpl ev;
        super.initMessage(msg, p);
        UpdateMessage m = (UpdateMessage)msg;
        m.event = ev = this.getEvent();
        m.eventId = ev.getEventId();
        m.key = ev.getKey();
        m.deserializationPolicy = (byte)2;
        ev.exportNewValue(m);
    }

    @Override
    protected void initProcessor(DistributedCacheOperation.CacheOperationReplyProcessor p, DistributedCacheOperation.CacheOperationMessage msg) {
        if (this.processor != null) {
            this.processor.msg = msg instanceof UpdateWithContextMessage ? new UpdateWithContextMessage((UpdateWithContextMessage)msg) : new UpdateMessage((UpdateMessage)msg);
        }
    }

    public static class UpdateWithContextMessage
    extends UpdateMessage {
        protected transient ClientProxyMembershipID clientID;

        @Override
        public EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            Object argNewValue = null;
            boolean originRemote = true;
            boolean generateCallbacks = true;
            EntryEventImpl ev = EntryEventImpl.create(rgn, this.getOperation(), this.key, argNewValue, this.callbackArg, true, this.getSender(), true);
            ev.setContext(this.clientID);
            this.setOldValueInEvent(ev);
            return ev;
        }

        public UpdateWithContextMessage() {
        }

        public UpdateWithContextMessage(UpdateWithContextMessage msg) {
            super(msg);
            this.clientID = msg.clientID;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; context=").append(this.clientID);
        }

        @Override
        public int getDSFID() {
            return 93;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.clientID = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.clientID, out);
        }
    }

    public static class UpdateMessage
    extends AbstractUpdateOperation.AbstractUpdateMessage
    implements EntryEventImpl.NewValueImporter {
        protected byte deserializationPolicy;
        protected EntryEventImpl event = null;
        protected EventID eventId = null;
        protected Object key;
        protected byte[] newValue;
        protected transient Object newValueObj;
        private byte[] deltaBytes;
        private boolean sendDeltaWithFullValue = true;
        static final int HAS_EVENTID = UpdateMessage.getNextByteMask(DistributedCacheOperation.DESERIALIZATION_POLICY_END);
        static final int HAS_DELTA_WITH_FULL_VALUE = UpdateMessage.getNextByteMask(HAS_EVENTID);
        private Long tailKey = 0L;

        public UpdateMessage() {
        }

        public UpdateMessage(UpdateMessage upMsg) {
            this.appliedOperation = upMsg.appliedOperation;
            this.callbackArg = upMsg.callbackArg;
            this.deserializationPolicy = upMsg.deserializationPolicy;
            this.directAck = upMsg.directAck;
            this.event = upMsg.event;
            this.eventId = upMsg.eventId;
            this.hasDelta = upMsg.hasDelta;
            this.key = upMsg.key;
            this.lastModified = upMsg.lastModified;
            this.newValue = upMsg.newValue;
            this.newValueObj = upMsg.newValueObj;
            this.op = upMsg.op;
            this.owner = upMsg.owner;
            this.possibleDuplicate = upMsg.possibleDuplicate;
            this.processorId = upMsg.processorId;
            this.regionAllowsConflation = upMsg.regionAllowsConflation;
            this.regionPath = upMsg.regionPath;
            this.sendDelta = upMsg.sendDelta;
            this.sender = upMsg.sender;
            this.processor = upMsg.processor;
            this.filterRouting = upMsg.filterRouting;
            this.needsRouting = upMsg.needsRouting;
            this.versionTag = upMsg.versionTag;
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.directAck || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, this.getOperation().isUpdate());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = this.createEntryEvent(rgn);
            boolean evReturned = false;
            try {
                ev.setEventId(this.eventId);
                ev.setDeltaBytes(this.deltaBytes);
                if (this.hasDelta()) {
                    this.newValueObj = null;
                    ev.setNewValue(this.newValueObj);
                } else {
                    UpdateMessage.setNewValueInEvent(this.newValue, this.newValueObj, ev, this.deserializationPolicy);
                }
                if (this.filterRouting != null) {
                    ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
                }
                ev.setTailKey(this.tailKey);
                ev.setVersionTag(this.versionTag);
                ev.setInhibitAllNotifications(this.inhibitAllNotifications);
                evReturned = true;
                EntryEventImpl entryEventImpl = ev;
                return entryEventImpl;
            }
            finally {
                if (!evReturned) {
                    ev.release();
                }
            }
        }

        @Override
        boolean processReply(final ReplyMessage replyMessage, DistributedCacheOperation.CacheOperationReplyProcessor processor) {
            UpdateMessage message;
            ReplyException ex = replyMessage.getException();
            if (ex != null && ex.getCause() instanceof InvalidDeltaException && (!(message = this).hasBridgeContext() || message.getDataPolicy() != DataPolicy.EMPTY)) {
                final DistributionManager dm = this.event.getRegion().getDistributionManager();
                final UpdateMessage updateMsg = this instanceof UpdateWithContextMessage ? new UpdateWithContextMessage((UpdateWithContextMessage)this) : new UpdateMessage(this);
                Runnable sendMessage = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        UpdateMessage updateMessage = updateMsg;
                        synchronized (updateMessage) {
                            updateMsg.resetRecipients();
                            updateMsg.setRecipient(replyMessage.getSender());
                            updateMsg.setSendDelta(false);
                            updateMsg.setSendDeltaWithFullValue(false);
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sending full object ({}) to {}", (Object)updateMsg, (Object)replyMessage.getSender());
                            }
                            dm.putOutgoing(updateMsg);
                        }
                        updateMsg.event.getRegion().getCachePerfStats().incDeltaFullValuesSent();
                    }

                    public String toString() {
                        return "Sending full object {" + updateMsg.toString() + "}";
                    }
                };
                if (processor.isExpectingDirectReply()) {
                    sendMessage.run();
                } else {
                    dm.getWaitingThreadPool().execute(sendMessage);
                }
                return false;
            }
            return true;
        }

        static void setNewValueInEvent(byte[] newValue, Object newValueObj, EntryEventImpl event, byte deserializationPolicy) {
            if (newValue == null) {
                if (event.getRegion().getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                    event.setLocalInvalid(true);
                }
                event.setNewValue(newValue);
                Assert.assertTrue(deserializationPolicy == 0);
                return;
            }
            switch (deserializationPolicy) {
                case 2: {
                    event.setSerializedNewValue(newValue);
                    break;
                }
                case 0: {
                    event.setNewValue(newValue);
                    break;
                }
                default: {
                    throw new InternalGemFireError(String.format("unknown deserialization policy: %s", deserializationPolicy));
                }
            }
        }

        protected EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            Object argNewValue = null;
            boolean originRemote = true;
            boolean generateCallbacks = true;
            EntryEventImpl result = EntryEventImpl.create(rgn, this.getOperation(), this.key, argNewValue, this.callbackArg, true, this.getSender(), true);
            this.setOldValueInEvent(result);
            result.setTailKey(this.tailKey);
            if (this.versionTag != null) {
                result.setVersionTag(this.versionTag);
            }
            return result;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; key=");
            buff.append(this.key);
            if (this.hasDelta()) {
                byte[] bytes = this.event != null ? this.event.getDeltaBytes() : this.deltaBytes;
                if (bytes == null) {
                    buff.append("; null delta bytes");
                } else {
                    buff.append("; ").append(bytes.length).append(" delta bytes");
                }
            } else if (this.newValueObj != null) {
                buff.append("; newValueObj=");
                buff.append(this.newValueObj);
            } else {
                buff.append("; newValue=");
                buff.append(this.newValue == null ? "null" : "(" + this.newValue.length + " bytes)");
            }
            if (this.eventId != null) {
                buff.append("; eventId=").append(this.eventId);
            }
            buff.append("; deserializationPolicy=");
            buff.append(DistributedCacheOperation.deserializationPolicyToString(this.deserializationPolicy));
        }

        @Override
        public int getDSFID() {
            return 71;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean hasEventId;
            super.fromData(in);
            byte extraFlags = in.readByte();
            boolean bl = hasEventId = (extraFlags & HAS_EVENTID) != 0;
            if (hasEventId) {
                this.eventId = new EventID();
                InternalDataSerializer.invokeFromData(this.eventId, in);
                boolean hasTailKey = in.readBoolean();
                if (hasTailKey) {
                    this.tailKey = in.readLong();
                }
            } else {
                this.eventId = null;
            }
            this.key = DataSerializer.readObject(in);
            this.deserializationPolicy = (byte)(extraFlags & DistributedCacheOperation.DESERIALIZATION_POLICY_MASK);
            if (this.hasDelta()) {
                this.deltaBytes = DataSerializer.readByteArray(in);
            } else {
                this.newValue = DataSerializer.readByteArray(in);
                if ((extraFlags & HAS_DELTA_WITH_FULL_VALUE) != 0) {
                    this.deltaBytes = DataSerializer.readByteArray(in);
                }
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            DistributedRegion region = (DistributedRegion)this.event.getRegion();
            this.setDeltaFlag(region);
            super.toData(out);
            byte extraFlags = this.deserializationPolicy;
            if (this.eventId != null) {
                extraFlags = (byte)(extraFlags | HAS_EVENTID);
            }
            if (this.deserializationPolicy != 0 && this.sendDeltaWithFullValue && this.event.getDeltaBytes() != null) {
                extraFlags = (byte)(extraFlags | HAS_DELTA_WITH_FULL_VALUE);
            }
            out.writeByte(extraFlags);
            if (this.eventId != null) {
                InternalDataSerializer.invokeToData(this.eventId, out);
                if (region instanceof BucketRegion) {
                    PartitionedRegion pr = region.getPartitionedRegion();
                    if (!pr.isParallelWanEnabled()) {
                        out.writeBoolean(false);
                    } else {
                        out.writeBoolean(true);
                        out.writeLong(this.event.getTailKey());
                    }
                } else {
                    out.writeBoolean(false);
                }
            }
            DataSerializer.writeObject(this.key, out);
            if (this.hasDelta()) {
                DataSerializer.writeByteArray(this.event.getDeltaBytes(), out);
                this.event.getRegion().getCachePerfStats().incDeltasSent();
            } else {
                DistributedCacheOperation.writeValue(this.deserializationPolicy, this.newValueObj, this.newValue, out);
                if ((extraFlags & HAS_DELTA_WITH_FULL_VALUE) != 0) {
                    DataSerializer.writeByteArray(this.event.getDeltaBytes(), out);
                }
            }
        }

        @Override
        public EventID getEventID() {
            return this.eventId;
        }

        private void setDeltaFlag(DistributedRegion region) {
            try {
                if (region != null && region.getSystem().getConfig().getDeltaPropagation() && this.sendDelta && !region.scope.isDistributedNoAck() && this.event.getDeltaBytes() != null) {
                    this.setHasDelta(true);
                    return;
                }
                this.setHasDelta(false);
            }
            catch (RuntimeException re) {
                throw new InvalidDeltaException("Caught exception while sending delta. ", re);
            }
        }

        public boolean hasBridgeContext() {
            if (this.event != null) {
                return this.event.getContext() != null;
            }
            return false;
        }

        public DataPolicy getDataPolicy() {
            if (this.event != null) {
                return this.event.getRegion().getAttributes().getDataPolicy();
            }
            return null;
        }

        public void setSendDeltaWithFullValue(boolean bool) {
            this.sendDeltaWithFullValue = bool;
        }

        @Override
        public boolean prefersNewSerialized() {
            return true;
        }

        @Override
        public boolean isUnretainedNewReferenceOk() {
            return true;
        }

        @Override
        public void importNewObject(Object nv, boolean isSerialized) {
            if (nv == null) {
                this.deserializationPolicy = 0;
                this.newValue = null;
            } else {
                if (!isSerialized) {
                    this.deserializationPolicy = 0;
                }
                this.newValueObj = nv;
            }
        }

        @Override
        public void importNewBytes(byte[] nv, boolean isSerialized) {
            if (!isSerialized) {
                this.deserializationPolicy = 0;
            }
            this.newValue = nv;
        }
    }
}

