/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.internal.cache.IdentityArrayList;
import org.apache.geode.internal.cache.TXRegionLockRequestImpl;

public class TXReservationMgr {
    private final Map regionLocks;
    private final boolean local;

    public TXReservationMgr(boolean local) {
        AbstractMap m = local ? new IdentityHashMap() : new HashMap();
        this.regionLocks = m;
        this.local = local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeReservation(IdentityArrayList localLocks) throws CommitConflictException {
        int llSize = localLocks.size();
        Object[] llArray = localLocks.getArrayRef();
        Map map = this.regionLocks;
        synchronized (map) {
            for (int i = 0; i < llSize; ++i) {
                this.checkForConflict((TXRegionLockRequestImpl)llArray[i], localLocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReservation(IdentityArrayList localLocks) {
        Map map = this.regionLocks;
        synchronized (map) {
            this.release(localLocks, false);
        }
    }

    private void checkForConflict(TXRegionLockRequestImpl rr, IdentityArrayList localLocks) throws CommitConflictException {
        Set<Object> keys;
        Object r = this.getRegionObject(rr);
        Set<Object> oldValue = this.regionLocks.put(r, keys = rr.getKeys());
        if (oldValue != null) {
            try {
                Object[] keysArray = keys.toArray();
                if (oldValue instanceof Set) {
                    this.checkSetForConflict(rr, oldValue, keysArray, localLocks);
                    IdentityArrayList<Set<Object>> newValue = new IdentityArrayList<Set<Object>>(2);
                    newValue.add(oldValue);
                    newValue.add(keys);
                    this.regionLocks.put(r, newValue);
                } else {
                    IdentityArrayList al = (IdentityArrayList)((Object)oldValue);
                    int alSize = al.size();
                    Object[] alArray = al.getArrayRef();
                    for (int i = 0; i < alSize; ++i) {
                        this.checkSetForConflict(rr, (Set)alArray[i], keysArray, localLocks);
                    }
                    al.add(keys);
                    this.regionLocks.put(r, al);
                }
            }
            catch (CommitConflictException ex) {
                this.regionLocks.put(r, oldValue);
                throw ex;
            }
        }
    }

    private void checkSetForConflict(TXRegionLockRequestImpl rr, Set s, Object[] keys, IdentityArrayList localLocks) throws CommitConflictException {
        for (int i = 0; i < keys.length; ++i) {
            if (!s.contains(keys[i])) continue;
            this.release(localLocks, true);
            throw new CommitConflictException(String.format("The key %s in region %s was being modified by another transaction locally.", keys[i], rr.getRegionFullPath()));
        }
    }

    private Object getRegionObject(TXRegionLockRequestImpl lr) {
        if (this.local) {
            return lr.getLocalRegion();
        }
        return lr.getRegionFullPath();
    }

    private void release(IdentityArrayList localLocks, boolean conflictDetected) {
        int llSize = localLocks.size();
        Object[] llArray = localLocks.getArrayRef();
        for (int i = 0; i < llSize; ++i) {
            TXRegionLockRequestImpl rr = (TXRegionLockRequestImpl)llArray[i];
            Object r = this.getRegionObject(rr);
            Set<Object> keys = rr.getKeys();
            Object curValue = this.regionLocks.get(r);
            boolean foundIt = false;
            if (curValue != null) {
                IdentityArrayList al;
                int idx;
                if (curValue == keys) {
                    foundIt = true;
                    this.regionLocks.remove(r);
                } else if (curValue instanceof IdentityArrayList && (idx = (al = (IdentityArrayList)curValue).indexOf(keys)) != -1) {
                    foundIt = true;
                    al.remove(idx);
                    if (al.isEmpty()) {
                        this.regionLocks.remove(r);
                    }
                }
            }
            if (!foundIt && conflictDetected) break;
        }
    }
}

