/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.locks.TXLockId;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXFarSideCMTracker {
    private static final Logger logger = LogService.getLogger();
    private final Map txInProgress;
    private final Object[] txHistory;
    private int lastHistoryItem;
    private Map<TXId, TXCommitMessage> failoverMap = Collections.synchronizedMap(new LinkedHashMap<TXId, TXCommitMessage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > TXManagerImpl.FAILOVER_TX_MAP_SIZE;
        }
    });

    public TXFarSideCMTracker(int historySize) {
        this.txInProgress = new HashMap();
        this.txHistory = new Object[historySize];
        this.lastHistoryItem = 0;
    }

    public int getHistorySize() {
        return this.txHistory.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitProcessReceived(Object key) {
        TXCommitMessage message;
        Object object = this.txInProgress;
        synchronized (object) {
            message = (TXCommitMessage)this.getTxInProgress().get(key);
            if (this.foundTxInProgress(message)) {
                return true;
            }
            if (this.foundFromHistory(key)) {
                return true;
            }
        }
        if (message != null) {
            object = message;
            synchronized (object) {
                if (!message.isProcessing()) {
                    message.setDontProcess();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    Map getTxInProgress() {
        return this.txInProgress;
    }

    boolean foundTxInProgress(TXCommitMessage message) {
        return null != message && message.isProcessing();
    }

    boolean foundFromHistory(Object key) {
        for (int i = this.txHistory.length - 1; i >= 0; --i) {
            if (!key.equals(this.txHistory[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllToProcess() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean messageWritten = false;
        Map map = this.txInProgress;
        synchronized (map) {
            while (!this.txInProgress.isEmpty()) {
                logger.info("Lock grantor recovery is waiting for transactions to complete: {}", (Object)this.txInProgress);
                messageWritten = true;
                this.txInProgress.wait();
            }
        }
        if (messageWritten) {
            logger.info("Wait for transactions completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToProcess(TXLockId lockId, DistributionManager dm) {
        TXCommitMessage commitMessage;
        this.waitForMemberToDepart(lockId.getMemberId(), dm);
        Object object = this.txInProgress;
        synchronized (object) {
            commitMessage = (TXCommitMessage)this.txInProgress.get(lockId);
        }
        if (commitMessage != null) {
            object = commitMessage;
            synchronized (object) {
                while (!commitMessage.wasProcessed() && !commitMessage.isDepartureNoticed()) {
                    try {
                        commitMessage.wait(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        logger.error(String.format("Waiting to complete on message %s caught an interrupted exception", commitMessage), (Throwable)ie);
                        break;
                    }
                }
            }
        } else {
            for (int i = this.txHistory.length - 1; i >= 0; --i) {
                if (!lockId.equals(this.txHistory[i])) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForMemberToDepart(final InternalDistributedMember memberId, DistributionManager dm) {
        if (!dm.getDistributionManagerIds().contains(memberId)) {
            return;
        }
        final Object lock = new Object();
        MembershipListener memEar = new MembershipListener(){

            @Override
            public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
            }

            @Override
            public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
                if (memberId.equals(id)) {
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
            }

            @Override
            public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            }
        };
        try {
            Set<InternalDistributedMember> memberSet = dm.addMembershipListenerAndGetDistributionManagerIds(memEar);
            Object object = lock;
            synchronized (object) {
                while (memberSet.contains(memberId)) {
                    try {
                        lock.wait();
                        memberSet = dm.getDistributionManagerIds();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var6_6
                        dm.removeMembershipListener(memEar);
                        return;
                    }
                }
                return;
            }
        }
        finally {
            dm.removeMembershipListener(memEar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXCommitMessage processed(TXCommitMessage processedMess) {
        TXCommitMessage mess;
        Object key = processedMess.getTrackerKey();
        Object object = this.txInProgress;
        synchronized (object) {
            mess = (TXCommitMessage)this.txInProgress.remove(key);
            if (mess != null) {
                this.txHistory[this.lastHistoryItem++] = key;
                if (this.lastHistoryItem >= this.txHistory.length) {
                    this.lastHistoryItem = 0;
                }
                if (this.txInProgress.isEmpty()) {
                    this.txInProgress.notifyAll();
                }
            }
        }
        if (mess != null) {
            object = mess;
            synchronized (object) {
                mess.setProcessed(true);
                mess.notifyAll();
            }
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(TXCommitMessage deadMess) {
        Map map = this.txInProgress;
        synchronized (map) {
            this.txInProgress.remove(deadMess.getTrackerKey());
            if (this.txInProgress.isEmpty()) {
                this.txInProgress.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXCommitMessage get(Object key) {
        TXCommitMessage mess;
        Map map = this.txInProgress;
        synchronized (map) {
            mess = (TXCommitMessage)this.txInProgress.get(key);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TXCommitMessage waitForMessage(Object key, DistributionManager dm) {
        TXCommitMessage msg = null;
        Map map = this.txInProgress;
        synchronized (map) {
            msg = (TXCommitMessage)this.txInProgress.get(key);
            while (msg == null) {
                try {
                    dm.getSystem().getCancelCriterion().checkCancelInProgress(null);
                    this.txInProgress.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                msg = (TXCommitMessage)this.txInProgress.get(key);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TXCommitMessage msg) {
        Map map = this.txInProgress;
        synchronized (map) {
            Object key = msg.getTrackerKey();
            if (key == null) {
                Assert.assertTrue(false, "TXFarSideCMTracker must have a non-null key for message " + msg);
            }
            this.txInProgress.put(key, msg);
            this.txInProgress.notifyAll();
        }
    }

    public void saveTXForClientFailover(TXId txId, TXCommitMessage msg) {
        this.failoverMap.put(txId, msg);
    }

    public TXCommitMessage getTXCommitMessage(TXId txId) {
        return this.failoverMap.get(txId);
    }

    public void clearForCacheClose() {
        this.failoverMap.clear();
        this.lastHistoryItem = 0;
        Arrays.fill(this.txHistory, null);
    }

    @VisibleForTesting
    public int getFailoverMapSize() {
        return this.failoverMap.size();
    }
}

