/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class HttpService {
    private static final Logger logger = LogService.getLogger();
    private Server httpServer;
    private String bindAddress = "0.0.0.0";
    private int port;
    private SSLConfig sslConfig;
    private static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String HTTPS = "https";
    public static final String SECURITY_SERVICE_SERVLET_CONTEXT_PARAM = "org.apache.geode.securityService";
    public static final String GEODE_SSLCONFIG_SERVLET_CONTEXT_PARAM = "org.apache.geode.sslConfig";
    public static final String CLUSTER_MANAGEMENT_SERVICE_CONTEXT_PARAM = "org.apache.geode.cluster.management.service";
    private List<WebAppContext> webApps = new ArrayList<WebAppContext>();

    public HttpService(String bindAddress, int port, SSLConfig sslConfig) {
        if (port == 0) {
            return;
        }
        this.sslConfig = sslConfig;
        this.httpServer = new Server();
        this.httpServer.setHandler((Handler)new HandlerCollection(true, new Handler[0]));
        ServerConnector connector = null;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HTTPS);
        httpConfig.setSecurePort(port);
        if (sslConfig.isEnabled()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getAlias())) {
                sslContextFactory.setCertAlias(sslConfig.getAlias());
            }
            sslContextFactory.setNeedClientAuth(sslConfig.isRequireAuth());
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getCiphers()) && !"any".equalsIgnoreCase(sslConfig.getCiphers())) {
                sslContextFactory.setExcludeCipherSuites(new String[0]);
                sslContextFactory.setIncludeCipherSuites(SSLUtil.readArray(sslConfig.getCiphers()));
            }
            sslContextFactory.setSslContext(SSLUtil.createAndConfigureSSLContext(sslConfig, false));
            if (logger.isDebugEnabled()) {
                logger.debug(sslContextFactory.dump());
            }
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(this.httpServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        } else {
            connector = new ServerConnector(this.httpServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        }
        this.httpServer.setConnectors(new Connector[]{connector});
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            connector.setHost(bindAddress);
        }
        if (bindAddress != null && !bindAddress.isEmpty()) {
            this.bindAddress = bindAddress;
        }
        this.port = port;
        logger.info("Enabled HttpService on port {}", (Object)port);
    }

    public Server getHttpServer() {
        return this.httpServer;
    }

    public synchronized void addWebApplication(String webAppContext, String warFilePath, Pair<String, Object> ... attributeNameValuePairs) throws Exception {
        if (this.httpServer == null) {
            logger.info(String.format("unable to add %s webapp. Http service is not started on this member.", webAppContext));
            return;
        }
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(webAppContext);
        webapp.setWar(warFilePath);
        webapp.setParentLoaderPriority(false);
        webapp.getSystemClasspathPattern().add("com.fasterxml.jackson.annotation.");
        webapp.getServerClasspathPattern().add(new String[]{"com.fasterxml.jackson.", "-com.fasterxml.jackson.annotation."});
        webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        webapp.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        if (attributeNameValuePairs != null) {
            Arrays.stream(attributeNameValuePairs).forEach(p -> webapp.setAttribute((String)p.getKey(), p.getValue()));
        }
        File tmpPath = new File(this.getWebAppBaseDirectory(webAppContext));
        tmpPath.mkdirs();
        webapp.setTempDirectory(tmpPath);
        logger.info("Adding webapp " + webAppContext);
        ((HandlerCollection)this.httpServer.getHandler()).addHandler((Handler)webapp);
        if (!this.httpServer.isStarted()) {
            logger.info("Attempting to start HTTP service on port ({}) at bind-address ({})...", (Object)this.port, (Object)this.bindAddress);
            this.httpServer.start();
        } else {
            webapp.start();
        }
        this.webApps.add(webapp);
    }

    private String getWebAppBaseDirectory(String context) {
        String underscoredContext = context.replace("/", "_");
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        String workingDirectory = USER_DIR.concat(FILE_PATH_SEPARATOR).concat("GemFire_" + USER_NAME).concat(FILE_PATH_SEPARATOR).concat("services").concat(FILE_PATH_SEPARATOR).concat("http").concat(FILE_PATH_SEPARATOR).concat(StringUtils.isBlank((CharSequence)this.bindAddress) ? "0.0.0.0" : this.bindAddress).concat("_").concat(String.valueOf(this.port).concat(underscoredContext)).concat("_").concat(uuid);
        return workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (this.httpServer == null) {
            return;
        }
        logger.debug("Stopping the HTTP service...");
        try {
            for (WebAppContext webapp : this.webApps) {
                webapp.stop();
            }
            this.httpServer.stop();
            return;
        }
        catch (Exception e) {
            logger.warn("Failed to stop the HTTP service because: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.info("Failed to properly release resources held by the HTTP service: {}", (Object)ignore.getMessage(), (Object)ignore);
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
        }
    }
}

