/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.logging.log4j.Logger;

public abstract class ExpiryTask
extends SystemTimer.SystemTimerTask {
    private static final Logger logger = LogService.getLogger();
    private LocalRegion region;
    @MakeNotStatic
    private static final ExecutorService executor;
    @MakeNotStatic
    private static boolean expirationSuspended;
    @MakeNotStatic
    private static final Object suspendLock;
    private static final ThreadLocal<Long> now;
    @MutableForTesting
    public static ExpiryTaskListener expiryTaskListener;

    private static void doExpiryThread(Runnable command) {
        ConnectionTable.threadWantsSharedResources();
        try {
            command.run();
        }
        finally {
            ConnectionTable.releaseThreadsSockets();
        }
    }

    protected ExpiryTask(LocalRegion region) {
        this.region = region;
    }

    protected abstract ExpirationAttributes getIdleAttributes();

    protected abstract ExpirationAttributes getTTLAttributes();

    public long getExpirationTime() throws EntryNotFoundException {
        long ttl = this.getTTLExpirationTime();
        long idle = this.getIdleExpirationTime();
        if (ttl == 0L) {
            return idle;
        }
        if (idle == 0L) {
            return ttl;
        }
        return Math.min(ttl, idle);
    }

    public long getTTLExpirationTime() throws EntryNotFoundException {
        long ttl = this.getTTLAttributes().getTimeout();
        long tilt = 0L;
        if (ttl > 0L) {
            if (this.getLocalRegion() != null && !this.getLocalRegion().EXPIRY_UNITS_MS) {
                ttl *= 1000L;
            }
            tilt = this.getLastModifiedTime() + ttl;
        }
        return tilt;
    }

    public long getIdleExpirationTime() throws EntryNotFoundException {
        long idle = this.getIdleTimeoutInMillis();
        if (idle > 0L) {
            return this.getLastAccessedTime() + idle;
        }
        return 0L;
    }

    protected long getIdleTimeoutInMillis() {
        long idle = this.getIdleAttributes().getTimeout();
        if (idle > 0L && this.getLocalRegion() != null && !this.getLocalRegion().EXPIRY_UNITS_MS) {
            idle *= 1000L;
        }
        return idle;
    }

    long getExpiryMillis() throws EntryNotFoundException {
        long extm = this.getExpirationTime() - this.getNow();
        if (extm < 0L) {
            return 0L;
        }
        return extm;
    }

    protected boolean isExpirationPossible() throws EntryNotFoundException {
        long now;
        long expTime = this.getExpirationTime();
        if (expTime > 0L && (now = this.getNow()) >= expTime) {
            if (this.isIdleExpiredOnOthers()) {
                return true;
            }
            expTime = this.getExpirationTime();
            if (expTime > 0L && now >= expTime) {
                return true;
            }
        }
        return false;
    }

    protected boolean isIdleExpiredOnOthers() throws EntryNotFoundException {
        return true;
    }

    protected boolean isExpirationAllowed() {
        return this.getLocalRegion().isExpirationAllowed(this);
    }

    protected void performTimeout() throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}.performTimeout(): getExpirationTime() returns {}", (Object)this.toString(), (Object)this.getExpirationTime());
        }
        this.getLocalRegion().performExpiryTimeout(this);
    }

    protected abstract void basicPerformTimeout(boolean var1) throws CacheException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void suspendExpiration() {
        Object object = suspendLock;
        synchronized (object) {
            expirationSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void permitExpiration() {
        Object object = suspendLock;
        synchronized (object) {
            expirationSuspended = false;
            suspendLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnExpirationSuspension() {
        while (true) {
            this.getLocalRegion().getCancelCriterion().checkCancelInProgress(null);
            Object object = suspendLock;
            synchronized (object) {
                boolean interrupted = Thread.interrupted();
                try {
                    while (expirationSuspended) {
                        suspendLock.wait();
                    }
                    break;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.getLocalRegion().getCancelCriterion().checkCancelInProgress(null);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    protected boolean expire(boolean isPending) throws CacheException {
        ExpirationAction action = this.getAction();
        if (action == null) {
            return false;
        }
        boolean result = this.expire(action, isPending);
        if (result && expiryTaskListener != null) {
            expiryTaskListener.afterExpire(this);
        }
        return result;
    }

    protected ExpirationAction getAction() {
        long ttl = this.getTTLExpirationTime();
        long idle = this.getIdleExpirationTime();
        if (ttl == 0L) {
            if (idle == 0L) {
                return null;
            }
            return this.getIdleAttributes().getAction();
        }
        if (idle == 0L) {
            return this.getTTLAttributes().getAction();
        }
        if (idle < ttl) {
            return this.getIdleAttributes().getAction();
        }
        return this.getTTLAttributes().getAction();
    }

    protected boolean isDistributedAction() {
        ExpirationAction action = this.getAction();
        return action != null && (action.isInvalidate() || action.isDestroy());
    }

    LocalRegion getLocalRegion() {
        return this.region;
    }

    protected boolean expire(ExpirationAction action, boolean isPending) throws CacheException {
        if (action.isInvalidate()) {
            return this.invalidate();
        }
        if (action.isDestroy()) {
            return this.destroy(isPending);
        }
        if (action.isLocalInvalidate()) {
            return this.localInvalidate();
        }
        if (action.isLocalDestroy()) {
            return this.localDestroy();
        }
        throw new InternalGemFireError(String.format("unrecognized expiration action: %s", action));
    }

    @Override
    public boolean cancel() {
        boolean superCancel = super.cancel();
        LocalRegion lr = this.getLocalRegion();
        if (lr != null && superCancel) {
            this.region = null;
        }
        return superCancel;
    }

    @Override
    public void run2() {
        try {
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ExpiryTask.this.runInThreadPool();
                    }
                });
            } else {
                this.runInThreadPool();
            }
        }
        catch (RejectedExecutionException ex) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rejected execution in expiration task", (Throwable)ex);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                t.printStackTrace();
            }
        }
        catch (CancelException e) {
            return;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            logger.fatal("Exception in expiration task", ex);
        }
    }

    protected void runInThreadPool() {
        try {
            if (this.isCacheClosing() || this.getLocalRegion().isClosed() || this.getLocalRegion().isDestroyed()) {
                return;
            }
            this.waitOnExpirationSuspension();
            if (logger.isTraceEnabled()) {
                logger.trace("{} is fired", (Object)this);
            }
            this.performTimeout();
        }
        catch (RegionDestroyedException regionDestroyedException) {
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        catch (CancelException cancelException) {
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            logger.fatal("Exception in expiration task", ex);
        }
        finally {
            if (expiryTaskListener != null) {
                expiryTaskListener.afterTaskRan(this);
            }
        }
    }

    protected boolean isCacheClosing() {
        return this.getLocalRegion().getCache().isClosed();
    }

    protected abstract void reschedule() throws CacheException;

    public String toString() {
        String expTtl = "<unavailable>";
        String expIdle = "<unavailable>";
        try {
            if (this.getTTLAttributes() != null) {
                expTtl = String.valueOf(this.getTTLExpirationTime());
            }
            if (this.getIdleAttributes() != null) {
                expIdle = String.valueOf(this.getIdleExpirationTime());
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        return super.toString() + " for " + this.getLocalRegion() + ", ttl expiration time: " + expTtl + ", idle expiration time: " + expIdle + "[now:" + this.calculateNow() + "]";
    }

    protected abstract long getLastModifiedTime() throws EntryNotFoundException;

    protected abstract long getLastAccessedTime() throws EntryNotFoundException;

    protected abstract boolean invalidate() throws CacheException;

    protected abstract boolean destroy(boolean var1) throws CacheException;

    protected abstract boolean localInvalidate() throws EntryNotFoundException;

    protected abstract boolean localDestroy() throws CacheException;

    protected abstract void addExpiryTask() throws EntryNotFoundException;

    public abstract boolean isPending();

    public abstract Object getKey();

    static void doWithNowSet(LocalRegion lr, Runnable runnable) {
        now.set(ExpiryTask.calculateNow(lr.getCache()));
        try {
            runnable.run();
        }
        finally {
            now.remove();
        }
    }

    protected long getNow() {
        Long tl = now.get();
        long result = tl != null ? tl.longValue() : this.calculateNow();
        return result;
    }

    public long calculateNow() {
        return ExpiryTask.calculateNow(this.getLocalRegion().getCache());
    }

    public static long calculateNow(InternalCache cache) {
        InternalDistributedSystem ids;
        if (cache != null && (ids = cache.getInternalDistributedSystem()) != null) {
            return ids.getClock().cacheTimeMillis();
        }
        return 0L;
    }

    static {
        int nThreads = Integer.getInteger("gemfire.EXPIRY_THREADS", 0);
        executor = nThreads > 0 ? LoggingExecutors.newThreadPoolWithSynchronousFeed("Expiry ", command -> ExpiryTask.doExpiryThread(command), nThreads) : null;
        expirationSuspended = false;
        suspendLock = new Object();
        now = new ThreadLocal();
    }

    public static interface ExpiryTaskListener {
        public void afterSchedule(ExpiryTask var1);

        public void afterTaskRan(ExpiryTask var1);

        public void afterReschedule(ExpiryTask var1);

        public void afterExpire(ExpiryTask var1);

        public void afterCancel(ExpiryTask var1);
    }
}

