/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.FunctionStreamingOrderedReplyMessage;
import org.apache.geode.internal.cache.FunctionStreamingReplyMessage;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DistributedRegionFunctionStreamingMessage
extends DistributionMessage
implements TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    private Object result;
    transient int replyMsgNum = 0;
    transient boolean replyLastMsg;
    transient int numObjectsInChunk = 0;
    private Function functionObject;
    private String functionName;
    Object args;
    private String regionPath;
    private Set filter;
    private int processorId;
    private boolean isReExecute;
    private boolean isFnSerializationReqd;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    private static final short IS_REEXECUTE = 64;
    @Immutable
    static final ForceReattemptException UNHANDLED_EXCEPTION = (ForceReattemptException)new ForceReattemptException("Unknown exception").fillInStackTrace();

    public DistributedRegionFunctionStreamingMessage() {
    }

    public DistributedRegionFunctionStreamingMessage(String regionPath, Function function, int procId, Set filter, Object args, boolean isReExecute, boolean isFnSerializationReqd) {
        this.functionObject = function;
        this.processorId = procId;
        this.args = args;
        this.regionPath = regionPath;
        this.filter = filter;
        this.isReExecute = isReExecute;
        this.isFnSerializationReqd = isFnSerializationReqd;
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
    }

    private TXStateProxy prepForTransaction(ClusterDistributionManager dm) throws InterruptedException {
        if (this.txUniqId == -1) {
            return null;
        }
        InternalCache cache = dm.getCache();
        if (cache == null) {
            return null;
        }
        TXManagerImpl mgr = cache.getTXMgr();
        return mgr.masqueradeAs(this);
    }

    private void cleanupTransaction(TXStateProxy tx) {
        if (this.txUniqId != -1) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            TXManagerImpl mgr = cache.getTXMgr();
            mgr.unmasquerade(tx);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean operateOnDistributedRegion(ClusterDistributionManager dm, DistributedRegion r) throws ForceReattemptException {
        if (this.functionObject == null) {
            ReplyMessage.send(this.getSender(), this.processorId, new ReplyException(new FunctionException(String.format("Function named %s is not registered to FunctionService", this.functionName))), dm, r.isInternalRegion());
            return false;
        }
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "FunctionMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        try {
            r.executeOnRegion(this, this.functionObject, this.args, this.processorId, this.filter, this.isReExecute);
            if (!this.replyLastMsg && this.functionObject.hasResult()) {
                ReplyMessage.send(this.getSender(), this.processorId, new ReplyException(new FunctionException(String.format("The function, %s, did not send last result", this.functionObject.getId()))), dm, r.isInternalRegion());
                return false;
            }
        }
        catch (IOException e) {
            ReplyMessage.send(this.getSender(), this.processorId, new ReplyException("Operation got interrupted due to shutdown in progress on remote VM", e), dm, r.isInternalRegion());
            return false;
        }
        catch (CancelException sde) {
            ReplyMessage.send(this.getSender(), this.processorId, new ReplyException(new ForceReattemptException("Operation got interrupted due to shutdown in progress on remote VM", sde)), dm, r.isInternalRegion());
            return false;
        }
        return false;
    }

    private boolean checkCacheClosing(ClusterDistributionManager dm) {
        InternalCache cache = dm.getCache();
        return cache == null || cache.getCancelCriterion().isCancelInProgress();
    }

    private boolean checkDSClosing(ClusterDistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getDSFID() {
        return 1203;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        Object object;
        super.fromData(in);
        short flags = in.readShort();
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        if ((object = DataSerializer.readObject(in)) instanceof String) {
            this.isFnSerializationReqd = false;
            this.functionObject = FunctionService.getFunction((String)object);
            if (this.functionObject == null) {
                this.functionName = (String)object;
            }
        } else {
            this.functionObject = (Function)object;
            this.isFnSerializationReqd = true;
        }
        this.args = (Serializable)DataSerializer.readObject(in);
        this.filter = DataSerializer.readHashSet(in);
        this.regionPath = DataSerializer.readString(in);
        this.isReExecute = (flags & 0x40) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.txUniqId != -1) {
            flags = (short)(flags | 4);
        }
        if (this.txMemberId != null) {
            flags = (short)(flags | 2);
        }
        if (this.isReExecute) {
            flags = (short)(flags | 0x40);
        }
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.txUniqId != -1) {
            out.writeInt(this.txUniqId);
        }
        if (this.txMemberId != null) {
            DataSerializer.writeObject(this.txMemberId, out);
        }
        if (this.isFnSerializationReqd) {
            DataSerializer.writeObject(this.functionObject, out);
        } else {
            DataSerializer.writeObject(this.functionObject.getId(), out);
        }
        DataSerializer.writeObject(this.args, out);
        DataSerializer.writeHashSet((HashSet)this.filter, out);
        DataSerializer.writeString(this.regionPath, out);
    }

    public synchronized boolean sendReplyForOneResult(DistributionManager dm, Object oneResult, boolean lastResult, boolean sendResultsInOrder) throws CacheException, ForceReattemptException, InterruptedException {
        if (this.replyLastMsg) {
            return false;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int msgNum = this.replyMsgNum;
        this.replyLastMsg = lastResult;
        this.sendReply(this.getSender(), this.processorId, dm, null, oneResult, msgNum, lastResult, sendResultsInOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending reply message count: {} to co-ordinating node", (Object)this.replyMsgNum);
        }
        ++this.replyMsgNum;
        return false;
    }

    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, Object result, int msgNum, boolean lastResult, boolean sendResultsInOrder) {
        if (ex != null) {
            this.result = null;
            this.replyMsgNum = 0;
            this.replyLastMsg = true;
        }
        if (sendResultsInOrder) {
            FunctionStreamingOrderedReplyMessage.send(member, procId, ex, dm, result, msgNum, lastResult);
        } else {
            FunctionStreamingReplyMessage.send(member, procId, ex, dm, result, msgNum, lastResult);
        }
    }

    @Override
    public int getProcessorType() {
        return 80;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return null;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return false;
    }
}

