/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.persistence.PRPersistentConfig;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ColocationHelper {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    public static boolean IGNORE_UNRECOVERED_QUEUE = Boolean.getBoolean("gemfire.IGNORE_UNRECOVERED_QUEUE");

    public static PartitionedRegion getColocatedRegion(PartitionedRegion partitionedRegion) {
        PartitionedRegion colocatedPR;
        block5: {
            Assert.assertTrue(partitionedRegion != null);
            String colocatedWith = partitionedRegion.getPartitionAttributes().getColocatedWith();
            if (colocatedWith == null) {
                return null;
            }
            LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
            PartitionRegionConfig prConf = (PartitionRegionConfig)prRoot.get(ColocationHelper.getRegionIdentifier(colocatedWith));
            if (prConf == null) {
                partitionedRegion.getCache().getCancelCriterion().checkCancelInProgress(null);
                throw new IllegalStateException(String.format("Region specified in 'colocated-with' (%s) for region %s does not exist. It should be created before setting 'colocated-with' attribute for this region.", colocatedWith, partitionedRegion.getFullPath()));
            }
            int prID = prConf.getPRId();
            colocatedPR = null;
            try {
                colocatedPR = PartitionedRegion.getPRFromId(prID);
                if (colocatedPR == null) {
                    partitionedRegion.getCache().getCancelCriterion().checkCancelInProgress(null);
                    throw new IllegalStateException(String.format("Region specified in 'colocated-with' (%s) for region %s does not exist. It should be created before setting 'colocated-with' attribute for this region.", colocatedWith, partitionedRegion.getFullPath()));
                }
                colocatedPR.waitOnBucketMetadataInitialization();
            }
            catch (PRLocallyDestroyedException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("PRLocallyDestroyedException : Region with prId={} is locally destroyed on this node", (Object)prID, (Object)e);
            }
        }
        return colocatedPR;
    }

    public static boolean checkMembersColocation(PartitionedRegion partitionedRegion, InternalDistributedMember member) {
        String colocatedWithRegionName;
        ArrayList colocatedRegions = new ArrayList();
        ArrayList<PartitionRegionConfig> tempcolocatedRegions = new ArrayList<PartitionRegionConfig>();
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig regionConfig = (PartitionRegionConfig)prRoot.get(partitionedRegion.getRegionIdentifier());
        if (regionConfig == null) {
            return false;
        }
        tempcolocatedRegions.add(regionConfig);
        colocatedRegions.addAll(tempcolocatedRegions);
        PartitionRegionConfig prConf = null;
        do {
            PartitionRegionConfig tempToBeColocatedWith = (PartitionRegionConfig)tempcolocatedRegions.remove(0);
            for (String prName : prRoot.keySet()) {
                try {
                    prConf = (PartitionRegionConfig)prRoot.get(prName);
                }
                catch (EntryDestroyedException ignore) {
                    continue;
                }
                if (prConf == null || prConf.getColocatedWith() == null || !prConf.getColocatedWith().equals(tempToBeColocatedWith.getFullPath()) && !("/" + prConf.getColocatedWith()).equals(tempToBeColocatedWith.getFullPath())) continue;
                colocatedRegions.add(prConf);
                tempcolocatedRegions.add(prConf);
            }
        } while (!tempcolocatedRegions.isEmpty());
        PartitionRegionConfig tempColocatedWith = regionConfig;
        prConf = null;
        while ((colocatedWithRegionName = tempColocatedWith.getColocatedWith()) != null && (prConf = (PartitionRegionConfig)prRoot.get(ColocationHelper.getRegionIdentifier(colocatedWithRegionName))) != null) {
            colocatedRegions.add(tempColocatedWith);
            tempColocatedWith = prConf;
        }
        for (PartitionRegionConfig config : colocatedRegions) {
            if (!config.isColocationComplete() || config.containsMember(member)) continue;
            return false;
        }
        return !ColocationHelper.hasOfflineColocatedChildRegions(partitionedRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOfflineColocatedChildRegions(PartitionedRegion region) {
        boolean hasOfflineChildren = false;
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            InternalCache cache = region.getCache();
            Collection<DiskStore> stores = cache.listDiskStores();
            for (DiskStore diskStore : stores) {
                for (Map.Entry<String, PRPersistentConfig> entry : ((DiskStoreImpl)diskStore).getAllPRs().entrySet()) {
                    PRPersistentConfig config = entry.getValue();
                    String childName = entry.getKey();
                    if (!region.getFullPath().equals(config.getColocatedWith())) continue;
                    PartitionedRegion childRegion = (PartitionedRegion)cache.getRegion(childName);
                    if (childRegion == null) {
                        if (ColocationHelper.ignoreUnrecoveredQueue(region, childName)) continue;
                        region.addMissingColocatedRegionLogger(childName);
                        hasOfflineChildren = true;
                        continue;
                    }
                    if (!ColocationHelper.hasOfflineColocatedChildRegions(childRegion)) continue;
                    hasOfflineChildren = true;
                    region.addMissingColocatedRegionLogger(childRegion);
                }
            }
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
        return hasOfflineChildren;
    }

    private static boolean ignoreUnrecoveredQueue(PartitionedRegion region, String childName) {
        if (!ParallelGatewaySenderQueue.isParallelQueue(childName)) {
            return false;
        }
        String senderId = ParallelGatewaySenderQueue.getSenderId(childName);
        return !region.getAsyncEventQueueIds().contains(senderId) && !region.getParallelGatewaySenderIds().contains(senderId) && IGNORE_UNRECOVERED_QUEUE;
    }

    public static boolean isColocationComplete(PartitionedRegion region) {
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(region.getCache());
        PartitionRegionConfig config = (PartitionRegionConfig)prRoot.get(region.getRegionIdentifier());
        if (config == null) {
            Assert.assertTrue(region.isDestroyed() || region.isClosed, "Region is not destroyed, but there is no entry in the prRoot for region " + region);
            return false;
        }
        return config.isColocationComplete();
    }

    public static Map<String, PartitionedRegion> getAllColocationRegions(PartitionedRegion partitionedRegion) {
        PartitionedRegion colocatedWithRegion;
        HashMap<String, PartitionedRegion> colocatedRegions = new HashMap<String, PartitionedRegion>();
        List<PartitionedRegion> colocatedByRegion = partitionedRegion.getColocatedByList();
        if (colocatedByRegion.size() != 0) {
            ArrayList<PartitionedRegion> tempcolocatedRegions = new ArrayList<PartitionedRegion>();
            tempcolocatedRegions.addAll(colocatedByRegion);
            do {
                PartitionedRegion pRegion = (PartitionedRegion)tempcolocatedRegions.remove(0);
                pRegion.waitOnBucketMetadataInitialization();
                colocatedRegions.put(pRegion.getFullPath(), pRegion);
                tempcolocatedRegions.addAll(pRegion.getColocatedByList());
            } while (!tempcolocatedRegions.isEmpty());
        }
        PartitionedRegion tempColocatedWith = partitionedRegion;
        while ((colocatedWithRegion = tempColocatedWith.getColocatedWithRegion()) != null) {
            colocatedRegions.put(colocatedWithRegion.getFullPath(), colocatedWithRegion);
            tempColocatedWith = colocatedWithRegion;
        }
        return colocatedRegions;
    }

    public static Map<String, Region> getAllColocatedLocalDataSets(PartitionedRegion partitionedRegion, InternalRegionFunctionContext context) {
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(partitionedRegion);
        HashMap<String, Region> colocatedLocalRegions = new HashMap<String, Region>();
        for (Map.Entry<String, PartitionedRegion> me : colocatedRegions.entrySet()) {
            Region pr = me.getValue();
            colocatedLocalRegions.put(me.getKey(), context.getLocalDataSet(pr));
        }
        return colocatedLocalRegions;
    }

    public static Map<String, LocalDataSet> constructAndGetAllColocatedLocalDataSet(PartitionedRegion region, Set<Integer> bucketSet) {
        HashMap<String, LocalDataSet> colocatedLocalDataSets = new HashMap<String, LocalDataSet>();
        if (region.getColocatedWith() == null && !region.isColocatedBy()) {
            colocatedLocalDataSets.put(region.getFullPath(), new LocalDataSet(region, bucketSet));
            return colocatedLocalDataSets;
        }
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(region);
        for (Region region2 : colocatedRegions.values()) {
            colocatedLocalDataSets.put(region2.getFullPath(), new LocalDataSet((PartitionedRegion)region2, bucketSet));
        }
        colocatedLocalDataSets.put(region.getFullPath(), new LocalDataSet(region, bucketSet));
        return colocatedLocalDataSets;
    }

    public static Map<String, LocalDataSet> getColocatedLocalDataSetsForBuckets(PartitionedRegion region, Set<Integer> bucketSet) {
        if (region.getColocatedWith() == null && !region.isColocatedBy()) {
            return Collections.emptyMap();
        }
        HashMap<String, LocalDataSet> ret = new HashMap<String, LocalDataSet>();
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(region);
        for (Region region2 : colocatedRegions.values()) {
            ret.put(region2.getFullPath(), new LocalDataSet((PartitionedRegion)region2, bucketSet));
        }
        return ret;
    }

    public static List<PartitionedRegion> getColocatedChildRegions(PartitionedRegion partitionedRegion) {
        ArrayList<PartitionedRegion> colocatedChildRegions = new ArrayList<PartitionedRegion>();
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(partitionedRegion.getCache());
        PartitionRegionConfig prConf = null;
        Iterator itr = prRoot.keySet().iterator();
        while (itr.hasNext()) {
            try {
                int prID;
                PartitionedRegion prRegion;
                String prName = (String)itr.next();
                if (prName.equals(partitionedRegion.getRegionIdentifier())) continue;
                try {
                    prConf = (PartitionRegionConfig)prRoot.get(prName);
                }
                catch (EntryDestroyedException ignore) {
                    continue;
                }
                if (prConf == null || (prRegion = PartitionedRegion.getPRFromId(prID = prConf.getPRId())) == null || prRegion.getColocatedWith() == null || !prRegion.getColocatedWith().equals(partitionedRegion.getFullPath()) && !("/" + prRegion.getColocatedWith()).equals(partitionedRegion.getFullPath())) continue;
                prRegion.waitOnBucketMetadataInitialization();
                colocatedChildRegions.add(prRegion);
            }
            catch (PRLocallyDestroyedException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("PRLocallyDestroyedException : Region ={} is locally destroyed on this node", (Object)prConf.getPRId(), (Object)e);
            }
            catch (RegionDestroyedException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("RegionDestroyedException : Region ={} is destroyed.", (Object)prConf.getPRId(), (Object)e);
            }
        }
        Collections.sort(colocatedChildRegions, new Comparator<PartitionedRegion>(){

            @Override
            public int compare(PartitionedRegion o1, PartitionedRegion o2) {
                if (o1.isShadowPR() == o2.isShadowPR()) {
                    return o1.getFullPath().compareTo(o2.getFullPath());
                }
                if (o1.isShadowPR()) {
                    return 1;
                }
                return -1;
            }
        });
        return colocatedChildRegions;
    }

    public static Function getFunctionInstance(Serializable function) {
        Function functionInstance = null;
        if (function instanceof String) {
            functionInstance = FunctionService.getFunction((String)((Object)function));
            Assert.assertTrue(functionInstance != null, "Function " + function + " is not registered on this node ");
        } else {
            functionInstance = (Function)((Object)function);
        }
        return functionInstance;
    }

    public static PartitionedRegion getLeaderRegion(PartitionedRegion prRegion) {
        PartitionedRegion parentRegion;
        while ((parentRegion = ColocationHelper.getColocatedRegion(prRegion)) != null) {
            prRegion = parentRegion;
        }
        return prRegion;
    }

    private static String getRegionIdentifier(String regionName) {
        if (regionName.startsWith("/")) {
            return regionName.replace("/", "#");
        }
        return "#" + regionName.replace("/", "#");
    }

    public static boolean hasPersistentChildRegion(PartitionedRegion region) {
        for (PartitionedRegion child : ColocationHelper.getColocatedChildRegions(region)) {
            if (!child.getDataPolicy().withPersistence()) continue;
            return true;
        }
        return false;
    }
}

