/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelException;
import org.apache.geode.LogWriter;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.ServerLauncherParameters;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.process.StartupStatus;
import org.apache.geode.internal.process.StartupStatusListener;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.internal.util.JavaCommandBuilder;

@Deprecated
public class CacheServerLauncher {
    @MakeNotStatic(value="Maybe this should be immutable instead, if this whole JVM is supposed to be a dedicated server?")
    public static boolean isDedicatedCacheServer = Boolean.getBoolean("gemfire.isDedicatedServer");
    public static final boolean ASSIGN_BUCKETS = Boolean.getBoolean("gemfire.CacheServerLauncher.assignBucketsToPartitions");
    public static final boolean DONT_EXIT_AFTER_LAUNCH = Boolean.getBoolean("gemfire.CacheServerLauncher.dontExitAfterLaunch");
    public static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(CacheServerLauncher.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");
    private static final long STATUS_WAIT_TIME = Long.getLong("gemfire.CacheServerLauncher.STATUS_WAIT_TIME_MS", 15000L);
    private static final long SHUTDOWN_WAIT_TIME = Long.getLong("gemfire.CacheServerLauncher.SHUTDOWN_WAIT_TIME_MS", 20000L);
    protected final String baseName;
    protected final String defaultLogFileName;
    protected final String startLogFileName;
    protected final String statusName;
    protected Status status = null;
    protected File workingDir = null;
    protected PrintStream oldOut = System.out;
    protected PrintStream oldErr = System.err;
    protected LogWriter logger = null;
    protected String maxHeapSize;
    protected String initialHeapSize;
    protected String offHeapSize;
    public static final int SHUTDOWN = 0;
    public static final int STARTING = 1;
    public static final int RUNNING = 2;
    public static final int SHUTDOWN_PENDING = 3;
    private static final int FORCE_STATUS_FILE_READ_ITERATION_COUNT = 10;
    protected static final String DIR = "dir";
    protected static final String VMARGS = "vmargs";
    protected static final String PROPERTIES = "properties";
    protected static final String CLASSPATH = "classpath";
    protected static final String REBALANCE = "rebalance";
    protected static final String SERVER_PORT = "server-port";
    protected static final String SERVER_BIND_ADDRESS_NAME = "server-bind-address";
    protected static final String DISABLE_DEFAULT_SERVER = "disable-default-server";
    public static final String CRITICAL_HEAP_PERCENTAGE = "critical-heap-percentage";
    public static final String EVICTION_HEAP_PERCENTAGE = "eviction-heap-percentage";
    public static final String CRITICAL_OFF_HEAP_PERCENTAGE = "critical-off-heap-percentage";
    public static final String EVICTION_OFF_HEAP_PERCENTAGE = "eviction-off-heap-percentage";
    protected static final String LOCK_MEMORY = "lock-memory";

    public CacheServerLauncher(String baseName) {
        assert (baseName != null) : "The base name used for the cache server launcher files cannot be null!";
        this.baseName = baseName;
        String baseNameLowerCase = baseName.toLowerCase().replace(" ", "");
        this.startLogFileName = "start_" + baseNameLowerCase + ".log";
        this.defaultLogFileName = baseNameLowerCase + ".log";
        this.statusName = "." + baseNameLowerCase + ".ser";
    }

    protected static Status createStatus(String baseName, int state, int pid) {
        return CacheServerLauncher.createStatus(baseName, state, pid, null, null);
    }

    protected static Status createStatus(String baseName, int state, int pid, String msg, Throwable t) {
        Status status = new Status(baseName);
        status.state = state;
        status.pid = pid;
        status.msg = msg;
        status.exception = t;
        return status;
    }

    protected void usage() {
        PrintStream out = System.out;
        out.println("cacheserver start [-J<vmarg>]* [<attName>=<attValue>]* [-dir=<workingdir>] [-classpath=<classpath>] [-disable-default-server] [-rebalance] [-lock-memory] [-server-port=<server-port>] [-server-bind-address=<server-bind-address>] [-critical-heap-percentage=<critical-heap-percentage>] [-eviction-heap-percentage=<eviction-heap-percentage>] [-critical-off-heap-percentage=<critical-off-heap-percentage>] [-eviction-off-heap-percentage=<eviction-off-heap-percentage>]\n");
        out.println("\tStarts a GemFire CacheServer VM");
        out.println("\t<vmarg> a VM-option passed to the spawned CacheServer VM, example -J-Xmx1024M for a 1 Gb heap");
        out.println("\t<workingdir> Directory in which cacheserver runs, default is the current directory");
        out.println("\t<classpath> Location of user classes required by the cache server.  This path is appended to the current classpath.");
        out.println("\t<attName> Distributed system attribute such as mcast-port or cache-xml-file.");
        out.println("\t-rebalance  Indicates that the Cache should immediately be rebalanced");
        out.println("\t-disable-default-server  Do not add a default <cache-server>");
        out.println("\t<server-port>  Port the server is to listen on for client connections. This overrides the port set in the <cache-server> element of the cache-xml-file");
        out.println("\t<server-bind-address>  Address the server is to listen on for client connections. This overrides the bind-address set in the <cache-server> element of the cache-xml-file");
        out.println("\t<critical-heap-percentage>  Sets the critical heap threshold limit of the Resource Manager. This best works with parallel young generation collector (UseParNewGC) and concurrent low pause collector (UseConcMarkSweepGC) with appropriate CMSInitiatingOccupancyFraction like 50%. This overrides the critical-heap-percentage set in the <resource-manager> element of the cache-xml-file");
        out.println("\t<eviction-heap-percentage>  Sets the eviction heap threshold limit of the Resource Manager above which the eviction should begin on Regions configured for eviction by heap LRU. This overrides the eviction-heap-percentage set in the resource-manager> element of the cache-xml-file");
        out.println("\t<critical-Off-heap-percentage>  Sets the critical off-heap threshold limit of the Resource Manager. This overrides the critical-off-heap-percentage set in the <resource-manager> element of the cache-xml-file");
        out.println("\t<eviction-off-heap-percentage>  Sets the eviction heap threshold limit of the Resource Manager above which the eviction should begin on Regions configured for eviction by off-heap LRU. This overrides the eviction-off-heap-percentage set in the <resource-manager> element of the cache-xml-file");
        out.println("\t-lock-memory Locks heap and off-heap memory pages into RAM, thereby preventing the operating system from swapping them out to disk.");
        out.println();
        out.println("cacheserver stop [-dir=<workingdir>]");
        out.println("\tStops a GemFire CacheServer VM");
        out.println("\t<workingdir> Directory in which cacheserver runs, default is the current directory");
        out.println();
        out.println("cacheserver status [-dir=<workingdir>]");
        out.println("\tReports the status and process id of a GemFire CacheServer VM");
        out.println("\t<workingdir> Directory in which cacheserver runs, default is the current directory");
    }

    protected void status(String[] args) throws Exception {
        this.workingDir = (File)this.getStopOptions(args).get(DIR);
        System.out.println(this.getStatus());
        ExitCode.NORMAL.doSystemExit();
    }

    protected Status getStatus() throws Exception {
        Status status = new File(this.workingDir, this.statusName).exists() ? this.spinReadStatus() : CacheServerLauncher.createStatus(this.baseName, 0, 0);
        return status;
    }

    public static void main(String[] args) {
        CacheServerLauncher launcher = new CacheServerLauncher("CacheServer");
        boolean inServer = false;
        try {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("start")) {
                    launcher.start(args);
                } else if (args[0].equalsIgnoreCase("server")) {
                    inServer = true;
                    launcher.server(args);
                } else if (args[0].equalsIgnoreCase("stop")) {
                    launcher.stop(args);
                } else if (args[0].equalsIgnoreCase("status")) {
                    launcher.status(args);
                } else {
                    launcher.usage();
                    ExitCode.FATAL.doSystemExit();
                }
            } else {
                launcher.usage();
                ExitCode.FATAL.doSystemExit();
            }
            throw new Exception("internal error.. should not reach here.");
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            if (inServer) {
                launcher.setServerError("Error starting server process. ", t);
            }
            launcher.restoreStdOut();
            if (launcher.logger != null) {
                launcher.logger.severe("Cache server error", t);
            } else {
                System.out.println(String.format("Error: %s", t.getMessage()));
            }
            ExitCode.FATAL.doSystemExit();
            return;
        }
    }

    protected void restoreStdOut() {
        System.setErr(this.oldErr);
        System.setOut(this.oldOut);
    }

    protected File processDirOption(Map<String, Object> options, String dirValue) throws FileNotFoundException {
        File inputWorkingDirectory = new File(dirValue);
        if (!inputWorkingDirectory.exists()) {
            throw new FileNotFoundException(String.format("The input working directory does not exist: %s", dirValue));
        }
        options.put(DIR, inputWorkingDirectory);
        return inputWorkingDirectory;
    }

    protected Map<String, Object> getStartOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(DIR, new File(System.getProperty("user.dir")));
        ArrayList<String> vmArgs = new ArrayList<String>();
        options.put(VMARGS, vmArgs);
        Properties props = new Properties();
        options.put(PROPERTIES, props);
        for (String arg : args) {
            if (arg.equals("start")) continue;
            if (arg.startsWith("-classpath=")) {
                options.put(CLASSPATH, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-dir=")) {
                this.processDirOption(options, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-disable-default-server")) {
                options.put(DISABLE_DEFAULT_SERVER, arg);
                continue;
            }
            if (arg.startsWith("-lock-memory")) {
                if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                    throw new IllegalArgumentException("Unable to lock memory on this operating system");
                }
                props.put(LOCK_MEMORY, "true");
                continue;
            }
            if (arg.startsWith("-rebalance")) {
                options.put(REBALANCE, Boolean.TRUE);
                continue;
            }
            if (arg.startsWith("-server-port")) {
                options.put(SERVER_PORT, arg);
                continue;
            }
            if (arg.startsWith("-critical-heap-percentage")) {
                options.put(CRITICAL_HEAP_PERCENTAGE, arg);
                continue;
            }
            if (arg.startsWith("-eviction-heap-percentage")) {
                options.put(EVICTION_HEAP_PERCENTAGE, arg);
                continue;
            }
            if (arg.startsWith("-critical-off-heap-percentage")) {
                options.put(CRITICAL_OFF_HEAP_PERCENTAGE, arg);
                continue;
            }
            if (arg.startsWith("-eviction-off-heap-percentage")) {
                options.put(EVICTION_OFF_HEAP_PERCENTAGE, arg);
                continue;
            }
            if (arg.startsWith("-server-bind-address")) {
                options.put(SERVER_BIND_ADDRESS_NAME, arg);
                continue;
            }
            if (arg.startsWith("-J")) {
                String vmArg = arg.substring(2);
                if (vmArg.startsWith("-Xmx")) {
                    this.maxHeapSize = vmArg.substring(4);
                } else if (vmArg.startsWith("-Xms")) {
                    this.initialHeapSize = vmArg.substring(4);
                }
                vmArgs.add(vmArg);
                continue;
            }
            if (arg.indexOf("=") > 0) {
                int assignmentIndex = arg.indexOf("=");
                String key = arg.substring(0, assignmentIndex);
                String value = arg.substring(assignmentIndex + 1);
                if (key.startsWith("-")) {
                    this.processStartOption(key.substring(1), value, options, vmArgs, props);
                    continue;
                }
                this.processStartArg(key, value, options, vmArgs, props);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown argument: %s", arg));
        }
        vmArgs.add("-Djava.awt.headless=true");
        vmArgs.add("-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.Jdk14Logger");
        options.put(VMARGS, vmArgs);
        return options;
    }

    protected void processStartArg(String key, String value, Map<String, Object> options, List<String> vmArgs, Properties props) throws Exception {
        props.setProperty(key, value);
    }

    protected void processStartOption(String key, String value, Map<String, Object> options, List<String> vmArgs, Properties props) throws Exception {
        this.processUnknownStartOption(key, value, options, vmArgs, props);
    }

    protected void processUnknownStartOption(String key, String value, Map<String, Object> options, List<String> vmArgs, Properties props) {
        throw new IllegalArgumentException(String.format("Unknown argument: %s", key));
    }

    protected Map<String, Object> getServerOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(DIR, new File("."));
        this.workingDir = (File)options.get(DIR);
        Properties props = new Properties();
        options.put(PROPERTIES, props);
        for (String arg : args) {
            if (arg.equals("server")) continue;
            if (arg.startsWith("-dir=")) {
                this.workingDir = this.processDirOption(options, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-rebalance")) {
                options.put(REBALANCE, Boolean.TRUE);
                continue;
            }
            if (arg.startsWith("-disable-default-server")) {
                options.put(DISABLE_DEFAULT_SERVER, Boolean.TRUE);
                continue;
            }
            if (arg.startsWith("-lock-memory")) {
                props.put(LOCK_MEMORY, "true");
                continue;
            }
            if (arg.startsWith("-server-port")) {
                options.put(SERVER_PORT, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-server-bind-address")) {
                options.put(SERVER_BIND_ADDRESS_NAME, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-critical-heap-percentage")) {
                options.put(CRITICAL_HEAP_PERCENTAGE, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-eviction-heap-percentage")) {
                options.put(EVICTION_HEAP_PERCENTAGE, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-critical-off-heap-percentage")) {
                options.put(CRITICAL_OFF_HEAP_PERCENTAGE, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.startsWith("-eviction-off-heap-percentage")) {
                options.put(EVICTION_OFF_HEAP_PERCENTAGE, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.indexOf("=") > 1) {
                int assignmentIndex = arg.indexOf("=");
                String key = arg.substring(0, assignmentIndex);
                String value = arg.substring(assignmentIndex + 1);
                if (key.startsWith("-")) {
                    options.put(key.substring(1), value);
                    continue;
                }
                props.setProperty(key, value);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown argument: %s", arg));
        }
        return options;
    }

    protected Map<String, Object> getStopOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(DIR, new File("."));
        for (String arg : args) {
            if (arg.equals("stop") || arg.equals("status")) continue;
            if (arg.startsWith("-dir=")) {
                this.processDirOption(options, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown argument: %s", arg));
        }
        return options;
    }

    public void start(String[] args) throws Exception {
        Map<String, Object> options = this.getStartOptions(args);
        this.workingDir = (File)options.get(DIR);
        this.verifyAndClearStatus();
        this.runCommandLine(options, this.buildCommandLine(options));
        this.waitForRunning();
        if (DONT_EXIT_AFTER_LAUNCH) {
            return;
        }
        ExitCode.NORMAL.doSystemExit();
    }

    private void verifyAndClearStatus() throws Exception {
        Status status = this.getStatus();
        if (status != null && status.state != 0) {
            throw new IllegalStateException(String.format("A %s is already running in directory %s %s", this.baseName, this.workingDir, status));
        }
        this.deleteStatus();
    }

    private String[] buildCommandLine(Map<String, Object> options) {
        List<String> commandLine = JavaCommandBuilder.buildCommand(this.getClass().getName(), (String)options.get(CLASSPATH), null, (List)options.get(VMARGS));
        commandLine.add("server");
        this.addToServerCommand(commandLine, options);
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private void printCommandLine(String[] commandLine) {
        if (PRINT_LAUNCH_COMMAND) {
            System.out.println("Starting " + this.baseName + " with command:");
            for (String command : commandLine) {
                System.out.print(command);
                System.out.print(" ");
            }
            System.out.println();
        }
    }

    private int runCommandLine(Map<String, Object> options, String[] commandLine) throws Exception {
        File startLogFile = new File(this.workingDir, this.startLogFileName).getAbsoluteFile();
        if (startLogFile.exists() && !startLogFile.delete()) {
            throw new IOException("Unable to delete start log file (" + startLogFile.getAbsolutePath() + ")!");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        SocketCreator.readSSLProperties(env);
        this.printCommandLine(commandLine);
        int pid = OSProcess.bgexec(commandLine, this.workingDir, startLogFile, false, env);
        this.printStartMessage(options, pid);
        return pid;
    }

    protected void printStartMessage(Map<String, Object> options, int pid) throws Exception {
        System.out.println(String.format("Starting %s with pid: %s", this.baseName, pid));
    }

    public void running() {
        try {
            this.writeStatus(CacheServerLauncher.createStatus(this.baseName, 2, OSProcess.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void server(String[] args) throws Exception {
        serverPort = null;
        CacheServerLauncher.isDedicatedCacheServer = true;
        SystemFailure.setExitOK(true);
        this.workingDir = new File(System.getProperty("user.dir"));
        options = this.getServerOptions(args);
        serverPortString = (String)options.get("server-port");
        if (serverPortString != null) {
            serverPort = Integer.parseInt(serverPortString);
        }
        ServerLauncherParameters.INSTANCE.withPort(serverPort).withBindAddress((String)options.get("server-bind-address")).withDisableDefaultServer((Boolean)options.get("disable-default-server"));
        this.status = originalStatus = CacheServerLauncher.createStatus(this.baseName, 1, OSProcess.getId());
        this.writeStatus(this.status);
        props = (Properties)options.get("properties");
        if (props.getProperty("log-file") == null && CacheServerLauncher.isLoggingToStdOut()) {
            gemfireProperties = new Properties();
            DistributionConfigImpl.loadGemFireProperties(gemfireProperties);
            if (gemfireProperties.get("log-file") == null) {
                props.setProperty("log-file", this.defaultLogFileName);
            }
        }
        system = this.connect(props);
        this.installLogListener();
        this.logger = system.getLogWriter();
        OSProcess.redirectOutput(system.getConfig().getLogFile());
        cache = this.createCache(system, options);
        cache.setIsServer(true);
        this.startAdditionalServices(cache, options);
        this.running();
        this.clearLogListener();
        if (CacheServerLauncher.ASSIGN_BUCKETS) {
            for (PartitionedRegion region : cache.getPartitionedRegions()) {
                PartitionRegionHelper.assignBucketsToPartitions(region);
            }
        }
        if (Boolean.TRUE.equals(options.get("rebalance"))) {
            cache.getResourceManager().createRebalanceFactory().start();
        }
        statusFile = new File(this.workingDir, this.statusName);
        lastModified = 0L;
        oldModified = statusFile.lastModified();
        count = 0;
        loggedWarning = false;
        while (true) {
            if ((lastModified = statusFile.lastModified()) > oldModified) ** GOTO lbl-1000
            v0 = count;
            count = (short)(count + 1);
            if (v0 == 10) lbl-1000:
            // 2 sources

            {
                block23: {
                    count = 0;
                    Thread.sleep(500L);
                    try {
                        this.status = this.readStatus();
                    }
                    catch (IOException ioeSecondChance) {
                        Thread.sleep(1000L);
                        try {
                            this.status = this.readStatus();
                        }
                        catch (IOException ioeThirdChance) {
                            Thread.sleep(5000L);
                            try {
                                this.status = this.readStatus();
                            }
                            catch (FileNotFoundException fnfe) {
                                this.status = CacheServerLauncher.createStatus(this.baseName, 2, originalStatus.pid);
                                try {
                                    this.writeStatus(this.status);
                                }
                                catch (FileNotFoundException e) {
                                    if (loggedWarning) break block23;
                                    this.logger.warning(String.format("The cacheserver status file could not be recreated due to the following exception: %s", new Object[]{e.toString()}));
                                    loggedWarning = true;
                                }
                            }
                        }
                    }
                }
                oldModified = lastModified;
                if (this.status.state == 3) {
                    this.stopAdditionalServices();
                    this.disconnect(cache);
                    this.status.state = 0;
                    this.writeStatus(this.status);
                } else {
                    Thread.sleep(250L);
                }
            } else {
                Thread.sleep(1000L);
            }
            if (system.isConnected()) continue;
            reconnected = false;
            if (system.isReconnecting()) {
                try {
                    reconnected = system.waitUntilReconnected(-1L, TimeUnit.SECONDS);
                }
                catch (CancelException var17_19) {
                    // empty catch block
                }
                if (reconnected) {
                    system = (InternalDistributedSystem)system.getReconnectedSystem();
                    cache = system.getCache();
                }
            }
            if (reconnected) continue;
            ExitCode.NORMAL.doSystemExit();
        }
    }

    private void installLogListener() {
        MainLogReporter reporter = new MainLogReporter(this.status);
        StartupStatus.setListener(reporter);
        reporter.setDaemon(true);
        reporter.start();
    }

    private void clearLogListener() {
        MainLogReporter mainLogListener = (MainLogReporter)StartupStatus.getStartupListener();
        if (mainLogListener != null) {
            mainLogListener.shutdown();
            StartupStatus.clearListener();
        }
    }

    protected InternalDistributedSystem connect(Properties props) {
        return (InternalDistributedSystem)DistributedSystem.connect(props);
    }

    protected static float getCriticalHeapPercent(Map<String, Object> options) {
        String criticalHeapThreshold;
        if (options != null && (criticalHeapThreshold = (String)options.get(CRITICAL_HEAP_PERCENTAGE)) != null) {
            return Float.parseFloat(criticalHeapThreshold.substring(criticalHeapThreshold.indexOf("=") + 1));
        }
        return -1.0f;
    }

    protected static float getEvictionHeapPercent(Map<String, Object> options) {
        String evictionHeapThreshold;
        if (options != null && (evictionHeapThreshold = (String)options.get(EVICTION_HEAP_PERCENTAGE)) != null) {
            return Float.parseFloat(evictionHeapThreshold.substring(evictionHeapThreshold.indexOf("=") + 1));
        }
        return -1.0f;
    }

    protected static float getCriticalOffHeapPercent(Map<String, Object> options) {
        String criticalOffHeapThreshold;
        if (options != null && (criticalOffHeapThreshold = (String)options.get(CRITICAL_OFF_HEAP_PERCENTAGE)) != null) {
            return Float.parseFloat(criticalOffHeapThreshold.substring(criticalOffHeapThreshold.indexOf("=") + 1));
        }
        return -1.0f;
    }

    protected static float getEvictionOffHeapPercent(Map<String, Object> options) {
        String evictionOffHeapThreshold;
        if (options != null && (evictionOffHeapThreshold = (String)options.get(EVICTION_OFF_HEAP_PERCENTAGE)) != null) {
            return Float.parseFloat(evictionOffHeapThreshold.substring(evictionOffHeapThreshold.indexOf("=") + 1));
        }
        return -1.0f;
    }

    protected InternalCache createCache(InternalDistributedSystem system, Map<String, Object> options) throws IOException {
        Boolean disable;
        InternalCache cache = (InternalCache)CacheFactory.create(system);
        float threshold = CacheServerLauncher.getCriticalHeapPercent(options);
        if (threshold > 0.0f) {
            cache.getResourceManager().setCriticalHeapPercentage(threshold);
        }
        if ((threshold = CacheServerLauncher.getEvictionHeapPercent(options)) > 0.0f) {
            cache.getResourceManager().setEvictionHeapPercentage(threshold);
        }
        threshold = CacheServerLauncher.getCriticalOffHeapPercent(options);
        CacheServerLauncher.getCriticalOffHeapPercent(options);
        if (threshold > 0.0f) {
            cache.getResourceManager().setCriticalOffHeapPercentage(threshold);
        }
        if ((threshold = CacheServerLauncher.getEvictionOffHeapPercent(options)) > 0.0f) {
            cache.getResourceManager().setEvictionOffHeapPercentage(threshold);
        }
        if (!((disable = ServerLauncherParameters.INSTANCE.isDisableDefaultServer()) != null && disable.booleanValue() || cache.getCacheServers().size() != 0)) {
            String serverBindAddress;
            CacheServer server = cache.addCacheServer();
            CacheServerHelper.setIsDefaultServer(server);
            Integer serverPort = ServerLauncherParameters.INSTANCE.getPort();
            if (serverPort != null) {
                server.setPort(serverPort);
            }
            if ((serverBindAddress = ServerLauncherParameters.INSTANCE.getBindAddress()) != null) {
                server.setBindAddress(serverBindAddress.trim());
            }
            server.start();
        }
        return cache;
    }

    protected void disconnect(Cache cache) {
        DistributedSystem dsys = cache.getDistributedSystem();
        cache.close();
        dsys.disconnect();
    }

    public void stop(String[] args) throws Exception {
        this.workingDir = (File)this.getStopOptions(args).get(DIR);
        File statusFile = new File(this.workingDir, this.statusName);
        ExitCode exitCode = ExitCode.FATAL;
        if (statusFile.exists()) {
            this.status = this.spinReadStatus();
            if (this.status.state != 0) {
                this.status = CacheServerLauncher.createStatus(this.baseName, 3, this.status.pid);
                this.writeStatus(this.status);
            }
            this.pollCacheServerForShutdown();
            if (this.status.state == 0) {
                System.out.println(String.format("The %s has stopped.", this.baseName));
                this.deleteStatus();
                exitCode = ExitCode.NORMAL;
            } else {
                System.out.println(String.format("Timeout waiting for %s to shutdown, status is: %s", this.baseName, this.status));
            }
        } else {
            System.out.println(String.format("The specified working directory (%s) contains no status file", this.workingDir));
        }
        if (DONT_EXIT_AFTER_LAUNCH) {
            return;
        }
        exitCode.doSystemExit();
    }

    private void pollCacheServerForShutdown() throws InterruptedException {
        int increment = 250;
        int clock = 0;
        while ((long)clock < SHUTDOWN_WAIT_TIME && this.status.state != 0) {
            try {
                this.status = this.readStatus();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                break;
            }
            clock += 250;
        }
    }

    protected void setServerError(String msg, Throwable t) {
        try {
            this.writeStatus(CacheServerLauncher.createStatus(this.baseName, 0, OSProcess.getId(), msg, t));
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.severe(e);
            } else {
                e.printStackTrace();
            }
            ExitCode.FATAL.doSystemExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStatus(Status s) throws IOException {
        FileOutputStream fileOutput = null;
        ObjectOutputStream objectOutput = null;
        try {
            fileOutput = new FileOutputStream(new File(this.workingDir, this.statusName));
            objectOutput = new ObjectOutputStream(fileOutput);
            objectOutput.writeObject(s);
            objectOutput.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(objectOutput);
            IOUtils.close(fileOutput);
            throw throwable;
        }
        IOUtils.close(objectOutput);
        IOUtils.close(fileOutput);
    }

    protected Status spinReadStatus() {
        long timeout = System.currentTimeMillis() + 60000L;
        Status status = null;
        while (status == null && System.currentTimeMillis() < timeout) {
            try {
                status = this.readStatus();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    status = null;
                    break;
                }
            }
        }
        return status;
    }

    /*
     * Exception decompiling
     */
    protected Status readStatus() throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteStatus() throws IOException {
        File statusFile = new File(this.workingDir, this.statusName);
        if (statusFile.exists() && !statusFile.delete()) {
            throw new IOException("Could not delete status file (" + statusFile.getAbsolutePath() + ")!");
        }
    }

    protected boolean isExistingProcess(int pid) {
        return PureJavaMode.isPure() || pid != 0 && OSProcess.exists(pid);
    }

    protected void waitForRunning() throws Exception {
        Status status = this.spinReadStatus();
        String lastReadMessage = null;
        String lastReportedMessage = null;
        long lastReadTime = System.nanoTime();
        if (status == null) {
            throw new Exception("No available status.");
        }
        switch (status.state) {
            case 1: {
                while (status.state == 1) {
                    long elapsed;
                    Thread.sleep(500L);
                    status = this.spinReadStatus();
                    if (status.dsMsg != null && !status.dsMsg.equals(lastReadMessage)) {
                        lastReadMessage = status.dsMsg;
                        lastReadTime = System.nanoTime();
                    }
                    if (TimeUnit.NANOSECONDS.toMillis(elapsed = System.nanoTime() - lastReadTime) <= STATUS_WAIT_TIME || lastReadMessage == null || lastReadMessage.equals(lastReportedMessage)) continue;
                    long elapsedSec = TimeUnit.NANOSECONDS.toSeconds(elapsed);
                    System.out.println(String.format("The server is still starting. %s seconds have elapsed since the last log message: %s", elapsedSec, status.dsMsg));
                    lastReportedMessage = lastReadMessage;
                }
                if (status.state != 0) break;
                System.out.println(status);
                ExitCode.FATAL.doSystemExit();
                break;
            }
        }
        System.out.println(status);
    }

    private static boolean isLoggingToStdOut() {
        Properties gfprops = new Properties();
        URL url = DistributedSystem.getPropertyFileURL();
        if (url != null) {
            try {
                gfprops.load(url.openStream());
            }
            catch (IOException io) {
                System.out.println("Failed reading " + url);
                ExitCode.FATAL.doSystemExit();
            }
            String logFile = gfprops.getProperty("log-file");
            return logFile == null || logFile.length() == 0;
        }
        return true;
    }

    protected void addToServerCommand(List<String> commandLine, Map<String, Object> options) {
        String evictionOffHeapThreshold;
        String criticalOffHeapThreshold;
        String evictionHeapThreshold;
        String criticalHeapThreshold;
        String serverBindAddressName;
        String serverPort;
        String disableDefaultServer;
        if (Boolean.TRUE.equals(options.get(REBALANCE))) {
            commandLine.add("-rebalance");
        }
        if ((disableDefaultServer = (String)options.get(DISABLE_DEFAULT_SERVER)) != null) {
            commandLine.add(disableDefaultServer);
        }
        if ((serverPort = (String)options.get(SERVER_PORT)) != null) {
            commandLine.add(serverPort);
        }
        if ((serverBindAddressName = (String)options.get(SERVER_BIND_ADDRESS_NAME)) != null) {
            commandLine.add(serverBindAddressName);
        }
        if ((criticalHeapThreshold = (String)options.get(CRITICAL_HEAP_PERCENTAGE)) != null) {
            commandLine.add(criticalHeapThreshold);
        }
        if ((evictionHeapThreshold = (String)options.get(EVICTION_HEAP_PERCENTAGE)) != null) {
            commandLine.add(evictionHeapThreshold);
        }
        if ((criticalOffHeapThreshold = (String)options.get(CRITICAL_OFF_HEAP_PERCENTAGE)) != null) {
            commandLine.add(criticalOffHeapThreshold);
        }
        if ((evictionOffHeapThreshold = (String)options.get(EVICTION_OFF_HEAP_PERCENTAGE)) != null) {
            commandLine.add(evictionOffHeapThreshold);
        }
        Properties props = (Properties)options.get(PROPERTIES);
        for (Object key : props.keySet()) {
            commandLine.add(key + "=" + props.getProperty(key.toString()));
        }
        if (props.getProperty("log-file") == null && CacheServerLauncher.isLoggingToStdOut()) {
            commandLine.add("log-file=" + this.defaultLogFileName);
        }
    }

    protected void startAdditionalServices(Cache cache, Map<String, Object> options) throws Exception {
    }

    protected void stopAdditionalServices() throws Exception {
    }

    protected static boolean safeEquals(String lastLogMessage, String dsMsg) {
        if (lastLogMessage == null && dsMsg == null) {
            return true;
        }
        if (lastLogMessage == null || dsMsg == null) {
            return false;
        }
        return lastLogMessage.equals(dsMsg);
    }

    private class MainLogReporter
    extends Thread
    implements StartupStatusListener {
        private String lastLogMessage;
        private final Status status;
        boolean running = true;

        public MainLogReporter(Status status) {
            this.status = status;
        }

        public synchronized void shutdown() {
            this.running = false;
            this.status.dsMsg = null;
            this.notifyAll();
        }

        @Override
        public void setStatus(String status) {
            this.lastLogMessage = status;
        }

        @Override
        public synchronized void run() {
            while (this.running) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!this.running || !CacheServerLauncher.safeEquals(this.lastLogMessage, this.status.dsMsg)) continue;
                this.status.dsMsg = this.lastLogMessage;
                try {
                    CacheServerLauncher.this.writeStatus(this.status);
                }
                catch (IOException e) {}
            }
        }
    }

    static class Status
    implements Serializable {
        private static final long serialVersionUID = 190943081363646485L;
        public int state = 0;
        public int pid = 0;
        private final String baseName;
        public Throwable exception;
        public String msg;
        public String dsMsg;

        public Status(String baseName) {
            this.baseName = baseName;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.baseName).append(" pid: ").append(this.pid).append(" status: ");
            switch (this.state) {
                case 0: {
                    buffer.append("stopped");
                    break;
                }
                case 1: {
                    buffer.append("starting");
                    break;
                }
                case 2: {
                    buffer.append("running");
                    break;
                }
                case 3: {
                    buffer.append("stopping");
                    break;
                }
                default: {
                    buffer.append("unknown");
                }
            }
            if (this.exception != null) {
                if (this.msg != null) {
                    buffer.append("\n").append(this.msg).append(" - ");
                } else {
                    buffer.append("\nException in ").append(this.baseName).append(" - ");
                }
                buffer.append("See log file for details.");
            } else if (this.dsMsg != null) {
                buffer.append('\n').append(this.dsMsg);
            }
            return buffer.toString();
        }
    }
}

