/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.partitioned.RedundancyAlreadyMetException;
import org.apache.geode.internal.cache.persistence.MembershipChangeListener;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisorImpl;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;
import org.apache.geode.internal.cache.persistence.PersistentStateListener;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.TransformUtils;
import org.apache.logging.log4j.Logger;

public class BucketPersistenceAdvisor
extends PersistenceAdvisorImpl {
    private static final Logger logger = LogService.getLogger();
    public CountDownLatch someMemberRecoveredLatch = new CountDownLatch(1);
    public boolean recovering = true;
    private boolean atomicCreation;
    private final PartitionedRegion.BucketLock bucketLock;
    private final RecoveryListener recoveryListener;
    private final ProxyBucketRegion proxyBucket;
    private short version;
    private RuntimeException recoveryException;

    public BucketPersistenceAdvisor(CacheDistributionAdvisor advisor, DistributedLockService dl, PersistentMemberView storage, String regionPath, DiskRegionStats diskStats, PersistentMemberManager memberManager, PartitionedRegion.BucketLock bucketLock, ProxyBucketRegion proxyBucketRegion) {
        super(advisor, dl, storage, regionPath, diskStats, memberManager);
        this.bucketLock = bucketLock;
        this.recoveryListener = new RecoveryListener();
        this.proxyBucket = proxyBucketRegion;
        this.addListener(this.recoveryListener);
    }

    public void recoveryDone(RuntimeException e) {
        this.recovering = false;
        if (!this.getPersistedMembers().isEmpty()) {
            ((BucketAdvisor)this.cacheDistributionAdvisor).setHadPrimary();
        }
        this.removeListener(this.recoveryListener);
        for (PersistentMemberID id : this.recoveryListener.getRemovedMembers()) {
            this.removeMember(id);
        }
        if (this.someMemberRecoveredLatch.getCount() > 0L) {
            this.recoveryException = e;
            this.someMemberRecoveredLatch.countDown();
        } else if (this.recoveryException != null) {
            logger.fatal(String.format("Unable to recover secondary bucket from disk for region %s bucket %s", this.proxyBucket.getPartitionedRegion().getFullPath(), this.proxyBucket.getBucketId()), (Throwable)e);
        }
    }

    @Override
    public void checkInterruptedByShutdownAll() {
        if (this.proxyBucket.getCache().isCacheAtShutdownAll()) {
            throw this.proxyBucket.getCache().getCacheClosedException("Cache is being closed by ShutdownAll");
        }
        this.proxyBucket.getPartitionedRegion().checkReadiness();
    }

    public boolean isRecovering() {
        return this.recovering;
    }

    @Override
    public void beginWaitingForMembershipChange(Set<PersistentMemberID> membersToWaitFor) {
        if (this.recovering) {
            this.bucketLock.unlock();
        } else if (membersToWaitFor != null && !membersToWaitFor.isEmpty()) {
            String message = String.format("Region %s bucket %s has persistent data that is no longer online stored at these locations: %s", this.proxyBucket.getPartitionedRegion().getFullPath(), this.proxyBucket.getBucketId(), membersToWaitFor);
            throw new PartitionOfflineException(membersToWaitFor, message);
        }
    }

    @Override
    public void logWaitingForMembers() {
        if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
            HashSet membersToWaitForPrettyFormat = new HashSet();
            if (this.offlineMembersWaitingFor != null && !this.offlineMembersWaitingFor.isEmpty()) {
                TransformUtils.transform(this.offlineMembersWaitingFor, membersToWaitForPrettyFormat, TransformUtils.persistentMemberIdToLogEntryTransformer);
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "Region {}, bucket {} has potentially stale data.  It is waiting for another member to recover the latest data.My persistent id: {} Members with potentially new data:{}  Use the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", new Object[]{this.proxyBucket.getPartitionedRegion().getFullPath(), this.proxyBucket.getBucketId(), TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.getPersistentID()), membersToWaitForPrettyFormat});
            } else {
                TransformUtils.transform(this.allMembersWaitingFor, membersToWaitForPrettyFormat, TransformUtils.persistentMemberIdToLogEntryTransformer);
                if (logger.isDebugEnabled()) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "All persistent members being waited on are online, but they have not yet initialized");
                }
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "Region {}, bucket {} has potentially stale data.  It is waiting for another member to recover the latest data. My persistent id: {} Members with potentially new data:{}  Use the gfsh show missing-disk-stores command to see all disk stores that are being waited on by other members.", new Object[]{this.proxyBucket.getPartitionedRegion().getFullPath(), this.proxyBucket.getBucketId(), TransformUtils.persistentMemberIdToLogEntryTransformer.transform(this.getPersistentID()), membersToWaitForPrettyFormat});
            }
        }
    }

    @Override
    public void endWaitingForMembershipChange() {
        if (this.recovering) {
            this.bucketLock.lock();
            if (!this.proxyBucket.hasPersistentChildRegion() && !this.proxyBucket.checkBucketRedundancyBeforeGrab(null, false)) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: After reacquiring dlock, we detected that redundancy is already satisfied", (Object)this.shortDiskStoreId(), (Object)this.regionPath);
                }
                this.proxyBucket.destroyOfflineData();
                throw new RedundancyAlreadyMetException();
            }
        }
    }

    @Override
    public void updateMembershipView(InternalDistributedMember replicate, boolean targetReinitializing) {
        if (this.recovering) {
            super.updateMembershipView(replicate, targetReinitializing);
            this.someMemberRecoveredLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initializeMembershipView() {
        MembershipChangeListener listener = new MembershipChangeListener(this);
        this.addListener(listener);
        boolean interrupted = false;
        try {
            block10: {
                while (!this.isClosed) {
                    this.cacheDistributionAdvisor.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
                    Map<InternalDistributedMember, PersistentMemberID> onlineMembers = this.cacheDistributionAdvisor.adviseInitializedPersistentMembers();
                    if (onlineMembers != null && this.updateMembershipView(onlineMembers.keySet())) {
                        return;
                    }
                    Set<InternalDistributedMember> postRecoveryMembers = ((BucketAdvisor)this.cacheDistributionAdvisor).adviseRecoveredFromDisk();
                    if (postRecoveryMembers != null && this.updateMembershipView(postRecoveryMembers)) {
                        return;
                    }
                    Set<PersistentMemberID> membersToWaitFor = this.getPersistedMembers();
                    if (!membersToWaitFor.isEmpty()) {
                        this.setWaitingOnMembers(membersToWaitFor, membersToWaitFor);
                        try {
                            listener.waitForChange();
                            continue;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                    }
                    break block10;
                }
                return;
            }
            this.beginUpdatingPersistentView();
            return;
        }
        finally {
            this.setWaitingOnMembers(null, null);
            this.removeListener(listener);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean updateMembershipView(Collection<InternalDistributedMember> targets) {
        for (InternalDistributedMember target : targets) {
            try {
                this.updateMembershipView(target, false);
                return true;
            }
            catch (ReplyException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Received a reply exception trying to update membership view", (Throwable)e);
            }
        }
        return false;
    }

    public void bucketRemoved() {
        this.resetState();
    }

    @Override
    public boolean acquireTieLock() {
        return true;
    }

    @Override
    public void releaseTieLock() {
    }

    @Override
    protected String getRegionPathForOfflineMembers() {
        return this.proxyBucket.getPartitionedRegion().getFullPath();
    }

    @Override
    public Set<PersistentMemberID> getMissingMembers() {
        if (this.recovering) {
            return super.getMissingMembers();
        }
        Set<PersistentMemberID> offlineMembers = this.getPersistedMembers();
        offlineMembers.removeAll(this.cacheDistributionAdvisor.advisePersistentMembers().values());
        return offlineMembers;
    }

    @Override
    public PersistentMemberID generatePersistentID() {
        PersistentMemberID id = this.persistentMemberView.generatePersistentID();
        if (id == null) {
            return id;
        }
        short s = this.version;
        this.version = (short)(s + 1);
        id = new PersistentMemberID(id.getDiskStoreId(), id.getHost(), id.getDirectory(), this.proxyBucket.getPartitionedRegion().getBirthTime(), s);
        return id;
    }

    public void dump(String infoMsg) {
        this.persistentMemberView.getOnlineMembers();
        this.persistentMemberView.getOfflineMembers();
        this.persistentMemberView.getOfflineAndEqualMembers();
        this.persistentMemberView.getMyInitializingID();
        this.persistentMemberView.getMyPersistentID();
        StringBuilder buf = new StringBuilder(2000);
        if (infoMsg != null) {
            buf.append(infoMsg);
            buf.append(": ");
        }
        buf.append("\nMY PERSISTENT ID:\n");
        buf.append(this.persistentMemberView.getMyPersistentID());
        buf.append("\nMY INITIALIZING ID:\n");
        buf.append(this.persistentMemberView.getMyInitializingID());
        buf.append("\nONLINE MEMBERS:\n");
        for (PersistentMemberID id : this.persistentMemberView.getOnlineMembers()) {
            buf.append("\t");
            buf.append(id);
            buf.append("\n");
        }
        buf.append("\nOFFLINE MEMBERS:\n");
        for (PersistentMemberID id : this.persistentMemberView.getOfflineMembers()) {
            buf.append("\t");
            buf.append(id);
            buf.append("\n");
        }
        buf.append("\nOFFLINE AND EQUAL MEMBERS:\n");
        for (PersistentMemberID id : this.persistentMemberView.getOfflineAndEqualMembers()) {
            buf.append("\t");
            buf.append(id);
            buf.append("\n");
        }
        logger.debug(buf.toString());
    }

    public void waitForPrimaryPersistentRecovery() {
        boolean interupted = false;
        while (true) {
            try {
                this.someMemberRecoveredLatch.await();
            }
            catch (InterruptedException e) {
                interupted = true;
                continue;
            }
            break;
        }
        if (interupted) {
            Thread.currentThread().interrupt();
        }
        if (this.recoveryException != null) {
            StackTraceElement[] oldStack = this.recoveryException.getStackTrace();
            this.recoveryException.fillInStackTrace();
            ArrayList<StackTraceElement> newStack = new ArrayList<StackTraceElement>();
            newStack.addAll(Arrays.asList(oldStack));
            newStack.addAll(Arrays.asList(this.recoveryException.getStackTrace()));
            this.recoveryException.setStackTrace(newStack.toArray(new StackTraceElement[0]));
            throw this.recoveryException;
        }
    }

    @Override
    public void setInitializing(PersistentMemberID newId) {
        if (this.atomicCreation) {
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: {} Deferring setInitializing until the EndBucketCreation phase for {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)this.regionPath, (Object)newId);
            }
        } else {
            super.setInitializing(newId);
        }
    }

    @Override
    public void setOnline(boolean didGII, boolean wasAtomicCreation, PersistentMemberID newId) throws ReplyException {
        if (this.atomicCreation) {
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: {} Deferring setOnline until the EndBucketCreation phase for {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)this.regionPath, (Object)newId);
            }
        } else {
            super.setOnline(didGII, wasAtomicCreation, newId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBucketCreation(PersistentMemberID newId) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.atomicCreation) {
                if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                    logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: {} In endBucketCreation - already online, skipping (possible concurrent endBucketCreation)", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)this.regionPath);
                }
                return;
            }
            if (logger.isDebugEnabled(LogMarker.PERSIST_ADVISOR_VERBOSE)) {
                logger.debug(LogMarker.PERSIST_ADVISOR_VERBOSE, "{}-{}: {} In endBucketCreation - now persisting the id {}", (Object)this.shortDiskStoreId(), (Object)this.regionPath, (Object)this.regionPath, (Object)newId);
            }
            this.atomicCreation = false;
        }
        super.setOnline(false, true, newId);
    }

    public boolean isAtomicCreation() {
        return this.atomicCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtomicCreation(boolean atomicCreation) {
        if (this.getPersistentID() != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.atomicCreation = atomicCreation;
        }
    }

    private BucketPersistenceAdvisor getColocatedPersistenceAdvisor() {
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.proxyBucket.getPartitionedRegion());
        if (colocatedRegion == null) {
            return null;
        }
        ProxyBucketRegion colocatedProxyBucket = colocatedRegion.getRegionAdvisor().getProxyBucketArray()[this.proxyBucket.getBucketId()];
        return colocatedProxyBucket.getPersistenceAdvisor();
    }

    private static class RecoveryListener
    extends PersistentStateListener.PersistentStateAdapter {
        private Set<PersistentMemberID> removedMembers = Collections.synchronizedSet(new HashSet());

        private RecoveryListener() {
        }

        @Override
        public void memberRemoved(PersistentMemberID persistentID, boolean revoked) {
            this.removedMembers.add(persistentID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashSet<PersistentMemberID> getRemovedMembers() {
            Set<PersistentMemberID> set = this.removedMembers;
            synchronized (set) {
                return new HashSet<PersistentMemberID>(this.removedMembers);
            }
        }
    }
}

