/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

abstract class BaseRegionMap
implements RegionMap {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    public static boolean FORCE_INVALIDATE_EVENT = Boolean.getBoolean("gemfire.FORCE_INVALIDATE_EVENT");

    BaseRegionMap() {
    }

    @Override
    public void incRecentlyUsed() {
    }

    @Override
    public long getEvictions() {
        return 0L;
    }

    @Override
    public EvictionController getEvictionController() {
        return null;
    }

    @Override
    public void lruUpdateCallback() {
    }

    @Override
    public boolean lruLimitExceeded(DiskRegionView diskRegionView) {
        return false;
    }

    @Override
    public void lruCloseStats() {
    }

    @Override
    public void resetThreadLocals() {
    }

    @Override
    public boolean disableLruUpdateCallback() {
        return false;
    }

    @Override
    public void enableLruUpdateCallback() {
    }

    @Override
    public int centralizedLruUpdateCallback() {
        return 0;
    }

    @Override
    public void updateEvictionCounter() {
    }

    @Override
    public void finishChangeValueForm() {
    }

    @Override
    public boolean beginChangeValueForm(EvictableEntry le, CachedDeserializable vmCachedDeserializable, Object v) {
        return false;
    }

    @Override
    public void lruEntryFaultIn(EvictableEntry entry) {
    }

    static void forceInvalidateEvent(EntryEventImpl event, LocalRegion owner) {
        if (FORCE_INVALIDATE_EVENT) {
            event.invokeCallbacks(owner, false, false);
        }
    }

    static boolean shouldInvokeCallbacks(LocalRegion owner, boolean isInitialized) {
        LocalRegion lr = owner;
        boolean isPartitioned = lr.isUsedForPartitionedRegionBucket();
        if (isPartitioned) {
            lr = owner.getPartitionedRegion();
        }
        return !(!isPartitioned && !isInitialized || !lr.shouldDispatchListenerEvent() && !lr.shouldNotifyBridgeClients() && !lr.getConcurrencyChecksEnabled());
    }

    static EntryEventImpl switchEventOwnerAndOriginRemote(EntryEventImpl event, boolean originRemote) {
        assert (event != null);
        if (event.getRegion().isUsedForPartitionedRegionBucket()) {
            LocalRegion pr = event.getRegion().getPartitionedRegion();
            event.setRegion(pr);
        }
        event.setOriginRemote(originRemote);
        return event;
    }
}

