/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.alerting.AlertMessaging;
import org.apache.geode.internal.alerting.AlertingSessionListener;

public class AlertingSessionListeners {
    @MakeNotStatic
    private static final AlertingSessionListeners INSTANCE = new AlertingSessionListeners();
    private final Set<AlertingSessionListener> listeners = new LinkedHashSet<AlertingSessionListener>();

    public static AlertingSessionListeners get() {
        return INSTANCE;
    }

    AlertingSessionListeners() {
    }

    public synchronized boolean addAlertingSessionListener(AlertingSessionListener listener) {
        return this.listeners.add(listener);
    }

    public synchronized boolean removeAlertingSessionListener(AlertingSessionListener listener) {
        return this.listeners.remove(listener);
    }

    public synchronized void clear() {
        this.listeners.clear();
    }

    public synchronized void createSession(AlertMessaging alertMessaging) {
        for (AlertingSessionListener listener : this.listeners) {
            listener.createSession(alertMessaging);
        }
    }

    public synchronized void startSession() {
        for (AlertingSessionListener listener : this.listeners) {
            listener.startSession();
        }
    }

    public synchronized void stopSession() {
        for (AlertingSessionListener listener : this.listeners) {
            listener.stopSession();
        }
    }
}

