/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.alerting.AlertingProvider;
import org.apache.geode.internal.alerting.AlertingSessionListeners;
import org.apache.geode.internal.alerting.NullAlertingProvider;

public class AlertingProviderRegistry {
    @Immutable
    private static final AlertingProvider NULL_ALERTING_PROVIDER = new NullAlertingProvider();
    @MakeNotStatic
    private static final AlertingProviderRegistry INSTANCE = new AlertingProviderRegistry();
    private final AlertingSessionListeners alertingSessionListeners;
    private final AtomicReference<AlertingProvider> alertingProviderRef = new AtomicReference();

    public static AlertingProviderRegistry get() {
        return INSTANCE;
    }

    @VisibleForTesting
    public static AlertingProvider getNullAlertingProvider() {
        return NULL_ALERTING_PROVIDER;
    }

    AlertingProviderRegistry() {
        this(AlertingSessionListeners.get(), NULL_ALERTING_PROVIDER);
    }

    private AlertingProviderRegistry(AlertingSessionListeners alertingSessionListeners, AlertingProvider alertingProvider) {
        if (alertingSessionListeners == null) {
            throw new NullPointerException("alertingSessionListeners must not be null");
        }
        if (alertingProvider == null) {
            throw new NullPointerException("alertingProvider must not be null");
        }
        this.alertingSessionListeners = alertingSessionListeners;
        this.alertingProviderRef.set(alertingProvider);
    }

    public AlertingProvider getAlertingProvider() {
        return this.alertingProviderRef.get();
    }

    public void registerAlertingProvider(AlertingProvider provider) {
        this.alertingSessionListeners.addAlertingSessionListener(provider);
        this.alertingProviderRef.compareAndSet(NULL_ALERTING_PROVIDER, provider);
    }

    public void unregisterAlertingProvider(AlertingProvider provider) {
        this.alertingProviderRef.compareAndSet(provider, NULL_ALERTING_PROVIDER);
        this.alertingSessionListeners.removeAlertingSessionListener(provider);
    }

    public void clear() {
        this.unregisterAlertingProvider(this.alertingProviderRef.get());
    }
}

