/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.alerting;

import java.util.Date;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.admin.remote.AlertListenerMessage;
import org.apache.geode.internal.alerting.AlertLevel;
import org.apache.geode.internal.alerting.AlertListenerMessageFactory;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.logging.log4j.Logger;

public class AlertMessaging {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedSystem system;
    private final DistributionManager dm;
    private final AlertListenerMessageFactory alertListenerMessageFactory;

    public AlertMessaging(InternalDistributedSystem system) {
        this(system, system.getDistributionManager(), new AlertListenerMessageFactory());
    }

    AlertMessaging(InternalDistributedSystem system, DistributionManager dm, AlertListenerMessageFactory alertListenerMessageFactory) {
        this.system = system;
        this.dm = dm;
        this.alertListenerMessageFactory = alertListenerMessageFactory;
    }

    public void sendAlert(DistributedMember member, AlertLevel alertLevel, Date date, String threadName, String formattedMessage, String stackTrace) {
        try {
            String connectionName = this.system.getConfig().getName();
            AlertListenerMessage message = this.alertListenerMessageFactory.createAlertListenerMessage(member, alertLevel, date, connectionName, threadName, formattedMessage, stackTrace);
            if (member.equals(this.system.getDistributedMember())) {
                logger.debug("Processing local alert message: {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)date, (Object)connectionName, (Object)threadName, (Object)formattedMessage, (Object)stackTrace);
                this.processAlertListenerMessage(message);
            } else {
                logger.debug("Sending remote alert message: {}, {}, {}, {}, {}, [{}], [{}].", (Object)member, (Object)alertLevel, (Object)date, (Object)connectionName, (Object)threadName, (Object)formattedMessage, (Object)stackTrace);
                this.dm.putOutgoing(message);
            }
        }
        catch (ReenteredConnectException reenteredConnectException) {
            // empty catch block
        }
    }

    void processAlertListenerMessage(AlertListenerMessage message) {
        this.verifyDistributionManagerCanProcessMessage();
        message.process((ClusterDistributionManager)this.dm);
    }

    private void verifyDistributionManagerCanProcessMessage() {
        if (!(this.dm instanceof ClusterDistributionManager)) {
            throw new IllegalArgumentException("Processing of AlertListenerMessage requires ClusterDistributionManager instead of " + this.dm.getClass().getSimpleName());
        }
    }
}

