/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.RegionNotFoundException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.admin.remote.AdminRequest;

public abstract class RegionAdminRequest
extends AdminRequest {
    private String regionName;

    public void setRegionName(String name) {
        this.regionName = name;
    }

    public String getRegionName() {
        return this.regionName;
    }

    protected Region getRegion(DistributedSystem sys) {
        Cache cache = CacheFactory.getInstance(sys);
        Region r = cache.getRegion(this.regionName);
        if (r == null) {
            throw new RegionNotFoundException(String.format("Region %s not found in remote cache %s.", this.regionName, cache.getName()));
        }
        return r;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionName, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionName = DataSerializer.readString(in);
    }
}

