/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;

public class HealthListenerMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private int listenerId;
    private GemFireHealth.Health status;

    public static HealthListenerMessage create(int listenerId, GemFireHealth.Health status) {
        HealthListenerMessage m = new HealthListenerMessage();
        m.listenerId = listenerId;
        m.status = status;
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        RemoteGemFireVM mgr;
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null && (mgr = agent.getMemberById(this.getSender())) != null) {
            mgr.callHealthListeners(this.listenerId, this.status);
        }
    }

    @Override
    public int getDSFID() {
        return 1034;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
        DataSerializer.writeObject(this.status, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
        this.status = (GemFireHealth.Health)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return String.format("The status of listener %s is %s", this.listenerId, this.status);
    }
}

