/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteStat;

public class FetchResourceAttributesResponse
extends AdminResponse {
    private RemoteStat[] stats;

    public static FetchResourceAttributesResponse create(DistributionManager dm, InternalDistributedMember recipient, long rsrcUniqueId) {
        FetchResourceAttributesResponse m = new FetchResourceAttributesResponse();
        m.setRecipient(recipient);
        Statistics s = null;
        InternalDistributedSystem ds = dm.getSystem();
        s = ds.getStatisticsManager().findStatisticsByUniqueId(rsrcUniqueId);
        if (s != null) {
            StatisticsType type = s.getType();
            StatisticDescriptor[] tmp = type.getStatistics();
            m.stats = new RemoteStat[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                m.stats[i] = new RemoteStat(s, tmp[i]);
            }
        }
        if (m.stats == null) {
            m.stats = new RemoteStat[0];
        }
        return m;
    }

    public RemoteStat[] getStats() {
        return this.stats;
    }

    @Override
    public int getDSFID() {
        return 1028;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.stats, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.stats = (RemoteStat[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "FetchResourceAttributesResponse from " + this.getRecipient();
    }
}

