/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.admin.remote.RegionAdminMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyRegionMessage
extends RegionAdminMessage {
    private static final Logger logger = LogService.getLogger();
    private ExpirationAction action;

    public static DestroyRegionMessage create(ExpirationAction action) {
        DestroyRegionMessage m = new DestroyRegionMessage();
        m.action = action;
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                if (this.action == ExpirationAction.LOCAL_DESTROY) {
                    r.localDestroyRegion();
                } else if (this.action == ExpirationAction.DESTROY) {
                    r.destroyRegion();
                } else if (this.action == ExpirationAction.INVALIDATE) {
                    r.invalidateRegion();
                } else if (this.action == ExpirationAction.LOCAL_INVALIDATE) {
                    r.localInvalidateRegion();
                }
            }
            catch (Exception e) {
                logger.warn("Failed attempt to destroy or invalidate region {} from console at {}", new Object[]{r.getFullPath(), this.getSender()});
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1020;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.action, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.action = (ExpirationAction)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return String.format("DestroyRegionMessage from %s", this.getSender());
    }
}

