/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.AlertLevel;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.Alert;
import org.apache.geode.internal.admin.remote.RemoteAlert;
import org.apache.geode.internal.admin.remote.RemoteGemFireVM;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.management.internal.AlertDetails;

public class AlertListenerMessage
extends PooledDistributionMessage
implements AdminMessageType {
    @MakeNotStatic
    private static final AtomicReference<Listener> listenerRef = new AtomicReference();
    private int alertLevel;
    private Date date;
    private String connectionName;
    private String threadName;
    private long threadId;
    private String message;
    private String exceptionText;

    public static AlertListenerMessage create(DistributedMember recipient, int alertLevel, Date date, String connectionName, String threadName, long threadId, String message, String exceptionText) {
        AlertListenerMessage alertListenerMessage = new AlertListenerMessage();
        alertListenerMessage.setRecipient((InternalDistributedMember)recipient);
        alertListenerMessage.alertLevel = alertLevel;
        alertListenerMessage.date = date;
        alertListenerMessage.connectionName = connectionName;
        if (alertListenerMessage.connectionName == null) {
            alertListenerMessage.connectionName = "";
        }
        alertListenerMessage.threadName = threadName;
        if (alertListenerMessage.threadName == null) {
            alertListenerMessage.threadName = "";
        }
        alertListenerMessage.threadId = threadId;
        alertListenerMessage.message = message;
        if (alertListenerMessage.message == null) {
            alertListenerMessage.message = "";
        }
        alertListenerMessage.exceptionText = exceptionText;
        if (alertListenerMessage.exceptionText == null) {
            alertListenerMessage.exceptionText = "";
        }
        return alertListenerMessage;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        RemoteGfManagerAgent agent;
        Listener listener = AlertListenerMessage.getListener();
        if (listener != null) {
            listener.received(this);
        }
        if ((agent = dm.getAgent()) != null) {
            RemoteGemFireVM manager = agent.getMemberById(this.getSender());
            if (manager == null) {
                return;
            }
            RemoteAlert alert = new RemoteAlert(manager, this.alertLevel, this.date, this.connectionName, this.threadName, this.threadId, this.message, this.exceptionText, this.getSender());
            if (listener != null) {
                listener.created(alert);
            }
            agent.callAlertListener(alert);
        } else {
            AlertDetails alertDetail = new AlertDetails(this.alertLevel, this.date, this.connectionName, this.threadName, this.threadId, this.message, this.exceptionText, this.getSender());
            if (listener != null) {
                listener.created(alertDetail);
            }
            dm.getSystem().handleResourceEvent(ResourceEvent.SYSTEM_ALERT, alertDetail);
        }
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public int getDSFID() {
        return 1008;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.alertLevel);
        DataSerializer.writeObject(this.date, out);
        DataSerializer.writeString(this.connectionName, out);
        DataSerializer.writeString(this.threadName, out);
        out.writeLong(this.threadId);
        DataSerializer.writeString(this.message, out);
        DataSerializer.writeString(this.exceptionText, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.alertLevel = in.readInt();
        this.date = (Date)DataSerializer.readObject(in);
        this.connectionName = DataSerializer.readString(in);
        this.threadName = DataSerializer.readString(in);
        this.threadId = in.readLong();
        this.message = DataSerializer.readString(in);
        this.exceptionText = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "Alert \"" + this.message + "\" level " + AlertLevel.forSeverity(this.alertLevel);
    }

    @VisibleForTesting
    public static void addListener(Listener listener) {
        listenerRef.compareAndSet(null, listener);
    }

    @VisibleForTesting
    public static void removeListener(Listener listener) {
        listenerRef.compareAndSet(listener, null);
    }

    @VisibleForTesting
    public static Listener getListener() {
        return listenerRef.get();
    }

    @VisibleForTesting
    public static interface Listener {
        public void received(AlertListenerMessage var1);

        public void created(Alert var1);

        public void created(AlertDetails var1);
    }
}

