/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.ByteBufferWriter;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.ObjToByteArraySerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataStream;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.logging.log4j.Logger;

public class HeapDataOutputStream
extends OutputStream
implements ObjToByteArraySerializer,
VersionedDataStream,
ByteBufferWriter {
    private static final Logger logger = LogService.getLogger();
    ByteBuffer buffer;
    protected LinkedList<ByteBuffer> chunks = null;
    protected int size = 0;
    private boolean writeMode = true;
    private boolean ignoreWrites = false;
    private final int MIN_CHUNK_SIZE;
    private boolean disallowExpansion = false;
    private Error expansionException = null;
    private int memoPosition;
    private Version version;
    private boolean doNotCopy;
    static final int SMALLEST_CHUNK_SIZE = 32;
    private static final int INITIAL_CAPACITY = 1024;
    private static final boolean ASCII_STRINGS = Boolean.getBoolean("gemfire.ASCII_STRINGS");
    public static final int MIN_TO_COPY = 128;

    public HeapDataOutputStream(Version version) {
        this(1024, version);
    }

    public HeapDataOutputStream(String s) {
        int maxStrBytes = ASCII_STRINGS ? s.length() : s.length() * 3;
        this.MIN_CHUNK_SIZE = 1024;
        this.buffer = ByteBuffer.allocate(maxStrBytes);
        this.doNotCopy = false;
        this.writeUTFNoLength(s);
    }

    public HeapDataOutputStream(int allocSize, Version version) {
        this(allocSize, version, false);
    }

    public HeapDataOutputStream(int allocSize, Version version, boolean doNotCopy) {
        this.MIN_CHUNK_SIZE = allocSize < 32 ? 32 : allocSize;
        this.buffer = ByteBuffer.allocate(allocSize);
        this.version = version;
        this.doNotCopy = doNotCopy;
    }

    public HeapDataOutputStream(ByteBuffer initialBuffer, Version version, boolean doNotCopy) {
        int allocSize;
        if (initialBuffer.position() != 0) {
            initialBuffer = initialBuffer.slice();
        }
        this.MIN_CHUNK_SIZE = (allocSize = initialBuffer.capacity()) < 32 ? 32 : allocSize;
        this.buffer = initialBuffer;
        this.version = version;
        this.doNotCopy = doNotCopy;
    }

    public HeapDataOutputStream(byte[] bytes) {
        int len = bytes.length;
        if (len <= 0) {
            throw new IllegalArgumentException("The byte array must not be empty");
        }
        this.MIN_CHUNK_SIZE = len > 32 ? len : 32;
        this.buffer = ByteBuffer.wrap(bytes);
        this.doNotCopy = false;
    }

    public boolean setDoNotCopy(boolean v) {
        boolean result = this.doNotCopy;
        if (result != v) {
            this.doNotCopy = v;
        }
        return result;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void disallowExpansion(Error ee) {
        this.disallowExpansion = true;
        this.expansionException = ee;
        this.memoPosition = this.buffer.position();
    }

    @Override
    public void write(int b) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(1);
        this.buffer.put((byte)(b & 0xFF));
    }

    private void ensureCapacity(int amount) {
        int remainingSpace = this.buffer.capacity() - this.buffer.position();
        if (amount > remainingSpace) {
            this.expand(amount);
        }
    }

    private void expand(int amount) {
        if (this.disallowExpansion) {
            this.buffer.position(this.memoPosition);
            this.ignoreWrites = true;
            throw this.expansionException;
        }
        ByteBuffer oldBuffer = this.buffer;
        if (this.chunks == null) {
            this.chunks = new LinkedList();
        }
        oldBuffer.flip();
        this.size += oldBuffer.remaining();
        this.chunks.add(oldBuffer);
        if (amount < this.MIN_CHUNK_SIZE) {
            amount = this.MIN_CHUNK_SIZE;
        }
        this.buffer = ByteBuffer.allocate(amount);
    }

    private void checkIfWritable() {
        if (!this.writeMode) {
            throw new IllegalStateException("not in write mode");
        }
    }

    @Override
    public void write(byte[] source, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        if (this.doNotCopy && len > 128) {
            this.moveBufferToChunks();
            this.addToChunks(source, offset, len);
        } else {
            int remainingSpace = this.buffer.capacity() - this.buffer.position();
            if (remainingSpace < len) {
                this.buffer.put(source, offset, remainingSpace);
                offset += remainingSpace;
                this.ensureCapacity(len -= remainingSpace);
            }
            this.buffer.put(source, offset, len);
        }
    }

    private void addToChunks(byte[] source, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(source, offset, len).slice();
        bb = bb.slice();
        this.size += bb.remaining();
        this.chunks.add(bb);
    }

    private void addToChunks(ByteBuffer bb) {
        int remaining = bb.remaining();
        if (remaining > 0) {
            this.size += remaining;
            if (bb.position() != 0) {
                bb = bb.slice();
            }
            this.chunks.add(bb);
        }
    }

    public int getByteBufferCount() {
        int result = 0;
        if (this.chunks != null) {
            result += this.chunks.size();
        }
        if (this.buffer.remaining() > 0) {
            ++result;
        }
        return result;
    }

    public void fillByteBufferArray(ByteBuffer[] bbArray, int offset) {
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                bbArray[offset++] = bb;
            }
        }
        if (this.buffer.remaining() > 0) {
            bbArray[offset] = this.buffer;
        }
    }

    private void moveBufferToChunks() {
        ByteBuffer oldBuffer = this.buffer;
        if (this.chunks == null) {
            this.chunks = new LinkedList();
        }
        if (oldBuffer.position() == 0) {
            return;
        }
        oldBuffer.flip();
        this.size += oldBuffer.remaining();
        ByteBuffer bufToAdd = oldBuffer.slice();
        this.chunks.add(bufToAdd);
        int newPos = oldBuffer.limit();
        if (oldBuffer.capacity() - newPos <= 0) {
            this.buffer = ByteBuffer.allocate(this.MIN_CHUNK_SIZE);
        } else {
            oldBuffer.limit(oldBuffer.capacity());
            oldBuffer.position(newPos);
            this.buffer = oldBuffer.slice();
        }
    }

    public int size() {
        if (this.writeMode) {
            return this.size + this.buffer.position();
        }
        return this.size;
    }

    public void trim() {
        this.finishWriting();
        if (this.buffer.limit() < this.buffer.capacity()) {
            ByteBuffer bb = ByteBuffer.allocate(this.buffer.limit());
            bb.put(this.buffer);
            bb.flip();
            this.buffer = bb;
        }
    }

    private void consolidateChunks() {
        if (this.chunks != null) {
            int size = this.size();
            ByteBuffer newBuffer = ByteBuffer.allocate(size);
            for (ByteBuffer bb : this.chunks) {
                newBuffer.put(bb);
            }
            this.chunks = null;
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
            this.buffer.flip();
        }
    }

    private void consolidateChunks(int startPosition) {
        assert (startPosition < 32);
        int size = this.size() - startPosition;
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        if (this.chunks != null) {
            this.chunks.getFirst().position(startPosition);
            for (ByteBuffer bb : this.chunks) {
                newBuffer.put(bb);
            }
            this.chunks = null;
        } else {
            this.buffer.position(startPosition);
        }
        newBuffer.put(this.buffer);
        newBuffer.flip();
        this.buffer = newBuffer;
    }

    public void rewind() {
        this.finishWriting();
        this.size = 0;
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                bb.rewind();
                this.size += bb.remaining();
            }
        }
        this.buffer.rewind();
        this.size += this.buffer.remaining();
    }

    public void reset() {
        this.size = 0;
        if (this.chunks != null) {
            this.chunks.clear();
            this.chunks = null;
        }
        this.buffer.clear();
        this.writeMode = true;
        this.ignoreWrites = false;
        this.disallowExpansion = false;
        this.expansionException = null;
    }

    @Override
    public void flush() {
    }

    public void finishWriting() {
        if (this.writeMode) {
            this.ignoreWrites = false;
            this.writeMode = false;
            this.buffer.flip();
            this.size += this.buffer.remaining();
        }
    }

    public ByteBuffer finishWritingAndReturnUnusedBuffer() {
        this.finishWriting();
        ByteBuffer result = this.buffer.duplicate();
        if (result.remaining() == 0) {
            result.limit(result.capacity());
            return result;
        }
        int newPos = result.limit();
        if (result.capacity() - newPos > 0) {
            result.limit(result.capacity());
            result.position(newPos);
            return result.slice();
        }
        return null;
    }

    @Override
    public void close() {
        this.reset();
    }

    public ByteBuffer toByteBuffer() {
        this.finishWriting();
        this.consolidateChunks();
        return this.buffer;
    }

    public ByteBuffer toByteBuffer(int startPosition) {
        this.finishWriting();
        this.consolidateChunks(startPosition);
        return this.buffer;
    }

    public byte[] toByteArray() {
        ByteBuffer bb = this.toByteBuffer();
        if (bb.hasArray() && bb.arrayOffset() == 0 && bb.limit() == bb.capacity()) {
            return bb.array();
        }
        ByteBuffer tmp = ByteBuffer.allocate(bb.remaining());
        tmp.put(bb);
        tmp.flip();
        this.buffer = tmp;
        return this.buffer.array();
    }

    public void sendTo(BytesAndBitsForCompactor wrapper, byte userBits) {
        ByteBuffer bb = this.toByteBuffer();
        if (bb.hasArray() && bb.arrayOffset() == 0) {
            wrapper.setData(bb.array(), userBits, bb.limit(), true);
        } else {
            ByteBuffer tmp = ByteBuffer.allocate(bb.remaining());
            tmp.put(bb);
            tmp.flip();
            this.buffer = tmp;
            byte[] bytes = this.buffer.array();
            wrapper.setData(bytes, userBits, bytes.length, true);
        }
    }

    public int sendTo(SocketChannel chan) throws IOException {
        int result;
        this.finishWriting();
        if (this.size() == 0) {
            return 0;
        }
        if (this.chunks != null) {
            ByteBuffer[] bufs = new ByteBuffer[this.chunks.size() + 1];
            bufs = this.chunks.toArray(bufs);
            bufs[this.chunks.size()] = this.buffer;
            result = (int)chan.write(bufs);
        } else {
            result = chan.write(this.buffer);
        }
        this.size -= result;
        return result;
    }

    public void sendTo(SocketChannel chan, ByteBuffer out) throws IOException {
        this.finishWriting();
        if (this.size() == 0) {
            return;
        }
        out.clear();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.sendChunkTo(bb, chan, out);
            }
        }
        this.sendChunkTo(this.buffer, chan, out);
        this.flushBuffer(chan, out);
    }

    private void sendChunkTo(ByteBuffer in, SocketChannel sc, ByteBuffer out) throws IOException {
        int bytesSent = in.remaining();
        if (in.isDirect()) {
            this.flushBuffer(sc, out);
            while (in.remaining() > 0) {
                sc.write(in);
            }
        } else {
            int OUT_MAX = out.remaining();
            if (bytesSent <= OUT_MAX) {
                out.put(in);
            } else {
                int bytesThisTime;
                byte[] bytes = in.array();
                int off = in.arrayOffset() + in.position();
                for (int len = bytesSent; len > 0; len -= bytesThisTime) {
                    bytesThisTime = len;
                    if (bytesThisTime > OUT_MAX) {
                        bytesThisTime = OUT_MAX;
                    }
                    out.put(bytes, off, bytesThisTime);
                    off += bytesThisTime;
                    this.flushBuffer(sc, out);
                    OUT_MAX = out.remaining();
                }
                in.position(in.limit());
            }
        }
        this.size -= bytesSent;
    }

    private void flushBuffer(SocketChannel sc, ByteBuffer out) throws IOException {
        if (out.position() == 0) {
            return;
        }
        out.flip();
        while (out.remaining() > 0) {
            sc.write(out);
        }
        out.clear();
    }

    public void sendTo(ByteBuffer out) {
        ByteBuffer bb;
        int bytesToWrite;
        this.finishWriting();
        if (out.remaining() < this.size()) {
            throw new BufferOverflowException();
        }
        if (this.chunks != null) {
            for (ByteBuffer bb2 : this.chunks) {
                int bytesToWrite2 = bb2.remaining();
                if (bytesToWrite2 <= 0) continue;
                out.put(bb2);
                this.size -= bytesToWrite2;
            }
        }
        if ((bytesToWrite = (bb = this.buffer).remaining()) > 0) {
            out.put(bb);
            this.size -= bytesToWrite;
        }
    }

    public void sendTo(OutputStream out, ByteBuffer outBuf) throws IOException {
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.sendTo(out, outBuf, bb);
            }
        }
        this.sendTo(out, outBuf, this.buffer);
        HeapDataOutputStream.flushStream(out, outBuf);
    }

    private void sendTo(OutputStream out, ByteBuffer outBuf, ByteBuffer inBuf) throws IOException {
        this.size -= HeapDataOutputStream.writeByteBufferToStream(out, outBuf, inBuf);
    }

    public static int writeByteBufferToStream(OutputStream out, ByteBuffer outBuf, ByteBuffer inBuf) throws IOException {
        int bytesToWrite = inBuf.remaining();
        if (bytesToWrite > 0) {
            if (inBuf.hasArray()) {
                HeapDataOutputStream.flushStream(out, outBuf);
                out.write(inBuf.array(), inBuf.arrayOffset() + inBuf.position(), bytesToWrite);
                inBuf.position(inBuf.limit());
            } else {
                int OUT_MAX = outBuf.remaining();
                for (int bytesToWriteThisTime = bytesToWrite; bytesToWriteThisTime > OUT_MAX; bytesToWriteThisTime -= OUT_MAX) {
                    int oldLimit = inBuf.limit();
                    inBuf.limit(inBuf.position() + OUT_MAX);
                    outBuf.put(inBuf);
                    inBuf.limit(oldLimit);
                    HeapDataOutputStream.flushStream(out, outBuf);
                    OUT_MAX = outBuf.remaining();
                }
                outBuf.put(inBuf);
            }
        }
        return bytesToWrite;
    }

    public static void flushStream(OutputStream out, ByteBuffer outBuf) throws IOException {
        if (outBuf.position() == 0) {
            return;
        }
        assert (outBuf.hasArray());
        outBuf.flip();
        out.write(outBuf.array(), outBuf.arrayOffset(), outBuf.remaining());
        outBuf.clear();
    }

    public void sendTo(ByteBufferWriter out) {
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb : this.chunks) {
                this.basicSendTo(out, bb);
            }
        }
        this.basicSendTo(out, this.buffer);
    }

    private void basicSendTo(ByteBufferWriter out, ByteBuffer bb) {
        int bytesToWrite = bb.remaining();
        if (bytesToWrite > 0) {
            out.write(bb.duplicate());
            this.size -= bytesToWrite;
        }
    }

    public InputStream getInputStream() {
        return new HDInputStream();
    }

    public void sendTo(DataOutput out) throws IOException {
        ByteBuffer bb;
        int bytesToWrite;
        this.finishWriting();
        if (this.chunks != null) {
            for (ByteBuffer bb2 : this.chunks) {
                int bytesToWrite2 = bb2.remaining();
                if (bytesToWrite2 <= 0) continue;
                if (bb2.hasArray()) {
                    out.write(bb2.array(), bb2.arrayOffset() + bb2.position(), bytesToWrite2);
                    bb2.position(bb2.limit());
                } else {
                    byte[] bytes = new byte[bytesToWrite2];
                    bb2.get(bytes);
                    out.write(bytes);
                }
                this.size -= bytesToWrite2;
            }
        }
        if ((bytesToWrite = (bb = this.buffer).remaining()) > 0) {
            if (bb.hasArray()) {
                out.write(bb.array(), bb.arrayOffset() + bb.position(), bytesToWrite);
                bb.position(bb.limit());
            } else {
                byte[] bytes = new byte[bytesToWrite];
                bb.get(bytes);
                out.write(bytes);
            }
            this.size -= bytesToWrite;
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeShort(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(2);
        this.buffer.putShort((short)(v & 0xFFFF));
    }

    @Override
    public void writeChar(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(2);
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        this.buffer.putLong(v);
    }

    public LongUpdater reserveLong() {
        if (this.ignoreWrites) {
            return null;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        LongUpdater result = new LongUpdater(this.buffer);
        this.buffer.putLong(0L);
        return result;
    }

    @Override
    public void writeFloat(float v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(4);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeBytes(String str) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int strlen = str.length();
        if (strlen > 0) {
            this.ensureCapacity(strlen);
            if (this.buffer.hasArray()) {
                int pos = this.buffer.position();
                str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
                this.buffer.position(pos + strlen);
            } else {
                byte[] bytes = new byte[strlen];
                str.getBytes(0, strlen, bytes, 0);
                this.buffer.put(bytes);
            }
        }
    }

    @Override
    public void writeChars(String s) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int len = s.length();
        if (len > 0) {
            this.ensureCapacity(len * 2);
            for (int i = 0; i < len; ++i) {
                this.buffer.putChar(s.charAt(i));
            }
        }
    }

    @Override
    public void writeUTF(String str) throws UTFDataFormatException {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        if (ASCII_STRINGS) {
            this.writeAsciiUTF(str, true);
        } else {
            this.writeFullUTF(str, true);
        }
    }

    private void writeAsciiUTF(String str, boolean encodeLength) throws UTFDataFormatException {
        int strlen = str.length();
        if (encodeLength && strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int maxLen = strlen;
        if (encodeLength) {
            maxLen += 2;
        }
        this.ensureCapacity(maxLen);
        if (encodeLength) {
            this.buffer.putShort((short)strlen);
        }
        if (this.buffer.hasArray()) {
            int pos = this.buffer.position();
            str.getBytes(0, strlen, this.buffer.array(), this.buffer.arrayOffset() + pos);
            this.buffer.position(pos + strlen);
        } else {
            for (int i = 0; i < strlen; ++i) {
                this.buffer.put((byte)str.charAt(i));
            }
        }
    }

    private void writeFullUTF(String str, boolean encodeLength) throws UTFDataFormatException {
        int strlen = str.length();
        if (encodeLength && strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int maxLen = strlen * 3;
        if (encodeLength) {
            maxLen += 2;
        }
        this.ensureCapacity(maxLen);
        int utfSizeIdx = this.buffer.position();
        if (encodeLength) {
            this.buffer.position(utfSizeIdx + 2);
        }
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.buffer.put((byte)(0xE0 | c >> 12 & 0xF));
                this.buffer.put((byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.buffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
        int utflen = this.buffer.position() - utfSizeIdx;
        if (encodeLength) {
            if ((utflen -= 2) > 65535) {
                this.buffer.position(utfSizeIdx);
                throw new UTFDataFormatException();
            }
            this.buffer.putShort(utfSizeIdx, (short)utflen);
        }
    }

    public void writeUTFNoLength(String str) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        try {
            if (ASCII_STRINGS) {
                this.writeAsciiUTF(str, false);
            } else {
                this.writeFullUTF(str, false);
            }
        }
        catch (UTFDataFormatException ex) {
            throw new IllegalStateException(String.format("unexpected %s", ex));
        }
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        this.ensureCapacity(5);
        if (v instanceof HeapDataOutputStream) {
            HeapDataOutputStream other = (HeapDataOutputStream)v;
            other.finishWriting();
            InternalDataSerializer.writeArrayLength(other.size(), this);
            if (this.doNotCopy) {
                if (other.chunks != null) {
                    for (ByteBuffer bb : other.chunks) {
                        this.write(bb);
                    }
                }
                this.write(other.buffer);
            } else {
                other.sendTo(this);
                other.rewind();
            }
        } else {
            ByteBuffer sizeBuf = this.buffer;
            int sizePos = sizeBuf.position();
            sizeBuf.position(sizePos + 5);
            int preArraySize = this.size();
            DataSerializer.writeObject(v, this);
            int arraySize = this.size() - preArraySize;
            sizeBuf.put(sizePos, (byte)-3);
            sizeBuf.putInt(sizePos + 1, arraySize);
        }
    }

    @Override
    public void write(ByteBuffer bb) {
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int remaining = bb.remaining();
        if (remaining == 0) {
            return;
        }
        if (this.doNotCopy && remaining > 128) {
            this.moveBufferToChunks();
            this.addToChunks(bb);
        } else {
            int remainingSpace = this.buffer.remaining();
            if (remainingSpace < remaining) {
                int oldLimit = bb.limit();
                bb.limit(bb.position() + remainingSpace);
                this.buffer.put(bb);
                bb.limit(oldLimit);
                this.ensureCapacity(bb.remaining());
            }
            this.buffer.put(bb);
        }
    }

    public void write(ByteBufferInputStream.ByteSource source) {
        ByteBuffer bb = source.getBackingByteBuffer();
        if (bb != null) {
            this.write(bb);
            return;
        }
        if (this.ignoreWrites) {
            return;
        }
        this.checkIfWritable();
        int remainingSpace = this.buffer.limit() - this.buffer.position();
        if (remainingSpace < source.remaining()) {
            int oldLimit = source.limit();
            source.limit(source.position() + remainingSpace);
            source.sendTo(this.buffer);
            source.limit(oldLimit);
            this.ensureCapacity(source.remaining());
        }
        source.sendTo(this.buffer);
    }

    public static class LongUpdater {
        private final ByteBuffer bb;
        private final int pos;

        public LongUpdater(ByteBuffer bb) {
            this.bb = bb;
            this.pos = bb.position();
        }

        public void update(long v) {
            this.bb.putLong(this.pos, v);
        }
    }

    private class HDInputStream
    extends InputStream {
        private Iterator<ByteBuffer> chunkIt;
        private ByteBuffer bb;

        public HDInputStream() {
            HeapDataOutputStream.this.finishWriting();
            if (HeapDataOutputStream.this.chunks != null) {
                this.chunkIt = HeapDataOutputStream.this.chunks.iterator();
                this.nextChunk();
            } else {
                this.chunkIt = null;
                this.bb = HeapDataOutputStream.this.buffer;
            }
        }

        private void nextChunk() {
            if (this.chunkIt != null) {
                if (this.chunkIt.hasNext()) {
                    this.bb = this.chunkIt.next();
                } else {
                    this.chunkIt = null;
                    this.bb = HeapDataOutputStream.this.buffer;
                }
            } else {
                this.bb = null;
            }
        }

        @Override
        public int available() {
            return HeapDataOutputStream.this.size();
        }

        @Override
        public int read() {
            if (this.available() <= 0) {
                return -1;
            }
            int remaining = this.bb.limit() - this.bb.position();
            while (remaining == 0) {
                this.nextChunk();
                remaining = this.bb.limit() - this.bb.position();
            }
            this.consume(1);
            return this.bb.get() & 0xFF;
        }

        @Override
        public int read(byte[] dst, int off, int len) {
            if (this.available() <= 0) {
                return -1;
            }
            int readCount = 0;
            while (len > 0 && this.bb != null) {
                if (this.bb.limit() == this.bb.position()) {
                    this.nextChunk();
                    continue;
                }
                int remaining = this.bb.limit() - this.bb.position();
                int bytesToRead = len;
                if (len > remaining) {
                    bytesToRead = remaining;
                }
                this.bb.get(dst, off, bytesToRead);
                off += bytesToRead;
                len -= bytesToRead;
                readCount += bytesToRead;
            }
            this.consume(readCount);
            return readCount;
        }

        @Override
        public long skip(long n) {
            long skipsRemaining;
            int remaining = HeapDataOutputStream.this.size();
            if ((long)remaining <= n) {
                this.chunkIt = null;
                this.bb = null;
                this.consume(remaining);
                return remaining;
            }
            long skipped = 0L;
            while ((skipped += this.chunkSkip(skipsRemaining = n - skipped)) != n) {
            }
            return n;
        }

        private long chunkSkip(long n) {
            int remaining = this.bb.limit() - this.bb.position();
            if ((long)remaining <= n) {
                this.bb.position(this.bb.limit());
                this.nextChunk();
                this.consume(remaining);
                return remaining;
            }
            this.bb.position(this.bb.position() + (int)n);
            this.consume((int)n);
            return n;
        }

        private void consume(int c) {
            HeapDataOutputStream.this.size -= c;
        }
    }
}

