/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.tcpserver.InfoRequest;
import org.apache.geode.distributed.internal.tcpserver.InfoResponse;
import org.apache.geode.distributed.internal.tcpserver.ShutdownRequest;
import org.apache.geode.distributed.internal.tcpserver.ShutdownResponse;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.VersionRequest;
import org.apache.geode.distributed.internal.tcpserver.VersionResponse;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataInputStream;
import org.apache.geode.internal.VersionedDataOutputStream;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolService;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolServiceLoader;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceLoadingFailureException;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceVersionNotFoundException;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.logging.log4j.Logger;

public class TcpServer {
    public static final int GOSSIPVERSION = 1002;
    public static final int OLDGOSSIPVERSION = 1001;
    @MutableForTesting(value="The map used here is mutable, because some tests modify it")
    private static final Map<Integer, Short> GOSSIP_TO_GEMFIRE_VERSION_MAP = TcpServer.createGossipToVersionMap();
    @MutableForTesting
    public static boolean isTesting = false;
    @MutableForTesting
    public static int TESTVERSION = 1002;
    @MutableForTesting
    public static int OLDTESTVERSION = 1001;
    public static final long SHUTDOWN_WAIT_TIME = 60000L;
    private static final int MAX_POOL_SIZE = Integer.getInteger("gemfire.TcpServer.MAX_POOL_SIZE", 100);
    private static final int POOL_IDLE_TIMEOUT = 60000;
    private static final Logger log = LogService.getLogger();
    private final int READ_TIMEOUT = Integer.getInteger("gemfire.TcpServer.READ_TIMEOUT", 60000);
    private static final int P2P_BACKLOG = Integer.getInteger("p2p.backlog", 1000);
    private static final int BACKLOG = Integer.getInteger("gemfire.TcpServer.BACKLOG", P2P_BACKLOG);
    private int port;
    private ServerSocket srv_sock = null;
    private InetAddress bind_address;
    private volatile boolean shuttingDown = false;
    private final PoolStatHelper poolHelper;
    private final InternalLocator internalLocator;
    private final TcpHandler handler;
    private final ClientProtocolServiceLoader clientProtocolServiceLoader;
    private ExecutorService executor;
    private final String threadName;
    private volatile Thread serverThread;
    protected SocketCreator socketCreator;

    private static Map<Integer, Short> createGossipToVersionMap() {
        HashMap<Integer, Short> map = new HashMap<Integer, Short>();
        map.put(1002, Version.GFE_71.ordinal());
        map.put(1001, Version.GFE_57.ordinal());
        return map;
    }

    public TcpServer(int port, InetAddress bind_address, Properties sslConfig, DistributionConfigImpl cfg, TcpHandler handler, PoolStatHelper poolHelper, String threadName, InternalLocator internalLocator, ClientProtocolServiceLoader clientProtocolServiceLoader) {
        this.port = port;
        this.bind_address = bind_address;
        this.handler = handler;
        this.poolHelper = poolHelper;
        this.internalLocator = internalLocator;
        this.clientProtocolServiceLoader = clientProtocolServiceLoader;
        DSFIDFactory.registerTypes();
        this.executor = TcpServer.createExecutor(poolHelper);
        this.threadName = threadName;
        if (cfg == null) {
            if (sslConfig == null) {
                sslConfig = new Properties();
            }
            cfg = new DistributionConfigImpl(sslConfig);
        }
    }

    protected SocketCreator getSocketCreator() {
        if (this.socketCreator == null) {
            this.socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR);
        }
        return this.socketCreator;
    }

    private static ExecutorService createExecutor(PoolStatHelper poolHelper) {
        return LoggingExecutors.newThreadPoolWithSynchronousFeed("locator request thread ", MAX_POOL_SIZE, poolHelper, 60000, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void restarting(InternalDistributedSystem ds, InternalCache cache, InternalConfigurationPersistenceService sharedConfig) throws IOException {
        this.shuttingDown = false;
        this.handler.restarting(ds, cache, sharedConfig);
        this.startServerThread();
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = TcpServer.createExecutor(this.poolHelper);
        }
        log.info("TcpServer@" + System.identityHashCode(this) + " restarting: completed.  Server thread=" + this.serverThread + '@' + System.identityHashCode(this.serverThread) + ";alive=" + this.serverThread.isAlive());
    }

    public void restartCompleted(InternalDistributedSystem ds) {
        this.handler.restartCompleted(ds);
    }

    public void start() throws IOException {
        this.shuttingDown = false;
        this.startServerThread();
        this.handler.init(this);
    }

    private void startServerThread() throws IOException {
        this.initializeServerSocket();
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            this.serverThread = new LoggingThread(this.threadName, this::run);
            this.serverThread.start();
        }
    }

    private void initializeServerSocket() throws IOException {
        if (this.srv_sock == null || this.srv_sock.isClosed()) {
            if (this.bind_address == null) {
                this.srv_sock = this.getSocketCreator().createServerSocket(this.port, BACKLOG);
                this.bind_address = this.srv_sock.getInetAddress();
            } else {
                this.srv_sock = this.getSocketCreator().createServerSocket(this.port, BACKLOG, this.bind_address);
            }
            if (this.port <= 0) {
                this.port = this.srv_sock.getLocalPort();
            }
            if (log.isInfoEnabled()) {
                log.info("Locator was created at " + new Date());
                log.info("Listening on port " + this.getPort() + " bound on address " + this.bind_address);
            }
            this.srv_sock.setReuseAddress(true);
        }
    }

    public void join(long millis) throws InterruptedException {
        if (this.serverThread != null) {
            this.serverThread.join(millis);
        }
    }

    public void join() throws InterruptedException {
        if (this.serverThread != null) {
            this.serverThread.join();
        }
    }

    public boolean isAlive() {
        return this.serverThread != null && this.serverThread.isAlive();
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public SocketAddress getBindAddress() {
        return this.srv_sock.getLocalSocketAddress();
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        Socket sock = null;
        while (!this.shuttingDown) {
            if (SystemFailure.getFailure() != null) {
                try {
                    this.srv_sock.close();
                    return;
                }
                catch (IOException iOException) {
                    SystemFailure.checkFailure();
                }
            }
            if (this.srv_sock.isClosed()) {
                this.shuttingDown = true;
                break;
            }
            try {
                try {
                    sock = this.srv_sock.accept();
                }
                catch (SSLException ex) {
                    log.error("Locator stopping due to SSL configuration problem.", (Throwable)ex);
                    this.shuttingDown = true;
                    continue;
                }
                this.processRequest(sock);
            }
            catch (Exception ex) {
                if (this.shuttingDown) continue;
                log.error("exception=", (Throwable)ex);
            }
        }
        if (!this.srv_sock.isClosed()) {
            try {
                this.srv_sock.close();
            }
            catch (IOException ex) {
                log.warn("exception closing server socket during shutdown", (Throwable)ex);
            }
        }
        if (this.shuttingDown) {
            log.info("locator shutting down");
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.handler.shutDown();
            TcpServer tcpServer = this;
            synchronized (tcpServer) {
                this.notifyAll();
            }
        }
    }

    private void processRequest(Socket socket) {
        this.executor.execute(() -> {
            long startTime = DistributionStats.getStatTime();
            DataInputStream input = null;
            try {
                socket.setSoTimeout(this.READ_TIMEOUT);
                this.getSocketCreator().handshakeIfSocketIsSSL(socket, this.READ_TIMEOUT);
                try {
                    input = new DataInputStream(socket.getInputStream());
                }
                catch (StreamCorruptedException e) {
                    log.debug("Discarding illegal request from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort(), (Throwable)e);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                int firstByte = input.readUnsignedByte();
                if (firstByte == CommunicationMode.ReservedForGossip.getModeNumber()) {
                    this.processOneConnection(socket, startTime, input);
                } else if (firstByte == CommunicationMode.ProtobufClientServerProtocol.getModeNumber()) {
                    this.handleProtobufConnection(socket, input);
                } else {
                    if (CommunicationMode.isValidMode(firstByte)) {
                        socket.getOutputStream().write(67);
                        throw new Exception("Improperly configured client detected - use addPoolLocator to configure its locators instead of addPoolServer.");
                    }
                    this.rejectUnknownProtocolConnection(socket, firstByte);
                }
            }
            catch (EOFException | SocketException firstByte) {
            }
            catch (CancelException firstByte) {
            }
            catch (ClassNotFoundException ex) {
                String sender = null;
                if (socket != null) {
                    sender = socket.getInetAddress().getHostAddress();
                }
                log.info("Unable to process request from " + sender + " exception=" + ex.getMessage());
            }
            catch (Exception ex) {
                String sender = null;
                if (socket != null) {
                    sender = socket.getInetAddress().getHostAddress();
                }
                if (ex instanceof IOException) {
                    if (!socket.isClosed()) {
                        log.info("Exception in processing request from " + sender, (Throwable)ex);
                    }
                } else {
                    log.fatal("Exception in processing request from " + sender, (Throwable)ex);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                String sender = null;
                if (socket != null) {
                    sender = socket.getInetAddress().getHostAddress();
                }
                try {
                    log.fatal("Exception in processing request from " + sender, ex);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    t.printStackTrace();
                }
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException ex) {}
            }
        });
    }

    private void processOneConnection(Socket socket, long startTime, DataInputStream input) throws IOException, UnsupportedVersionException, ClassNotFoundException {
        int gossipVersion = 0;
        for (int i = 0; i < 3; ++i) {
            gossipVersion = (gossipVersion << 8) + (0xFF & input.readUnsignedByte());
        }
        if (gossipVersion <= TcpServer.getCurrentGossipVersion() && GOSSIP_TO_GEMFIRE_VERSION_MAP.containsKey(gossipVersion)) {
            Object response;
            short versionOrdinal = GOSSIP_TO_GEMFIRE_VERSION_MAP.get(gossipVersion);
            if (Version.GFE_71.compareTo(versionOrdinal) <= 0) {
                versionOrdinal = input.readShort();
            }
            if (log.isDebugEnabled() && versionOrdinal != Version.CURRENT_ORDINAL) {
                log.debug("Locator reading request from " + socket.getInetAddress() + " with version " + Version.fromOrdinal(versionOrdinal, false));
            }
            input = new VersionedDataInputStream(input, Version.fromOrdinal(versionOrdinal, false));
            Object request = DataSerializer.readObject(input);
            if (log.isDebugEnabled()) {
                log.debug("Locator received request " + request + " from " + socket.getInetAddress());
            }
            if (request instanceof ShutdownRequest) {
                this.shuttingDown = true;
                this.srv_sock.close();
                response = new ShutdownResponse();
            } else {
                response = request instanceof InfoRequest ? this.handleInfoRequest(request) : (request instanceof VersionRequest ? this.handleVersionRequest(request) : this.handler.processRequest(request));
            }
            this.handler.endRequest(request, startTime);
            startTime = DistributionStats.getStatTime();
            if (response != null) {
                DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                if (versionOrdinal != Version.CURRENT_ORDINAL) {
                    output = new VersionedDataOutputStream(output, Version.fromOrdinal(versionOrdinal, false));
                }
                DataSerializer.writeObject(response, output);
                output.flush();
            }
            this.handler.endResponse(request, startTime);
        } else {
            this.rejectUnknownProtocolConnection(socket, gossipVersion);
        }
    }

    private void rejectUnknownProtocolConnection(Socket socket, int gossipVersion) {
        try {
            socket.getOutputStream().write("unknown protocol version".getBytes());
            socket.getOutputStream().flush();
            socket.close();
        }
        catch (IOException e) {
            log.debug("exception in sending reply to process using unknown protocol " + gossipVersion, (Throwable)e);
        }
    }

    private void handleProtobufConnection(Socket socket, DataInputStream input) throws Exception {
        if (!Boolean.getBoolean("geode.feature-protobuf-protocol")) {
            log.warn("Incoming protobuf connection, but protobuf not enabled on this locator.");
            socket.close();
            return;
        }
        try {
            ClientProtocolService clientProtocolService = this.clientProtocolServiceLoader.lookupService();
            clientProtocolService.initializeStatistics("LocatorStats", this.internalLocator.getDistributedSystem());
            try (ClientProtocolProcessor pipeline = clientProtocolService.createProcessorForLocator(this.internalLocator, this.internalLocator.getCache().getSecurityService());){
                while (!pipeline.socketProcessingIsFinished()) {
                    pipeline.processMessage(input, socket.getOutputStream());
                }
            }
            catch (IncompatibleVersionException e) {
                log.error("Unexpected exception in client message processing", (Throwable)e);
            }
        }
        catch (ServiceLoadingFailureException e) {
            log.error("There was an error looking up the client protocol service", (Throwable)e);
            socket.close();
            throw new IOException("There was an error looking up the client protocol service", e);
        }
        catch (ServiceVersionNotFoundException e) {
            log.error("Unable to find service matching the client protocol version byte", (Throwable)e);
            socket.close();
            throw new IOException("Unable to find service matching the client protocol version byte", e);
        }
    }

    protected Object handleInfoRequest(Object request) {
        String[] info = new String[2];
        info[0] = System.getProperty("user.dir");
        URL url = GemFireVersion.getJarURL();
        if (url == null) {
            String s = "Could not find gemfire jar";
            throw new IllegalStateException(s);
        }
        File gemfireJar = new File(url.getPath());
        File lib = gemfireJar.getParentFile();
        File product = lib.getParentFile();
        info[1] = product.getAbsolutePath();
        return new InfoResponse(info);
    }

    protected Object handleVersionRequest(Object request) {
        VersionResponse response = new VersionResponse();
        response.setVersionOrdinal(Version.CURRENT_ORDINAL);
        return response;
    }

    public static int getCurrentGossipVersion() {
        return isTesting ? TESTVERSION : 1002;
    }

    public static int getOldGossipVersion() {
        return isTesting ? OLDTESTVERSION : 1001;
    }

    public static Map<Integer, Short> getGossipVersionMapForTestOnly() {
        return GOSSIP_TO_GEMFIRE_VERSION_MAP;
    }
}

