/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSEncrypt;
import org.apache.logging.log4j.Logger;

public class GMSEncryptionCipherPool {
    private static final int MAX_CIPHERS_PER_POOL = Integer.getInteger("GMSEncrypt.MAX_ENCRYPTORS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    private static final int MAX_CIPHER_WAIT_IN_SEC = 10;
    private static final Logger logger = Services.getLogger();
    private final GMSEncrypt gmsEncrypt;
    private final byte[] secretBytes;
    private final BlockingQueue<Cipher> encryptCipherQueue = new LinkedBlockingQueue<Cipher>();
    private final AtomicInteger encryptCipherCount = new AtomicInteger(0);
    private final BlockingQueue<Cipher> decryptCipherQueue = new LinkedBlockingQueue<Cipher>();
    private final AtomicInteger decryptCipherCount = new AtomicInteger(0);

    GMSEncryptionCipherPool(GMSEncrypt gmsEncrypt, byte[] secretBytes) {
        this.gmsEncrypt = gmsEncrypt;
        this.secretBytes = secretBytes;
    }

    byte[] getSecretBytes() {
        return this.secretBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] encryptBytes(byte[] data) throws Exception {
        Cipher encrypt = this.getOrCreateCipher(this.encryptCipherQueue, this.encryptCipherCount, this.gmsEncrypt::getEncryptCipher);
        try {
            byte[] byArray = encrypt.doFinal(data);
            return byArray;
        }
        finally {
            this.encryptCipherQueue.offer(encrypt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] decryptBytes(byte[] data) throws Exception {
        Cipher decrypt = this.getOrCreateCipher(this.decryptCipherQueue, this.decryptCipherCount, this.gmsEncrypt::getDecryptCipher);
        try {
            byte[] byArray = decrypt.doFinal(data);
            return byArray;
        }
        finally {
            this.decryptCipherQueue.offer(decrypt);
        }
    }

    private Cipher getOrCreateCipher(BlockingQueue<Cipher> cipherQueue, AtomicInteger cipherCount, ThrowingFunction<byte[], Cipher> maker) throws Exception {
        Cipher cipher = (Cipher)cipherQueue.poll();
        if (cipher == null) {
            if (cipherCount.getAndIncrement() < MAX_CIPHERS_PER_POOL) {
                cipher = maker.apply(this.secretBytes);
            } else {
                cipherCount.decrementAndGet();
                cipher = cipherQueue.poll(10L, TimeUnit.SECONDS);
            }
        }
        if (cipher == null) {
            logger.error("No encryption cipher available, exceeding max cipher threshold");
            cipherCount.incrementAndGet();
            cipher = maker.apply(this.secretBytes);
        }
        return cipher;
    }

    static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

