/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LocatorStats;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.GMSUtil;
import org.apache.geode.distributed.internal.membership.gms.NetLocator;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Locator;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewResponse;
import org.apache.geode.distributed.internal.membership.gms.membership.HostAddress;
import org.apache.geode.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedObjectInput;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GMSLocator
implements Locator,
NetLocator {
    static final int LOCATOR_FILE_STAMP = 2072835905;
    private static final Logger logger = LogService.getLogger();
    private final boolean usePreferredCoordinators;
    private final boolean networkPartitionDetectionEnabled;
    private final String securityUDPDHAlgo;
    private final String locatorString;
    private final List<HostAddress> locators;
    private Services services;
    private final LocatorStats stats;
    private InternalDistributedMember localAddress;
    private final Set<InternalDistributedMember> registrants = new HashSet<InternalDistributedMember>();
    private Map<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]> registerMbrVsPK = new ConcurrentHashMap<InternalDistributedMember.InternalDistributedMemberWrapper, byte[]>();
    private transient NetView view;
    private transient NetView recoveredView;
    private File viewFile;
    private volatile boolean isCoordinator;

    public GMSLocator(InetAddress bindAddress, String locatorString, boolean usePreferredCoordinators, boolean networkPartitionDetectionEnabled, LocatorStats stats, String securityUDPDHAlgo) {
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.securityUDPDHAlgo = securityUDPDHAlgo;
        this.locatorString = locatorString;
        this.locators = this.locatorString == null || this.locatorString.length() == 0 ? new ArrayList<HostAddress>(0) : GMSUtil.parseLocators(locatorString, bindAddress);
        this.stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setMembershipManager(MembershipManager mgr) {
        if (this.services == null || this.services.isStopped()) {
            this.services = ((GMSMembershipManager)mgr).getServices();
            this.localAddress = this.services.getMessenger().getMemberID();
            assert (this.localAddress != null) : "member address should have been established";
            logger.info("Peer locator is connecting to local membership services with ID {}", (Object)this.localAddress);
            this.services.setLocator(this);
            NetView newView = this.services.getJoinLeave().getView();
            if (newView != null) {
                this.view = newView;
                this.recoveredView = null;
            } else {
                if (this.view != null) {
                    this.view.setViewId(-100);
                    this.recoveredView = this.view;
                    this.view = null;
                }
                if (this.localAddress != null) {
                    if (this.recoveredView != null) {
                        this.recoveredView.remove(this.localAddress);
                    }
                    Set<InternalDistributedMember> set = this.registrants;
                    synchronized (set) {
                        this.registrants.add(this.localAddress);
                    }
                }
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    File setViewFile(File file) {
        this.viewFile = file.getAbsoluteFile();
        return this.viewFile;
    }

    @Override
    public void init(TcpServer server) throws InternalGemFireException {
        if (this.viewFile == null) {
            this.viewFile = new File("locator" + server.getPort() + "view.dat").getAbsoluteFile();
        }
        logger.info("GemFire peer location service starting.  Other locators: {}  Locators preferred as coordinators: {}  Network partition detection enabled: {}  View persistence file: {}", (Object)this.locatorString, (Object)this.usePreferredCoordinators, (Object)this.networkPartitionDetectionEnabled, (Object)this.viewFile);
        this.recover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installView(NetView view) {
        Set<InternalDistributedMember> set = this.registrants;
        synchronized (set) {
            this.registrants.clear();
        }
        logger.info("Peer locator received new membership view: " + view);
        this.view = view;
        this.recoveredView = null;
        this.saveView(view);
    }

    @Override
    public void setIsCoordinator(boolean isCoordinator) {
        if (isCoordinator) {
            logger.info("Location services has received notification that this node is becoming membership coordinator");
        }
        this.isCoordinator = isCoordinator;
    }

    @Override
    public Object processRequest(Object request) {
        DataSerializableFixedID response = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator processing {}", request);
        }
        if (this.localAddress == null && this.services != null) {
            this.localAddress = this.services.getMessenger().getMemberID();
        }
        if (request instanceof GetViewRequest) {
            if (this.view != null) {
                response = new GetViewResponse(this.view);
            }
        } else if (request instanceof FindCoordinatorRequest) {
            response = this.processFindCoordinatorRequest((FindCoordinatorRequest)request);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator returning {}", (Object)response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindCoordinatorResponse processFindCoordinatorRequest(FindCoordinatorRequest findRequest) {
        if (!findRequest.getDHAlgo().equals(this.securityUDPDHAlgo)) {
            return new FindCoordinatorResponse("Rejecting findCoordinatorRequest, as member not configured same udp security(" + findRequest.getDHAlgo() + " )as locator (" + this.securityUDPDHAlgo + ")");
        }
        if (this.services == null) {
            if (findRequest.getMyPublicKey() != null) {
                this.registerMbrVsPK.put(new InternalDistributedMember.InternalDistributedMemberWrapper(findRequest.getMemberID()), findRequest.getMyPublicKey());
            }
            logger.debug("Rejecting a request to find the coordinator - membership services are still initializing");
            return null;
        }
        if (findRequest.getMemberID() == null) {
            return null;
        }
        this.services.getMessenger().setPublicKey(findRequest.getMyPublicKey(), findRequest.getMemberID());
        InternalDistributedMember coordinator = null;
        if (this.view == null && this.services == null) {
            return null;
        }
        boolean fromView = false;
        NetView v = this.view;
        if (v == null) {
            v = this.recoveredView;
        }
        Set<InternalDistributedMember> set = this.registrants;
        synchronized (set) {
            this.registrants.add(findRequest.getMemberID());
            if (this.recoveredView != null) {
                this.recoveredView.remove(findRequest.getMemberID());
            }
        }
        if (v != null) {
            InternalDistributedMember requestingMemberID = findRequest.getMemberID();
            for (InternalDistributedMember id : v.getMembers()) {
                if (requestingMemberID.compareTo(id, false) != 0) continue;
                NetView newView = new NetView(v, v.getViewId());
                newView.remove(id);
                v = newView;
                break;
            }
            coordinator = v.getViewId() > findRequest.getLastViewId() ? v.getCoordinator(Collections.emptyList()) : v.getCoordinator(findRequest.getRejectedCoordinators());
            logger.info("Peer locator: coordinator from view is {}", (Object)coordinator);
            fromView = true;
        }
        if (coordinator == null) {
            Collection<InternalDistributedMember> rejections = findRequest.getRejectedCoordinators();
            if (rejections == null) {
                rejections = Collections.emptyList();
            }
            Set<InternalDistributedMember> set2 = this.registrants;
            synchronized (set2) {
                coordinator = this.services.getJoinLeave().getMemberID();
                for (InternalDistributedMember mbr : this.registrants) {
                    if (mbr == coordinator || coordinator != null && mbr.compareTo(coordinator) >= 0 || rejections.contains(mbr) || !mbr.getNetMember().preferredForCoordinator() && mbr.getNetMember().isNetworkPartitionDetectionEnabled()) continue;
                    coordinator = mbr;
                }
                logger.info("Peer locator: coordinator from registrations is {}", (Object)coordinator);
            }
        }
        set = this.registrants;
        synchronized (set) {
            if (this.isCoordinator) {
                coordinator = this.localAddress;
                if (v != null && this.localAddress != null && !this.localAddress.equals(v.getCoordinator())) {
                    v = null;
                    fromView = false;
                }
            }
            byte[] coordinatorPublicKey = null;
            if (v != null) {
                coordinatorPublicKey = (byte[])v.getPublicKey(coordinator);
            }
            if (coordinatorPublicKey == null) {
                coordinatorPublicKey = this.services.getMessenger().getPublicKey(coordinator);
            }
            return new FindCoordinatorResponse(coordinator, this.localAddress, fromView, v, new HashSet<InternalDistributedMember>(this.registrants), this.networkPartitionDetectionEnabled, this.usePreferredCoordinators, coordinatorPublicKey);
        }
    }

    private void saveView(NetView view) {
        if (this.viewFile == null) {
            return;
        }
        if (!this.viewFile.delete() && this.viewFile.exists()) {
            logger.warn("Peer locator is unable to delete persistent membership information in " + this.viewFile.getAbsolutePath());
        }
        try {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(this.viewFile));
                oos.writeInt(2072835905);
                oos.writeInt(Version.CURRENT_ORDINAL);
                DataSerializer.writeObject(view, oos);
            }
            finally {
                if (oos != null) {
                    oos.flush();
                    oos.close();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Peer locator encountered an error writing current membership to disk.  Disabling persistence.  Care should be taken when bouncing this locator as it will not be able to recover knowledge of the running distributed system", (Throwable)e);
            this.viewFile = null;
        }
    }

    @Override
    public void endRequest(Object request, long startTime) {
        this.stats.endLocatorRequest(startTime);
    }

    @Override
    public void endResponse(Object request, long startTime) {
        this.stats.endLocatorResponse(startTime);
    }

    public byte[] getPublicKey(InternalDistributedMember mbr) {
        return this.registerMbrVsPK.get(new InternalDistributedMember.InternalDistributedMemberWrapper(mbr));
    }

    @Override
    public void shutDown() {
        this.registerMbrVsPK.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InternalDistributedMember> getMembers() {
        if (this.view != null) {
            return new ArrayList<InternalDistributedMember>(this.view.getMembers());
        }
        Set<InternalDistributedMember> set = this.registrants;
        synchronized (set) {
            return new ArrayList<InternalDistributedMember>(this.registrants);
        }
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, InternalConfigurationPersistenceService sharedConfig) {
        this.setMembershipManager(((InternalDistributedSystem)ds).getDM().getMembershipManager());
    }

    private void recover() throws InternalGemFireException {
        if (!this.recoverFromOtherLocators()) {
            this.recoverFromFile(this.viewFile);
        }
    }

    private boolean recoverFromOtherLocators() {
        for (HostAddress other : this.locators) {
            if (!this.recover(other.getSocketInetAddress())) continue;
            logger.info("Peer locator recovered state from " + other);
            return true;
        }
        return false;
    }

    private boolean recover(InetSocketAddress other) {
        try {
            logger.info("Peer locator attempting to recover from " + other);
            TcpClient client = new TcpClient();
            Object response = client.requestToServer(other.getAddress(), other.getPort(), new GetViewRequest(), 20000, true);
            if (response instanceof GetViewResponse) {
                this.view = ((GetViewResponse)response).getView();
                logger.info("Peer locator recovered initial membership of {}", (Object)this.view);
                return true;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            logger.debug("Peer locator could not recover membership view from {}: {}", (Object)other, (Object)ex.getMessage());
        }
        logger.info("Peer locator was unable to recover state from this locator");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean recoverFromFile(File file) throws InternalGemFireException {
        if (!file.exists()) {
            logger.info("recovery file not found: " + file.getAbsolutePath());
            return false;
        }
        logger.info("Peer locator recovering from " + file.getAbsolutePath());
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            if (ois.readInt() != 2072835905) {
                boolean bl = false;
                return bl;
            }
            ObjectInput ois2 = ois;
            int version = ois2.readInt();
            if (version != Version.CURRENT_ORDINAL) {
                Version geodeVersion = Version.fromOrdinalNoThrow((short)version, false);
                logger.info("Peer locator found that persistent view was written with {}", (Object)geodeVersion);
                ois2 = new VersionedObjectInput(ois2, geodeVersion);
            }
            Object o = DataSerializer.readObject(ois2);
            this.recoveredView = (NetView)o;
            this.recoveredView.setViewId(-1);
            ArrayList<InternalDistributedMember> members = new ArrayList<InternalDistributedMember>(this.recoveredView.getMembers());
            for (InternalDistributedMember member : members) {
                if (member.getVmKind() != 11) continue;
                this.recoveredView.remove(member);
            }
            logger.info("Peer locator recovered membership is " + this.recoveredView);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String msg = String.format("Unable to recover previous membership view from %s", file.toString());
            logger.warn(msg, (Throwable)e);
            if (file.delete()) throw new InternalGemFireException(msg, e);
            if (!file.exists()) throw new InternalGemFireException(msg, e);
            logger.warn("Peer locator was unable to recover from or delete " + file);
            this.viewFile = null;
            throw new InternalGemFireException(msg, e);
        }
    }
}

