/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.fd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.distributed.internal.membership.gms.GMSMember;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.interfaces.HealthMonitor;
import org.apache.geode.distributed.internal.membership.gms.interfaces.MessageHandler;
import org.apache.geode.distributed.internal.membership.gms.messages.FinalCheckPassedMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.HeartbeatRequestMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectMembersMessage;
import org.apache.geode.distributed.internal.membership.gms.messages.SuspectRequest;
import org.apache.geode.internal.ConnectionWatcher;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.logging.LoggingExecutors;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.logging.log4j.Logger;
import org.jgroups.util.UUID;

public class GMSHealthMonitor
implements HealthMonitor,
MessageHandler {
    private Services services;
    private volatile NetView currentView;
    private volatile InternalDistributedMember nextNeighbor;
    long memberTimeout;
    private volatile boolean isStopping = false;
    private final AtomicInteger requestId = new AtomicInteger();
    private static final Logger logger = Services.getLogger();
    private static final int NUM_HEARTBEATS = Integer.getInteger("geode.heartbeat-recipients", 2);
    public static final int LOGICAL_INTERVAL = Integer.getInteger("geode.logical-message-received-interval", 2);
    public static final long MEMBER_SUSPECT_COLLECTION_INTERVAL = Long.getLong("geode.suspect-member-collection-interval", 200L);
    private volatile long currentTimeStamp;
    private InternalDistributedMember localAddress;
    final ConcurrentMap<InternalDistributedMember, TimeStamp> memberTimeStamps = new ConcurrentHashMap<InternalDistributedMember, TimeStamp>();
    private final ConcurrentHashMap<InternalDistributedMember, NetView> suspectedMemberIds = new ConcurrentHashMap();
    private final List<InternalDistributedMember> membersInFinalCheck = Collections.synchronizedList(new ArrayList(30));
    private final Map<Integer, Response> requestIdVsResponse = new ConcurrentHashMap<Integer, Response>();
    private final Map<NetView, Set<SuspectRequest>> suspectRequestsInView = new HashMap<NetView, Set<SuspectRequest>>();
    private ScheduledExecutorService scheduler;
    private ExecutorService checkExecutor;
    private ScheduledFuture<?> monitorFuture;
    private volatile boolean playingDead = false;
    private volatile boolean beingSick = false;
    private ExecutorService serverSocketExecutor;
    static final int OK = 123;
    static final int ERROR = 0;
    private volatile int socketPort;
    private volatile ServerSocket serverSocket;
    private DMStats stats;

    public static void loadEmergencyClasses() {
    }

    @Override
    public void contactedBy(InternalDistributedMember sender) {
        this.contactedBy(sender, this.currentTimeStamp);
    }

    private void contactedBy(InternalDistributedMember sender, long timeStamp) {
        TimeStamp cTS = new TimeStamp(timeStamp);
        if ((cTS = this.memberTimeStamps.putIfAbsent(sender, cTS)) != null && cTS.getTime() < timeStamp) {
            cTS.setTime(timeStamp);
        }
        if (this.suspectedMemberIds.containsKey(sender)) {
            this.memberUnsuspected(sender);
            this.setNextNeighbor(this.currentView, null);
        }
    }

    private HeartbeatRequestMessage constructHeartbeatRequestMessage(InternalDistributedMember mbr) {
        int reqId = this.requestId.getAndIncrement();
        HeartbeatRequestMessage hrm = new HeartbeatRequestMessage(mbr, reqId);
        hrm.setRecipient(mbr);
        return hrm;
    }

    private void checkMember(InternalDistributedMember mbr) {
        NetView cv = this.currentView;
        this.setNextNeighbor(cv, mbr);
        this.checkExecutor.execute(() -> {
            boolean pinged;
            try {
                pinged = this.doCheckMember(mbr, true);
            }
            catch (CancelException e) {
                return;
            }
            if (!pinged) {
                String reason = "Member isn't responding to heartbeat requests";
                this.memberSuspected(this.localAddress, mbr, reason);
                this.initiateSuspicion(mbr, reason);
                this.setNextNeighbor(this.currentView, null);
            } else {
                logger.trace("Setting next neighbor as member {} has responded.", (Object)mbr);
                this.memberUnsuspected(mbr);
                this.setNextNeighbor(this.currentView, null);
            }
        });
    }

    private void initiateSuspicion(InternalDistributedMember mbr, String reason) {
        if (this.services.getJoinLeave().isMemberLeaving(mbr)) {
            return;
        }
        this.sendSuspectRequest(Collections.singletonList(new SuspectRequest(mbr, reason)));
    }

    /*
     * Exception decompiling
     */
    private boolean doCheckMember(InternalDistributedMember member, boolean waitForResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doTCPCheckMember(InternalDistributedMember suspectMember, int port, boolean retryIfConnectFails) {
        Socket clientSocket = null;
        long giveupTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(this.services.getConfig().getMemberTimeout(), TimeUnit.MILLISECONDS);
        boolean passed = false;
        int iteration = 0;
        do {
            if (++iteration > 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            try {
                logger.debug("Checking member {} with TCP socket connection {}:{}.", (Object)suspectMember, (Object)suspectMember.getInetAddress(), (Object)port);
                clientSocket = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.CLUSTER).connect(suspectMember.getInetAddress(), port, (int)this.memberTimeout, new ConnectTimeoutTask(this.services.getTimer(), this.memberTimeout), false, -1, false);
                clientSocket.setTcpNoDelay(true);
                passed = this.doTCPCheckMember(suspectMember, clientSocket);
            }
            catch (IOException e) {
            }
            catch (IllegalStateException | GemFireConfigException e) {
                if (this.isStopping) continue;
                logger.trace("Unexpected exception", (Throwable)e);
            }
            finally {
                try {
                    if (clientSocket != null) {
                        clientSocket.setSoLinger(true, 0);
                        clientSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } while (retryIfConnectFails && !passed && !this.isShutdown() && System.nanoTime() < giveupTime);
        return passed;
    }

    boolean doTCPCheckMember(InternalDistributedMember suspectMember, Socket clientSocket) {
        try {
            if (clientSocket.isConnected()) {
                clientSocket.setSoTimeout((int)this.services.getConfig().getMemberTimeout());
                InputStream in = clientSocket.getInputStream();
                DataOutputStream out = new DataOutputStream(clientSocket.getOutputStream());
                GMSMember gmbr = (GMSMember)suspectMember.getNetMember();
                this.writeMemberToStream(gmbr, out);
                this.stats.incFinalCheckRequestsSent();
                this.stats.incTcpFinalCheckRequestsSent();
                logger.debug("Connected to suspect member - reading response");
                int b = in.read();
                if (logger.isDebugEnabled()) {
                    logger.debug("Received {}", (Object)(b == 123 ? "OK" : (b == 0 ? "ERROR" : "unknown response: " + b)));
                }
                if (b >= 0) {
                    this.stats.incFinalCheckResponsesReceived();
                    this.stats.incTcpFinalCheckResponsesReceived();
                }
                if (b == 123) {
                    TimeStamp ts = (TimeStamp)this.memberTimeStamps.get(suspectMember);
                    if (ts != null) {
                        ts.setTime(System.currentTimeMillis());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SocketTimeoutException e) {
            logger.debug("Availability check TCP/IP connection timed out for suspect member {}", (Object)suspectMember);
            return false;
        }
        catch (IOException e) {
            logger.trace("Unexpected exception", (Throwable)e);
            return false;
        }
    }

    void writeMemberToStream(GMSMember gmbr, DataOutputStream out) throws IOException {
        out.writeShort(Version.CURRENT_ORDINAL);
        out.writeInt(gmbr.getVmViewId());
        out.writeLong(gmbr.getUuidLSBs());
        out.writeLong(gmbr.getUuidMSBs());
        out.flush();
    }

    @Override
    public void suspect(InternalDistributedMember mbr, String reason) {
        this.initiateSuspicion(mbr, reason);
    }

    @Override
    public boolean checkIfAvailable(DistributedMember mbr, String reason, boolean initiateRemoval) {
        return this.inlineCheckIfAvailable(this.localAddress, this.currentView, initiateRemoval, (InternalDistributedMember)mbr, reason);
    }

    @Override
    public void start() {
        this.scheduler = LoggingExecutors.newScheduledThreadPool("Geode Failure Detection Scheduler", 1);
        this.checkExecutor = LoggingExecutors.newCachedThreadPool("Geode Failure Detection thread ", true);
        Monitor m = new Monitor(this.memberTimeout);
        long delay = this.memberTimeout / (long)LOGICAL_INTERVAL;
        this.monitorFuture = this.scheduler.scheduleAtFixedRate(m, delay, delay, TimeUnit.MILLISECONDS);
        this.serverSocketExecutor = LoggingExecutors.newCachedThreadPool("Geode Failure Detection Server thread ", true);
    }

    ServerSocket createServerSocket(InetAddress socketAddress, int[] portRange) {
        ServerSocket serverSocket;
        try {
            serverSocket = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.CLUSTER).createServerSocketUsingPortRange(socketAddress, 50, true, false, 65536, portRange, false);
            this.socketPort = serverSocket.getLocalPort();
        }
        catch (IOException | SystemConnectException e) {
            throw new GemFireConfigException("Unable to allocate a failure detection port in the membership-port range", e);
        }
        return serverSocket;
    }

    private void startTcpServer(ServerSocket ssocket) {
        this.serverSocketExecutor.execute(() -> {
            logger.info("Started failure detection server thread on {}:{}.", (Object)ssocket.getInetAddress(), (Object)this.socketPort);
            Socket socket = null;
            try {
                while (!this.services.getCancelCriterion().isCancelInProgress() && !this.isStopping) {
                    try {
                        socket = ssocket.accept();
                        if (this.playingDead) continue;
                        this.serverSocketExecutor.execute(new ClientSocketHandler(socket));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    catch (IOException e) {
                        if (!this.isStopping) {
                            logger.trace("Unexpected exception", (Throwable)e);
                        }
                        try {
                            if (socket == null) continue;
                            socket.close();
                        }
                        catch (IOException ioe) {
                            logger.trace("Unexpected exception", (Throwable)ioe);
                        }
                    }
                }
                logger.info("GMSHealthMonitor server thread exiting");
                return;
            }
            finally {
                if (!ssocket.isClosed()) {
                    try {
                        ssocket.close();
                    }
                    catch (IOException e) {
                        logger.debug("Unexpected exception", (Throwable)e);
                    }
                }
            }
        });
    }

    private void startHeartbeatThread() {
        this.checkExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Geode Heartbeat Sender");
                this.sendPeriodicHeartbeats();
            }

            private void sendPeriodicHeartbeats() {
                while (!GMSHealthMonitor.this.isStopping && !GMSHealthMonitor.this.services.getCancelCriterion().isCancelInProgress()) {
                    List<InternalDistributedMember> mbrs;
                    int index;
                    try {
                        Thread.sleep(GMSHealthMonitor.this.memberTimeout / (long)LOGICAL_INTERVAL);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    NetView v = GMSHealthMonitor.this.currentView;
                    if (v == null || (index = (mbrs = v.getMembers()).indexOf(GMSHealthMonitor.this.localAddress)) < 0 || mbrs.size() < 2 || GMSHealthMonitor.this.playingDead) continue;
                    this.sendHeartbeats(mbrs, index);
                }
            }

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void sendHeartbeats(List<InternalDistributedMember> mbrs, int startIndex) {
                InternalDistributedMember coordinator = GMSHealthMonitor.this.currentView.getCoordinator();
                if (coordinator != null && !coordinator.equals(GMSHealthMonitor.this.localAddress)) {
                    HeartbeatMessage message = new HeartbeatMessage(-1);
                    message.setRecipient(coordinator);
                    try {
                        if (GMSHealthMonitor.this.isStopping) {
                            return;
                        }
                        GMSHealthMonitor.this.services.getMessenger().sendUnreliably(message);
                        GMSHealthMonitor.this.stats.incHeartbeatsSent();
                    }
                    catch (CancelException e) {
                        return;
                    }
                }
                int index = startIndex;
                int numSent = 0;
                while (true) {
                    InternalDistributedMember mbr;
                    if (--index < 0) {
                        index = mbrs.size() - 1;
                    }
                    if ((mbr = mbrs.get(index)).equals(GMSHealthMonitor.this.localAddress)) return;
                    if (mbr.equals(coordinator)) continue;
                    if (GMSHealthMonitor.this.isStopping) {
                        return;
                    }
                    HeartbeatMessage message = new HeartbeatMessage(-1);
                    message.setRecipient(mbr);
                    GMSHealthMonitor.this.services.getMessenger().sendUnreliably(message);
                    GMSHealthMonitor.this.stats.incHeartbeatsSent();
                    if (++numSent >= NUM_HEARTBEATS) return;
                    continue;
                    break;
                }
                catch (CancelException e) {
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void installView(NetView newView) {
        Map<NetView, Set<SuspectRequest>> map = this.suspectRequestsInView;
        synchronized (map) {
            this.suspectRequestsInView.clear();
        }
        Iterator it = this.memberTimeStamps.keySet().iterator();
        while (it.hasNext()) {
            if (newView.contains((DistributedMember)it.next())) continue;
            it.remove();
        }
        it = ((ConcurrentHashMap.KeySetView)this.suspectedMemberIds.keySet()).iterator();
        while (it.hasNext()) {
            if (newView.contains((DistributedMember)it.next())) continue;
            it.remove();
        }
        this.currentView = newView;
        this.setNextNeighbor(newView, null);
    }

    public synchronized NetView getView() {
        return this.currentView;
    }

    protected synchronized void setNextNeighbor(NetView newView, InternalDistributedMember nextTo) {
        int index;
        List<InternalDistributedMember> allMembers;
        if (newView == null) {
            return;
        }
        if (nextTo == null) {
            nextTo = this.localAddress;
        }
        if ((allMembers = newView.getMembers()).size() > 1 && this.suspectedMemberIds.size() >= allMembers.size() - 1) {
            boolean nonSuspectFound = false;
            for (InternalDistributedMember member : allMembers) {
                if (member.equals(this.localAddress) || this.suspectedMemberIds.containsKey(member)) continue;
                nonSuspectFound = true;
                break;
            }
            if (!nonSuspectFound) {
                logger.info("All other members are suspect at this point");
                this.nextNeighbor = null;
                return;
            }
        }
        if ((index = allMembers.indexOf(nextTo)) != -1) {
            int nextNeighborIndex = (index + 1) % allMembers.size();
            InternalDistributedMember newNeighbor = allMembers.get(nextNeighborIndex);
            if (this.suspectedMemberIds.containsKey(newNeighbor)) {
                this.setNextNeighbor(newView, newNeighbor);
                return;
            }
            InternalDistributedMember oldNeighbor = this.nextNeighbor;
            if (oldNeighbor != newNeighbor) {
                logger.debug("Failure detection is now watching " + newNeighbor);
                this.nextNeighbor = newNeighbor;
            }
        }
        if (this.nextNeighbor != null && this.nextNeighbor.equals(this.localAddress)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Health monitor is unable to find a neighbor to watch.  Current suspects are {}", this.suspectedMemberIds);
            }
            this.nextNeighbor = null;
        }
    }

    public InternalDistributedMember getNextNeighbor() {
        return this.nextNeighbor;
    }

    @Override
    public void init(Services s) {
        this.isStopping = false;
        this.services = s;
        this.memberTimeout = s.getConfig().getMemberTimeout();
        this.stats = this.services.getStatistics();
        this.services.getMessenger().addHandler(HeartbeatRequestMessage.class, this);
        this.services.getMessenger().addHandler(HeartbeatMessage.class, this);
        this.services.getMessenger().addHandler(SuspectMembersMessage.class, this);
        this.services.getMessenger().addHandler(FinalCheckPassedMessage.class, this);
    }

    @Override
    public void started() {
        this.setLocalAddress(this.services.getMessenger().getMemberID());
        this.serverSocket = this.createServerSocket(this.localAddress.getInetAddress(), this.services.getConfig().getMembershipPortRange());
        this.startTcpServer(this.serverSocket);
        this.startHeartbeatThread();
    }

    @Override
    public void stop() {
        this.stopServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServices() {
        logger.debug("Stopping HealthMonitor");
        this.isStopping = true;
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        Collection<Response> val = this.requestIdVsResponse.values();
        Iterator<Response> iterator = val.iterator();
        while (iterator.hasNext()) {
            Response r;
            Response response = r = iterator.next();
            synchronized (response) {
                r.notify();
            }
        }
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
        if (this.serverSocketExecutor != null) {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    logger.trace("Unexpected exception", (Throwable)e);
                }
            }
            this.serverSocketExecutor.shutdownNow();
            try {
                this.serverSocketExecutor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown() && this.checkExecutor.isShutdown() && this.serverSocketExecutor.isShutdown();
    }

    public boolean isSuspectMember(InternalDistributedMember m) {
        return this.suspectedMemberIds.containsKey(m);
    }

    @Override
    public void stopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
        Map<NetView, Set<SuspectRequest>> map = this.suspectRequestsInView;
        synchronized (map) {
            this.suspectedMemberIds.put(suspect, this.currentView);
            HashSet<SuspectRequest> requests = (HashSet<SuspectRequest>)this.suspectRequestsInView.get(this.currentView);
            boolean found = false;
            if (requests == null) {
                requests = new HashSet<SuspectRequest>();
                requests.add(new SuspectRequest(suspect, reason));
            }
            for (SuspectRequest request : requests) {
                if (!suspect.equals(request.getSuspectMember())) continue;
                found = true;
                break;
            }
            if (!found) {
                requests.add(new SuspectRequest(suspect, reason));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memberUnsuspected(InternalDistributedMember mbr) {
        Map<NetView, Set<SuspectRequest>> map = this.suspectRequestsInView;
        synchronized (map) {
            Collection suspectRequests;
            if (this.suspectedMemberIds.remove(mbr) != null) {
                logger.info("No longer suspecting {}", (Object)mbr);
            }
            if ((suspectRequests = (Collection)this.suspectRequestsInView.get(this.currentView)) != null) {
                ArrayList<SuspectRequest> removals = new ArrayList<SuspectRequest>(suspectRequests.size());
                for (SuspectRequest suspectRequest : suspectRequests) {
                    if (!mbr.equals(suspectRequest.getSuspectMember())) continue;
                    removals.add(suspectRequest);
                }
                suspectRequests.removeAll(removals);
            }
        }
    }

    @Override
    public void beSick() {
        this.beingSick = true;
    }

    @Override
    public void playDead() {
        this.playingDead = true;
    }

    @Override
    public void beHealthy() {
        this.beingSick = false;
        this.playingDead = false;
    }

    @Override
    public void emergencyClose() {
        this.stopServices();
    }

    @Override
    public void setLocalAddress(InternalDistributedMember idm) {
        this.localAddress = idm;
    }

    @Override
    public void processMessage(DistributionMessage m) {
        if (this.isStopping) {
            return;
        }
        logger.trace("processing {}", (Object)m);
        switch (m.getDSFID()) {
            case -154: {
                if (this.beingSick || this.playingDead) {
                    logger.debug("sick member is ignoring check request");
                    break;
                }
                this.processHeartbeatRequest((HeartbeatRequestMessage)m);
                break;
            }
            case -155: {
                if (this.beingSick || this.playingDead) {
                    logger.debug("sick member is ignoring check response");
                    break;
                }
                this.processHeartbeat((HeartbeatMessage)m);
                break;
            }
            case -156: {
                if (this.beingSick || this.playingDead) {
                    logger.debug("sick member is ignoring suspect message");
                    break;
                }
                this.processSuspectMembersRequest((SuspectMembersMessage)m);
                break;
            }
            case -158: {
                this.contactedBy(((FinalCheckPassedMessage)m).getSuspect());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown message type: " + m);
            }
        }
    }

    private void processHeartbeatRequest(HeartbeatRequestMessage m) {
        this.stats.incHeartbeatRequestsReceived();
        if (this.isStopping || this.playingDead) {
            return;
        }
        InternalDistributedMember me = this.localAddress;
        if (me == null || me.getVmViewId() >= 0 && m.getTarget().equals(me)) {
            HeartbeatMessage hm = new HeartbeatMessage(m.getRequestId());
            hm.setRecipient(m.getSender());
            Set<InternalDistributedMember> membersNotReceivedMsg = this.services.getMessenger().send(hm);
            this.stats.incHeartbeatsSent();
            if (membersNotReceivedMsg != null && membersNotReceivedMsg.contains(m.getSender())) {
                logger.debug("Unable to send heartbeat to member: {}", (Object)m.getSender());
            }
        } else {
            logger.debug("Ignoring heartbeat request intended for {}.  My ID is {}", (Object)m.getTarget(), (Object)me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeartbeat(HeartbeatMessage m) {
        this.stats.incHeartbeatsReceived();
        if (m.getRequestId() >= 0) {
            Response resp = this.requestIdVsResponse.get(m.getRequestId());
            logger.trace("Got heartbeat from member {}. {}", (Object)m.getSender(), (Object)(resp != null ? "Check thread still waiting" : "Check thread is not waiting"));
            if (resp != null) {
                Response response = resp;
                synchronized (response) {
                    resp.setResponseMsg(m);
                    resp.notify();
                }
            }
        }
        this.contactedBy(m.getSender(), System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuspectMembersRequest(SuspectMembersMessage incomingRequest) {
        Object message;
        this.stats.incSuspectsReceived();
        NetView cv = this.currentView;
        if (cv == null) {
            return;
        }
        List<SuspectRequest> suspectRequests = incomingRequest.getMembers();
        InternalDistributedMember sender = incomingRequest.getSender();
        int viewId = sender.getVmViewId();
        if (cv.getViewId() >= viewId && !cv.contains(incomingRequest.getSender())) {
            logger.info("Membership ignoring suspect request for " + incomingRequest + " from non-member " + incomingRequest.getSender());
            this.services.getJoinLeave().remove(sender, "this process is initiating suspect processing but is no longer a member");
            return;
        }
        if (!this.playingDead) {
            Iterator<SuspectRequest> it = incomingRequest.getMembers().iterator();
            while (it.hasNext()) {
                SuspectRequest req = it.next();
                if (!req.getSuspectMember().equals(this.localAddress)) continue;
                message = new HeartbeatMessage(-1);
                ((DistributionMessage)message).setRecipient(sender);
                try {
                    this.services.getMessenger().send((DistributionMessage)message);
                    this.stats.incHeartbeatsSent();
                    it.remove();
                }
                catch (CancelException e) {
                    return;
                }
            }
        }
        logger.debug("Processing suspect requests {}\nproposed view is currently {}\nwith coordinator {}", suspectRequests, (Object)cv, (Object)cv.getCoordinator());
        if (cv.getCoordinator().equals(this.localAddress)) {
            this.logSuspectRequests(incomingRequest, sender);
            this.checkIfAvailable(sender, suspectRequests, cv);
        } else {
            NetView check = new NetView(cv, cv.getViewId() + 1);
            ArrayList<SuspectRequest> membersToCheck = new ArrayList<SuspectRequest>();
            message = this.suspectRequestsInView;
            synchronized (message) {
                this.recordSuspectRequests(suspectRequests, cv);
                Set<SuspectRequest> suspectsInView = this.suspectRequestsInView.get(cv);
                logger.debug("Current suspects are {}", suspectsInView);
                Iterator<SuspectRequest> iterator = suspectsInView.iterator();
                while (iterator.hasNext()) {
                    SuspectRequest sr = iterator.next();
                    check.remove(sr.getSuspectMember());
                    membersToCheck.add(sr);
                }
            }
            ArrayList<InternalDistributedMember> membersLeaving = new ArrayList<InternalDistributedMember>();
            for (InternalDistributedMember member : cv.getMembers()) {
                if (!this.services.getJoinLeave().isMemberLeaving(member)) continue;
                membersLeaving.add(member);
            }
            if (!membersLeaving.isEmpty()) {
                logger.debug("Current leave requests are {}", membersLeaving);
                check.removeAll(membersLeaving);
            }
            logger.trace("Proposed view with suspects & leaving members removed is {}\nwith coordinator {}\nmy address is {}", (Object)check, (Object)check.getCoordinator(), (Object)this.localAddress);
            InternalDistributedMember coordinator = check.getCoordinator();
            if (coordinator != null && coordinator.equals(this.localAddress)) {
                this.logSuspectRequests(incomingRequest, sender);
                this.checkIfAvailable(sender, membersToCheck, cv);
            }
        }
    }

    private void logSuspectRequests(SuspectMembersMessage incomingRequest, InternalDistributedMember sender) {
        for (SuspectRequest req : incomingRequest.getMembers()) {
            String who = sender.equals(this.localAddress) ? "myself" : sender.toString();
            logger.info("received suspect message from {} for {}: {}", (Object)who, (Object)req.getSuspectMember(), (Object)req.getReason());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSuspectRequests(List<SuspectRequest> suspectRequests, NetView cv) {
        Map<NetView, Set<SuspectRequest>> map = this.suspectRequestsInView;
        synchronized (map) {
            Set<SuspectRequest> suspectedMembers = this.suspectRequestsInView.get(cv);
            if (suspectedMembers == null) {
                suspectedMembers = new HashSet<SuspectRequest>();
                this.suspectRequestsInView.put(cv, suspectedMembers);
            }
            suspectedMembers.addAll(suspectRequests);
        }
    }

    private void checkIfAvailable(InternalDistributedMember initiator, List<SuspectRequest> sMembers, NetView cv) {
        for (SuspectRequest sr : sMembers) {
            InternalDistributedMember mbr = sr.getSuspectMember();
            if (!cv.contains(mbr) || this.membersInFinalCheck.contains(mbr) || mbr.equals(this.localAddress)) continue;
            String reason = sr.getReason();
            logger.debug("Scheduling availability check for member {}; reason={}", (Object)mbr, (Object)reason);
            this.checkExecutor.execute(() -> {
                try {
                    this.inlineCheckIfAvailable(initiator, cv, true, mbr, reason);
                }
                catch (CancelException cancelException) {
                }
                catch (Exception e) {
                    logger.info("Unexpected exception while verifying member", (Throwable)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean inlineCheckIfAvailable(InternalDistributedMember initiator, NetView cv, boolean forceRemovalIfCheckFails, InternalDistributedMember mbr, String reason) {
        if (this.services.getJoinLeave().isMemberLeaving(mbr)) {
            return false;
        }
        boolean failed = false;
        logger.info("Performing availability check for suspect member {} reason={}", (Object)mbr, (Object)reason);
        this.membersInFinalCheck.add(mbr);
        this.setNextNeighbor(this.currentView, mbr);
        try {
            boolean pinged;
            this.services.memberSuspected(initiator, mbr, reason);
            long startTime = System.currentTimeMillis();
            int port = cv.getFailureDetectionPort(mbr);
            if (port <= 0) {
                logger.info("Unable to locate failure detection port - requesting a heartbeat");
                if (logger.isDebugEnabled()) {
                    logger.debug("\ncurrent view: {}\nports: {}", (Object)cv, (Object)Arrays.toString(cv.getFailureDetectionPorts()));
                }
                pinged = this.doCheckMember(mbr, true);
                this.stats.incFinalCheckRequestsSent();
                this.stats.incUdpFinalCheckRequestsSent();
                if (pinged) {
                    this.stats.incFinalCheckResponsesReceived();
                    this.stats.incUdpFinalCheckResponsesReceived();
                }
            } else {
                this.doCheckMember(mbr, false);
                boolean retryIfConnectFails = forceRemovalIfCheckFails;
                pinged = this.doTCPCheckMember(mbr, port, retryIfConnectFails);
            }
            if (!pinged && !this.isStopping) {
                TimeStamp ts = (TimeStamp)this.memberTimeStamps.get(mbr);
                if (ts == null || ts.getTime() < startTime) {
                    logger.info("Availability check failed for member {}", (Object)mbr);
                    if (forceRemovalIfCheckFails) {
                        logger.info("Requesting removal of suspect member {}", (Object)mbr);
                        this.services.getJoinLeave().remove(mbr, reason);
                        this.memberSuspected(this.localAddress, mbr, reason);
                    } else if (this.doTCPCheckMember(this.localAddress, this.socketPort, false)) {
                        this.membersInFinalCheck.remove(mbr);
                        this.memberSuspected(this.localAddress, mbr, reason);
                        this.initiateSuspicion(mbr, reason);
                        SuspectMembersMessage suspectMembersMessage = new SuspectMembersMessage(Collections.singletonList(this.localAddress), Collections.singletonList(new SuspectRequest(mbr, "failed availability check")));
                        suspectMembersMessage.setSender(this.localAddress);
                        logger.debug("Performing local processing on suspect request");
                        this.processSuspectMembersRequest(suspectMembersMessage);
                    }
                    failed = true;
                } else {
                    logger.info("Availability check failed but detected recent message traffic for suspect member " + mbr);
                }
            }
            if (!failed) {
                if (!this.isStopping && !initiator.equals(this.localAddress) && initiator.getVersionObject().compareTo(Version.GEODE_1_3_0) >= 0) {
                    FinalCheckPassedMessage message = new FinalCheckPassedMessage(initiator, mbr);
                    this.services.getMessenger().send(message);
                }
                logger.info("Availability check passed for suspect member " + mbr);
            }
        }
        finally {
            if (!failed) {
                this.memberUnsuspected(mbr);
                this.setNextNeighbor(this.currentView, null);
            }
            this.membersInFinalCheck.remove(mbr);
        }
        return !failed;
    }

    @Override
    public void memberShutdown(DistributedMember mbr, String reason) {
    }

    @Override
    public int getFailureDetectionPort() {
        return this.socketPort;
    }

    @Override
    public Collection<InternalDistributedMember> getMembersFailingAvailabilityCheck() {
        return Collections.unmodifiableCollection(this.suspectedMemberIds.keySet());
    }

    private void sendSuspectRequest(List<SuspectRequest> requests) {
        Set<InternalDistributedMember> failedRecipients;
        List<InternalDistributedMember> recipients;
        logger.debug("Sending suspect request for members {}", requests);
        if (this.currentView.size() > 9) {
            HashSet<InternalDistributedMember> filter = new HashSet<InternalDistributedMember>();
            Enumeration<InternalDistributedMember> e = this.suspectedMemberIds.keys();
            while (e.hasMoreElements()) {
                filter.add(e.nextElement());
            }
            filter.addAll(requests.stream().map(SuspectRequest::getSuspectMember).collect(Collectors.toList()));
            recipients = this.currentView.getPreferredCoordinators(filter, this.services.getJoinLeave().getMemberID(), 10);
        } else {
            recipients = this.currentView.getMembers();
        }
        logger.trace("Sending suspect messages to {}", recipients);
        SuspectMembersMessage smm = new SuspectMembersMessage(recipients, requests);
        try {
            failedRecipients = this.services.getMessenger().send(smm);
            this.stats.incSuspectsSent();
        }
        catch (CancelException e) {
            return;
        }
        if (failedRecipients != null && failedRecipients.size() > 0) {
            logger.trace("Unable to send suspect message to {}", failedRecipients);
        }
    }

    public DMStats getStats() {
        return this.stats;
    }

    private static class ConnectTimeoutTask
    extends TimerTask
    implements ConnectionWatcher {
        final Timer scheduler;
        Socket socket;
        final long timeout;

        ConnectTimeoutTask(Timer scheduler, long timeout) {
            this.scheduler = scheduler;
            this.timeout = timeout;
        }

        @Override
        public void beforeConnect(Socket socket) {
            this.socket = socket;
            this.scheduler.schedule((TimerTask)this, this.timeout);
        }

        @Override
        public void afterConnect(Socket socket) {
            this.cancel();
        }

        @Override
        public void run() {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class ClientSocketHandler
    implements Runnable {
        private final Socket socket;

        public ClientSocketHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                this.socket.setTcpNoDelay(true);
                DataInputStream in = new DataInputStream(this.socket.getInputStream());
                OutputStream out = this.socket.getOutputStream();
                short version = in.readShort();
                int vmViewId = in.readInt();
                long uuidLSBs = in.readLong();
                long uuidMSBs = in.readLong();
                GMSHealthMonitor.this.stats.incFinalCheckRequestsReceived();
                GMSHealthMonitor.this.stats.incTcpFinalCheckRequestsReceived();
                GMSMember gmbr = (GMSMember)GMSHealthMonitor.this.localAddress.getNetMember();
                UUID myUUID = gmbr.getUUID();
                int myVmViewId = gmbr.getVmViewId();
                if (GMSHealthMonitor.this.playingDead) {
                    logger.debug("HealthMonitor: simulating sick member in health check");
                } else if (uuidLSBs == myUUID.getLeastSignificantBits() && uuidMSBs == myUUID.getMostSignificantBits() && (vmViewId == myVmViewId || myVmViewId < 0)) {
                    logger.debug("HealthMonitor: sending OK reply");
                    out.write(123);
                    out.flush();
                    this.socket.shutdownOutput();
                    GMSHealthMonitor.this.stats.incFinalCheckResponsesSent();
                    GMSHealthMonitor.this.stats.incTcpFinalCheckResponsesSent();
                    logger.debug("HealthMonitor: server replied OK.");
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("HealthMonitor: sending ERROR reply - my UUID is {},{} received is {},{}.  My viewID is {} received is {}", (Object)Long.toHexString(myUUID.getMostSignificantBits()), (Object)Long.toHexString(myUUID.getLeastSignificantBits()), (Object)Long.toHexString(uuidMSBs), (Object)Long.toHexString(uuidLSBs), (Object)myVmViewId, (Object)vmViewId);
                    }
                    out.write(0);
                    out.flush();
                    this.socket.shutdownOutput();
                    GMSHealthMonitor.this.stats.incFinalCheckResponsesSent();
                    GMSHealthMonitor.this.stats.incTcpFinalCheckResponsesSent();
                    logger.debug("HealthMonitor: server replied ERROR.");
                }
            }
            catch (IOException in) {
            }
            catch (RuntimeException e) {
                logger.debug("Unexpected runtime exception", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                logger.debug("Unexpected error", (Throwable)e);
                throw e;
            }
            finally {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class Response {
        private DistributionMessage responseMsg;

        private Response() {
        }

        public DistributionMessage getResponseMsg() {
            return this.responseMsg;
        }

        public void setResponseMsg(DistributionMessage responseMsg) {
            this.responseMsg = responseMsg;
        }
    }

    private class Monitor
    implements Runnable {
        final long memberTimeoutInMillis;

        public Monitor(long memberTimeout) {
            this.memberTimeoutInMillis = memberTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (GMSHealthMonitor.this.isStopping) {
                return;
            }
            InternalDistributedMember neighbour = GMSHealthMonitor.this.nextNeighbor;
            long currentTime = System.currentTimeMillis();
            GMSHealthMonitor.this.currentTimeStamp = currentTime;
            if (neighbour != null) {
                TimeStamp nextNeighborTS;
                GMSHealthMonitor gMSHealthMonitor = GMSHealthMonitor.this;
                synchronized (gMSHealthMonitor) {
                    nextNeighborTS = (TimeStamp)GMSHealthMonitor.this.memberTimeStamps.get(neighbour);
                }
                if (nextNeighborTS == null) {
                    TimeStamp customTS = new TimeStamp(currentTime);
                    GMSHealthMonitor.this.memberTimeStamps.put(neighbour, customTS);
                    return;
                }
                long interval = this.memberTimeoutInMillis / (long)LOGICAL_INTERVAL;
                long lastTS = currentTime - nextNeighborTS.getTime();
                if (lastTS + interval >= this.memberTimeoutInMillis) {
                    logger.debug("Checking member {} ", (Object)neighbour);
                    GMSHealthMonitor.this.checkMember(neighbour);
                }
            }
        }
    }

    private static class TimeStamp {
        private volatile long timeStamp;

        TimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getTime() {
            return this.timeStamp;
        }

        public void setTime(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

