/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalRole;
import org.apache.geode.distributed.internal.membership.MemberAttributes;
import org.apache.geode.distributed.internal.membership.MemberFactory;
import org.apache.geode.distributed.internal.membership.NetMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.net.SocketCreator;

public class InternalDistributedMember
implements DistributedMember,
Externalizable,
DataSerializableFixedID,
DistributionAdvisor.ProfileId,
VersionSource<DistributedMember> {
    private static final long serialVersionUID = -2785249969777296507L;
    private final boolean SHOW_NETMEMBER = Boolean.getBoolean("gemfire.show_netmembers");
    protected NetMember netMbr;
    private boolean isPartial;
    private volatile Set<Role> rolesSet = null;
    private final Object rolesLock = new Object();
    private String uniqueTag = null;
    private static final int NPD_ENABLED_BIT = 1;
    private static final int COORD_ENABLED_BIT = 2;
    private static final int PARTIAL_ID_BIT = 4;
    private static final int VERSION_BIT = 8;
    @MutableForTesting
    private static HostnameResolver hostnameResolver = location -> InetAddress.getByName(location.getHostName());
    private String hostName = null;
    private transient Version versionObj = Version.CURRENT;
    @Immutable
    private static final Version[] dsfidVersions = new Version[]{Version.GFE_71, Version.GFE_90};
    private transient String cachedToString;

    public static void setHostnameResolver(HostnameResolver hostnameResolver) {
        InternalDistributedMember.hostnameResolver = hostnameResolver;
    }

    private void defaultToCurrentHost() {
        this.netMbr.setProcessId(OSProcess.getId());
        try {
            this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(SocketCreator.getLocalHost()) : SocketCreator.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ee) {
            throw new InternalGemFireError(ee);
        }
    }

    public InternalDistributedMember() {
    }

    public InternalDistributedMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator, MemberAttributes attr) {
        this.netMbr = MemberFactory.newNetMember(i, p, splitBrainEnabled, canBeCoordinator, Version.CURRENT_ORDINAL, attr);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(i) : i.getHostAddress();
        short version = this.netMbr.getVersionOrdinal();
        try {
            this.versionObj = Version.fromOrdinal(version, false);
        }
        catch (UnsupportedVersionException e) {
            this.versionObj = Version.CURRENT;
        }
    }

    public InternalDistributedMember(NetMember m) {
        this.netMbr = m;
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(m.getInetAddress()) : m.getInetAddress().getHostAddress();
        short version = m.getVersionOrdinal();
        try {
            this.versionObj = Version.fromOrdinal(version, false);
        }
        catch (UnsupportedVersionException e) {
            this.versionObj = Version.CURRENT;
        }
        this.cachedToString = null;
        this.isPartial = true;
    }

    public void setNetMember(NetMember m) {
        this.netMbr = m;
    }

    public InternalDistributedMember(String i, int p) {
        this(i, p, Version.CURRENT);
    }

    public InternalDistributedMember(ServerLocation location) {
        InetAddress addr;
        this.hostName = location.getHostName();
        try {
            addr = hostnameResolver.getInetAddress(location);
        }
        catch (UnknownHostException e) {
            throw new ServerConnectivityException("Unable to resolve server location " + location, e);
        }
        this.netMbr = MemberFactory.newNetMember(addr, location.getPort());
        this.netMbr.setVmKind(10);
        this.versionObj = Version.CURRENT;
        this.netMbr.setVersion(this.versionObj);
    }

    public InternalDistributedMember(String i, int p, Version version) {
        this(i, p, version, MemberFactory.newNetMember(i, p));
    }

    public InternalDistributedMember(String i, int p, Version version, NetMember netMember) {
        this.netMbr = netMember;
        this.defaultToCurrentHost();
        netMember.setVmKind(10);
        this.versionObj = version;
        netMember.setVersion(version);
    }

    public InternalDistributedMember(String host, int p, String n, String u, int vmKind, String[] groups, DurableClientAttributes attr) throws UnknownHostException {
        MemberAttributes mattr = new MemberAttributes(p, OSProcess.getId(), vmKind, -1, n, groups, attr);
        InetAddress addr = SocketCreator.toInetAddress(host);
        this.netMbr = MemberFactory.newNetMember(addr, p, false, true, Version.CURRENT_ORDINAL, mattr);
        this.defaultToCurrentHost();
        this.netMbr.setName(n);
        this.uniqueTag = u;
        this.netMbr.setVmKind(vmKind);
        this.netMbr.setDirectPort(p);
        this.netMbr.setDurableClientAttributes(attr);
        this.hostName = host;
        this.netMbr.setGroups(groups);
    }

    public InternalDistributedMember(InetAddress i, int p) {
        this.netMbr = MemberFactory.newNetMember(i, p);
        this.defaultToCurrentHost();
    }

    public InternalDistributedMember(InetAddress addr, int p, boolean isCurrentHost) {
        this.netMbr = MemberFactory.newNetMember(addr, p);
        if (isCurrentHost) {
            this.defaultToCurrentHost();
        }
    }

    public InetAddress getInetAddress() {
        return this.netMbr.getInetAddress();
    }

    public NetMember getNetMember() {
        return this.netMbr;
    }

    public int getPort() {
        return this.netMbr.getPort();
    }

    public int getDirectChannelPort() {
        assert (!this.isPartial);
        return this.netMbr.getDirectPort();
    }

    public int getVmKind() {
        return this.netMbr.getVmKind();
    }

    public int getVmViewId() {
        return this.netMbr.getVmViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Role> getRoles() {
        Set<Role> tmpRolesSet = this.rolesSet;
        if (tmpRolesSet != null) {
            return tmpRolesSet;
        }
        assert (!this.isPartial);
        Object object = this.rolesLock;
        synchronized (object) {
            tmpRolesSet = this.rolesSet;
            if (tmpRolesSet == null) {
                String[] tmpRoles = this.netMbr.getGroups();
                if (tmpRoles == null || tmpRoles.length == 0) {
                    tmpRolesSet = Collections.emptySet();
                } else {
                    tmpRolesSet = new HashSet<Role>(tmpRoles.length);
                    for (int i = 0; i < tmpRoles.length; ++i) {
                        tmpRolesSet.add(InternalRole.getRole(tmpRoles[i]));
                    }
                    tmpRolesSet = Collections.unmodifiableSet(tmpRolesSet);
                }
                this.rolesSet = tmpRolesSet;
            }
        }
        Assert.assertTrue(tmpRolesSet != null);
        return tmpRolesSet;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(Arrays.asList(this.netMbr.getGroups()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(String[] newGroups) {
        assert (!this.isPartial);
        assert (newGroups != null);
        Object object = this.rolesLock;
        synchronized (object) {
            this.netMbr.setGroups(newGroups);
            this.rolesSet = null;
            this.cachedToString = null;
        }
    }

    public void setVmKind(int p) {
        this.netMbr.setVmKind(p);
        this.cachedToString = null;
    }

    public void setVmViewId(int p) {
        this.netMbr.setVmViewId(p);
        this.cachedToString = null;
    }

    public int getVmPid() {
        return this.netMbr.getProcessId();
    }

    public void setVmPid(int p) {
        this.netMbr.setProcessId(p);
        this.cachedToString = null;
    }

    @Override
    public String getName() {
        String result = this.netMbr.getName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public DurableClientAttributes getDurableClientAttributes() {
        assert (!this.isPartial);
        DurableClientAttributes attributes = this.netMbr.getDurableClientAttributes();
        if (attributes == null) {
            attributes = new DurableClientAttributes("", 300);
            this.netMbr.setDurableClientAttributes(attributes);
        }
        return this.netMbr.getDurableClientAttributes();
    }

    @Override
    public int compareTo(DistributedMember o) {
        return this.compareTo(o, true);
    }

    public int compareTo(DistributedMember o, boolean checkNetMembersIfEqual) {
        return this.compareTo(o, checkNetMembersIfEqual, true);
    }

    public int compareTo(DistributedMember o, boolean checkNetMembersIfEqual, boolean verifyViewId) {
        int i;
        byte[] otherBytes;
        int otherPort;
        if (this == o) {
            return 0;
        }
        if (o == null || !(o instanceof InternalDistributedMember)) {
            throw new ClassCastException("InternalDistributedMember.compareTo(): comparison between different classes");
        }
        InternalDistributedMember other = (InternalDistributedMember)o;
        int myPort = this.getPort();
        if (myPort < (otherPort = other.getPort())) {
            return -1;
        }
        if (myPort > otherPort) {
            return 1;
        }
        InetAddress myAddr = this.getInetAddress();
        InetAddress otherAddr = other.getInetAddress();
        if (myAddr == null && otherAddr == null) {
            return 0;
        }
        if (myAddr == null) {
            return -1;
        }
        if (otherAddr == null) {
            return 1;
        }
        byte[] myBytes = myAddr.getAddress();
        if (myBytes != (otherBytes = otherAddr.getAddress())) {
            for (int i2 = 0; i2 < myBytes.length; ++i2) {
                if (i2 >= otherBytes.length) {
                    return -1;
                }
                if (myBytes[i2] < otherBytes[i2]) {
                    return -1;
                }
                if (myBytes[i2] <= otherBytes[i2]) continue;
                return 1;
            }
            if (myBytes.length > otherBytes.length) {
                return 1;
            }
        }
        String myName = this.getName();
        String otherName = other.getName();
        if (!(other.isPartial || this.isPartial || myName == null && otherName == null)) {
            if (myName == null) {
                return -1;
            }
            if (otherName == null) {
                return 1;
            }
            i = myName.compareTo(otherName);
            if (i != 0) {
                return i;
            }
        }
        if (this.uniqueTag == null && other.uniqueTag == null) {
            if (verifyViewId) {
                int thisViewId = this.getVmViewId();
                int otherViewId = other.getVmViewId();
                if (thisViewId >= 0 && otherViewId >= 0) {
                    if (thisViewId < otherViewId) {
                        return -1;
                    }
                    if (thisViewId > otherViewId) {
                        return 1;
                    }
                }
            }
        } else {
            if (this.uniqueTag == null) {
                return -1;
            }
            if (other.uniqueTag == null) {
                return 1;
            }
            i = this.uniqueTag.compareTo(other.uniqueTag);
            if (i != 0) {
                return i;
            }
        }
        if (checkNetMembersIfEqual && this.netMbr != null && other.netMbr != null) {
            return this.netMbr.compareAdditionalData(other.netMbr);
        }
        return 0;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof InternalDistributedMember)) {
            return false;
        }
        return this.compareTo((InternalDistributedMember)obj) == 0;
    }

    public int hashCode() {
        int result = 0;
        result += this.netMbr.getInetAddress().hashCode();
        return result += this.getPort();
    }

    private String shortName(String hostname) {
        if (hostname == null) {
            return "<null inet_addr hostname>";
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    public String toString() {
        String result = this.cachedToString;
        if (result == null) {
            StringBuilder sb = new StringBuilder();
            this.addFixedToString(sb);
            short version = this.netMbr.getVersionOrdinal();
            if (version != Version.CURRENT.ordinal()) {
                sb.append("(version:").append(Version.toString(version)).append(')');
            }
            if (this.SHOW_NETMEMBER) {
                sb.append("[[").append(this.netMbr).append("]]");
            }
            this.cachedToString = result = sb.toString();
        }
        return result;
    }

    public void addFixedToString(StringBuilder sb) {
        int vmViewId;
        InetAddress add = this.getInetAddress();
        String host = add.isMulticastAddress() ? add.getHostAddress() : (SocketCreator.resolve_dns ? this.shortName(this.hostName) : this.hostName);
        sb.append(host);
        String myName = this.getName();
        int vmPid = this.netMbr.getProcessId();
        byte vmKind = this.netMbr.getVmKind();
        if (vmPid > 0 || vmKind != 10 || !"".equals(myName)) {
            sb.append("(");
            if (!"".equals(myName)) {
                sb.append(myName);
                if (vmPid > 0) {
                    sb.append(':');
                }
            }
            if (vmPid > 0) {
                sb.append(Integer.toString(vmPid));
            }
            String vmStr = "";
            switch (vmKind) {
                case 10: {
                    break;
                }
                case 11: {
                    vmStr = ":locator";
                    break;
                }
                case 12: {
                    vmStr = ":admin";
                    break;
                }
                case 13: {
                    vmStr = ":loner";
                    break;
                }
                default: {
                    vmStr = ":<unknown:" + vmKind + ">";
                }
            }
            sb.append(vmStr);
            sb.append(")");
        }
        if (vmKind != 13 && this.netMbr.preferredForCoordinator()) {
            sb.append("<ec>");
        }
        if ((vmViewId = this.getVmViewId()) >= 0) {
            sb.append("<v" + vmViewId + ">");
        }
        sb.append(":");
        sb.append(this.getPort());
        if (vmKind == 13) {
            String name;
            if (this.uniqueTag != null && this.uniqueTag.length() != 0) {
                sb.append(":").append(this.uniqueTag);
            }
            if ((name = this.getName()).length() != 0) {
                sb.append(":").append(name);
            }
        }
    }

    private short readVersion(int flags, DataInput in) throws IOException {
        if ((flags & 8) != 0) {
            short version = Version.readOrdinal(in);
            this.versionObj = Version.fromOrdinalNoThrow(version, false);
            return version;
        }
        Version v = InternalDataSerializer.getVersionForDataStreamOrNull(in);
        if (v != null) {
            this.versionObj = v;
            return v.ordinal();
        }
        return Version.CURRENT_ORDINAL;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
        byte[] address = this.getInetAddress().getAddress();
        out.writeInt(address.length);
        out.write(address);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.netMbr.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.netMbr.preferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.netMbr.getDirectPort());
        out.writeInt(this.netMbr.getProcessId());
        out.writeInt(this.netMbr.getVmKind());
        out.writeInt(this.netMbr.getVmViewId());
        DataSerializer.writeStringArray(this.netMbr.getGroups(), out);
        DataSerializer.writeString(this.netMbr.getName(), out);
        DataSerializer.writeString(this.uniqueTag, out);
        DurableClientAttributes attributes = this.netMbr.getDurableClientAttributes();
        DataSerializer.writeString(attributes == null ? "" : attributes.getId(), out);
        DataSerializer.writeInteger(attributes == null ? 300 : attributes.getTimeout(), out);
        Version.writeOrdinal(out, this.netMbr.getVersionOrdinal(), true);
        this.netMbr.writeAdditionalData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] addr = new byte[len];
        in.readFully(addr);
        InetAddress inetAddr = InetAddress.getByAddress(addr);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readInt();
        int vmViewId = in.readInt();
        String[] groups = DataSerializer.readStringArray(in);
        String name = DataSerializer.readString(in);
        this.uniqueTag = DataSerializer.readString(in);
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        DurableClientAttributes durableClientAttributes = new DurableClientAttributes(durableId, durableTimeout);
        short version = this.readVersion(flags, in);
        this.netMbr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, version, new MemberAttributes(dcPort, vmPid, vmKind, vmViewId, name, groups, durableClientAttributes));
        if (version >= Version.GFE_90.ordinal()) {
            try {
                this.netMbr.readAdditionalData(in);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
    }

    @Override
    public int getDSFID() {
        return 92;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GFE_9_0_0_0(out);
        if (this.netMbr.getVersionOrdinal() >= Version.GFE_90.ordinal()) {
            this.getNetMember().writeAdditionalData(out);
        }
    }

    public void toDataPre_GFE_9_0_0_0(DataOutput out) throws IOException {
        DataSerializer.writeInetAddress(this.getInetAddress(), out);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.netMbr.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.netMbr.preferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.netMbr.getDirectPort());
        out.writeInt(this.netMbr.getProcessId());
        byte vmKind = this.netMbr.getVmKind();
        out.writeByte(vmKind);
        DataSerializer.writeStringArray(this.netMbr.getGroups(), out);
        DataSerializer.writeString(this.netMbr.getName(), out);
        if (vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.netMbr.getVmViewId()), out);
        }
        DurableClientAttributes durableClientAttributes = this.netMbr.getDurableClientAttributes();
        DataSerializer.writeString(durableClientAttributes == null ? "" : durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(durableClientAttributes == null ? 300 : durableClientAttributes.getTimeout(), out);
        short version = this.netMbr.getVersionOrdinal();
        Version.writeOrdinal(out, version, true);
    }

    public void toDataPre_GFE_7_1_0_0(DataOutput out) throws IOException {
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
        DataSerializer.writeInetAddress(this.getInetAddress(), out);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.netMbr.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.netMbr.preferredForCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)(flags & 0xFF));
        out.writeInt(this.netMbr.getDirectPort());
        out.writeInt(this.netMbr.getProcessId());
        out.writeByte(this.netMbr.getVmKind());
        DataSerializer.writeStringArray(this.netMbr.getGroups(), out);
        DataSerializer.writeString(this.netMbr.getName(), out);
        byte vmKind = this.netMbr.getVmKind();
        if (vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.netMbr.getVmViewId()), out);
        }
        DurableClientAttributes durableClientAttributes = this.netMbr.getDurableClientAttributes();
        DataSerializer.writeString(durableClientAttributes == null ? "" : durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(durableClientAttributes == null ? 300 : durableClientAttributes.getTimeout(), out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GFE_9_0_0_0(in);
        if (this.getNetMember().getVersionOrdinal() >= Version.GFE_90.ordinal()) {
            try {
                this.netMbr.readAdditionalData(in);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    public void fromDataPre_GFE_9_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getCanonicalHostName(inetAddr, this.hostName) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readUnsignedByte();
        String[] groups = DataSerializer.readStringArray(in);
        int vmViewId = -1;
        String name = DataSerializer.readString(in);
        if (vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        DurableClientAttributes durableClientAttributes = durableId.length() > 0 ? new DurableClientAttributes(durableId, durableTimeout) : null;
        short version = this.readVersion(flags, in);
        MemberAttributes attr = new MemberAttributes(dcPort, vmPid, vmKind, vmViewId, name, groups, durableClientAttributes);
        this.netMbr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, version, attr);
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
    }

    public void fromDataPre_GFE_7_1_0_0(DataInput in) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getCanonicalHostName(inetAddr, this.hostName) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        int dcPort = in.readInt();
        int vmPid = in.readInt();
        int vmKind = in.readUnsignedByte();
        String[] groups = DataSerializer.readStringArray(in);
        int vmViewId = -1;
        String name = DataSerializer.readString(in);
        if (vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        DurableClientAttributes durableClientAttributes = durableId.length() > 0 ? new DurableClientAttributes(durableId, durableTimeout) : null;
        short version = this.readVersion(flags, in);
        MemberAttributes attr = new MemberAttributes(dcPort, vmPid, vmKind, vmViewId, name, groups, durableClientAttributes);
        this.netMbr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, version, attr);
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
    }

    public static InternalDistributedMember readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        InternalDistributedMember mbr = new InternalDistributedMember();
        mbr._readEssentialData(in);
        return mbr;
    }

    private void _readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        this.isPartial = true;
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(inetAddr) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        int vmKind = in.readUnsignedByte();
        int vmViewId = -1;
        if (vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                vmViewId = Integer.parseInt(str);
            }
        }
        String name = DataSerializer.readString(in);
        MemberAttributes attr = new MemberAttributes(-1, -1, vmKind, vmViewId, name, null, null);
        this.netMbr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, InternalDataSerializer.getVersionForDataStream(in).ordinal(), attr);
        if (InternalDataSerializer.getVersionForDataStream(in).compareTo(Version.GFE_90) == 0) {
            this.netMbr.readAdditionalData(in);
        }
    }

    @Override
    public void writeEssentialData(DataOutput out) throws IOException {
        Assert.assertTrue(this.netMbr.getVmKind() > 0);
        DataSerializer.writeInetAddress(this.getInetAddress(), out);
        out.writeInt(this.getPort());
        int flags = 0;
        if (this.netMbr.isNetworkPartitionDetectionEnabled()) {
            flags |= 1;
        }
        if (this.netMbr.preferredForCoordinator()) {
            flags |= 2;
        }
        out.writeByte((byte)((flags |= 4) & 0xFF));
        byte vmKind = this.netMbr.getVmKind();
        out.writeByte(vmKind);
        if (vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.netMbr.getVmViewId()), out);
        }
        DataSerializer.writeString(this.netMbr.getName(), out);
        Version outputVersion = InternalDataSerializer.getVersionForDataStream(out);
        if (0 <= outputVersion.compareTo(Version.GFE_90) && outputVersion.compareTo(Version.GEODE_1_1_0) < 0) {
            this.netMbr.writeAdditionalData(out);
        }
    }

    public void setDirectChannelPort(int p) {
        this.netMbr.setDirectPort(p);
    }

    public void setPort(int p) {
        assert (this.netMbr.getVmKind() == 13);
        this.netMbr.setPort(p);
        this.cachedToString = null;
    }

    @Override
    public String getHost() {
        return this.netMbr.getInetAddress().getCanonicalHostName();
    }

    @Override
    public int getProcessId() {
        return this.netMbr.getProcessId();
    }

    @Override
    public String getId() {
        return this.toString();
    }

    @Override
    public String getUniqueId() {
        StringBuilder sb = new StringBuilder();
        this.addFixedToString(sb);
        short version = this.netMbr.getVersionOrdinal();
        if (version != Version.CURRENT.ordinal()) {
            sb.append("(version:").append(Version.toString(version)).append(')');
        }
        if (this.SHOW_NETMEMBER) {
            sb.append("[[").append(this.netMbr.getUniqueId()).append("]]");
        }
        return sb.toString();
    }

    public void setVersionObjectForTest(Version v) {
        this.versionObj = v;
        this.netMbr.setVersion(v);
    }

    public Version getVersionObject() {
        return this.versionObj;
    }

    @Override
    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }

    public static class InternalDistributedMemberWrapper {
        InternalDistributedMember mbr;

        public InternalDistributedMemberWrapper(InternalDistributedMember m) {
            this.mbr = m;
        }

        public InternalDistributedMember getMbr() {
            return this.mbr;
        }

        public int hashCode() {
            return this.mbr.hashCode();
        }

        public boolean equals(Object obj) {
            InternalDistributedMember other = ((InternalDistributedMemberWrapper)obj).mbr;
            return this.mbr.compareTo(other, false, false) == 0;
        }

        public String toString() {
            return "InternalDistributedMemberWrapper [mbr=" + this.mbr + "]";
        }
    }

    @FunctionalInterface
    public static interface HostnameResolver {
        public InetAddress getInetAddress(ServerLocation var1) throws UnknownHostException;
    }
}

