/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.Sizeable;
import org.apache.geode.distributed.internal.ThrottledMemQueueStatHelper;

public class ThrottlingMemLinkedQueueWithDMStats<E>
extends OverflowQueueWithDMStats<E> {
    private static final long serialVersionUID = 5425180246954573433L;
    private final int maxMemSize;
    private final int startThrottleMemSize;
    private final int maxSize;
    private final int startThrottleSize;
    private final AtomicInteger memSize = new AtomicInteger();

    public ThrottlingMemLinkedQueueWithDMStats(int maxMemSize, int startThrottleMemSize, int maxSize, int startThrottleSize, ThrottledMemQueueStatHelper stats) {
        super(maxSize, stats);
        this.maxMemSize = maxMemSize;
        this.startThrottleMemSize = startThrottleMemSize;
        this.maxSize = maxSize;
        this.startThrottleSize = startThrottleSize;
    }

    private int calculateThrottleTime() {
        int sleep;
        int myMemSize = this.memSize.get();
        if (myMemSize > this.startThrottleMemSize) {
            sleep = (int)((float)(myMemSize - this.startThrottleMemSize) / (float)(this.maxMemSize - this.startThrottleMemSize) * 100.0f);
        } else {
            int qSize = this.size();
            if (qSize > this.startThrottleSize) {
                sleep = (int)((float)(qSize - this.startThrottleSize) / (float)(this.maxSize - this.startThrottleSize) * 100.0f);
            } else {
                return 0;
            }
        }
        sleep *= sleep / 10 + 1;
        sleep = Math.max(sleep, 1);
        return sleep;
    }

    @Override
    protected void preAdd(Object o) {
        try {
            this.preAddInterruptibly(o);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void preAddInterruptibly(Object o) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!DistributionMessage.isPreciousThread()) {
            long startTime = DistributionStats.getStatTime();
            do {
                try {
                    int sleep = this.calculateThrottleTime();
                    if (sleep > 0) {
                        Thread.sleep(sleep);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (!DistributionStats.enableClockStats) continue;
                long endTime = DistributionStats.getStatTime();
                ((ThrottledMemQueueStatHelper)this.stats).throttleTime(endTime - startTime);
                startTime = endTime;
            } while (this.memSize.get() >= this.maxMemSize || this.size() >= this.maxSize);
            ((ThrottledMemQueueStatHelper)this.stats).incThrottleCount();
        }
        if (o instanceof Sizeable) {
            int mem = ((Sizeable)o).getSize();
            ((ThrottledMemQueueStatHelper)this.stats).addMem(mem);
            this.memSize.addAndGet(mem);
        }
    }

    @Override
    protected void postRemove(Object o) {
        if (o instanceof Sizeable) {
            int mem = ((Sizeable)o).getSize();
            this.memSize.addAndGet(-mem);
            ((ThrottledMemQueueStatHelper)this.stats).removeMem(mem);
        }
    }

    @Override
    protected void postDrain(Collection c) {
        for (Object aC : c) {
            this.postRemove(aC);
        }
    }
}

