/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.internal.logging.LogWriterLevel;
import org.apache.geode.internal.logging.PureLogWriter;

public class ProductUseLog
implements MembershipListener {
    @MutableForTesting
    protected static long MAX_PRODUCT_USE_FILE_SIZE = Long.getLong("max_view_log_size", 5000000L);
    private final int logLevel;
    private final File productUseLogFile;
    private PureLogWriter logWriter;
    private InternalDistributedSystem system;

    public ProductUseLog(File productUseLogFile) {
        this.productUseLogFile = productUseLogFile.getAbsoluteFile();
        this.logLevel = LogWriterLevel.INFO.intLevel();
        this.createLogWriter();
    }

    public void monitorUse(InternalDistributedSystem system) {
        this.system = system;
        DistributionManager dmgr = system.getDistributionManager();
        dmgr.addMembershipListener(this);
        MembershipManager mmgr = dmgr.getMembershipManager();
        if (mmgr != null) {
            this.log("Log opened with new distributed system connection.  " + system.getDM().getMembershipManager().getView());
        } else {
            this.log("Log opened with new distributed system connection.  Membership view not yet available in this VM.");
        }
    }

    public synchronized void log(String logMessage) {
        if (!this.logWriter.isClosed()) {
            if (this.productUseLogFile.length() + (long)logMessage.length() + 100L > MAX_PRODUCT_USE_FILE_SIZE) {
                this.clearLog();
            }
            this.logWriter.info(logMessage);
        }
    }

    public synchronized void close() {
        if (!this.logWriter.isClosed()) {
            this.logWriter.close();
        }
    }

    public synchronized boolean isClosed() {
        return this.logWriter.isClosed();
    }

    public synchronized void reopen() {
        if (this.logWriter.isClosed()) {
            this.createLogWriter();
        }
    }

    private synchronized void clearLog() {
        this.logWriter.close();
        this.productUseLogFile.delete();
        this.createLogWriter();
    }

    private synchronized void createLogWriter() {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(this.productUseLogFile, true);
        }
        catch (FileNotFoundException ex) {
            String s = String.format("Could not open log file %s.", this.productUseLogFile.getAbsolutePath());
            throw new GemFireIOException(s, ex);
        }
        PrintStream out = new PrintStream(fos);
        this.logWriter = new PureLogWriter(this.logLevel, out);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        this.log("A new member joined: " + id + ".  " + this.system.getDM().getMembershipManager().getView());
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    static {
        if (MAX_PRODUCT_USE_FILE_SIZE < 1000000L) {
            MAX_PRODUCT_USE_FILE_SIZE = 1000000L;
        }
    }
}

