/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.logging.LoggingExecutors;

public class LocatorLoadSnapshot {
    public static final String LOAD_IMBALANCE_THRESHOLD_PROPERTY_NAME = "gemfire.locator-load-imbalance-threshold";
    public static final float DEFAULT_LOAD_IMBALANCE_THRESHOLD = 10.0f;
    private final Map serverGroupMap = new HashMap();
    private final Map connectionLoadMap = new HashMap();
    private final Map queueLoadMap = new HashMap();
    private final ConcurrentMap estimateMap = new ConcurrentHashMap();
    private float loadImbalanceThreshold;
    private boolean rebalancing;
    private final ScheduledExecutorService estimateTimeoutProcessor = LoggingExecutors.newScheduledThreadPool("loadEstimateTimeoutProcessor", 1, false);

    public LocatorLoadSnapshot() {
        this.connectionLoadMap.put(null, new HashMap());
        this.queueLoadMap.put(null, new HashMap());
        String property = System.getProperty(LOAD_IMBALANCE_THRESHOLD_PROPERTY_NAME);
        this.loadImbalanceThreshold = property != null ? Float.parseFloat(property) : 10.0f;
    }

    public void addServer(ServerLocation location, String[] groups, ServerLoad initialLoad) {
        this.addServer(location, groups, initialLoad, 30000L);
    }

    public synchronized void addServer(ServerLocation location, String[] groups, ServerLoad initialLoad, long loadPollInterval) {
        this.serverGroupMap.put(location, groups);
        LoadHolder connectionLoad = new LoadHolder(location, initialLoad.getConnectionLoad(), initialLoad.getLoadPerConnection(), loadPollInterval);
        this.addGroups(this.connectionLoadMap, groups, connectionLoad);
        LoadHolder queueLoad = new LoadHolder(location, initialLoad.getSubscriptionConnectionLoad(), initialLoad.getLoadPerSubscriptionConnection(), loadPollInterval);
        this.addGroups(this.queueLoadMap, groups, queueLoad);
        this.updateLoad(location, initialLoad);
    }

    public synchronized void removeServer(ServerLocation location) {
        String[] groups = (String[])this.serverGroupMap.remove(location);
        if (groups != null) {
            this.removeFromMap(this.connectionLoadMap, groups, location);
            this.removeFromMap(this.queueLoadMap, groups, location);
        }
    }

    public void updateLoad(ServerLocation location, ServerLoad newLoad) {
        this.updateLoad(location, newLoad, null);
    }

    public synchronized void updateLoad(ServerLocation location, ServerLoad newLoad, List clientIds) {
        String[] groups = (String[])this.serverGroupMap.get(location);
        if (groups == null) {
            return;
        }
        if (clientIds != null) {
            Iterator itr = clientIds.iterator();
            while (itr.hasNext()) {
                this.cancelClientEstimate((ClientProxyMembershipID)itr.next(), location);
            }
        }
        this.updateMap(this.connectionLoadMap, location, newLoad.getConnectionLoad(), newLoad.getLoadPerConnection());
        this.updateMap(this.queueLoadMap, location, newLoad.getSubscriptionConnectionLoad(), newLoad.getLoadPerSubscriptionConnection());
    }

    public synchronized boolean hasBalancedConnections(String group) {
        if ("".equals(group)) {
            group = null;
        }
        Map groupServers = (Map)this.connectionLoadMap.get(group);
        return this.isBalanced(groupServers);
    }

    private synchronized boolean isBalanced(Map<ServerLocation, LoadHolder> groupServers) {
        return this.isBalanced(groupServers, false);
    }

    private synchronized boolean isBalanced(Map<ServerLocation, LoadHolder> groupServers, boolean withThresholdCheck) {
        boolean balanced;
        if (groupServers == null || groupServers.isEmpty()) {
            return true;
        }
        float bestLoad = Float.MAX_VALUE;
        float largestLoadPerConnection = Float.MIN_VALUE;
        float worstLoad = Float.MIN_VALUE;
        for (Map.Entry<ServerLocation, LoadHolder> loadHolderEntry : groupServers.entrySet()) {
            LoadHolder nextLoadReference = loadHolderEntry.getValue();
            float nextLoad = nextLoadReference.getLoad();
            float nextLoadPerConnection = nextLoadReference.getLoadPerConnection();
            if (nextLoad < bestLoad) {
                bestLoad = nextLoad;
            }
            if (nextLoad > worstLoad) {
                worstLoad = nextLoad;
            }
            if (!(nextLoadPerConnection > largestLoadPerConnection)) continue;
            largestLoadPerConnection = nextLoadPerConnection;
        }
        boolean bl = balanced = worstLoad - bestLoad <= largestLoadPerConnection;
        if (withThresholdCheck) {
            balanced = this.thresholdCheck(bestLoad, worstLoad, largestLoadPerConnection, balanced);
        }
        return balanced;
    }

    synchronized boolean thresholdCheck(float bestLoad, float worstLoad, float largestLoadPerConnection, boolean balanced) {
        if (this.rebalancing) {
            if (balanced) {
                this.rebalancing = false;
            }
            return balanced;
        }
        if (!balanced) {
            float imbalance = worstLoad - bestLoad;
            if (imbalance >= largestLoadPerConnection * this.loadImbalanceThreshold) {
                this.rebalancing = true;
            } else {
                balanced = true;
            }
        }
        return balanced;
    }

    synchronized boolean isRebalancing() {
        return this.rebalancing;
    }

    public synchronized ServerLocation getServerForConnection(String group, Set excludedServers) {
        Map groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = (Map)this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        List bestLHs = this.findBestServers(groupServers, excludedServers, 1);
        if (bestLHs == null || bestLHs.isEmpty()) {
            return null;
        }
        LoadHolder lh = (LoadHolder)bestLHs.get(0);
        lh.incConnections();
        return lh.getLocation();
    }

    public synchronized Map<String, ServerLocation> getServersForConnection(Collection<String> groups, Set excludedServers) {
        HashMap<String, ServerLocation> loadMap = new HashMap<String, ServerLocation>();
        if (groups == null) {
            groups = this.connectionLoadMap.keySet();
        }
        for (String group : groups) {
            loadMap.put(group, this.getServerForConnection(group, excludedServers));
        }
        return loadMap;
    }

    public synchronized ArrayList getServers(String group) {
        Map groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = (Map)this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        ArrayList servers = new ArrayList();
        servers.addAll(groupServers.keySet());
        return servers;
    }

    public void shutDown() {
        this.estimateTimeoutProcessor.shutdown();
    }

    public synchronized ServerLocation getReplacementServerForConnection(ServerLocation currentServer, String group, Set excludedServers) {
        Map groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = (Map)this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        if (this.isBalanced(groupServers, true)) {
            return currentServer;
        }
        LoadHolder currentServerLH = this.isCurrentServerMostLoaded(currentServer, groupServers);
        if (currentServerLH == null) {
            return currentServer;
        }
        List bestLHs = this.findBestServers(groupServers, excludedServers, 1);
        if (bestLHs == null || bestLHs.isEmpty()) {
            return null;
        }
        LoadHolder bestLH = (LoadHolder)bestLHs.get(0);
        currentServerLH.decConnections();
        bestLH.incConnections();
        return bestLH.getLocation();
    }

    public List getServersForQueue(String group, Set excludedServers, int count) {
        return this.getServersForQueue(null, group, excludedServers, count);
    }

    public synchronized List getServersForQueue(ClientProxyMembershipID id, String group, Set excludedServers, int count) {
        Map groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = (Map)this.queueLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List bestLHs = this.findBestServers(groupServers, excludedServers, count);
        ArrayList<ServerLocation> result = new ArrayList<ServerLocation>(bestLHs.size());
        if (id != null) {
            ClientProxyMembershipID.Identity actualId = id.getIdentity();
            for (LoadHolder load : bestLHs) {
                EstimateMapKey key = new EstimateMapKey(actualId, load.getLocation());
                LoadEstimateTask task = new LoadEstimateTask(key, load);
                try {
                    long MIN_TIMEOUT = 60000L;
                    long timeout = load.getLoadPollInterval() * 2L;
                    if (timeout < 60000L) {
                        timeout = 60000L;
                    }
                    task.setFuture(this.estimateTimeoutProcessor.schedule(task, timeout, TimeUnit.MILLISECONDS));
                    this.addEstimate(key, task);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                result.add(load.getLocation());
            }
        } else {
            for (LoadHolder load : bestLHs) {
                load.incConnections();
                result.add(load.getLocation());
            }
        }
        return result;
    }

    public synchronized Map<ServerLocation, ServerLoad> getLoadMap() {
        Map connectionMap = (Map)this.connectionLoadMap.get(null);
        Map queueMap = (Map)this.queueLoadMap.get(null);
        HashMap<ServerLocation, ServerLoad> result = new HashMap<ServerLocation, ServerLoad>();
        for (Map.Entry next : connectionMap.entrySet()) {
            ServerLocation location = (ServerLocation)next.getKey();
            LoadHolder connectionLoad = (LoadHolder)next.getValue();
            LoadHolder queueLoad = (LoadHolder)queueMap.get(location);
            if (queueLoad == null) continue;
            result.put(location, new ServerLoad(connectionLoad.getLoad(), connectionLoad.getLoadPerConnection(), queueLoad.getLoad(), queueLoad.getLoadPerConnection()));
        }
        return result;
    }

    private void addGroups(Map map, String[] groups, LoadHolder holder) {
        for (int i = 0; i < groups.length; ++i) {
            HashMap<ServerLocation, LoadHolder> groupMap = (HashMap<ServerLocation, LoadHolder>)map.get(groups[i]);
            if (groupMap == null) {
                groupMap = new HashMap<ServerLocation, LoadHolder>();
                map.put(groups[i], groupMap);
            }
            groupMap.put(holder.getLocation(), holder);
        }
        if (groups.length <= 0 || !groups[0].equals("__recv__group")) {
            HashMap<ServerLocation, LoadHolder> groupMap = (HashMap<ServerLocation, LoadHolder>)map.get(null);
            if (groupMap == null) {
                groupMap = new HashMap<ServerLocation, LoadHolder>();
                map.put(null, groupMap);
            }
            groupMap.put(holder.getLocation(), holder);
        }
    }

    private void removeFromMap(Map map, String[] groups, ServerLocation location) {
        for (int i = 0; i < groups.length; ++i) {
            Map groupMap = (Map)map.get(groups[i]);
            if (groupMap == null) continue;
            groupMap.remove(location);
            if (groupMap.size() != 0) continue;
            map.remove(groupMap);
        }
        Map groupMap = (Map)map.get(null);
        groupMap.remove(location);
    }

    private void updateMap(Map map, ServerLocation location, float load, float loadPerConnection) {
        Map groupMap = (Map)map.get(null);
        LoadHolder holder = (LoadHolder)groupMap.get(location);
        if (holder != null) {
            holder.setLoad(load, loadPerConnection);
        }
    }

    private List findBestServers(Map<ServerLocation, LoadHolder> groupServers, Set excludedServers, int count) {
        TreeSet<LoadHolder> bestEntries = new TreeSet<LoadHolder>(new Comparator(){

            public int compare(Object o1, Object o2) {
                LoadHolder l1 = (LoadHolder)o1;
                LoadHolder l2 = (LoadHolder)o2;
                int difference = Float.compare(l1.getLoad(), l2.getLoad());
                if (difference != 0) {
                    return difference;
                }
                ServerLocation sl1 = l1.getLocation();
                ServerLocation sl2 = l2.getLocation();
                return sl1.compareTo(sl2);
            }
        });
        boolean retainAll = count < 0;
        float lastBestLoad = Float.MAX_VALUE;
        for (Map.Entry<ServerLocation, LoadHolder> loadEntry : groupServers.entrySet()) {
            ServerLocation location = loadEntry.getKey();
            if (excludedServers.contains(location)) continue;
            LoadHolder nextLoadReference = loadEntry.getValue();
            float nextLoad = nextLoadReference.getLoad();
            if (bestEntries.size() >= count && !retainAll && !(nextLoad < lastBestLoad)) continue;
            bestEntries.add(nextLoadReference);
            if (!retainAll && bestEntries.size() > count) {
                bestEntries.remove(bestEntries.last());
            }
            LoadHolder lastBestHolder = (LoadHolder)bestEntries.last();
            lastBestLoad = lastBestHolder.getLoad();
        }
        return new ArrayList(bestEntries);
    }

    private LoadHolder isCurrentServerMostLoaded(ServerLocation currentServer, Map<ServerLocation, LoadHolder> groupServers) {
        LoadHolder currentLH = groupServers.get(currentServer);
        if (currentLH == null) {
            return null;
        }
        float currentLoad = currentLH.getLoad();
        for (Map.Entry<ServerLocation, LoadHolder> loadEntry : groupServers.entrySet()) {
            LoadHolder nextLoadReference;
            float nextLoad;
            ServerLocation location = loadEntry.getKey();
            if (location.equals(currentServer) || !((nextLoad = (nextLoadReference = loadEntry.getValue()).getLoad()) > currentLoad)) continue;
            return null;
        }
        return currentLH;
    }

    private void cancelClientEstimate(ClientProxyMembershipID id, ServerLocation location) {
        if (id != null) {
            this.removeAndCancelEstimate(new EstimateMapKey(id.getIdentity(), location));
        }
    }

    private void addEstimate(EstimateMapKey key, LoadEstimateTask task) {
        LoadEstimateTask oldTask = null;
        oldTask = this.estimateMap.put(key, task);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    protected boolean removeIfPresentEstimate(EstimateMapKey key, LoadEstimateTask task) {
        return this.estimateMap.remove(key, task);
    }

    private void removeAndCancelEstimate(EstimateMapKey key) {
        LoadEstimateTask oldTask = null;
        oldTask = (LoadEstimateTask)this.estimateMap.remove(key);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    private static class LoadHolder {
        private float load;
        private float loadPerConnection;
        private int estimateCount;
        private final ServerLocation location;
        private final long loadPollInterval;

        public LoadHolder(ServerLocation location, float load, float loadPerConnection, long loadPollInterval) {
            this.location = location;
            this.load = load;
            this.loadPerConnection = loadPerConnection;
            this.loadPollInterval = loadPollInterval;
        }

        public void setLoad(float load, float loadPerConnection) {
            this.loadPerConnection = loadPerConnection;
            this.load = load + (float)this.estimateCount * loadPerConnection;
        }

        public void incConnections() {
            this.load += this.loadPerConnection;
        }

        public void addEstimate() {
            ++this.estimateCount;
            this.incConnections();
        }

        public void removeEstimate() {
            --this.estimateCount;
            this.decConnections();
        }

        public void decConnections() {
            this.load -= this.loadPerConnection;
        }

        public float getLoad() {
            return this.load;
        }

        public float getLoadPerConnection() {
            return this.loadPerConnection;
        }

        public ServerLocation getLocation() {
            return this.location;
        }

        public long getLoadPollInterval() {
            return this.loadPollInterval;
        }

        public String toString() {
            return "LoadHolder[" + this.getLoad() + ", " + this.getLocation() + ", loadPollInterval=" + this.getLoadPollInterval() + (this.estimateCount != 0 ? ", estimates=" + this.estimateCount : "") + ", " + this.loadPerConnection + "]";
        }
    }

    private class LoadEstimateTask
    implements Runnable {
        private final EstimateMapKey key;
        private final LoadHolder lh;
        private ScheduledFuture future;

        public LoadEstimateTask(EstimateMapKey key, LoadHolder lh) {
            this.key = key;
            this.lh = lh;
            lh.addEstimate();
        }

        @Override
        public void run() {
            if (LocatorLoadSnapshot.this.removeIfPresentEstimate(this.key, this)) {
                this.decEstimate();
            }
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public void cancel() {
            this.future.cancel(false);
            this.decEstimate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decEstimate() {
            LocatorLoadSnapshot locatorLoadSnapshot = LocatorLoadSnapshot.this;
            synchronized (locatorLoadSnapshot) {
                this.lh.removeEstimate();
            }
        }
    }

    private static class EstimateMapKey {
        private final ClientProxyMembershipID.Identity clientId;
        private final ServerLocation serverId;

        public EstimateMapKey(ClientProxyMembershipID.Identity clientId, ServerLocation serverId) {
            this.clientId = clientId;
            this.serverId = serverId;
        }

        public int hashCode() {
            return this.clientId.hashCode() ^ this.serverId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof EstimateMapKey)) {
                return false;
            }
            EstimateMapKey that = (EstimateMapKey)obj;
            return this.clientId.equals(that.clientId) && this.serverId.equals(that.serverId);
        }
    }
}

