/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.LogWriter;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ConnectionConfig;
import org.apache.geode.distributed.internal.ConnectionConfigImpl;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DSClock;
import org.apache.geode.distributed.internal.DistributedSystemService;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.RuntimeDistributionConfigImpl;
import org.apache.geode.distributed.internal.SecurityConfig;
import org.apache.geode.distributed.internal.locks.GrantorRequestProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.QuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.messenger.MembershipInformation;
import org.apache.geode.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.alerting.AlertLevel;
import org.apache.geode.internal.alerting.AlertMessaging;
import org.apache.geode.internal.alerting.AlertingService;
import org.apache.geode.internal.alerting.AlertingSession;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheBuilder;
import org.apache.geode.internal.cache.execute.FunctionServiceStats;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionService;
import org.apache.geode.internal.cache.tier.sockets.EncryptorImpl;
import org.apache.geode.internal.cache.xmlcache.CacheServerCreation;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogConfigListener;
import org.apache.geode.internal.logging.LogConfigSupplier;
import org.apache.geode.internal.logging.LogFile;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.LoggingSession;
import org.apache.geode.internal.logging.LoggingThread;
import org.apache.geode.internal.logging.NullLoggingSession;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.OffHeapStorage;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.SecurityServiceFactory;
import org.apache.geode.internal.statistics.DummyStatisticsRegistry;
import org.apache.geode.internal.statistics.GemFireStatSampler;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsManagerFactory;
import org.apache.geode.internal.statistics.StatisticsRegistry;
import org.apache.geode.internal.statistics.platform.LinuxProcFsStatistics;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.JavaWorkarounds;
import org.apache.geode.management.ManagementException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.PostProcessor;
import org.apache.geode.security.SecurityManager;
import org.apache.logging.log4j.Logger;

public class InternalDistributedSystem
extends DistributedSystem
implements LogConfigSupplier {
    private static final boolean ALLOW_MEMORY_LOCK_WHEN_OVERCOMMITTED = Boolean.getBoolean("gemfire.Cache.ALLOW_MEMORY_OVERCOMMIT");
    private static final Logger logger = LogService.getLogger();
    private static final String DISABLE_MANAGEMENT_PROPERTY = "gemfire.disableManagement";
    public static final String ALLOW_MULTIPLE_SYSTEMS_PROPERTY = "gemfire.ALLOW_MULTIPLE_SYSTEMS";
    @MutableForTesting
    public static boolean ALLOW_MULTIPLE_SYSTEMS = Boolean.getBoolean("gemfire.ALLOW_MULTIPLE_SYSTEMS");
    @MakeNotStatic
    public static volatile DistributedSystem systemAttemptingReconnect;
    @Immutable
    public static final CreationStackGenerator DEFAULT_CREATION_STACK_GENERATOR;
    @MutableForTesting
    public static final AtomicReference<CreationStackGenerator> TEST_CREATION_STACK_GENERATOR;
    private final ThreadLocal<Boolean> isDisconnectThread = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final StatisticsManager statisticsManager;
    protected DistributionManager dm;
    private final GrantorRequestProcessor.GrantorRequestContext grc;
    private Map<Class, DistributedSystemService> services = new HashMap<Class, DistributedSystemService>();
    private long id;
    protected InternalLogWriter logWriter = null;
    protected InternalLogWriter securityLogWriter = null;
    private DSClock clock;
    private final long startTime;
    private final Object isConnectedMutex = new Object();
    protected volatile boolean isConnected;
    private boolean isLoner = false;
    private GemFireStatSampler sampler = null;
    private final Set<DisconnectListener> disconnectListeners = new LinkedHashSet<DisconnectListener>();
    @MakeNotStatic
    private static final Set<ConnectListener> connectListeners;
    @MakeNotStatic
    private static final List<ReconnectListener> reconnectListeners;
    private boolean isReconnectingDS;
    private QuorumChecker quorumChecker;
    public static final String SHUTDOWN_HOOK_NAME = "Distributed system shutdown hook";
    public static final String DISABLE_SHUTDOWN_HOOK_PROPERTY = "gemfire.disableShutdownHook";
    public static final String APPEND_TO_LOG_FILE = "gemfire.append-log";
    private final DistributionConfig originalConfig;
    private final boolean statsDisabled = Boolean.getBoolean("gemfire.statsDisabled");
    private DistributionConfig config;
    private volatile boolean shareSockets;
    private InternalLocator startedLocator;
    private List<ResourceEventsListener> resourceListeners;
    private final boolean disableManagement = Boolean.getBoolean("gemfire.disableManagement");
    private final Throwable creationStack;
    private volatile SecurityService securityService;
    private boolean deltaEnabledOnServer = true;
    private final AlertingSession alertingSession;
    private final AlertingService alertingService;
    private final LoggingSession loggingSession;
    private final Set<LogConfigListener> logConfigListeners = new HashSet<LogConfigListener>();
    private MemoryAllocator offHeapStore = null;
    private final Stopper stopper = new Stopper();
    protected volatile boolean isDisconnecting = false;
    private static final long MAX_DISCONNECT_WAIT;
    @MakeNotStatic
    private static volatile boolean emergencyClassesLoaded;
    private final ConcurrentHashMap<String, FunctionStats> functionExecutionStatsMap = new ConcurrentHashMap();
    private FunctionServiceStats functionServiceStats = null;
    @Immutable
    public static final Thread shutdownHook;
    @MakeNotStatic
    private static volatile int reconnectAttemptCounter;
    private volatile boolean attemptingToReconnect = false;
    private volatile boolean reconnected = false;
    private Exception reconnectException;
    private volatile boolean forcedDisconnect = false;
    private volatile InternalDistributedSystem reconnectDS;
    private boolean locatorDMTypeForced;
    private volatile boolean reconnectCancelled = false;
    private final Object reconnectLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalDistributedSystem connectInternal(Properties config, SecurityConfig securityConfig) {
        if (config == null) {
            config = new Properties();
        }
        if (ALLOW_MULTIPLE_SYSTEMS) {
            return InternalDistributedSystem.newInstance(config);
        }
        Object object = existingSystemsLock;
        synchronized (object) {
            if (ClusterDistributionManager.isDedicatedAdminVM()) {
                InternalDistributedSystem existingSystem = (InternalDistributedSystem)InternalDistributedSystem.getConnection(config);
                if (existingSystem != null) {
                    return existingSystem;
                }
            } else {
                boolean existingSystemDisconnecting = true;
                boolean isReconnecting = false;
                while (!existingSystems.isEmpty() && existingSystemDisconnecting && !isReconnecting) {
                    Assert.assertTrue(existingSystems.size() == 1);
                    InternalDistributedSystem existingSystem = (InternalDistributedSystem)existingSystems.get(0);
                    existingSystemDisconnecting = existingSystem.isDisconnecting();
                    isReconnecting = existingSystem.isReconnectingDS();
                    if (existingSystemDisconnecting) {
                        boolean interrupted = Thread.interrupted();
                        try {
                            existingSystemsLock.wait(50L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                            continue;
                        }
                        finally {
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                    }
                    if (existingSystem.isConnected()) {
                        existingSystem.validateSameProperties(config, existingSystem.isConnected());
                        return existingSystem;
                    }
                    throw new AssertionError((Object)"system should not have both disconnecting==false and isConnected==false");
                }
            }
            InternalDistributedSystem newSystem = InternalDistributedSystem.newInstance(config, securityConfig);
            InternalDistributedSystem.addSystem(newSystem);
            return newSystem;
        }
    }

    public GrantorRequestProcessor.GrantorRequestContext getGrantorRequestContext() {
        return this.grc;
    }

    public boolean isDeltaEnabledOnServer() {
        return this.deltaEnabledOnServer;
    }

    public void setDeltaEnabledOnServer(boolean deltaEnabledOnServer) {
        this.deltaEnabledOnServer = deltaEnabledOnServer;
    }

    public static InternalDistributedSystem newInstance(Properties config) {
        return InternalDistributedSystem.newInstance(config, null);
    }

    public static InternalDistributedSystem newInstance(Properties config, SecurityConfig securityConfig) {
        if (securityConfig == null) {
            return InternalDistributedSystem.newInstance(config, null, null);
        }
        return InternalDistributedSystem.newInstance(config, securityConfig.getSecurityManager(), securityConfig.getPostProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalDistributedSystem newInstance(Properties config, SecurityManager securityManager, PostProcessor postProcessor) {
        boolean success = false;
        InternalDataSerializer.checkSerializationVersion();
        try {
            SystemFailure.startThreads();
            InternalDistributedSystem newSystem = new InternalDistributedSystem(config);
            newSystem.initialize(securityManager, postProcessor);
            reconnectAttemptCounter = 0;
            InternalDistributedSystem.notifyConnectListeners(newSystem);
            success = true;
            InternalDistributedSystem internalDistributedSystem = newSystem;
            return internalDistributedSystem;
        }
        finally {
            if (!success) {
                SystemFailure.stopThreads();
            }
        }
    }

    public static InternalDistributedSystem newInstanceForTesting(DistributionManager distributionManager, Properties properties) {
        StatisticsManagerFactory statisticsManagerFactory = InternalDistributedSystem.defaultStatisticsManagerFactory();
        return InternalDistributedSystem.newInstanceForTesting(distributionManager, properties, statisticsManagerFactory);
    }

    static InternalDistributedSystem newInstanceForTesting(DistributionManager distributionManager, Properties properties, StatisticsManagerFactory statisticsManagerFactory) {
        ConnectionConfigImpl connectionConfig = new ConnectionConfigImpl(properties);
        InternalDistributedSystem internalDistributedSystem = new InternalDistributedSystem(connectionConfig, statisticsManagerFactory);
        internalDistributedSystem.config = new RuntimeDistributionConfigImpl(internalDistributedSystem);
        internalDistributedSystem.dm = distributionManager;
        internalDistributedSystem.isConnected = true;
        return internalDistributedSystem;
    }

    public static boolean removeSystem(InternalDistributedSystem oldSystem) {
        return DistributedSystem.removeSystem(oldSystem);
    }

    public static DistributedSystem connectForAdmin(Properties props) {
        return DistributedSystem.connectForAdmin(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalDistributedSystem getConnectedInstance() {
        InternalDistributedSystem result = null;
        Object object = existingSystemsLock;
        synchronized (object) {
            InternalDistributedSystem existingSystem;
            if (!existingSystems.isEmpty() && (existingSystem = (InternalDistributedSystem)existingSystems.get(0)).isConnected()) {
                result = existingSystem;
            }
        }
        return result;
    }

    public static InternalDistributedSystem unsafeGetConnectedInstance() {
        InternalDistributedSystem result = InternalDistributedSystem.getAnyInstance();
        if (result != null && !result.isConnected()) {
            result = null;
        }
        return result;
    }

    public static DMStats getDMStats() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.dm != null) {
            return sys.dm.getStats();
        }
        return null;
    }

    public static LogWriter getLogger() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && sys.logWriter != null) {
            return sys.logWriter;
        }
        return null;
    }

    public static InternalLogWriter getStaticInternalLogWriter() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null) {
            return sys.logWriter;
        }
        return null;
    }

    public InternalLogWriter getInternalLogWriter() {
        return this.logWriter;
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null) {
            return sys.securityLogWriter;
        }
        return null;
    }

    private static void resetReconnectAttemptCounter() {
        reconnectAttemptCounter = 0;
    }

    private InternalDistributedSystem(Properties configurationProperties) {
        this(new ConnectionConfigImpl(configurationProperties));
    }

    private InternalDistributedSystem(ConnectionConfig config) {
        this(config, InternalDistributedSystem.defaultStatisticsManagerFactory());
        this.isReconnectingDS = config.isReconnecting();
        this.quorumChecker = config.quorumChecker();
    }

    private InternalDistributedSystem(ConnectionConfig config, StatisticsManagerFactory statisticsManagerFactory) {
        this.alertingSession = AlertingSession.create();
        this.alertingService = new AlertingService();
        this.loggingSession = LoggingSession.create();
        DSFIDFactory.registerTypes();
        this.originalConfig = config.distributionConfig();
        ((DistributionConfigImpl)this.originalConfig).checkForDisallowedDefaults();
        this.shareSockets = this.originalConfig.getConserveSockets();
        this.startTime = System.currentTimeMillis();
        this.grc = new GrantorRequestProcessor.GrantorRequestContext(this.stopper);
        this.creationStack = TEST_CREATION_STACK_GENERATOR.get().generateCreationStack(this.originalConfig);
        this.statisticsManager = statisticsManagerFactory.create(this.originalConfig.getName(), this.startTime, this.statsDisabled);
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void addResourceListener(ResourceEventsListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(ResourceEventsListener listener) {
        this.resourceListeners.remove(listener);
    }

    public List<ResourceEventsListener> getResourceListeners() {
        return this.resourceListeners;
    }

    public void handleResourceEvent(ResourceEvent event, Object resource) {
        if (this.disableManagement) {
            return;
        }
        if (this.resourceListeners.size() == 0) {
            return;
        }
        this.notifyResourceEventListeners(event, resource);
    }

    public boolean isLoner() {
        return this.isLoner;
    }

    public MemoryAllocator getOffHeapStore() {
        return this.offHeapStore;
    }

    private void initializeServices() {
        ServiceLoader<DistributedSystemService> loader = ServiceLoader.load(DistributedSystemService.class);
        for (DistributedSystemService service : loader) {
            service.init(this);
            this.services.put(service.getInterface(), service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initialize(SecurityManager securityManager, PostProcessor postProcessor) {
        if (this.originalConfig.getLocators().equals("")) {
            if (this.originalConfig.getMcastPort() != 0) {
                throw new GemFireConfigException("The locators attribute can not be empty when the mcast-port attribute is non-zero.");
            }
            this.isLoner = true;
        }
        this.config = new RuntimeDistributionConfigImpl(this);
        this.securityService = SecurityServiceFactory.create(this.config.getSecurityProps(), securityManager, postProcessor);
        if (!this.isLoner) {
            this.attemptingToReconnect = InternalDistributedSystem.reconnectAttemptCounter > 0;
        }
        try {
            SocketCreatorFactory.setDistributionConfig(this.config);
            logBanner = this.attemptingToReconnect == false;
            logConfiguration = this.attemptingToReconnect == false;
            this.loggingSession.createSession(this, logBanner, logConfiguration);
            if (this.logWriter == null) {
                this.logWriter = LogWriterFactory.createLogWriterLogger(this.config, false);
                this.logWriter.fine("LogWriter is created.");
            }
            if (this.securityLogWriter == null) {
                this.securityLogWriter = LogWriterFactory.createLogWriterLogger(this.config, true);
                this.securityLogWriter.fine("SecurityLogWriter is created.");
            }
            this.loggingSession.startSession();
            this.clock = new DSClock(this.isLoner);
            if (this.attemptingToReconnect && InternalDistributedSystem.logger.isDebugEnabled()) {
                InternalDistributedSystem.logger.debug("This thread is initializing a new DistributedSystem in order to reconnect to other members");
            }
            if (Boolean.getBoolean("Locator.forceLocatorDMType")) {
                this.locatorDMTypeForced = true;
            }
            this.initializeServices();
            InternalDataSerializer.initialize(this.config, this.services.values());
            try {
                EncryptorImpl.initCertsMap(this.config.getSecurityProps());
                EncryptorImpl.initPrivateKey(this.config.getSecurityProps());
                EncryptorImpl.initDHKeys(this.config);
            }
            catch (Exception ex) {
                throw new GemFireSecurityException("Problem in initializing keys for client authentication", ex);
            }
            offHeapMemorySize = OffHeapStorage.parseOffHeapMemorySize(this.getConfig().getOffHeapMemorySize());
            this.offHeapStore = OffHeapStorage.createOffHeapStorage(this, offHeapMemorySize, this);
            if (this.getConfig().getLockMemory()) {
                avail = LinuxProcFsStatistics.getAvailableMemory(InternalDistributedSystem.logger);
                if (avail < (size = offHeapMemorySize + Runtime.getRuntime().totalMemory())) {
                    if (InternalDistributedSystem.ALLOW_MEMORY_LOCK_WHEN_OVERCOMMITTED) {
                        InternalDistributedSystem.logger.warn("System memory appears to be over committed by {} bytes.  You may experience instability, performance issues, or terminated processes due to the Linux OOM killer.", (Object)(size - avail));
                    } else {
                        throw new IllegalStateException(String.format("Insufficient free memory (%s) when attempting to lock %s bytes.  Either reduce the amount of heap or off-heap memory requested or free up additional system memory.  You may also specify -Dgemfire.Cache.ALLOW_MEMORY_OVERCOMMIT=true on the command-line to override the constraint check.", new Object[]{avail, size}));
                    }
                }
                InternalDistributedSystem.logger.info("Locking memory. This may take a while...");
                GemFireCacheImpl.lockMemory();
                InternalDistributedSystem.logger.info("Finished locking memory.");
            }
            try {
                this.startInitLocator();
            }
            catch (InterruptedException e) {
                throw new SystemConnectException("Startup has been interrupted", e);
            }
            e = this.isConnectedMutex;
            synchronized (e) {
                this.isConnected = true;
            }
            if (!this.isLoner) {
                try {
                    if (this.quorumChecker != null) {
                        this.quorumChecker.suspend();
                    }
                    this.dm = ClusterDistributionManager.create(this);
                    if (!InternalLocator.hasLocator()) ** GOTO lbl75
                    locator = InternalLocator.getLocator();
                    this.getDistributionManager().addHostedLocators(this.getDistributedMember(), InternalLocator.getLocatorStrings(), locator.isSharedConfigurationEnabled());
                }
                finally {
                    if (this.dm == null && this.quorumChecker != null) {
                        this.quorumChecker.resume();
                    }
                    this.setDisconnected();
                }
            } else {
                this.dm = new LonerDistributionManager(this, this.logWriter);
            }
lbl75:
            // 3 sources

            Assert.assertTrue(this.dm != null);
            Assert.assertTrue(this.dm.getSystem() == this);
            try {
                this.id = this.dm.getMembershipPort();
            }
            catch (DistributedSystemDisconnectedException e) {
                throw new SystemConnectException("Distributed system has disconnected during startup.", e);
            }
            e = this.isConnectedMutex;
            synchronized (e) {
                this.isConnected = true;
            }
            if (this.attemptingToReconnect && this.startedLocator == null) {
                try {
                    this.startInitLocator();
                }
                catch (InterruptedException e) {
                    throw new SystemConnectException("Startup has been interrupted", e);
                }
            }
            try {
                this.endInitLocator();
            }
            catch (IOException e) {
                throw new GemFireIOException("Problem finishing a locator service start", e);
            }
            this.startSampler();
            this.alertingSession.createSession(new AlertMessaging(this));
            this.alertingSession.startSession();
            InternalInstantiator.logInstantiators();
        }
        catch (RuntimeException ex) {
            this.config.close();
            throw ex;
        }
        this.resourceListeners = new CopyOnWriteArrayList<ResourceEventsListener>();
        this.reconnected = this.attemptingToReconnect;
        this.attemptingToReconnect = false;
    }

    private void startSampler() {
        if (this.statsDisabled) {
            return;
        }
        this.sampler = this.loggingSession.getLogFile().map(logFile -> new GemFireStatSampler(this, (LogFile)logFile)).orElseGet(() -> new GemFireStatSampler(this));
        this.sampler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInitLocator() throws InterruptedException {
        String locatorString = this.originalConfig.getStartLocator();
        if (locatorString.length() == 0) {
            return;
        }
        if (this.attemptingToReconnect && !this.isConnected && this.quorumChecker != null) {
            logger.info("performing a quorum check to see if location services can be started early");
            if (!this.quorumChecker.checkForQuorum(3L * (long)this.config.getMemberTimeout())) {
                logger.info("quorum check failed - not allowing location services to start early");
                return;
            }
            logger.info("Quorum check passed - allowing location services to start early");
        }
        DistributionLocatorId locId = new DistributionLocatorId(locatorString);
        try {
            this.startedLocator = InternalLocator.createLocator(locId.getPort(), NullLoggingSession.create(), null, this.logWriter, this.securityLogWriter, locId.getHost().getAddress(), locId.getHostnameForClients(), this.originalConfig.toProperties(), false);
            this.startedLocator.getConfig().setEnableClusterConfiguration(false);
            boolean startedPeerLocation = false;
            try {
                this.startedLocator.startPeerLocation();
                startedPeerLocation = true;
            }
            finally {
                if (!startedPeerLocation) {
                    this.startedLocator.stop();
                }
            }
        }
        catch (IOException e) {
            throw new GemFireIOException("Problem starting a locator service", e);
        }
    }

    private void endInitLocator() throws IOException {
        InternalLocator loc = this.startedLocator;
        if (loc != null) {
            boolean finished = false;
            try {
                loc.startServerLocation(this);
                loc.endStartLocator(this);
                finished = true;
            }
            finally {
                if (!finished) {
                    loc.stop();
                }
            }
        }
    }

    void setDM(DistributionManager dm) {
        this.dm = dm;
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new DistributedSystemDisconnectedException("This connection to a distributed system has been disconnected.", this.dm.getRootCause());
        }
    }

    @Override
    public boolean isConnected() {
        if (this.dm == null) {
            return false;
        }
        if (this.dm.getCancelCriterion().isCancelInProgress()) {
            return false;
        }
        if (this.isDisconnecting) {
            return false;
        }
        return this.isConnected;
    }

    public boolean isDisconnected() {
        return !this.isConnected;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.statisticsManager.createIntCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return this.statisticsManager.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return this.statisticsManager.createDoubleCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.statisticsManager.createIntGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return this.statisticsManager.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return this.statisticsManager.createDoubleGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return this.statisticsManager.createDoubleGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.statisticsManager.createType(name, description, stats);
    }

    @Override
    public StatisticsType findType(String name) {
        return this.statisticsManager.findType(name);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return this.statisticsManager.createTypesFromXml(reader);
    }

    @Override
    public Statistics createStatistics(StatisticsType type) {
        return this.statisticsManager.createStatistics(type);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId) {
        return this.statisticsManager.createStatistics(type, textId);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.statisticsManager.createStatistics(type, textId, numericId);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type) {
        return this.statisticsManager.createAtomicStatistics(type);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.statisticsManager.createAtomicStatistics(type, textId);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        return this.statisticsManager.createAtomicStatistics(type, textId, numericId);
    }

    @Override
    public Statistics[] findStatisticsByType(StatisticsType type) {
        return this.statisticsManager.findStatisticsByType(type);
    }

    @Override
    public Statistics[] findStatisticsByTextId(String textId) {
        return this.statisticsManager.findStatisticsByTextId(textId);
    }

    @Override
    public Statistics[] findStatisticsByNumericId(long numericId) {
        return this.statisticsManager.findStatisticsByNumericId(numericId);
    }

    @Override
    public String getName() {
        return this.getOriginalConfig().getName();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public boolean isDisconnecting() {
        if (this.dm == null) {
            return true;
        }
        if (this.dm.getCancelCriterion().isCancelInProgress()) {
            return true;
        }
        if (!this.isConnected) {
            return true;
        }
        return this.isDisconnecting;
    }

    @Override
    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public DSClock getClock() {
        return this.clock;
    }

    @Override
    public LogWriter getSecurityLogWriter() {
        return this.securityLogWriter;
    }

    public GemFireStatSampler getStatSampler() {
        return this.sampler;
    }

    @Override
    public void disconnect() {
        this.disconnect(false, "normal disconnect", false);
    }

    public void disconnect(String reason, Throwable cause, boolean shunned) {
        boolean isForcedDisconnect = this.dm.getRootCause() instanceof ForcedDisconnectException;
        boolean rejoined = false;
        this.reconnected = false;
        if (isForcedDisconnect && !this.isReconnectingDS) {
            this.forcedDisconnect = true;
            InternalDistributedSystem.resetReconnectAttemptCounter();
            rejoined = this.tryReconnect(true, reason, GemFireCacheImpl.getInstance());
        }
        if (!rejoined) {
            this.disconnect(false, reason, shunned);
        }
    }

    private void runDisconnect(final DisconnectListener dc) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        InternalDistributedSystem.this.isDisconnectThread.set(Boolean.TRUE);
                        dc.onDisconnect(InternalDistributedSystem.this);
                    }
                    catch (CancelException e) {
                        if (!logger.isDebugEnabled()) break block2;
                        logger.debug("Disconnect listener <{}> thwarted by cancellation: {}", (Object)dc, (Object)e, (Object)(logger.isTraceEnabled() ? e : null));
                    }
                }
            }
        };
        LoggingThread t = new LoggingThread(dc.toString(), false, r);
        try {
            t.start();
            t.join(MAX_DISCONNECT_WAIT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while processing disconnect listener", (Throwable)e);
        }
        if (t.isAlive()) {
            logger.warn("Disconnect listener still running: {}", (Object)dc);
            t.interrupt();
            try {
                t.join(MAX_DISCONNECT_WAIT);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (t.isAlive()) {
                logger.warn("Disconnect listener ignored its interrupt: {}", (Object)dc);
            }
        }
    }

    public boolean isDisconnectThread() {
        return this.isDisconnectThread.get();
    }

    public void setIsDisconnectThread() {
        this.isDisconnectThread.set(Boolean.TRUE);
    }

    private void runDisconnectForReconnect(DisconnectListener dc) {
        block2: {
            try {
                dc.onDisconnect(this);
            }
            catch (DistributedSystemDisconnectedException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Disconnect listener <{}> thwarted by shutdown: {}", (Object)dc, (Object)e, (Object)(logger.isTraceEnabled() ? e : null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<ShutdownListener> doDisconnects(boolean doReconnect) {
        HashSet<ShutdownListener> shutdownListeners = new HashSet<ShutdownListener>();
        while (true) {
            DisconnectListener listener;
            Set<DisconnectListener> set = this.disconnectListeners;
            synchronized (set) {
                Iterator<DisconnectListener> itr = this.disconnectListeners.iterator();
                if (!itr.hasNext()) {
                    return shutdownListeners;
                }
                listener = itr.next();
                if (listener instanceof ShutdownListener) {
                    shutdownListeners.add((ShutdownListener)listener);
                }
                itr.remove();
            }
            if (doReconnect) {
                this.runDisconnectForReconnect(listener);
                continue;
            }
            this.runDisconnect(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doShutdownListeners(HashSet<ShutdownListener> shutdownListeners) {
        if (shutdownListeners == null) {
            return;
        }
        for (ShutdownListener shutdownListener : shutdownListeners) {
            try {
                shutdownListener.onShutdown(this);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.fatal(String.format("ShutdownListener < %s > threw...", shutdownListener), t);
            }
        }
        while (true) {
            DisconnectListener dcListener = null;
            ShutdownListener sdListener = null;
            Set<DisconnectListener> t = this.disconnectListeners;
            synchronized (t) {
                Iterator<DisconnectListener> itr = this.disconnectListeners.iterator();
                if (!itr.hasNext()) {
                    return;
                }
                dcListener = itr.next();
                itr.remove();
                if (dcListener instanceof ShutdownListener) {
                    sdListener = (ShutdownListener)dcListener;
                }
            }
            this.runDisconnect(dcListener);
            if (sdListener == null) continue;
            try {
                sdListener.onShutdown(this);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t2) {
                SystemFailure.checkFailure();
                logger.fatal("DisconnectListener/Shutdown threw...", t2);
                continue;
            }
            break;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        GMSMembershipManager.loadEmergencyClasses();
    }

    public void emergencyClose() {
        MembershipManager mm;
        boolean DEBUG = false;
        if (this.dm != null && (mm = this.dm.getMembershipManager()) != null) {
            mm.emergencyClose();
        }
        this.isConnected = false;
        if (this.dm != null) {
            this.dm.setRootCause(SystemFailure.getFailure());
        }
        this.isDisconnecting = true;
        this.disconnectListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisconnected() {
        Object object = this.isConnectedMutex;
        synchronized (object) {
            this.isConnected = false;
            this.isConnectedMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitDisconnected() {
        Object object = this.isConnectedMutex;
        synchronized (object) {
            while (this.isConnected) {
                boolean interrupted = Thread.interrupted();
                try {
                    this.isConnectedMutex.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.getLogWriter().warning("Disconnect wait interrupted", e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void disconnect(boolean preparingForReconnect, String reason, boolean keepAlive) {
        boolean isShutdownHook;
        boolean bl = isShutdownHook = shutdownHook != null && Thread.currentThread() == shutdownHook;
        if (!preparingForReconnect) {
            List<ReconnectListener> list = reconnectListeners;
            synchronized (list) {
                reconnectListeners.clear();
            }
            this.cancelReconnect();
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            HashSet<ShutdownListener> shutdownListeners = null;
            if (isDebugEnabled) {
                logger.debug("DistributedSystem.disconnect invoked on {}", (Object)this);
            }
            Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
            synchronized (GemFireCacheImpl.class) {
                InternalCache currentCache = this.getCache();
                if (currentCache != null && !currentCache.isClosed()) {
                    this.isDisconnectThread.set(Boolean.TRUE);
                    try {
                        currentCache.close(reason, this.dm.getRootCause(), keepAlive, true);
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        SystemFailure.checkFailure();
                        logger.warn("Exception trying to close cache", e);
                    }
                    finally {
                        this.isDisconnectThread.set(Boolean.FALSE);
                    }
                }
                InternalDistributedSystem internalDistributedSystem = this;
                synchronized (internalDistributedSystem) {
                    if (this.isDisconnecting) {
                        this.waitDisconnected();
                        // MONITOREXIT @DISABLED, blocks:[1, 2, 24, 25, 60] lbl36 : MonitorExitStatement: MONITOREXIT : var9_12
                        // ** MonitorExit[var7_8] (shouldn't be in output)
                        try {
                            this.dm.close();
                            if (this.startedLocator == null) return;
                            this.startedLocator.stop(this.forcedDisconnect, preparingForReconnect, true);
                            this.startedLocator = null;
                            return;
                        }
                        finally {
                            if (!preparingForReconnect) {
                                SystemTimer.cancelSwarm(this);
                            }
                        }
                    }
                    this.isDisconnecting = true;
                    if (!preparingForReconnect && this.reconnectDS != null) {
                        if (isDebugEnabled) {
                            logger.debug("disconnecting reconnected DS: {}", (Object)this.reconnectDS);
                        }
                        InternalDistributedSystem r = this.reconnectDS;
                        this.reconnectDS = null;
                        r.disconnect(false, null, false);
                    }
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
                if (!isShutdownHook) {
                    shutdownListeners = this.doDisconnects(this.attemptingToReconnect);
                }
                if (!this.attemptingToReconnect) {
                    this.alertingSession.stopSession();
                }
            }
            {
                if (!isShutdownHook) {
                    this.doShutdownListeners(shutdownListeners);
                }
                if (this.functionServiceStats != null) {
                    this.functionServiceStats.close();
                }
                for (FunctionStats functionstats : this.functionExecutionStatsMap.values()) {
                    functionstats.close();
                }
                InternalFunctionService.unregisterAllFunctions();
                if (this.sampler != null) {
                    this.sampler.stop();
                    this.sampler = null;
                }
                if (!this.attemptingToReconnect) {
                    this.loggingSession.stopSession();
                }
                EventID.unsetDS();
                return;
            }
        }
        finally {
            try {
                if (this.getOffHeapStore() != null) {
                    this.getOffHeapStore().close();
                }
            }
            finally {
                try {
                    InternalDistributedSystem.removeSystem(this);
                    if (!this.attemptingToReconnect) {
                        this.loggingSession.shutdown();
                    }
                    this.alertingSession.shutdown();
                    this.config.close();
                }
                finally {
                    this.setDisconnected();
                    SystemFailure.stopThreads();
                }
            }
        }
    }

    public DistributionManager getDistributionManager() {
        this.checkConnected();
        return this.dm;
    }

    public DistributionManager getDM() {
        return this.dm;
    }

    public QuorumChecker getQuorumChecker() {
        return this.quorumChecker;
    }

    public boolean isReconnectCancelled() {
        return this.reconnectCancelled;
    }

    public boolean sameAs(Properties props, boolean isConnected) {
        return this.originalConfig.sameAs(DistributionConfigImpl.produce(props, isConnected));
    }

    public boolean threadOwnsResources() {
        Boolean b = ConnectionTable.getThreadOwnsResourcesRegistration();
        if (b == null) {
            return !this.shareSockets;
        }
        return b;
    }

    public boolean sameSystemAs(Properties props) {
        String otherLocators;
        DistributionConfigImpl other = DistributionConfigImpl.produce(props);
        DistributionConfig me = this.getConfig();
        if (!me.getBindAddress().equals(other.getBindAddress())) {
            return false;
        }
        String myLocators = me.getLocators();
        if (myLocators.equals(otherLocators = other.getLocators())) {
            return true;
        }
        myLocators = InternalDistributedSystem.canonicalizeLocators(myLocators);
        otherLocators = InternalDistributedSystem.canonicalizeLocators(otherLocators);
        return myLocators.equals(otherLocators);
    }

    private static String canonicalizeLocators(String locators) {
        TreeSet<String> sorted = new TreeSet<String>();
        StringTokenizer st = new StringTokenizer(locators, ",");
        while (st.hasMoreTokens()) {
            String l = st.nextToken();
            StringBuilder canonical = new StringBuilder();
            DistributionLocatorId locId = new DistributionLocatorId(l);
            String addr = locId.getBindAddress();
            if (addr != null && addr.trim().length() > 0) {
                canonical.append(addr);
            } else {
                canonical.append(locId.getHostName());
            }
            canonical.append("[");
            canonical.append(String.valueOf(locId.getPort()));
            canonical.append("]");
            sorted.add(canonical.toString());
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    public AlertingService getAlertingService() {
        return this.alertingService;
    }

    @Override
    public LogConfig getLogConfig() {
        return this.config;
    }

    @Override
    public StatisticsConfig getStatisticsConfig() {
        return this.config;
    }

    @Override
    public void addLogConfigListener(LogConfigListener logConfigListener) {
        this.logConfigListeners.add(logConfigListener);
    }

    @Override
    public void removeLogConfigListener(LogConfigListener logConfigListener) {
        this.logConfigListeners.remove(logConfigListener);
    }

    public Optional<LogFile> getLogFile() {
        return this.loggingSession.getLogFile();
    }

    void logConfigChanged() {
        for (LogConfigListener listener : this.logConfigListeners) {
            listener.configChanged();
        }
    }

    @Override
    public String getMemberId() {
        return String.valueOf(this.dm.getId());
    }

    @Override
    public InternalDistributedMember getDistributedMember() {
        return this.dm.getId();
    }

    @Override
    public Set<DistributedMember> getAllOtherMembers() {
        return this.dm.getAllOtherMembers();
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        return this.dm.getGroupMembers(group);
    }

    @Override
    public Set<DistributedMember> findDistributedMembers(InetAddress address) {
        Set<InternalDistributedMember> allMembers = this.dm.getDistributionManagerIdsIncludingAdmin();
        HashSet<DistributedMember> results = new HashSet<DistributedMember>(2);
        for (InternalDistributedMember member : allMembers) {
            Set<InetAddress> equivalentAddresses = this.dm.getEquivalents(member.getInetAddress());
            if (!address.equals(member.getInetAddress()) && !equivalentAddresses.contains(address)) continue;
            results.add(member);
        }
        return results;
    }

    @Override
    public DistributedMember findDistributedMember(String name) {
        for (DistributedMember distributedMember : this.dm.getDistributionManagerIdsIncludingAdmin()) {
            if (!distributedMember.getName().equals(name)) continue;
            return distributedMember;
        }
        return null;
    }

    public DistributionConfig getOriginalConfig() {
        return this.originalConfig;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Connected ");
        String name = this.getName();
        if (name != null && !name.equals("")) {
            sb.append("\"");
            sb.append(name);
            sb.append("\" ");
        }
        sb.append("(id=");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(") ");
        sb.append("to distributed system using ");
        int port = this.config.getMcastPort();
        if (port != 0) {
            sb.append("multicast port ");
            sb.append(port);
            sb.append(" ");
        } else {
            sb.append("locators \"");
            sb.append(this.config.getLocators());
            sb.append("\" ");
        }
        File logFile = this.config.getLogFile();
        sb.append("logging to ");
        if (logFile == null || logFile.equals(new File(""))) {
            sb.append("standard out ");
        } else {
            sb.append(logFile);
            sb.append(" ");
        }
        sb.append(" started at ");
        sb.append(new Date(this.startTime).toString());
        if (!this.isConnected()) {
            sb.append(" (closed)");
        }
        return sb.toString().trim();
    }

    public FunctionStats getFunctionStats(String textId) {
        return JavaWorkarounds.computeIfAbsent(this.functionExecutionStatsMap, textId, key -> new FunctionStats(this, (String)key));
    }

    public synchronized FunctionServiceStats getFunctionServiceStats() {
        if (this.functionServiceStats == null) {
            this.functionServiceStats = new FunctionServiceStats(this, "FunctionExecution");
        }
        return this.functionServiceStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List addConnectListener(ConnectListener listener) {
        Object object = existingSystemsLock;
        synchronized (object) {
            Set<ConnectListener> set = connectListeners;
            synchronized (set) {
                connectListeners.add(listener);
                return existingSystems;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReconnectListener(ReconnectListener listener) {
        Object object = existingSystemsLock;
        synchronized (object) {
            List<ReconnectListener> list = reconnectListeners;
            synchronized (list) {
                reconnectListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyConnectListeners(InternalDistributedSystem sys) {
        Set<ConnectListener> set = connectListeners;
        synchronized (set) {
            for (ConnectListener listener : connectListeners) {
                try {
                    listener.onConnect(sys);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    sys.getLogWriter().severe("ConnectListener threw...", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyReconnectListeners(InternalDistributedSystem oldsys, InternalDistributedSystem newsys, boolean starting) {
        ArrayList<ReconnectListener> listeners;
        List<ReconnectListener> list = reconnectListeners;
        synchronized (list) {
            listeners = new ArrayList<ReconnectListener>(reconnectListeners);
        }
        for (ReconnectListener listener : listeners) {
            try {
                if (starting) {
                    listener.reconnecting(oldsys);
                    continue;
                }
                listener.onReconnect(oldsys, newsys);
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError || t instanceof UnknownError) {
                    Error err = (Error)t;
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                SystemFailure.checkFailure();
                logger.fatal("ConnectListener threw...", t);
            }
        }
    }

    private void notifyResourceEventListeners(ResourceEvent event, Object resource) {
        for (ResourceEventsListener listener : this.resourceListeners) {
            try {
                listener.handleEvent(event, resource);
            }
            catch (CancelException e) {
                logger.info("Skipping notifyResourceEventListeners for {} due to cancellation", (Object)event);
            }
            catch (ManagementException | GemFireSecurityException ex) {
                if (event == ResourceEvent.CACHE_CREATE) {
                    throw ex;
                }
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception err) {
                logger.warn(err.getMessage(), (Throwable)err);
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(t.getMessage(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisconnectListener(DisconnectListener listener) {
        Set<DisconnectListener> set = this.disconnectListeners;
        synchronized (set) {
            String reason;
            this.disconnectListeners.add(listener);
            boolean disconnectThreadBoolean = this.isDisconnectThread.get();
            if (!disconnectThreadBoolean && (reason = this.stopper.cancelInProgress()) != null) {
                this.disconnectListeners.remove(listener);
                throw new DistributedSystemDisconnectedException(String.format("No listeners permitted after shutdown: %s", reason), this.dm.getRootCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisconnectListener(DisconnectListener listener) {
        Set<DisconnectListener> set = this.disconnectListeners;
        synchronized (set) {
            this.disconnectListeners.remove(listener);
        }
    }

    public static InternalDistributedSystem getAnyInstance() {
        List l = existingSystems;
        if (l.isEmpty()) {
            return null;
        }
        return (InternalDistributedSystem)l.get(0);
    }

    public static List getExistingSystems() {
        return existingSystems;
    }

    @Override
    public Properties getProperties() {
        return this.config.toProperties();
    }

    @Override
    public Properties getSecurityProperties() {
        return this.config.getSecurityProps();
    }

    @Override
    public boolean isReconnecting() {
        InternalDistributedSystem rds = this.reconnectDS;
        if (!this.attemptingToReconnect) {
            return false;
        }
        if (this.reconnectCancelled) {
            return false;
        }
        boolean newDsConnected = rds == null || !rds.isConnected();
        return newDsConnected;
    }

    public boolean isReconnectingDS() {
        return this.isReconnectingDS;
    }

    public MembershipInformation oldDSMembershipInfo() {
        if (this.quorumChecker != null) {
            return this.quorumChecker.getMembershipInfo();
        }
        return null;
    }

    public boolean reconnected() {
        return this.reconnected;
    }

    public boolean forcedDisconnect() {
        return this.forcedDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelReconnect() {
        this.reconnectCancelled = true;
        if (this.isReconnecting()) {
            Object object = this.reconnectLock;
            synchronized (object) {
                this.reconnectLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReconnect(boolean forcedDisconnect, String reason, InternalCache oldCache) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.isReconnectingDS && forcedDisconnect) {
            return false;
        }
        Class<InternalCacheBuilder> clazz = InternalCacheBuilder.class;
        synchronized (InternalCacheBuilder.class) {
            Class<GemFireCacheImpl> clazz2 = GemFireCacheImpl.class;
            synchronized (GemFireCacheImpl.class) {
                Object object = this.reconnectLock;
                synchronized (object) {
                    if (!forcedDisconnect && !oldCache.isClosed() && oldCache.getCachePerfStats().getReliableRegionsMissing() == 0) {
                        if (isDebugEnabled) {
                            logger.debug("tryReconnect: No required roles are missing.");
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6, 14] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return false;
                    }
                    if (isDebugEnabled) {
                        logger.debug("tryReconnect: forcedDisconnect={}", (Object)forcedDisconnect);
                    }
                    if (forcedDisconnect && this.config.getDisableAutoReconnect()) {
                        if (isDebugEnabled) {
                            logger.debug("tryReconnect: auto reconnect after forced disconnect is disabled");
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6, 11] lbl25 : MonitorExitStatement: MONITOREXIT : var7_7
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return false;
                    }
                    this.reconnect(forcedDisconnect, reason);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var7_7
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this.reconnectDS != null && this.reconnectDS.isConnected();
                }
            }
        }
    }

    public static int getReconnectAttemptCounter() {
        return reconnectAttemptCounter;
    }

    /*
     * Exception decompiling
     */
    private void reconnect(boolean forcedDisconnect, String reason) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createAndStartCacheServers(List<CacheServerCreation> cacheServerCreation, InternalCache cache) {
        List<CacheServer> servers = cache.getCacheServers();
        if (servers.isEmpty() && cacheServerCreation != null) {
            for (CacheServerCreation bridge : cacheServerCreation) {
                CacheServerImpl impl = (CacheServerImpl)cache.addCacheServer();
                impl.configureFrom(bridge);
            }
        }
        servers = cache.getCacheServers();
        for (CacheServer server : servers) {
            try {
                if (server.isRunning()) continue;
                server.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(String.format("While starting cache server %s", server), ex);
            }
        }
    }

    public void validateSameProperties(Properties propsToCheck, boolean isConnected) {
        if (!this.sameAs(propsToCheck, isConnected)) {
            String[] validAttributeNames;
            StringBuilder sb = new StringBuilder();
            DistributionConfigImpl wanted = DistributionConfigImpl.produce(propsToCheck);
            for (String attName : validAttributeNames = this.originalConfig.getAttributeNames()) {
                Object expectedAtt = wanted.getAttributeObject(attName);
                String expectedAttStr = expectedAtt.toString();
                Object actualAtt = this.originalConfig.getAttributeObject(attName);
                String actualAttStr = actualAtt.toString();
                sb.append("  ");
                sb.append(attName);
                sb.append("=\"");
                if (actualAtt.getClass().isArray()) {
                    actualAttStr = InternalDistributedSystem.arrayToString(actualAtt);
                    expectedAttStr = InternalDistributedSystem.arrayToString(expectedAtt);
                }
                sb.append(actualAttStr);
                sb.append("\"");
                if (!expectedAttStr.equals(actualAttStr)) {
                    sb.append(" ***(wanted \"");
                    sb.append(expectedAtt);
                    sb.append("\")***");
                }
                sb.append("\n");
            }
            if (this.creationStack == null) {
                throw new IllegalStateException(String.format("A connection to a distributed system already exists in this VM.  It has the following configuration:%s", sb.toString()));
            }
            throw new IllegalStateException(String.format("A connection to a distributed system already exists in this VM.  It has the following configuration:%s", sb.toString()), this.creationStack);
        }
    }

    public static String arrayToString(Object obj) {
        if (!obj.getClass().isArray()) {
            return "-not-array-object-";
        }
        StringBuilder buff = new StringBuilder("[");
        int arrayLength = Array.getLength(obj);
        for (int i = 0; i < arrayLength - 1; ++i) {
            buff.append(Array.get(obj, i).toString());
            buff.append(",");
        }
        if (arrayLength > 0) {
            buff.append(Array.get(obj, arrayLength - 1).toString());
        }
        buff.append("]");
        return buff.toString();
    }

    public boolean isShareSockets() {
        return this.shareSockets;
    }

    public void setShareSockets(boolean shareSockets) {
        this.shareSockets = shareSockets;
    }

    public boolean hasAlertListenerFor(DistributedMember member) {
        return this.hasAlertListenerFor(member, AlertLevel.WARNING.intLevel());
    }

    public boolean hasAlertListenerFor(DistributedMember member, int severity) {
        return this.alertingService.hasAlertListener(member, AlertLevel.find(severity));
    }

    public static void setEnableAdministrationOnly(boolean adminOnly) {
        DistributedSystem.setEnableAdministrationOnly(adminOnly);
    }

    public static void setCommandLineAdmin(boolean adminOnly) {
        DistributedSystem.setEnableAdministrationOnly(adminOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        int sleepTime = 1000;
        long endTime = System.currentTimeMillis();
        endTime = time < 0L ? Long.MAX_VALUE : (endTime += TimeUnit.MILLISECONDS.convert(time, units));
        Object object = this.reconnectLock;
        synchronized (object) {
            while (this.isReconnecting() && !this.reconnectCancelled) {
                if (time != 0L) {
                    this.reconnectLock.wait(sleepTime);
                }
                if (time != 0L && System.currentTimeMillis() <= endTime) continue;
            }
            if (this.reconnectException != null) {
                throw new DistributedSystemDisconnectedException("Reconnect attempts terminated due to exception", this.reconnectException);
            }
            InternalDistributedSystem recon = this.reconnectDS;
            return !this.attemptingToReconnect && recon != null && recon.isConnected();
        }
    }

    @Override
    public DistributedSystem getReconnectedSystem() {
        return this.reconnectDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReconnecting() {
        this.reconnectCancelled = true;
        Object object = this.reconnectLock;
        synchronized (object) {
            this.reconnectLock.notify();
        }
        this.disconnect(false, "stopReconnecting was invoked", false);
        this.attemptingToReconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReconnectingNoDisconnect() {
        this.reconnectCancelled = true;
        Object object = this.reconnectLock;
        synchronized (object) {
            this.reconnectLock.notify();
        }
        this.attemptingToReconnect = false;
    }

    public void setCache(InternalCache instance) {
        this.dm.setCache(instance);
    }

    public InternalCache getCache() {
        return this.dm == null ? null : this.dm.getCache();
    }

    private static StatisticsManagerFactory defaultStatisticsManagerFactory() {
        return (name, startTime, statsDisabled) -> {
            if (statsDisabled) {
                return new DummyStatisticsRegistry(name, startTime);
            }
            return new StatisticsRegistry(name, startTime);
        };
    }

    static {
        DEFAULT_CREATION_STACK_GENERATOR = new CreationStackGenerator(){

            @Override
            public Throwable generateCreationStack(DistributionConfig config) {
                return null;
            }
        };
        TEST_CREATION_STACK_GENERATOR = new AtomicReference<CreationStackGenerator>(DEFAULT_CREATION_STACK_GENERATOR);
        connectListeners = new LinkedHashSet<ConnectListener>();
        reconnectListeners = new ArrayList<ReconnectListener>();
        MAX_DISCONNECT_WAIT = Long.getLong("DistributionManager.DISCONNECT_WAIT", 10000L);
        emergencyClassesLoaded = false;
        LoggingThread tmp_shutdownHook = null;
        try {
            if (!Boolean.getBoolean(DISABLE_SHUTDOWN_HOOK_PROPERTY)) {
                tmp_shutdownHook = new LoggingThread(SHUTDOWN_HOOK_NAME, false, () -> {
                    InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                    InternalDistributedSystem.setThreadsSocketPolicy(true);
                    if (ds != null && ds.isConnected()) {
                        logger.info("VM is exiting - shutting down distributed system");
                        DurableClientAttributes dca = ds.getDistributedMember().getDurableClientAttributes();
                        boolean isDurableClient = false;
                        if (dca != null) {
                            isDurableClient = dca.getId() != null && !dca.getId().isEmpty();
                        }
                        ds.disconnect(false, "normal disconnect", isDurableClient);
                    }
                });
                Runtime.getRuntime().addShutdownHook(tmp_shutdownHook);
            }
        }
        finally {
            shutdownHook = tmp_shutdownHook;
        }
        reconnectAttemptCounter = 0;
    }

    public static interface CreationStackGenerator {
        public Throwable generateCreationStack(DistributionConfig var1);
    }

    public static interface ConnectListener {
        public void onConnect(InternalDistributedSystem var1);
    }

    public static interface ShutdownListener
    extends DisconnectListener {
        public void onShutdown(InternalDistributedSystem var1);
    }

    public static interface ReconnectListener {
        public void reconnecting(InternalDistributedSystem var1);

        public void onReconnect(InternalDistributedSystem var1, InternalDistributedSystem var2);
    }

    public static interface DisconnectListener {
        public void onDisconnect(InternalDistributedSystem var1);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            if (InternalDistributedSystem.this.dm == null) {
                return "No dm";
            }
            return InternalDistributedSystem.this.dm.getCancelCriterion().cancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            if (InternalDistributedSystem.this.dm == null) {
                return new DistributedSystemDisconnectedException("no dm", e);
            }
            return InternalDistributedSystem.this.dm.getCancelCriterion().generateCancelledException(e);
        }
    }
}

