/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import joptsimple.internal.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.CancelException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.XSDRootElement;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.internal.config.JAXBService;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.util.ClasspathScanLoadHelper;
import org.apache.geode.management.internal.configuration.callbacks.ConfigurationChangeListener;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.configuration.functions.DownloadJarFunction;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import org.apache.geode.management.internal.configuration.utils.XmlUtils;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InternalConfigurationPersistenceService
implements ConfigurationPersistenceService {
    private static final Logger logger = LogService.getLogger();
    public static final String CLUSTER_CONFIG_ARTIFACTS_DIR_NAME = "cluster_config";
    private static final String CLUSTER_CONFIG_DISK_STORE_NAME = "cluster_config";
    public static final String CLUSTER_CONFIG_DISK_DIR_PREFIX = "ConfigDiskDir_";
    private static final String SHARED_CONFIG_LOCK_SERVICE_NAME = "__CLUSTER_CONFIG_LS";
    private static final String SHARED_CONFIG_LOCK_NAME = "__CLUSTER_CONFIG_LOCK";
    public static final String CONFIG_REGION_NAME = "_ConfigurationRegion";
    private static final String CACHE_CONFIG_VERSION = "1.0";
    private final String configDirPath;
    private final String configDiskDirPath;
    private final Set<PersistentMemberPattern> newerSharedConfigurationLocatorInfo = new HashSet<PersistentMemberPattern>();
    private final AtomicReference<SharedConfigurationStatus> status = new AtomicReference();
    private final InternalCache cache;
    private DistributedLockService sharedConfigLockingService;
    private JAXBService jaxbService;

    @VisibleForTesting
    InternalConfigurationPersistenceService(Class<?> ... xsdClasses) {
        this.configDirPath = null;
        this.configDiskDirPath = null;
        this.cache = null;
        this.jaxbService = new JAXBService(xsdClasses);
        this.jaxbService.validateWithLocalCacheXSD();
    }

    @VisibleForTesting
    InternalConfigurationPersistenceService() {
        this.configDirPath = null;
        this.configDiskDirPath = null;
        this.cache = null;
        this.jaxbService = new JAXBService(CacheConfig.class);
    }

    public JAXBService getJaxbService() {
        return this.jaxbService;
    }

    public InternalConfigurationPersistenceService(InternalCache cache, Class<?> ... xsdClasses) throws IOException {
        this.cache = cache;
        Properties properties = cache.getDistributedSystem().getProperties();
        String clusterConfigRootDir = properties.getProperty("cluster-configuration-dir");
        if (StringUtils.isBlank((CharSequence)clusterConfigRootDir)) {
            clusterConfigRootDir = System.getProperty("user.dir");
        } else {
            File diskDir = new File(clusterConfigRootDir);
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new IOException("Cannot create directory : " + clusterConfigRootDir);
            }
            clusterConfigRootDir = diskDir.getCanonicalPath();
        }
        clusterConfigRootDir = new File(clusterConfigRootDir).getAbsolutePath();
        String configDiskDirName = CLUSTER_CONFIG_DISK_DIR_PREFIX + cache.getDistributedSystem().getName();
        this.configDirPath = FilenameUtils.concat((String)clusterConfigRootDir, (String)"cluster_config");
        this.configDiskDirPath = FilenameUtils.concat((String)clusterConfigRootDir, (String)configDiskDirName);
        this.sharedConfigLockingService = this.getSharedConfigLockService(cache.getDistributedSystem());
        this.status.set(SharedConfigurationStatus.NOT_STARTED);
        if (xsdClasses != null && xsdClasses.length > 0) {
            this.jaxbService = new JAXBService(xsdClasses);
        } else {
            Set<String> packages = this.getPackagesToScan();
            try (ClasspathScanLoadHelper scanner = new ClasspathScanLoadHelper(packages);){
                Set<Class<?>> scannedClasses = scanner.scanClasspathForAnnotation(XSDRootElement.class, packages.toArray(new String[0]));
                this.jaxbService = new JAXBService(scannedClasses.toArray(new Class[scannedClasses.size()]));
            }
        }
        this.jaxbService.validateWithLocalCacheXSD();
    }

    protected Set<String> getPackagesToScan() {
        Set<String> packages = new HashSet<String>();
        String sysProperty = SystemPropertyHelper.getProperty("packagesToScan");
        if (sysProperty != null) {
            packages = Arrays.stream(sysProperty.split(",")).collect(Collectors.toSet());
        } else {
            packages.add("*");
        }
        return packages;
    }

    private DistributedLockService getSharedConfigLockService(DistributedSystem ds) {
        DistributedLockService sharedConfigDls = DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        try {
            if (sharedConfigDls == null) {
                sharedConfigDls = DLockService.create(SHARED_CONFIG_LOCK_SERVICE_NAME, (InternalDistributedSystem)ds, true, true);
            }
        }
        catch (IllegalArgumentException ignore) {
            return DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        }
        return sharedConfigDls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null || groups.length == 0) {
                groups = new String[]{"cluster"};
            }
            for (String group : groups) {
                String xmlContent;
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if ((xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) {
                    xmlContent = this.generateInitialXmlContent();
                }
                try {
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.addNewNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteXmlEntity(XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                Set<String> groupSet = configRegion.keySet();
                groups = groupSet.toArray(new String[groupSet.size()]);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) continue;
                String xmlContent = configuration.getCacheXmlContent();
                try {
                    if (xmlContent == null || xmlContent.isEmpty()) continue;
                    Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                    XmlUtils.deleteNode(doc, xmlEntity);
                    configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    configRegion.put(group, configuration);
                }
                catch (Exception e) {
                    logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyXmlAndProperties(Properties properties, XmlEntity xmlEntity, String[] groups) {
        this.lockSharedConfiguration();
        try {
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                }
                if (xmlEntity != null) {
                    String xmlContent = configuration.getCacheXmlContent();
                    if (xmlContent == null || xmlContent.isEmpty()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        CacheXmlGenerator.generateDefault(pw);
                        xmlContent = sw.toString();
                    }
                    try {
                        Document doc = XmlUtils.createAndUpgradeDocumentFromXml(xmlContent);
                        XmlUtils.modifyRootAttributes(doc, xmlEntity);
                        configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
                    }
                    catch (Exception e) {
                        logger.error("error updating cluster configuration for group {}", (Object)group, (Object)e);
                    }
                }
                if (properties != null) {
                    configuration.getGemfireProperties().putAll((Map<?, ?>)properties);
                }
                configRegion.put(group, configuration);
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarsToThisLocator(List<String> jarFullPaths, String[] groups) throws IOException {
        this.lockSharedConfiguration();
        try {
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                    this.createConfigDirIfNecessary(group);
                }
                String groupDir = FilenameUtils.concat((String)this.configDirPath, (String)group);
                HashSet<String> jarNames = new HashSet<String>();
                for (String jarFullPath : jarFullPaths) {
                    File stagedJar = new File(jarFullPath);
                    jarNames.add(stagedJar.getName());
                    String filePath = FilenameUtils.concat((String)groupDir, (String)stagedJar.getName());
                    File jarFile = new File(filePath);
                    FileUtils.copyFile((File)stagedJar, (File)jarFile);
                }
                String memberId = this.cache.getMyId().getId();
                Configuration configurationCopy = new Configuration(configuration);
                configurationCopy.addJarNames(jarNames);
                configRegion.put(group, configurationCopy, memberId);
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJars(String[] jarNames, String[] groups) {
        this.lockSharedConfiguration();
        boolean success = true;
        try {
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                groups = (String[])configRegion.keySet().stream().toArray(String[]::new);
            }
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    break;
                }
                for (String jarRemoved : jarNames) {
                    File jar = this.getPathToJarOnThisLocator(group, jarRemoved).toFile();
                    if (!jar.exists()) continue;
                    try {
                        FileUtils.forceDelete((File)jar);
                    }
                    catch (IOException e) {
                        logger.error("Exception occurred while attempting to delete a jar from the filesystem: {}", (Object)jarRemoved, (Object)e);
                    }
                }
                Configuration configurationCopy = new Configuration(configuration);
                configurationCopy.removeJarNames(jarNames);
                configRegion.put(group, configurationCopy);
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred while deleting the jar files", (Throwable)e);
            success = false;
        }
        finally {
            this.unlockSharedConfiguration();
        }
        return success;
    }

    public void downloadJarFromOtherLocators(String groupName, String jarName) throws IllegalStateException, IOException {
        logger.info("Getting Jar files from other locators");
        DistributionManager dm = this.cache.getDistributionManager();
        InternalDistributedMember me = this.cache.getMyId();
        ArrayList<InternalDistributedMember> locators = new ArrayList<InternalDistributedMember>(dm.getAllHostedLocatorsWithSharedConfiguration().keySet());
        locators.remove(me);
        this.createConfigDirIfNecessary(groupName);
        if (locators.isEmpty()) {
            throw new IllegalStateException("Request to download jar " + jarName + " but no other locators are present");
        }
        this.downloadJarFromLocator(groupName, jarName, (DistributedMember)locators.get(0));
    }

    public void downloadJarFromLocator(String groupName, String jarName, DistributedMember sourceLocator) throws IllegalStateException, IOException {
        logger.info("Downloading jar {} from locator {}", (Object)jarName, (Object)sourceLocator.getName());
        this.createConfigDirIfNecessary(groupName);
        File jarFile = this.downloadJar(sourceLocator, groupName, jarName);
        File jarToWrite = this.getPathToJarOnThisLocator(groupName, jarName).toFile();
        Files.copy(jarFile.toPath(), jarToWrite.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public File downloadJar(DistributedMember locator, String groupName, String jarName) throws IOException {
        ResultCollector<?, ?> rc = CliUtil.executeFunction(new DownloadJarFunction(), new Object[]{groupName, jarName}, Collections.singleton(locator));
        List result = (List)rc.getResult();
        RemoteInputStream jarStream = (RemoteInputStream)result.get(0);
        Path tempDir = FileUploader.createSecuredTempDirectory("deploy-");
        Path tempJar = Paths.get(tempDir.toString(), jarName);
        FileOutputStream fos = new FileOutputStream(tempJar.toString());
        InputStream input = RemoteInputStreamClient.wrap((RemoteInputStream)jarStream);
        IOUtils.copy((InputStream)input, (OutputStream)fos);
        fos.close();
        input.close();
        return tempJar.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initSharedConfiguration(boolean loadSharedConfigFromDir) throws CacheLoaderException, TimeoutException, IllegalStateException, IOException, TransformerException, SAXException, ParserConfigurationException {
        this.status.set(SharedConfigurationStatus.STARTED);
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        this.lockSharedConfiguration();
        this.removeInvalidXmlConfigurations(configRegion);
        try {
            if (loadSharedConfigFromDir) {
                logger.info("Reading cluster configuration from '{}' directory", (Object)"cluster_config");
                this.loadSharedConfigurationFromDir(new File(this.configDirPath));
            } else {
                this.persistSecuritySettings(configRegion);
                for (Map.Entry<String, Configuration> stringConfigurationEntry : configRegion.entrySet()) {
                    Configuration config = stringConfigurationEntry.getValue();
                    for (String jar : config.getJarNames()) {
                        if (this.getPathToJarOnThisLocator(stringConfigurationEntry.getKey(), jar).toFile().exists()) continue;
                        this.downloadJarFromOtherLocators(stringConfigurationEntry.getKey(), jar);
                    }
                }
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
        this.status.set(SharedConfigurationStatus.RUNNING);
    }

    void removeInvalidXmlConfigurations(Region<String, Configuration> configRegion) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        for (Map.Entry<String, Configuration> entry : configRegion.entrySet()) {
            String group = entry.getKey();
            Configuration configuration = entry.getValue();
            String configurationXml = configuration.getCacheXmlContent();
            if (configurationXml == null || configurationXml.isEmpty()) continue;
            Document document = XmlUtils.createDocumentFromXml(configurationXml);
            boolean removedInvalidReceivers = this.removeInvalidGatewayReceivers(document);
            boolean removedDuplicateReceivers = this.removeDuplicateGatewayReceivers(document);
            if (!removedInvalidReceivers && !removedDuplicateReceivers) continue;
            configuration.setCacheXmlContent(XmlUtils.prettyXml(document));
            configRegion.put(group, configuration);
        }
    }

    boolean removeInvalidGatewayReceivers(Document document) throws TransformerException {
        boolean modified = false;
        NodeList receiverNodes = document.getElementsByTagName("gateway-receiver");
        for (int i = receiverNodes.getLength() - 1; i >= 0; --i) {
            String bindAddress;
            Element receiverElement = (Element)receiverNodes.item(i);
            String hostNameForSenders = receiverElement.getAttribute("hostname-for-senders");
            if (StringUtils.isNotBlank((CharSequence)hostNameForSenders)) {
                receiverElement.getParentNode().removeChild(receiverElement);
                logger.info("Removed invalid cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
                modified = true;
            }
            if (!StringUtils.isNotBlank((CharSequence)(bindAddress = receiverElement.getAttribute("bind-address"))) || bindAddress.equals("0.0.0.0")) continue;
            receiverElement.getParentNode().removeChild(receiverElement);
            logger.info("Removed invalid cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
            modified = true;
        }
        return modified;
    }

    boolean removeDuplicateGatewayReceivers(Document document) throws TransformerException {
        boolean modified = false;
        NodeList receiverNodes = document.getElementsByTagName("gateway-receiver");
        while (receiverNodes.getLength() > 1) {
            Element receiverElement = (Element)receiverNodes.item(0);
            receiverElement.getParentNode().removeChild(receiverElement);
            logger.info("Removed duplicate cluster configuration gateway-receiver element=" + XmlUtils.prettyXml(receiverElement));
            modified = true;
            receiverNodes = document.getElementsByTagName("gateway-receiver");
        }
        return modified;
    }

    private void persistSecuritySettings(Region<String, Configuration> configRegion) {
        Properties securityProps = this.cache.getDistributedSystem().getSecurityProperties();
        Configuration clusterPropertiesConfig = configRegion.get("cluster");
        if (clusterPropertiesConfig == null) {
            clusterPropertiesConfig = new Configuration("cluster");
            configRegion.put("cluster", clusterPropertiesConfig);
        }
        Properties clusterProperties = clusterPropertiesConfig.getGemfireProperties();
        if (securityProps.containsKey("security-manager")) {
            clusterProperties.setProperty("security-manager", securityProps.getProperty("security-manager"));
        }
        if (securityProps.containsKey("security-post-processor")) {
            clusterProperties.setProperty("security-post-processor", securityProps.getProperty("security-post-processor"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationResponse createConfigurationResponse(Set<String> groups) {
        ConfigurationResponse configResponse = null;
        boolean isLocked = this.lockSharedConfiguration();
        try {
            if (isLocked) {
                configResponse = new ConfigurationResponse();
                groups.add("cluster");
                logger.info("Building up configuration response with following configurations: {}", groups);
                for (String group : groups) {
                    Configuration configuration = this.getConfiguration(group);
                    configResponse.addConfiguration(configuration);
                    if (configuration == null) continue;
                    configResponse.addJar(group, configuration.getJarNames());
                }
                ConfigurationResponse configurationResponse = configResponse;
                return configurationResponse;
            }
        }
        finally {
            this.unlockSharedConfiguration();
        }
        return configResponse;
    }

    SharedConfigurationStatusResponse createStatusResponse() {
        SharedConfigurationStatusResponse response = new SharedConfigurationStatusResponse();
        response.setStatus(this.getStatus());
        response.addWaitingLocatorInfo(this.newerSharedConfigurationLocatorInfo);
        return response;
    }

    public void destroySharedConfiguration() {
        try {
            DiskStore configDiskStore;
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (configRegion != null) {
                configRegion.destroyRegion();
            }
            if ((configDiskStore = this.cache.findDiskStore("cluster_config")) != null) {
                configDiskStore.destroy();
                File file = new File(this.configDiskDirPath);
                FileUtils.deleteDirectory((File)file);
            }
            FileUtils.deleteDirectory((File)new File(this.configDirPath));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public Path getPathToJarOnThisLocator(String groupName, String jarName) {
        return new File(this.configDirPath).toPath().resolve(groupName).resolve(jarName);
    }

    public Configuration getConfiguration(String groupName) {
        return this.getConfigurationRegion().get(groupName);
    }

    public void setConfiguration(String groupName, Configuration configuration) {
        this.getConfigurationRegion().put(groupName, configuration);
    }

    public boolean hasXmlConfiguration() {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        return configRegion.values().stream().anyMatch(c -> c.getCacheXmlContent() != null);
    }

    public Map<String, Configuration> getEntireConfiguration() {
        Set<String> keys = this.getConfigurationRegion().keySet();
        return this.getConfigurationRegion().getAll(keys);
    }

    @Override
    public Set<String> getGroups() {
        return this.getConfigurationRegion().keySet();
    }

    public String getSharedConfigurationDirPath() {
        return this.configDirPath;
    }

    public Path getClusterConfigDirPath() {
        return Paths.get(this.configDirPath, new String[0]);
    }

    public SharedConfigurationStatus getStatus() {
        PersistentMemberManager pmm;
        Map<String, Set<PersistentMemberID>> waitingRegions;
        SharedConfigurationStatus scStatus = this.status.get();
        if (scStatus == SharedConfigurationStatus.STARTED && !(waitingRegions = (pmm = this.cache.getPersistentMemberManager()).getWaitingRegions()).isEmpty()) {
            this.status.compareAndSet(SharedConfigurationStatus.STARTED, SharedConfigurationStatus.WAITING);
            Set<PersistentMemberID> persMemIds = waitingRegions.get("/_ConfigurationRegion");
            for (PersistentMemberID persMemId : persMemIds) {
                this.newerSharedConfigurationLocatorInfo.add(new PersistentMemberPattern(persMemId));
            }
        }
        return this.status.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSharedConfigurationFromDir(File configDir) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        this.lockSharedConfiguration();
        try {
            File[] groupNames = configDir.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
            boolean needToCopyJars = true;
            if (configDir.getAbsolutePath().equals(this.getSharedConfigurationDirPath())) {
                needToCopyJars = false;
            }
            logger.info("loading the cluster configuration: ");
            HashMap<String, Configuration> sharedConfiguration = new HashMap<String, Configuration>();
            for (File groupName : groupNames) {
                Configuration configuration = this.readConfiguration(groupName);
                logger.info(configuration.getConfigName() + " xml content: \n" + configuration.getCacheXmlContent());
                logger.info(configuration.getConfigName() + " properties: " + configuration.getGemfireProperties().size());
                logger.info(configuration.getConfigName() + " jars: " + Strings.join(configuration.getJarNames(), (String)", "));
                sharedConfiguration.put(groupName.getName(), configuration);
                if (!needToCopyJars || configuration.getJarNames().size() <= 0) continue;
                Path groupDirPath = this.createConfigDirIfNecessary(configuration.getConfigName()).toPath();
                for (String jarName : configuration.getJarNames()) {
                    Files.copy(groupName.toPath().resolve(jarName), groupDirPath.resolve(jarName), new CopyOption[0]);
                }
            }
            Region<String, Configuration> clusterRegion = this.getConfigurationRegion();
            clusterRegion.clear();
            String memberId = this.cache.getMyId().getId();
            clusterRegion.putAll(sharedConfiguration, memberId);
            this.persistSecuritySettings(clusterRegion);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }

    public void writeConfigToFile(Configuration configuration, File rootDir) throws IOException {
        File configDir = this.createConfigDirIfNecessary(rootDir, configuration.getConfigName());
        File propsFile = new File(configDir, configuration.getPropertiesFileName());
        BufferedWriter bw = new BufferedWriter(new FileWriter(propsFile));
        configuration.getGemfireProperties().store(bw, null);
        bw.close();
        File xmlFile = new File(configDir, configuration.getCacheXmlFileName());
        FileUtils.writeStringToFile((File)xmlFile, (String)configuration.getCacheXmlContent(), (String)"UTF-8");
        if (rootDir.getAbsolutePath().equals(this.getSharedConfigurationDirPath())) {
            return;
        }
        File locatorConfigDir = new File(this.getSharedConfigurationDirPath(), configuration.getConfigName());
        if (locatorConfigDir.exists()) {
            File[] jarFiles;
            for (File file : jarFiles = locatorConfigDir.listFiles(x -> x.getName().endsWith(".jar"))) {
                Files.copy(file.toPath(), configDir.toPath().resolve(file.getName()), new CopyOption[0]);
            }
        }
    }

    public boolean lockSharedConfiguration() {
        return this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, -1L, -1L);
    }

    public void unlockSharedConfiguration() {
        this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
    }

    public Region<String, Configuration> getConfigurationRegion() {
        Region<String, Configuration> configRegion = this.cache.getRegion(CONFIG_REGION_NAME);
        try {
            if (configRegion == null) {
                File diskDir = new File(this.configDiskDirPath);
                if (!diskDir.exists() && !diskDir.mkdirs()) {
                    throw new IOException("Cannot create directory at " + this.configDiskDirPath);
                }
                File[] diskDirs = new File[]{diskDir};
                this.cache.createDiskStoreFactory().setDiskDirs(diskDirs).setAutoCompact(true).setMaxOplogSize(10L).create("cluster_config");
                AttributesFactory<String, Configuration> regionAttrsFactory = new AttributesFactory<String, Configuration>();
                regionAttrsFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionAttrsFactory.setCacheListener(new ConfigurationChangeListener(this, this.cache));
                regionAttrsFactory.setDiskStoreName("cluster_config");
                regionAttrsFactory.setScope(Scope.DISTRIBUTED_ACK);
                InternalRegionArguments internalArgs = new InternalRegionArguments();
                internalArgs.setIsUsedForMetaRegion(true);
                internalArgs.setMetaRegionWithTransactions(false);
                configRegion = this.cache.createVMRegion(CONFIG_REGION_NAME, regionAttrsFactory.create(), internalArgs);
            }
        }
        catch (CancelException e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw e;
        }
        catch (Exception e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw new RuntimeException("Error occurred while initializing cluster configuration", e);
        }
        return configRegion;
    }

    private Configuration readConfiguration(File groupConfigDir) throws SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        Configuration configuration = new Configuration(groupConfigDir.getName());
        File cacheXmlFull = new File(groupConfigDir, configuration.getCacheXmlFileName());
        File propertiesFull = new File(groupConfigDir, configuration.getPropertiesFileName());
        configuration.setCacheXmlFile(cacheXmlFull);
        configuration.setPropertiesFile(propertiesFull);
        Set<String> jarFileNames = Arrays.stream(groupConfigDir.list()).filter(filename -> filename.endsWith(".jar")).collect(Collectors.toSet());
        configuration.addJarNames(jarFileNames);
        return configuration;
    }

    private File createConfigDirIfNecessary(String configName) throws IOException {
        return this.createConfigDirIfNecessary(new File(this.getSharedConfigurationDirPath()), configName);
    }

    private File createConfigDirIfNecessary(File clusterConfigDir, String configName) throws IOException {
        if (!clusterConfigDir.exists() && !clusterConfigDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + this.getSharedConfigurationDirPath());
        }
        Path configDirPath = clusterConfigDir.toPath().resolve(configName);
        File configDir = configDirPath.toFile();
        if (!configDir.exists() && !configDir.mkdir()) {
            throw new IOException("Cannot create directory : " + configDirPath);
        }
        return configDir;
    }

    private String generateInitialXmlContent() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CacheXmlGenerator.generateDefault(pw);
        return sw.toString();
    }

    @Override
    public CacheConfig getCacheConfig(String group) {
        return this.getCacheConfig(group, false);
    }

    @Override
    public CacheConfig getCacheConfig(String group, boolean createNew) {
        Configuration configuration;
        if (group == null) {
            group = "cluster";
        }
        if ((configuration = this.getConfiguration(group)) == null) {
            if (createNew) {
                return new CacheConfig(CACHE_CONFIG_VERSION);
            }
            return null;
        }
        String xmlContent = configuration.getCacheXmlContent();
        if (xmlContent == null || xmlContent.isEmpty()) {
            if (createNew) {
                return new CacheConfig(CACHE_CONFIG_VERSION);
            }
            return null;
        }
        return (CacheConfig)this.jaxbService.unMarshall(xmlContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheConfig(String group, UnaryOperator<CacheConfig> mutator) {
        if (group == null) {
            group = "cluster";
        }
        this.lockSharedConfiguration();
        try {
            CacheConfig cacheConfig = this.getCacheConfig(group, true);
            cacheConfig = (CacheConfig)mutator.apply(cacheConfig);
            if (cacheConfig == null) {
                return;
            }
            Configuration configuration = this.getConfiguration(group);
            if (configuration == null) {
                configuration = new Configuration(group);
            }
            configuration.setCacheXmlContent(this.jaxbService.marshall(cacheConfig));
            this.getConfigurationRegion().put(group, configuration);
        }
        finally {
            this.unlockSharedConfiguration();
        }
    }
}

