/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.AbstractDistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.FlowControlParams;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.process.ProcessLauncherContext;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class DistributionConfigImpl
extends AbstractDistributionConfig
implements Serializable {
    private static final long serialVersionUID = 4096393792893825167L;
    private String name = "";
    private int tcpPort = 0;
    private int mcastPort = 0;
    private int mcastTtl = 32;
    private int socketLeaseTime = 60000;
    private int socketBufferSize = 32768;
    private boolean conserveSockets = true;
    private String roles = "";
    private InetAddress mcastAddress = DEFAULT_MCAST_ADDRESS;
    private String bindAddress = "";
    private String serverBindAddress = "";
    private String locators = "";
    private int locatorWaitTime;
    private File logFile = DEFAULT_LOG_FILE;
    private File deployWorkingDir = new File(System.getProperty("user.dir"));
    protected int logLevel = DEFAULT_LOG_LEVEL;
    private String startLocator = "";
    private int startLocatorPort;
    protected boolean statisticSamplingEnabled = true;
    protected int statisticSampleRate = 1000;
    File statisticArchiveFile = DEFAULT_STATISTIC_ARCHIVE_FILE;
    private int ackWaitThreshold = 15;
    private int ackForceDisconnectThreshold = 0;
    private File cacheXmlFile = Boolean.getBoolean("Locator.forceLocatorDMType") ? new File("") : DEFAULT_CACHE_XML_FILE;
    protected int archiveDiskSpaceLimit = 0;
    protected int archiveFileSizeLimit = 0;
    protected int logDiskSpaceLimit = 0;
    protected int logFileSizeLimit = 0;
    @Deprecated
    private boolean clusterSSLEnabled = false;
    @Deprecated
    private String clusterSSLProtocols = "any";
    @Deprecated
    private String clusterSSLCiphers = "any";
    @Deprecated
    private boolean clusterSSLRequireAuthentication = true;
    @Deprecated
    private String clusterSSLKeyStore = "";
    @Deprecated
    private String clusterSSLKeyStoreType = "";
    @Deprecated
    private String clusterSSLKeyStorePassword = "";
    @Deprecated
    private String clusterSSLTrustStore = "";
    @Deprecated
    private String clusterSSLTrustStorePassword = "";
    private String clusterSSLAlias = "";
    private int mcastSendBufferSize = 65535;
    private int mcastRecvBufferSize = 0x100000;
    private FlowControlParams mcastFlowControl = DEFAULT_MCAST_FLOW_CONTROL;
    private int udpSendBufferSize = 65535;
    private int udpRecvBufferSize = 0x100000;
    private int udpFragmentSize = 60000;
    protected boolean disableTcp = false;
    protected boolean disableJmx = false;
    protected boolean enableTimeStatistics = false;
    protected int memberTimeout = 5000;
    private int[] membershipPortRange = DEFAULT_MEMBERSHIP_PORT_RANGE;
    private int maxWaitTimeForReconnect = 60000;
    private int maxNumReconnectTries = 3;
    private int asyncDistributionTimeout = 0;
    private int asyncQueueTimeout = 60000;
    private int asyncMaxQueueSize = 8;
    private String clientConflation = "server";
    private String durableClientId = "";
    private int durableClientTimeout = 300;
    private String securityClientAuthInit = "";
    private String securityClientAuthenticator = "";
    private String securityManager = "";
    private String postProcessor = "";
    private String securityClientDHAlgo = "";
    private String securityUDPDHAlgo = "";
    private String securityPeerAuthInit = "";
    private String securityPeerAuthenticator = "";
    private String securityClientAccessor = "";
    private String securityClientAccessorPP = "";
    private int securityLogLevel = DEFAULT_LOG_LEVEL;
    private boolean enableNetworkPartitionDetection = true;
    private boolean disableAutoReconnect = false;
    private File securityLogFile = DEFAULT_SECURITY_LOG_FILE;
    private int securityPeerMembershipTimeout = 1000;
    private final Properties security = new Properties();
    private final Properties userDefinedProps = new Properties();
    public static final String SECURITY_SYSTEM_PREFIX = "gemfire.sys.";
    private boolean removeUnresponsiveClient = false;
    private boolean deltaPropagation = true;
    private Map props;
    private int distributedSystemId = -1;
    private String remoteLocators = "";
    private boolean enforceUniqueHost = DistributionConfig.DEFAULT_ENFORCE_UNIQUE_HOST;
    private String redundancyZone = "";
    private Properties sslProperties = new Properties();
    private Properties clusterSSLProperties = new Properties();
    private String groups = "";
    private boolean enableSharedConfiguration = true;
    private boolean useSharedConfiguration = true;
    private boolean loadSharedConfigurationFromDir = false;
    private String clusterConfigDir = "";
    private int httpServicePort = 7070;
    private String httpServiceBindAddress = "";
    private boolean startDevRestApi = false;
    private int memcachedPort;
    private String memcachedProtocol = DEFAULT_MEMCACHED_PROTOCOL;
    private String memcachedBindAddress = "";
    private boolean distributedTransactions = false;
    private int redisPort = 0;
    private String redisBindAddress = "";
    private String redisPassword = "";
    private boolean jmxManager = Boolean.getBoolean("Locator.forceLocatorDMType");
    private boolean jmxManagerStart = false;
    private int jmxManagerPort = 1099;
    private String jmxManagerBindAddress = "";
    private String jmxManagerHostnameForClients = "";
    private String jmxManagerPasswordFile = "";
    private String jmxManagerAccessFile = "";
    private int jmxManagerHttpPort = 7070;
    private int jmxManagerUpdateRate = 2000;
    @Deprecated
    private boolean jmxManagerSSLEnabled = false;
    @Deprecated
    private boolean jmxManagerSslRequireAuthentication = true;
    @Deprecated
    private String jmxManagerSslProtocols = "any";
    @Deprecated
    private String jmxManagerSslCiphers = "any";
    @Deprecated
    private Properties jmxManagerSslProperties = new Properties();
    @Deprecated
    private String jmxManagerSSLKeyStore = "";
    @Deprecated
    private String jmxManagerSSLKeyStoreType = "";
    @Deprecated
    private String jmxManagerSSLKeyStorePassword = "";
    @Deprecated
    private String jmxManagerSSLTrustStore = "";
    @Deprecated
    private String jmxManagerSSLTrustStorePassword = "";
    private String jmxManagerSSLAlias = "";
    @Deprecated
    private boolean serverSSLEnabled = false;
    @Deprecated
    private boolean serverSslRequireAuthentication = true;
    @Deprecated
    private String serverSslProtocols = "any";
    @Deprecated
    private String serverSslCiphers = "any";
    @Deprecated
    private Properties serverSslProperties = new Properties();
    @Deprecated
    private String serverSSLKeyStore = "";
    @Deprecated
    private String serverSSLKeyStoreType = "";
    @Deprecated
    private String serverSSLKeyStorePassword = "";
    @Deprecated
    private String serverSSLTrustStore = "";
    @Deprecated
    private String serverSSLTrustStorePassword = "";
    private String serverSSLAlias = "";
    @Deprecated
    private boolean gatewaySSLEnabled = false;
    @Deprecated
    private boolean gatewaySslRequireAuthentication = true;
    @Deprecated
    private String gatewaySslProtocols = "any";
    @Deprecated
    private String gatewaySslCiphers = "any";
    @Deprecated
    private Properties gatewaySslProperties = new Properties();
    @Deprecated
    private String gatewaySSLKeyStore = "";
    @Deprecated
    private String gatewaySSLKeyStoreType = "";
    @Deprecated
    private String gatewaySSLKeyStorePassword = "";
    @Deprecated
    private String gatewaySSLTrustStore = "";
    @Deprecated
    private String gatewaySSLTrustStorePassword = "";
    private String gatewaySSLAlias = "";
    @Deprecated
    private boolean httpServiceSSLEnabled = false;
    @Deprecated
    private boolean httpServiceSSLRequireAuthentication = false;
    @Deprecated
    private String httpServiceSSLProtocols = "any";
    @Deprecated
    private String httpServiceSSLCiphers = "any";
    @Deprecated
    private Properties httpServiceSSLProperties = new Properties();
    @Deprecated
    private String httpServiceSSLKeyStore = "";
    @Deprecated
    private String httpServiceSSLKeyStoreType = "";
    @Deprecated
    private String httpServiceSSLKeyStorePassword = "";
    @Deprecated
    private String httpServiceSSLTrustStore = "";
    @Deprecated
    private String httpServiceSSLTrustStorePassword = "";
    private String httpServiceSSLAlias = "";
    private Boolean sslEndPointIdentificationEnabled = null;
    private SecurableCommunicationChannel[] securableCommunicationChannels = DEFAULT_SSL_ENABLED_COMPONENTS;
    private boolean sslUseDefaultSSLContext = false;
    private String sslProtocols = "any";
    private String sslCiphers = "any";
    private boolean sslRequireAuthentication = true;
    private String sslKeyStore = "";
    private String sslKeyStoreType = "";
    private String sslKeyStorePassword = "";
    private String sslTrustStore = "";
    private String sslTrustStorePassword = "";
    private String sslTrustStoreType = "";
    private boolean sslWebServiceRequireAuthentication = false;
    private String locatorSSLAlias = "";
    private String sslDefaultAlias = "";
    private Map<String, ConfigSource> sourceMap = Collections.synchronizedMap(new HashMap());
    private String userCommandPackages = "";
    private boolean validateSerializableObjects = false;
    private String serializableObjectFilter = "!*";
    protected String offHeapMemorySize = "";
    private boolean lockMemory = false;
    private String shiroInit = "";
    private boolean threadMonitorEnabled = true;
    private int threadMonitorInterval = 60000;
    private int threadMonitorTimeLimit = 30000;
    protected boolean modifiable;

    public DistributionConfigImpl(DistributionConfig other) {
        this.name = other.getName();
        this.tcpPort = other.getTcpPort();
        this.mcastPort = other.getMcastPort();
        this.mcastTtl = other.getMcastTtl();
        this.socketLeaseTime = other.getSocketLeaseTime();
        this.socketBufferSize = other.getSocketBufferSize();
        this.conserveSockets = other.getConserveSockets();
        this.roles = other.getRoles();
        this.mcastAddress = other.getMcastAddress();
        this.bindAddress = other.getBindAddress();
        this.serverBindAddress = other.getServerBindAddress();
        this.locators = ((DistributionConfigImpl)other).locators;
        this.locatorWaitTime = other.getLocatorWaitTime();
        this.remoteLocators = other.getRemoteLocators();
        this.startLocator = other.getStartLocator();
        this.startLocatorPort = ((DistributionConfigImpl)other).startLocatorPort;
        this.deployWorkingDir = other.getDeployWorkingDir();
        this.logFile = other.getLogFile();
        this.logLevel = other.getLogLevel();
        this.statisticSamplingEnabled = other.getStatisticSamplingEnabled();
        this.threadMonitorEnabled = other.getThreadMonitorEnabled();
        this.threadMonitorInterval = other.getThreadMonitorInterval();
        this.threadMonitorTimeLimit = other.getThreadMonitorTimeLimit();
        this.statisticSampleRate = other.getStatisticSampleRate();
        this.statisticArchiveFile = other.getStatisticArchiveFile();
        this.ackWaitThreshold = other.getAckWaitThreshold();
        this.ackForceDisconnectThreshold = other.getAckSevereAlertThreshold();
        this.cacheXmlFile = other.getCacheXmlFile();
        this.archiveDiskSpaceLimit = other.getArchiveDiskSpaceLimit();
        this.archiveFileSizeLimit = other.getArchiveFileSizeLimit();
        this.logDiskSpaceLimit = other.getLogDiskSpaceLimit();
        this.logFileSizeLimit = other.getLogFileSizeLimit();
        this.clusterSSLEnabled = other.getClusterSSLEnabled();
        this.clusterSSLProtocols = other.getClusterSSLProtocols();
        this.clusterSSLCiphers = other.getClusterSSLCiphers();
        this.clusterSSLRequireAuthentication = other.getClusterSSLRequireAuthentication();
        this.clusterSSLKeyStore = other.getClusterSSLKeyStore();
        this.clusterSSLKeyStoreType = other.getClusterSSLKeyStoreType();
        this.clusterSSLKeyStorePassword = other.getClusterSSLKeyStorePassword();
        this.clusterSSLTrustStore = other.getClusterSSLTrustStore();
        this.clusterSSLTrustStorePassword = other.getClusterSSLTrustStorePassword();
        this.asyncDistributionTimeout = other.getAsyncDistributionTimeout();
        this.asyncQueueTimeout = other.getAsyncQueueTimeout();
        this.asyncMaxQueueSize = other.getAsyncMaxQueueSize();
        this.modifiable = true;
        this.mcastSendBufferSize = other.getMcastSendBufferSize();
        this.mcastRecvBufferSize = other.getMcastRecvBufferSize();
        this.mcastFlowControl = other.getMcastFlowControl();
        this.udpSendBufferSize = other.getUdpSendBufferSize();
        this.udpRecvBufferSize = other.getUdpRecvBufferSize();
        this.udpFragmentSize = other.getUdpFragmentSize();
        this.disableTcp = other.getDisableTcp();
        this.disableJmx = other.getDisableJmx();
        this.enableTimeStatistics = other.getEnableTimeStatistics();
        this.memberTimeout = other.getMemberTimeout();
        this.membershipPortRange = other.getMembershipPortRange();
        this.maxWaitTimeForReconnect = other.getMaxWaitTimeForReconnect();
        this.maxNumReconnectTries = other.getMaxNumReconnectTries();
        this.clientConflation = other.getClientConflation();
        this.durableClientId = other.getDurableClientId();
        this.durableClientTimeout = other.getDurableClientTimeout();
        this.enableNetworkPartitionDetection = other.getEnableNetworkPartitionDetection();
        this.disableAutoReconnect = other.getDisableAutoReconnect();
        this.securityClientAuthInit = other.getSecurityClientAuthInit();
        this.securityClientAuthenticator = other.getSecurityClientAuthenticator();
        this.securityClientDHAlgo = other.getSecurityClientDHAlgo();
        this.securityUDPDHAlgo = other.getSecurityUDPDHAlgo();
        this.securityPeerAuthInit = other.getSecurityPeerAuthInit();
        this.securityPeerAuthenticator = other.getSecurityPeerAuthenticator();
        this.securityClientAccessor = other.getSecurityClientAccessor();
        this.securityClientAccessorPP = other.getSecurityClientAccessorPP();
        this.securityPeerMembershipTimeout = other.getSecurityPeerMembershipTimeout();
        this.securityLogLevel = other.getSecurityLogLevel();
        this.securityLogFile = other.getSecurityLogFile();
        this.security.putAll((Map<?, ?>)other.getSecurityProps());
        this.removeUnresponsiveClient = other.getRemoveUnresponsiveClient();
        this.deltaPropagation = other.getDeltaPropagation();
        this.distributedSystemId = other.getDistributedSystemId();
        this.redundancyZone = other.getRedundancyZone();
        this.enforceUniqueHost = other.getEnforceUniqueHost();
        this.sslProperties = other.getSSLProperties();
        this.clusterSSLProperties = other.getClusterSSLProperties();
        this.jmxManagerSslProperties = other.getJmxSSLProperties();
        this.userDefinedProps.putAll((Map<?, ?>)other.getUserDefinedProps());
        this.groups = other.getGroups();
        this.jmxManager = other.getJmxManager();
        this.jmxManagerStart = other.getJmxManagerStart();
        this.jmxManagerSSLEnabled = other.getJmxManagerSSLEnabled();
        this.jmxManagerSslRequireAuthentication = other.getJmxManagerSSLRequireAuthentication();
        this.jmxManagerSslProtocols = other.getJmxManagerSSLProtocols();
        this.jmxManagerSslCiphers = other.getJmxManagerSSLCiphers();
        this.jmxManagerSSLKeyStore = other.getJmxManagerSSLKeyStore();
        this.jmxManagerSSLKeyStoreType = other.getJmxManagerSSLKeyStoreType();
        this.jmxManagerSSLKeyStorePassword = other.getJmxManagerSSLKeyStorePassword();
        this.jmxManagerSSLTrustStore = other.getJmxManagerSSLTrustStore();
        this.jmxManagerSSLTrustStorePassword = other.getJmxManagerSSLTrustStorePassword();
        this.jmxManagerSslProperties = other.getJmxSSLProperties();
        this.jmxManagerPort = other.getJmxManagerPort();
        this.jmxManagerBindAddress = other.getJmxManagerBindAddress();
        this.jmxManagerHostnameForClients = other.getJmxManagerHostnameForClients();
        this.jmxManagerPasswordFile = other.getJmxManagerPasswordFile();
        this.jmxManagerAccessFile = other.getJmxManagerAccessFile();
        this.jmxManagerHttpPort = other.getJmxManagerHttpPort();
        this.jmxManagerUpdateRate = other.getJmxManagerUpdateRate();
        this.memcachedPort = other.getMemcachedPort();
        this.memcachedProtocol = other.getMemcachedProtocol();
        this.memcachedBindAddress = other.getMemcachedBindAddress();
        this.redisPort = other.getRedisPort();
        this.redisBindAddress = other.getRedisBindAddress();
        this.redisPassword = other.getRedisPassword();
        this.userCommandPackages = other.getUserCommandPackages();
        this.enableSharedConfiguration = other.getEnableClusterConfiguration();
        this.loadSharedConfigurationFromDir = other.getLoadClusterConfigFromDir();
        this.clusterConfigDir = other.getClusterConfigDir();
        this.useSharedConfiguration = other.getUseSharedConfiguration();
        this.serverSSLEnabled = other.getServerSSLEnabled();
        this.serverSslRequireAuthentication = other.getServerSSLRequireAuthentication();
        this.serverSslProtocols = other.getServerSSLProtocols();
        this.serverSslCiphers = other.getServerSSLCiphers();
        this.serverSSLKeyStore = other.getServerSSLKeyStore();
        this.serverSSLKeyStoreType = other.getServerSSLKeyStoreType();
        this.serverSSLKeyStorePassword = other.getServerSSLKeyStorePassword();
        this.serverSSLTrustStore = other.getServerSSLTrustStore();
        this.serverSSLTrustStorePassword = other.getServerSSLTrustStorePassword();
        this.serverSslProperties = other.getServerSSLProperties();
        this.gatewaySSLEnabled = other.getGatewaySSLEnabled();
        this.gatewaySslRequireAuthentication = other.getGatewaySSLRequireAuthentication();
        this.gatewaySslProtocols = other.getGatewaySSLProtocols();
        this.gatewaySslCiphers = other.getGatewaySSLCiphers();
        this.gatewaySSLKeyStore = other.getGatewaySSLKeyStore();
        this.gatewaySSLKeyStoreType = other.getGatewaySSLKeyStoreType();
        this.gatewaySSLKeyStorePassword = other.getGatewaySSLKeyStorePassword();
        this.gatewaySSLTrustStore = other.getGatewaySSLTrustStore();
        this.gatewaySSLTrustStorePassword = other.getGatewaySSLTrustStorePassword();
        this.gatewaySslProperties = other.getGatewaySSLProperties();
        this.httpServicePort = other.getHttpServicePort();
        this.httpServiceBindAddress = other.getHttpServiceBindAddress();
        this.httpServiceSSLEnabled = other.getHttpServiceSSLEnabled();
        this.httpServiceSSLCiphers = other.getHttpServiceSSLCiphers();
        this.httpServiceSSLProtocols = other.getHttpServiceSSLProtocols();
        this.httpServiceSSLRequireAuthentication = other.getHttpServiceSSLRequireAuthentication();
        this.httpServiceSSLKeyStore = other.getHttpServiceSSLKeyStore();
        this.httpServiceSSLKeyStorePassword = other.getHttpServiceSSLKeyStorePassword();
        this.httpServiceSSLKeyStoreType = other.getHttpServiceSSLKeyStoreType();
        this.httpServiceSSLTrustStore = other.getHttpServiceSSLTrustStore();
        this.httpServiceSSLTrustStorePassword = other.getHttpServiceSSLTrustStorePassword();
        this.httpServiceSSLProperties = other.getHttpServiceSSLProperties();
        this.startDevRestApi = other.getStartDevRestApi();
        this.offHeapMemorySize = other.getOffHeapMemorySize();
        Map<String, ConfigSource> otherSources = ((DistributionConfigImpl)other).sourceMap;
        if (otherSources != null) {
            this.sourceMap = new HashMap<String, ConfigSource>(otherSources);
        }
        this.lockMemory = other.getLockMemory();
        this.distributedTransactions = other.getDistributedTransactions();
        this.shiroInit = other.getShiroInit();
        this.securityManager = other.getSecurityManager();
        this.postProcessor = other.getPostProcessor();
        this.clusterSSLAlias = other.getClusterSSLAlias();
        this.gatewaySSLAlias = other.getGatewaySSLAlias();
        this.httpServiceSSLAlias = other.getHTTPServiceSSLAlias();
        this.jmxManagerSSLAlias = other.getJMXSSLAlias();
        this.serverSSLAlias = other.getServerSSLAlias();
        this.locatorSSLAlias = other.getLocatorSSLAlias();
        this.sslEndPointIdentificationEnabled = other.getSSLEndPointIdentificationEnabled();
        this.securableCommunicationChannels = ((DistributionConfigImpl)other).securableCommunicationChannels;
        this.sslUseDefaultSSLContext = other.getSSLUseDefaultContext();
        this.sslCiphers = other.getSSLCiphers();
        this.sslProtocols = other.getSSLProtocols();
        this.sslRequireAuthentication = other.getSSLRequireAuthentication();
        this.sslKeyStore = other.getSSLKeyStore();
        this.sslKeyStorePassword = other.getSSLKeyStorePassword();
        this.sslKeyStoreType = other.getSSLKeyStoreType();
        this.sslTrustStore = other.getSSLTrustStore();
        this.sslTrustStorePassword = other.getSSLTrustStorePassword();
        this.sslTrustStoreType = other.getSSLTrustStoreType();
        this.sslProperties = other.getSSLProperties();
        this.sslDefaultAlias = other.getSSLDefaultAlias();
        this.sslWebServiceRequireAuthentication = other.getSSLWebRequireAuthentication();
        this.validateSerializableObjects = other.getValidateSerializableObjects();
        this.serializableObjectFilter = other.getSerializableObjectFilter();
    }

    @Override
    protected boolean _modifiableDefault() {
        return this.modifiable;
    }

    private DistributionConfigImpl() {
    }

    public DistributionConfigImpl(Properties nonDefault) {
        this(nonDefault, false, false);
    }

    public DistributionConfigImpl(Properties nonDefault, boolean ignoreGemFirePropsFile) {
        this(nonDefault, ignoreGemFirePropsFile, false);
    }

    public DistributionConfigImpl(Properties nonDefault, boolean ignoreGemFirePropsFile, boolean isConnected) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (!ignoreGemFirePropsFile) {
            props.putAll(this.loadPropertiesFromURL(DistributedSystem.getPropertyFileURL(), false));
        }
        props.putAll(this.loadPropertiesFromURL(DistributedSystem.getSecurityPropertiesFileURL(), true));
        if (nonDefault != null) {
            props.putAll(nonDefault);
            this.setSource(nonDefault, ConfigSource.api());
        }
        for (Map.Entry entry : props.entrySet()) {
            Map.Entry ent = entry;
            if (!((String)ent.getKey()).startsWith("custom-")) continue;
            this.userDefinedProps.put(ent.getKey(), ent.getValue());
        }
        String[] attNames = this.getAttributeNames();
        HashSet<String> attNameSet = new HashSet<String>();
        for (int index = 0; index < attNames.length; ++index) {
            attNameSet.add("gemfire." + attNames[index]);
        }
        for (String key : System.getProperties().stringPropertyNames()) {
            String sysValue;
            if (!attNameSet.contains(key) && !key.startsWith("gemfire.security-") && !key.startsWith("gemfire.javax.net.ssl") || (sysValue = System.getProperty(key)) == null) continue;
            String attName = key.substring("gemfire.".length());
            props.put(attName, sysValue);
            this.sourceMap.put(attName, ConfigSource.sysprop());
        }
        Properties overriddenDefaults = ProcessLauncherContext.getOverriddenDefaults();
        if (!overriddenDefaults.isEmpty()) {
            for (String key : overriddenDefaults.stringPropertyNames()) {
                String property = key.substring("gemfire.default.".length());
                if (props.containsKey(property)) continue;
                props.put(property, overriddenDefaults.getProperty(key));
                this.sourceMap.put(property, ConfigSource.launcher());
            }
        }
        this.initialize(props);
        if (this.securityPeerAuthInit != null && this.securityPeerAuthInit.length() > 0) {
            System.setProperty("gemfire.sys.security-peer-auth-init", this.securityPeerAuthInit);
        }
        if (this.securityPeerAuthenticator != null && this.securityPeerAuthenticator.length() > 0) {
            System.setProperty("gemfire.sys.security-peer-authenticator", this.securityPeerAuthenticator);
        }
        if (!isConnected) {
            this.copySSLPropsToServerSSLProps();
            this.copySSLPropsToJMXSSLProps();
            this.copyClusterSSLPropsToGatewaySSLProps();
            this.copySSLPropsToHTTPSSLProps();
        }
        this.modifiable = true;
        this.validateConfigurationProperties(props);
        this.validateSSLEnabledComponentsConfiguration();
        this.modifiable = false;
    }

    private void validateSSLEnabledComponentsConfiguration() {
        SecurableCommunicationChannel[] sslEnabledComponents;
        Object value = null;
        try {
            Method method = (Method)getters.get("ssl-enabled-components");
            if (method != null) {
                value = method.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking getter for propertyssl-enabled-components");
        }
        for (SecurableCommunicationChannel securableCommunicationChannel : sslEnabledComponents = (SecurableCommunicationChannel[])value) {
            if (this.isAliasCorrectlyConfiguredForComponents(securableCommunicationChannel)) continue;
            throw new IllegalArgumentException("The alias options for the SSL options provided seem to be invalid. Please check that all required aliases are set");
        }
    }

    static DistributionConfig createDefaultInstance() {
        return new DistributionConfigImpl();
    }

    private boolean isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel component) {
        switch (component) {
            case ALL: {
                if (StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias())) {
                    boolean correctAlias = true;
                    correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.CLUSTER);
                    correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.GATEWAY);
                    correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.WEB);
                    correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.JMX);
                    correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.LOCATOR);
                    return correctAlias &= this.isAliasCorrectlyConfiguredForComponents(SecurableCommunicationChannel.SERVER);
                }
            }
            case CLUSTER: {
                return StringUtils.isEmpty((CharSequence)this.getClusterSSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
            case GATEWAY: {
                return StringUtils.isEmpty((CharSequence)this.getGatewaySSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
            case WEB: {
                return StringUtils.isEmpty((CharSequence)this.getHTTPServiceSSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
            case JMX: {
                return StringUtils.isEmpty((CharSequence)this.getJMXSSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
            case LOCATOR: {
                return StringUtils.isEmpty((CharSequence)this.getLocatorSSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
            case SERVER: {
                return StringUtils.isEmpty((CharSequence)this.getServerSSLAlias()) || this.getSecurableCommunicationChannels().length <= 1 || !StringUtils.isEmpty((CharSequence)this.getSSLDefaultAlias());
            }
        }
        return false;
    }

    private void validateConfigurationProperties(Map<Object, Object> props) {
        for (Object o : props.keySet()) {
            String propertyName = (String)o;
            Object value = null;
            try {
                Method method = (Method)getters.get(propertyName);
                if (method != null) {
                    value = method.invoke((Object)this, new Object[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new InternalGemFireException("error invoking getter for property" + propertyName);
            }
            this.checkAttribute(propertyName, value);
        }
    }

    private void copySSLPropsToJMXSSLProps() {
        boolean hasSSLComponents;
        boolean jmxSSLEnabledOverriden = this.sourceMap.get("jmx-manager-ssl-enabled") != null;
        boolean clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        boolean bl = hasSSLComponents = this.sourceMap.get("ssl-enabled-components") != null;
        if (clusterSSLOverRidden && !jmxSSLEnabledOverriden && !hasSSLComponents) {
            this.jmxManagerSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("jmx-manager-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.jmxManagerSslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("jmx-manager-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.jmxManagerSslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("jmx-manager-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.jmxManagerSslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("jmx-manager-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.jmxManagerSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("jmx-manager-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.jmxManagerSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("jmx-manager-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.jmxManagerSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("jmx-manager-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.jmxManagerSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("jmx-manager-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.jmxManagerSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("jmx-manager-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.jmxManagerSslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (jmxSSLEnabledOverriden) {
            if (this.sourceMap.get("jmx-manager-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.jmxManagerSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("jmx-manager-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.jmxManagerSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("jmx-manager-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.jmxManagerSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("jmx-manager-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.jmxManagerSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("jmx-manager-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.jmxManagerSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("jmx-manager-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copySSLPropsToHTTPSSLProps() {
        boolean hasSSLComponents;
        boolean httpServiceSSLEnabledOverriden = this.sourceMap.get("http-service-ssl-enabled") != null;
        boolean clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        boolean bl = hasSSLComponents = this.sourceMap.get("ssl-enabled-components") != null;
        if (clusterSSLOverRidden && !httpServiceSSLEnabledOverriden && !hasSSLComponents) {
            this.httpServiceSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("http-service-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.httpServiceSSLCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("http-service-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.httpServiceSSLProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("http-service-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.httpServiceSSLRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("http-service-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.setHttpServiceSSLKeyStore(this.clusterSSLKeyStore);
                this.sourceMap.put("http-service-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.setHttpServiceSSLKeyStoreType(this.clusterSSLKeyStoreType);
                this.sourceMap.put("http-service-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.setHttpServiceSSLKeyStorePassword(this.clusterSSLKeyStorePassword);
                this.sourceMap.put("http-service-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.setHttpServiceSSLTrustStore(this.clusterSSLTrustStore);
                this.sourceMap.put("http-service-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.setHttpServiceSSLTrustStorePassword(this.clusterSSLTrustStorePassword);
                this.sourceMap.put("http-service-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.httpServiceSSLProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (httpServiceSSLEnabledOverriden) {
            if (this.sourceMap.get("http-service-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.httpServiceSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("http-service-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("http-service-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.httpServiceSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("http-service-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("http-service-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.httpServiceSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("http-service-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("http-service-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.httpServiceSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("http-service-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("http-service-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.httpServiceSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("http-service-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copySSLPropsToServerSSLProps() {
        boolean hasSSLComponents;
        boolean cacheServerSSLOverriden = this.sourceMap.get("server-ssl-enabled") != null;
        boolean clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        boolean bl = hasSSLComponents = this.sourceMap.get("ssl-enabled-components") != null;
        if (clusterSSLOverRidden && !cacheServerSSLOverriden && !hasSSLComponents) {
            this.serverSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("server-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.serverSslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("server-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.serverSslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("server-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.serverSslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("server-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.serverSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("server-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.serverSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("server-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.serverSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("server-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.serverSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("server-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.serverSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("server-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.serverSslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (cacheServerSSLOverriden) {
            if (this.sourceMap.get("server-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.serverSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("server-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("server-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.serverSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("server-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("server-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.serverSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("server-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("server-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.serverSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("server-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("server-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.serverSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("server-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copyClusterSSLPropsToGatewaySSLProps() {
        boolean hasSSLComponents;
        boolean gatewaySSLOverriden = this.sourceMap.get("gateway-ssl-enabled") != null;
        boolean clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        boolean bl = hasSSLComponents = this.sourceMap.get("ssl-enabled-components") != null;
        if (clusterSSLOverRidden && !gatewaySSLOverriden && !hasSSLComponents) {
            this.gatewaySSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("gateway-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.gatewaySslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("gateway-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.gatewaySslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("gateway-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.gatewaySslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("gateway-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.gatewaySSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("gateway-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.gatewaySSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("gateway-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.gatewaySSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("gateway-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.gatewaySSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("gateway-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.gatewaySSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("gateway-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.gatewaySslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (gatewaySSLOverriden) {
            if (this.sourceMap.get("gateway-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.gatewaySSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("gateway-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("gateway-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.gatewaySSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("gateway-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("gateway-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.gatewaySSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("gateway-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("gateway-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.gatewaySSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("gateway-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("gateway-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.gatewaySSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("gateway-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    public static DistributionConfigImpl produce(Properties props) {
        Object o;
        if (props != null && (o = props.get("ds-config")) instanceof DistributionConfigImpl) {
            return (DistributionConfigImpl)o;
        }
        return new DistributionConfigImpl(props, false, false);
    }

    public static DistributionConfigImpl produce(Properties props, boolean isConnected) {
        Object o;
        if (props != null && (o = props.get("ds-config")) instanceof DistributionConfigImpl) {
            return (DistributionConfigImpl)o;
        }
        return new DistributionConfigImpl(props, false, isConnected);
    }

    void setApiProps(Properties apiProps) {
        if (apiProps != null) {
            this.setSource(apiProps, ConfigSource.api());
            this.modifiable = true;
            for (Map.Entry<Object, Object> me : apiProps.entrySet()) {
                String propVal;
                String propName = (String)me.getKey();
                this.props.put(propName, me.getValue());
                if (DistributionConfigImpl.specialPropName(propName) || (propVal = (String)me.getValue()) == null) continue;
                this.setAttribute(propName, propVal.trim(), this.sourceMap.get(propName));
            }
            this.modifiable = false;
        }
    }

    private static boolean specialPropName(String propName) {
        return propName.equalsIgnoreCase("cluster-ssl-enabled") || propName.equals("security-peer-auth-init") || propName.equals("security-peer-authenticator") || propName.equals("log-writer") || propName.equals("ds-config") || propName.equals("security-log-writer") || propName.equals("log-output-stream") || propName.equals("security-log-output-stream");
    }

    @Override
    protected Map<String, ConfigSource> getAttSourceMap() {
        return this.sourceMap;
    }

    @Override
    public Properties getUserDefinedProps() {
        return this.userDefinedProps;
    }

    public static void loadGemFireProperties(Properties properties) throws GemFireIOException {
        DistributionConfigImpl.loadGemFireProperties(properties, false);
    }

    public static void loadGemFireProperties(Properties properties, boolean ignoreGemFirePropsFile) throws GemFireIOException {
        if (!ignoreGemFirePropsFile) {
            DistributionConfigImpl.loadPropertiesFromURL(properties, DistributedSystem.getPropertyFileURL());
        }
        DistributionConfigImpl.loadPropertiesFromURL(properties, DistributedSystem.getSecurityPropertiesFileURL());
    }

    private void setSource(Properties p, ConfigSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Valid ConfigSource must be specified instead of null.");
        }
        for (Object k : p.keySet()) {
            this.sourceMap.put((String)k, source);
        }
    }

    private Properties loadPropertiesFromURL(URL url, boolean secure) {
        Properties result = new Properties();
        DistributionConfigImpl.loadPropertiesFromURL(result, url);
        if (!result.isEmpty()) {
            this.setSource(result, ConfigSource.file(url.toString(), secure));
        }
        return result;
    }

    private static void loadPropertiesFromURL(Properties properties, URL url) {
        if (url != null) {
            try {
                properties.load(url.openStream());
            }
            catch (IOException io) {
                throw new GemFireIOException(String.format("Failed reading %s", url), io);
            }
        }
    }

    private void initialize(Map props) {
        this.modifiable = true;
        this.props = props;
        for (Map.Entry me : props.entrySet()) {
            Object propVal;
            String propName = (String)me.getKey();
            if (DistributionConfigImpl.specialPropName(propName) || !((propVal = me.getValue()) instanceof String)) continue;
            this.setAttribute(propName, ((String)propVal).trim(), this.sourceMap.get(propName));
        }
        if (props.containsKey("cluster-ssl-enabled")) {
            this.setAttribute("cluster-ssl-enabled", (String)props.get("cluster-ssl-enabled"), this.sourceMap.get("cluster-ssl-enabled"));
        }
        if (props.containsKey("security-peer-auth-init")) {
            this.setAttribute("security-peer-auth-init", (String)props.get("security-peer-auth-init"), this.sourceMap.get("security-peer-auth-init"));
        }
        if (props.containsKey("security-peer-authenticator")) {
            this.setAttribute("security-peer-authenticator", (String)props.get("security-peer-authenticator"), this.sourceMap.get("security-peer-authenticator"));
        }
        this.modifiable = false;
    }

    private String convertCommaDelimitedToSpaceDelimitedString(String propVal) {
        return propVal.replace(",", " ");
    }

    @Override
    public void close() {
        Properties properties = System.getProperties();
        properties.remove("gemfire.sys.security-peer-auth-init");
        properties.remove("gemfire.sys.security-peer-authenticator");
        Iterator<Object> iter = this.security.keySet().iterator();
        while (iter.hasNext()) {
            properties.remove(SECURITY_SYSTEM_PREFIX + iter.next());
        }
        System.setProperties(properties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTcpPort() {
        return this.tcpPort;
    }

    @Override
    public int getMcastPort() {
        return this.mcastPort;
    }

    @Override
    public int getMcastTtl() {
        return this.mcastTtl;
    }

    @Override
    public int getSocketLeaseTime() {
        return this.socketLeaseTime;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public boolean getConserveSockets() {
        return this.conserveSockets;
    }

    @Override
    public String getRoles() {
        return this.roles;
    }

    @Override
    public int getMaxWaitTimeForReconnect() {
        return this.maxWaitTimeForReconnect;
    }

    @Override
    public int getMaxNumReconnectTries() {
        return this.maxNumReconnectTries;
    }

    @Override
    public InetAddress getMcastAddress() {
        try {
            return this.mcastAddress;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    @Override
    public String getLocators() {
        if (this.startLocator != null && this.startLocator.length() > 0) {
            String locs = this.locators;
            String startL = this.getStartLocator();
            int comma = startL.indexOf(44);
            if (comma >= 0) {
                startL = startL.substring(0, comma);
            }
            if (locs.length() > 0) {
                if (locs.contains(startL)) {
                    return locs;
                }
                return locs + "," + startL;
            }
            return startL;
        }
        return this.locators;
    }

    @Override
    public String getStartLocator() {
        if (this.startLocatorPort > 0) {
            if (this.bindAddress != null) {
                return this.bindAddress + "[" + this.startLocatorPort + "]";
            }
            try {
                return SocketCreator.getHostName(SocketCreator.getLocalHost()) + "[" + this.startLocatorPort + "]";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.startLocator;
    }

    @Override
    public File getDeployWorkingDir() {
        return this.deployWorkingDir;
    }

    @Override
    public File getLogFile() {
        return this.logFile;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean getStatisticSamplingEnabled() {
        return this.statisticSamplingEnabled;
    }

    @Override
    public int getStatisticSampleRate() {
        return this.statisticSampleRate;
    }

    @Override
    public File getStatisticArchiveFile() {
        return this.statisticArchiveFile;
    }

    @Override
    public int getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    @Override
    public int getAckSevereAlertThreshold() {
        return this.ackForceDisconnectThreshold;
    }

    @Override
    public File getCacheXmlFile() {
        return this.cacheXmlFile;
    }

    @Override
    public boolean getClusterSSLEnabled() {
        return this.clusterSSLEnabled;
    }

    @Override
    public String getClusterSSLProtocols() {
        return this.clusterSSLProtocols;
    }

    @Override
    public String getClusterSSLCiphers() {
        return this.clusterSSLCiphers;
    }

    @Override
    public boolean getClusterSSLRequireAuthentication() {
        return this.clusterSSLRequireAuthentication;
    }

    @Override
    public String getClusterSSLKeyStore() {
        return this.clusterSSLKeyStore;
    }

    @Override
    public String getClusterSSLKeyStoreType() {
        return this.clusterSSLKeyStoreType;
    }

    @Override
    public String getClusterSSLKeyStorePassword() {
        return this.clusterSSLKeyStorePassword;
    }

    @Override
    public String getClusterSSLTrustStore() {
        return this.clusterSSLTrustStore;
    }

    @Override
    public String getClusterSSLTrustStorePassword() {
        return this.clusterSSLTrustStorePassword;
    }

    @Override
    public int getAsyncDistributionTimeout() {
        return this.asyncDistributionTimeout;
    }

    @Override
    public int getAsyncQueueTimeout() {
        return this.asyncQueueTimeout;
    }

    @Override
    public int getAsyncMaxQueueSize() {
        return this.asyncMaxQueueSize;
    }

    @Override
    public String getUserCommandPackages() {
        return this.userCommandPackages;
    }

    @Override
    public int getHttpServicePort() {
        return this.httpServicePort;
    }

    @Override
    public void setHttpServicePort(int value) {
        this.httpServicePort = value;
    }

    @Override
    public String getHttpServiceBindAddress() {
        return this.httpServiceBindAddress;
    }

    @Override
    public void setHttpServiceBindAddress(String value) {
        this.httpServiceBindAddress = value;
    }

    @Override
    public boolean getStartDevRestApi() {
        return this.startDevRestApi;
    }

    @Override
    public void setStartDevRestApi(boolean value) {
        this.startDevRestApi = value;
    }

    @Override
    public void setUserCommandPackages(String value) {
        this.userCommandPackages = value;
    }

    @Override
    public boolean getDeltaPropagation() {
        return this.deltaPropagation;
    }

    @Override
    public void setDeltaPropagation(boolean value) {
        this.deltaPropagation = value;
    }

    @Override
    public void setName(String value) {
        if (value == null) {
            value = "";
        }
        this.name = value;
    }

    @Override
    public void setTcpPort(int value) {
        this.tcpPort = value;
    }

    @Override
    public void setMcastPort(int value) {
        this.mcastPort = value;
    }

    @Override
    public void setMcastTtl(int value) {
        this.mcastTtl = value;
    }

    @Override
    public void setSocketLeaseTime(int value) {
        this.socketLeaseTime = value;
    }

    @Override
    public void setSocketBufferSize(int value) {
        this.socketBufferSize = value;
    }

    @Override
    public void setConserveSockets(boolean newValue) {
        this.conserveSockets = newValue;
    }

    @Override
    public void setRoles(String roles) {
        this.roles = roles;
    }

    @Override
    public void setMaxWaitTimeForReconnect(int timeOut) {
        this.maxWaitTimeForReconnect = timeOut;
    }

    @Override
    public void setMaxNumReconnectTries(int tries) {
        this.maxNumReconnectTries = tries;
    }

    @Override
    public void setMcastAddress(InetAddress value) {
        this.mcastAddress = value;
    }

    @Override
    public void setBindAddress(String value) {
        this.bindAddress = value;
    }

    @Override
    public void setServerBindAddress(String value) {
        this.serverBindAddress = value;
    }

    @Override
    public void setLocators(String value) {
        if (value == null) {
            value = "";
        }
        this.locators = value;
    }

    @Override
    public void setLocatorWaitTime(int seconds) {
        this.locatorWaitTime = seconds;
    }

    @Override
    public int getLocatorWaitTime() {
        return this.locatorWaitTime;
    }

    @Override
    public void setDeployWorkingDir(File value) {
        this.deployWorkingDir = value;
    }

    @Override
    public void setLogFile(File value) {
        this.logFile = value;
    }

    @Override
    public void setLogLevel(int value) {
        this.logLevel = value;
    }

    void unsafeSetLogFile(File value) {
        this.logFile = value;
    }

    @Override
    public void setStartLocator(String value) {
        this.startLocatorPort = 0;
        if (value == null) {
            value = "";
        } else {
            boolean alldigits = true;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isDigit(c)) continue;
                alldigits = false;
                break;
            }
            if (value.length() > 0 && alldigits) {
                try {
                    int port = Integer.parseInt(value);
                    if (port < 0 || port > 65535) {
                        throw new GemFireConfigException("Illegal port specified for start-locator");
                    }
                    this.startLocatorPort = port;
                }
                catch (NumberFormatException e) {
                    throw new GemFireConfigException("Illegal port specified for start-locator", e);
                }
            }
        }
        this.startLocator = value;
    }

    @Override
    public void setStatisticSamplingEnabled(boolean newValue) {
        this.statisticSamplingEnabled = newValue;
    }

    @Override
    public void setStatisticSampleRate(int value) {
        if (value < 1000) {
            InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
            if (ids != null) {
                ids.getLogWriter().info("Setting statistic-sample-rate to 1000 instead of the requested " + value + " because VSD does not work with sub-second sampling.");
            }
            value = 1000;
        }
        this.statisticSampleRate = value;
    }

    @Override
    public void setStatisticArchiveFile(File value) {
        if (value == null) {
            value = new File("");
        }
        this.statisticArchiveFile = value;
    }

    @Override
    public void setCacheXmlFile(File value) {
        this.cacheXmlFile = value;
    }

    @Override
    public void setAckWaitThreshold(int newThreshold) {
        this.ackWaitThreshold = newThreshold;
    }

    @Override
    public void setAckSevereAlertThreshold(int newThreshold) {
        this.ackForceDisconnectThreshold = newThreshold;
    }

    @Override
    public int getArchiveDiskSpaceLimit() {
        return this.archiveDiskSpaceLimit;
    }

    @Override
    public void setArchiveDiskSpaceLimit(int value) {
        this.archiveDiskSpaceLimit = value;
    }

    @Override
    public int getArchiveFileSizeLimit() {
        return this.archiveFileSizeLimit;
    }

    @Override
    public void setArchiveFileSizeLimit(int value) {
        this.archiveFileSizeLimit = value;
    }

    @Override
    public int getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    @Override
    public void setLogDiskSpaceLimit(int value) {
        this.logDiskSpaceLimit = value;
    }

    @Override
    public int getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    @Override
    public void setLogFileSizeLimit(int value) {
        this.logFileSizeLimit = value;
    }

    @Override
    public void setClusterSSLEnabled(boolean enabled) {
        this.clusterSSLEnabled = enabled;
    }

    @Override
    public void setClusterSSLProtocols(String protocols) {
        this.clusterSSLProtocols = protocols;
    }

    @Override
    public void setClusterSSLCiphers(String ciphers) {
        this.clusterSSLCiphers = ciphers;
    }

    @Override
    public void setClusterSSLRequireAuthentication(boolean enabled) {
        this.clusterSSLRequireAuthentication = enabled;
    }

    @Override
    public void setClusterSSLKeyStore(String keyStore) {
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStore", keyStore);
        this.clusterSSLKeyStore = keyStore;
    }

    @Override
    public void setClusterSSLKeyStoreType(String keyStoreType) {
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        this.clusterSSLKeyStoreType = keyStoreType;
    }

    @Override
    public void setClusterSSLKeyStorePassword(String keyStorePassword) {
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.clusterSSLKeyStorePassword = keyStorePassword;
    }

    @Override
    public void setClusterSSLTrustStore(String trustStore) {
        this.getClusterSSLProperties().setProperty("javax.net.ssl.trustStore", trustStore);
        this.clusterSSLTrustStore = trustStore;
    }

    @Override
    public void setClusterSSLTrustStorePassword(String trusStorePassword) {
        this.getClusterSSLProperties().setProperty("javax.net.ssl.trustStorePassword", trusStorePassword);
        this.clusterSSLTrustStorePassword = trusStorePassword;
    }

    @Override
    public int getMcastSendBufferSize() {
        return this.mcastSendBufferSize;
    }

    @Override
    public void setMcastSendBufferSize(int value) {
        this.mcastSendBufferSize = value;
    }

    @Override
    public int getMcastRecvBufferSize() {
        return this.mcastRecvBufferSize;
    }

    @Override
    public void setMcastRecvBufferSize(int value) {
        this.mcastRecvBufferSize = value;
    }

    @Override
    public void setAsyncDistributionTimeout(int newValue) {
        this.asyncDistributionTimeout = newValue;
    }

    @Override
    public void setAsyncQueueTimeout(int newValue) {
        this.asyncQueueTimeout = newValue;
    }

    @Override
    public void setAsyncMaxQueueSize(int newValue) {
        this.asyncMaxQueueSize = newValue;
    }

    @Override
    public FlowControlParams getMcastFlowControl() {
        return this.mcastFlowControl;
    }

    @Override
    public void setMcastFlowControl(FlowControlParams values) {
        this.mcastFlowControl = values;
    }

    @Override
    public int getUdpFragmentSize() {
        return this.udpFragmentSize;
    }

    @Override
    public void setUdpFragmentSize(int value) {
        this.udpFragmentSize = value;
    }

    @Override
    public int getUdpSendBufferSize() {
        return this.udpSendBufferSize;
    }

    @Override
    public void setUdpSendBufferSize(int value) {
        this.udpSendBufferSize = value;
    }

    @Override
    public int getUdpRecvBufferSize() {
        return this.udpRecvBufferSize;
    }

    @Override
    public void setUdpRecvBufferSize(int value) {
        this.udpRecvBufferSize = value;
    }

    @Override
    public boolean getDisableTcp() {
        return this.disableTcp;
    }

    @Override
    public void setDisableTcp(boolean newValue) {
        this.disableTcp = newValue;
    }

    @Override
    public boolean getDisableJmx() {
        return this.disableJmx;
    }

    @Override
    public void setDisableJmx(boolean newValue) {
        this.disableJmx = newValue;
    }

    @Override
    public boolean getEnableTimeStatistics() {
        return this.enableTimeStatistics;
    }

    @Override
    public void setEnableTimeStatistics(boolean newValue) {
        this.enableTimeStatistics = newValue;
    }

    @Override
    public int getMemberTimeout() {
        return this.memberTimeout;
    }

    @Override
    public void setMemberTimeout(int value) {
        this.memberTimeout = value;
    }

    @Override
    public String getClientConflation() {
        return this.clientConflation;
    }

    @Override
    public void setClientConflation(String clientConflation) {
        this.clientConflation = clientConflation;
    }

    @Override
    public String getDurableClientId() {
        return this.durableClientId;
    }

    @Override
    public void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    @Override
    public int getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    @Override
    public void setDurableClientTimeout(int durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    @Override
    public String getSecurityClientAuthInit() {
        return this.securityClientAuthInit;
    }

    @Override
    public void setSecurityClientAuthInit(String attValue) {
        this.securityClientAuthInit = attValue;
    }

    @Override
    public String getSecurityClientAuthenticator() {
        return this.securityClientAuthenticator;
    }

    @Override
    public String getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public String getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    @Override
    public void setEnableNetworkPartitionDetection(boolean newValue) {
        this.enableNetworkPartitionDetection = newValue;
    }

    @Override
    public boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    @Override
    public void setDisableAutoReconnect(boolean value) {
        this.disableAutoReconnect = value;
    }

    @Override
    public void setSecurityClientAuthenticator(String attValue) {
        this.securityClientAuthenticator = attValue;
    }

    @Override
    public void setSecurityManager(String attValue) {
        this.securityManager = attValue;
    }

    @Override
    public void setPostProcessor(String attValue) {
        this.postProcessor = attValue;
    }

    @Override
    public String getSecurityClientDHAlgo() {
        return this.securityClientDHAlgo;
    }

    @Override
    public void setSecurityClientDHAlgo(String attValue) {
        this.securityClientDHAlgo = attValue;
    }

    @Override
    public String getSecurityUDPDHAlgo() {
        return this.securityUDPDHAlgo;
    }

    @Override
    public void setSecurityUDPDHAlgo(String attValue) {
        this.securityUDPDHAlgo = (String)this.checkAttribute("security-udp-dhalgo", attValue);
    }

    @Override
    public String getSecurityPeerAuthInit() {
        return this.securityPeerAuthInit;
    }

    @Override
    public void setSecurityPeerAuthInit(String attValue) {
        this.securityPeerAuthInit = attValue;
    }

    @Override
    public String getSecurityPeerAuthenticator() {
        return this.securityPeerAuthenticator;
    }

    @Override
    public void setSecurityPeerAuthenticator(String attValue) {
        this.securityPeerAuthenticator = attValue;
    }

    @Override
    public String getSecurityClientAccessor() {
        return this.securityClientAccessor;
    }

    @Override
    public void setSecurityClientAccessor(String attValue) {
        this.securityClientAccessor = attValue;
    }

    @Override
    public String getSecurityClientAccessorPP() {
        return this.securityClientAccessorPP;
    }

    @Override
    public void setSecurityClientAccessorPP(String attValue) {
        this.securityClientAccessorPP = attValue;
    }

    @Override
    public int getSecurityLogLevel() {
        return this.securityLogLevel;
    }

    @Override
    public void setSecurityLogLevel(int level) {
        this.securityLogLevel = level;
    }

    @Override
    public File getSecurityLogFile() {
        return this.securityLogFile;
    }

    @Override
    public void setSecurityLogFile(File value) {
        this.securityLogFile = value;
    }

    @Override
    public int getSecurityPeerMembershipTimeout() {
        return this.securityPeerMembershipTimeout;
    }

    @Override
    public void setSecurityPeerMembershipTimeout(int attValue) {
        this.securityPeerMembershipTimeout = attValue;
    }

    @Override
    public Properties getSecurityProps() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.security);
        return result;
    }

    @Override
    public Properties toSecurityProperties() {
        Properties result = new Properties();
        for (Object attName : this.security.keySet()) {
            if (attName instanceof String) {
                result.put(attName, this.getAttribute((String)attName));
                continue;
            }
            result.put(attName, this.security.get(attName));
        }
        return result;
    }

    @Override
    public String getSecurity(String attName) {
        String attValue = this.security.getProperty(attName);
        return attValue == null ? "" : attValue;
    }

    @Override
    public void setSecurity(String attName, String attValue) {
        this.security.setProperty(attName, attValue);
    }

    @Override
    public boolean getRemoveUnresponsiveClient() {
        return this.removeUnresponsiveClient;
    }

    @Override
    public void setRemoveUnresponsiveClient(boolean value) {
        this.removeUnresponsiveClient = value;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    @Override
    public void setDistributedSystemId(int distributedSystemId) {
        this.distributedSystemId = distributedSystemId;
    }

    @Override
    public boolean getEnforceUniqueHost() {
        return this.enforceUniqueHost;
    }

    @Override
    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    @Override
    public void setEnforceUniqueHost(boolean enforceUniqueHost) {
        this.enforceUniqueHost = enforceUniqueHost;
    }

    @Override
    public void setRedundancyZone(String redundancyZone) {
        this.redundancyZone = redundancyZone;
    }

    @Override
    public void setSSLProperty(String attName, String attValue) {
        if (attName.startsWith("sysprop-")) {
            attName = attName.substring("sysprop-".length());
        }
        if (attName.endsWith("-jmx")) {
            this.jmxManagerSslProperties.setProperty(attName.substring(0, attName.length() - "-jmx".length()), attValue);
        } else {
            this.sslProperties.setProperty(attName, attValue);
            if (!this.jmxManagerSslProperties.containsKey(attName)) {
                this.jmxManagerSslProperties.setProperty(attName, attValue);
            }
            if (!this.serverSslProperties.containsKey(attName)) {
                this.serverSslProperties.setProperty(attName, attValue);
            }
            if (!this.gatewaySslProperties.containsKey(attName)) {
                this.gatewaySslProperties.setProperty(attName, attValue);
            }
            if (!this.httpServiceSSLProperties.containsKey(attName)) {
                this.httpServiceSSLProperties.setProperty(attName, attValue);
            }
            if (!this.clusterSSLProperties.containsKey(attName)) {
                this.clusterSSLProperties.setProperty(attName, attValue);
            }
        }
    }

    @Override
    public Properties getSSLProperties() {
        return this.sslProperties;
    }

    @Override
    public Properties getClusterSSLProperties() {
        return this.clusterSSLProperties;
    }

    @Override
    public Properties getJmxSSLProperties() {
        return this.jmxManagerSslProperties;
    }

    @Override
    public String getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(String value) {
        if (value == null) {
            value = "";
        }
        this.groups = value;
    }

    @Override
    public boolean getJmxManager() {
        return this.jmxManager;
    }

    @Override
    public void setJmxManager(boolean value) {
        this.jmxManager = value;
    }

    @Override
    public boolean getJmxManagerStart() {
        return this.jmxManagerStart;
    }

    @Override
    public void setJmxManagerStart(boolean value) {
        this.jmxManagerStart = value;
    }

    @Override
    public boolean getJmxManagerSSLEnabled() {
        return this.jmxManagerSSLEnabled;
    }

    @Override
    public void setJmxManagerSSLEnabled(boolean enabled) {
        this.jmxManagerSSLEnabled = enabled;
    }

    @Override
    public boolean getJmxManagerSSLRequireAuthentication() {
        return this.jmxManagerSslRequireAuthentication;
    }

    @Override
    public void setJmxManagerSSLRequireAuthentication(boolean enabled) {
        this.jmxManagerSslRequireAuthentication = enabled;
    }

    @Override
    public String getJmxManagerSSLProtocols() {
        return this.jmxManagerSslProtocols;
    }

    @Override
    public void setJmxManagerSSLProtocols(String protocols) {
        this.jmxManagerSslProtocols = protocols;
    }

    @Override
    public String getJmxManagerSSLCiphers() {
        return this.jmxManagerSslCiphers;
    }

    @Override
    public void setJmxManagerSSLCiphers(String ciphers) {
        this.jmxManagerSslCiphers = ciphers;
    }

    @Override
    public void setJmxManagerSSLKeyStore(String keyStore) {
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStore", keyStore);
        this.jmxManagerSSLKeyStore = keyStore;
    }

    @Override
    public void setJmxManagerSSLKeyStoreType(String keyStoreType) {
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        this.jmxManagerSSLKeyStoreType = keyStoreType;
    }

    @Override
    public void setJmxManagerSSLKeyStorePassword(String keyStorePassword) {
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.jmxManagerSSLKeyStorePassword = keyStorePassword;
    }

    @Override
    public void setJmxManagerSSLTrustStore(String trustStore) {
        this.getJmxSSLProperties().setProperty("javax.net.ssl.trustStore", trustStore);
        this.jmxManagerSSLTrustStore = trustStore;
    }

    @Override
    public void setJmxManagerSSLTrustStorePassword(String trusStorePassword) {
        this.getJmxSSLProperties().setProperty("javax.net.ssl.trustStorePassword", trusStorePassword);
        this.jmxManagerSSLTrustStorePassword = trusStorePassword;
    }

    @Override
    public String getJmxManagerSSLKeyStore() {
        return this.jmxManagerSSLKeyStore;
    }

    @Override
    public String getJmxManagerSSLKeyStoreType() {
        return this.jmxManagerSSLKeyStoreType;
    }

    @Override
    public String getJmxManagerSSLKeyStorePassword() {
        return this.jmxManagerSSLKeyStorePassword;
    }

    @Override
    public String getJmxManagerSSLTrustStore() {
        return this.jmxManagerSSLTrustStore;
    }

    @Override
    public String getJmxManagerSSLTrustStorePassword() {
        return this.jmxManagerSSLTrustStorePassword;
    }

    @Override
    public int getJmxManagerPort() {
        return this.jmxManagerPort;
    }

    @Override
    public void setJmxManagerPort(int value) {
        this.jmxManagerPort = value;
    }

    @Override
    public String getJmxManagerBindAddress() {
        return this.jmxManagerBindAddress;
    }

    @Override
    public void setJmxManagerBindAddress(String value) {
        if (value == null) {
            value = "";
        }
        this.jmxManagerBindAddress = value;
    }

    @Override
    public String getJmxManagerHostnameForClients() {
        return this.jmxManagerHostnameForClients;
    }

    @Override
    public void setJmxManagerHostnameForClients(String value) {
        if (value == null) {
            value = "";
        }
        this.jmxManagerHostnameForClients = value;
    }

    @Override
    public String getJmxManagerPasswordFile() {
        return this.jmxManagerPasswordFile;
    }

    @Override
    public void setJmxManagerPasswordFile(String value) {
        if (value == null) {
            value = "";
        }
        this.jmxManagerPasswordFile = value;
    }

    @Override
    public String getJmxManagerAccessFile() {
        return this.jmxManagerAccessFile;
    }

    @Override
    public void setJmxManagerAccessFile(String value) {
        if (value == null) {
            value = "";
        }
        this.jmxManagerAccessFile = value;
    }

    @Override
    public int getJmxManagerHttpPort() {
        return this.getHttpServicePort();
    }

    @Override
    public void setJmxManagerHttpPort(int value) {
        this.setHttpServicePort(value);
    }

    @Override
    public int getJmxManagerUpdateRate() {
        return this.jmxManagerUpdateRate;
    }

    @Override
    public void setJmxManagerUpdateRate(int value) {
        this.jmxManagerUpdateRate = value;
    }

    @Override
    public boolean getLockMemory() {
        return this.lockMemory;
    }

    @Override
    public void setLockMemory(boolean value) {
        this.lockMemory = value;
    }

    @Override
    public void setShiroInit(String value) {
        this.shiroInit = value;
    }

    @Override
    public String getShiroInit() {
        return this.shiroInit;
    }

    @Override
    public String getClusterSSLAlias() {
        return this.clusterSSLAlias;
    }

    @Override
    public void setClusterSSLAlias(String alias) {
        this.clusterSSLAlias = alias;
    }

    @Override
    public String getLocatorSSLAlias() {
        return this.locatorSSLAlias;
    }

    @Override
    public void setLocatorSSLAlias(String alias) {
        this.locatorSSLAlias = alias;
    }

    @Override
    public String getGatewaySSLAlias() {
        return this.gatewaySSLAlias;
    }

    @Override
    public void setGatewaySSLAlias(String alias) {
        this.gatewaySSLAlias = alias;
    }

    @Override
    public String getHTTPServiceSSLAlias() {
        return this.httpServiceSSLAlias;
    }

    @Override
    public void setHTTPServiceSSLAlias(String alias) {
        this.httpServiceSSLAlias = alias;
    }

    @Override
    public String getJMXSSLAlias() {
        return this.jmxManagerSSLAlias;
    }

    @Override
    public void setJMXSSLAlias(String alias) {
        this.jmxManagerSSLAlias = alias;
    }

    @Override
    public String getServerSSLAlias() {
        return this.serverSSLAlias;
    }

    @Override
    public void setServerSSLAlias(String alias) {
        this.serverSSLAlias = alias;
    }

    @Override
    public boolean getSSLEndPointIdentificationEnabled() {
        if (this.sslEndPointIdentificationEnabled == null) {
            return false;
        }
        return this.sslEndPointIdentificationEnabled;
    }

    @Override
    public void setSSLEndPointIdentificationEnabled(boolean sslEndPointIdentificationEnabled) {
        this.sslEndPointIdentificationEnabled = sslEndPointIdentificationEnabled;
    }

    @Override
    public SecurableCommunicationChannel[] getSecurableCommunicationChannels() {
        return this.securableCommunicationChannels;
    }

    @Override
    public void setSecurableCommunicationChannels(SecurableCommunicationChannel[] sslEnabledComponents) {
        this.securableCommunicationChannels = sslEnabledComponents;
    }

    @Override
    public boolean getSSLUseDefaultContext() {
        return this.sslUseDefaultSSLContext;
    }

    @Override
    public void setSSLUseDefaultContext(boolean sslUseDefaultSSLContext) {
        if (this.sslEndPointIdentificationEnabled == null) {
            this.sslEndPointIdentificationEnabled = Boolean.TRUE;
        }
        this.sslUseDefaultSSLContext = sslUseDefaultSSLContext;
    }

    @Override
    public String getSSLProtocols() {
        return this.sslProtocols;
    }

    @Override
    public void setSSLProtocols(String protocols) {
        this.sslProtocols = this.convertCommaDelimitedToSpaceDelimitedString(protocols);
    }

    @Override
    public String getSSLCiphers() {
        return this.sslCiphers;
    }

    @Override
    public void setSSLCiphers(String ciphers) {
        this.sslCiphers = this.convertCommaDelimitedToSpaceDelimitedString(ciphers);
    }

    @Override
    public boolean getSSLRequireAuthentication() {
        return this.sslRequireAuthentication;
    }

    @Override
    public void setSSLRequireAuthentication(boolean enabled) {
        this.sslRequireAuthentication = enabled;
    }

    @Override
    public String getSSLKeyStore() {
        return this.sslKeyStore;
    }

    @Override
    public void setSSLKeyStore(String keyStore) {
        this.sslKeyStore = keyStore;
    }

    @Override
    public String getSSLKeyStoreType() {
        return this.sslKeyStoreType;
    }

    @Override
    public void setSSLKeyStoreType(String keyStoreType) {
        this.sslKeyStoreType = keyStoreType;
    }

    @Override
    public String getSSLKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    @Override
    public void setSSLKeyStorePassword(String keyStorePassword) {
        this.sslKeyStorePassword = keyStorePassword;
    }

    @Override
    public String getSSLTrustStore() {
        return this.sslTrustStore;
    }

    @Override
    public void setSSLTrustStore(String trustStore) {
        this.sslTrustStore = trustStore;
    }

    @Override
    public String getSSLDefaultAlias() {
        return this.sslDefaultAlias;
    }

    @Override
    public void setSSLDefaultAlias(String sslDefaultAlias) {
        this.sslDefaultAlias = sslDefaultAlias;
    }

    @Override
    public String getSSLTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    @Override
    public void setSSLTrustStorePassword(String trustStorePassword) {
        this.sslTrustStorePassword = trustStorePassword;
    }

    @Override
    public String getSSLTrustStoreType() {
        return this.sslTrustStoreType;
    }

    @Override
    public void setSSLTrustStoreType(String trustStoreType) {
        this.sslTrustStoreType = trustStoreType;
    }

    @Override
    public boolean getSSLWebRequireAuthentication() {
        return this.sslWebServiceRequireAuthentication;
    }

    @Override
    public void setSSLWebRequireAuthentication(boolean requiresAuthentication) {
        this.sslWebServiceRequireAuthentication = requiresAuthentication;
    }

    @Override
    public boolean getValidateSerializableObjects() {
        return this.validateSerializableObjects;
    }

    @Override
    public void setValidateSerializableObjects(boolean value) {
        this.validateSerializableObjects = value;
    }

    @Override
    public String getSerializableObjectFilter() {
        return this.serializableObjectFilter;
    }

    @Override
    public void setSerializableObjectFilter(String value) {
        this.serializableObjectFilter = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DistributionConfigImpl that = (DistributionConfigImpl)obj;
        return new EqualsBuilder().append(this.tcpPort, that.tcpPort).append(this.mcastPort, that.mcastPort).append(this.mcastTtl, that.mcastTtl).append(this.socketLeaseTime, that.socketLeaseTime).append(this.socketBufferSize, that.socketBufferSize).append(this.conserveSockets, that.conserveSockets).append(this.locatorWaitTime, that.locatorWaitTime).append(this.logLevel, that.logLevel).append(this.startLocatorPort, that.startLocatorPort).append(this.statisticSamplingEnabled, that.statisticSamplingEnabled).append(this.statisticSampleRate, that.statisticSampleRate).append(this.ackWaitThreshold, that.ackWaitThreshold).append(this.ackForceDisconnectThreshold, that.ackForceDisconnectThreshold).append(this.archiveDiskSpaceLimit, that.archiveDiskSpaceLimit).append(this.archiveFileSizeLimit, that.archiveFileSizeLimit).append(this.logDiskSpaceLimit, that.logDiskSpaceLimit).append(this.logFileSizeLimit, that.logFileSizeLimit).append(this.clusterSSLEnabled, that.clusterSSLEnabled).append(this.clusterSSLRequireAuthentication, that.clusterSSLRequireAuthentication).append(this.mcastSendBufferSize, that.mcastSendBufferSize).append(this.mcastRecvBufferSize, that.mcastRecvBufferSize).append(this.udpSendBufferSize, that.udpSendBufferSize).append(this.udpRecvBufferSize, that.udpRecvBufferSize).append(this.udpFragmentSize, that.udpFragmentSize).append(this.disableTcp, that.disableTcp).append(this.disableJmx, that.disableJmx).append(this.enableTimeStatistics, that.enableTimeStatistics).append(this.memberTimeout, that.memberTimeout).append(this.maxWaitTimeForReconnect, that.maxWaitTimeForReconnect).append(this.maxNumReconnectTries, that.maxNumReconnectTries).append(this.asyncDistributionTimeout, that.asyncDistributionTimeout).append(this.asyncQueueTimeout, that.asyncQueueTimeout).append(this.asyncMaxQueueSize, that.asyncMaxQueueSize).append(this.durableClientTimeout, that.durableClientTimeout).append(this.securityLogLevel, that.securityLogLevel).append(this.enableNetworkPartitionDetection, that.enableNetworkPartitionDetection).append(this.disableAutoReconnect, that.disableAutoReconnect).append(this.securityPeerMembershipTimeout, that.securityPeerMembershipTimeout).append(this.removeUnresponsiveClient, that.removeUnresponsiveClient).append(this.deltaPropagation, that.deltaPropagation).append(this.distributedSystemId, that.distributedSystemId).append(this.enforceUniqueHost, that.enforceUniqueHost).append(this.enableSharedConfiguration, that.enableSharedConfiguration).append(this.useSharedConfiguration, that.useSharedConfiguration).append(this.loadSharedConfigurationFromDir, that.loadSharedConfigurationFromDir).append(this.httpServicePort, that.httpServicePort).append(this.startDevRestApi, that.startDevRestApi).append(this.memcachedPort, that.memcachedPort).append(this.distributedTransactions, that.distributedTransactions).append(this.redisPort, that.redisPort).append(this.jmxManager, that.jmxManager).append(this.jmxManagerStart, that.jmxManagerStart).append(this.jmxManagerPort, that.jmxManagerPort).append(this.jmxManagerHttpPort, that.jmxManagerHttpPort).append(this.jmxManagerUpdateRate, that.jmxManagerUpdateRate).append(this.jmxManagerSSLEnabled, that.jmxManagerSSLEnabled).append(this.jmxManagerSslRequireAuthentication, that.jmxManagerSslRequireAuthentication).append(this.serverSSLEnabled, that.serverSSLEnabled).append(this.serverSslRequireAuthentication, that.serverSslRequireAuthentication).append(this.gatewaySSLEnabled, that.gatewaySSLEnabled).append(this.gatewaySslRequireAuthentication, that.gatewaySslRequireAuthentication).append(this.httpServiceSSLEnabled, that.httpServiceSSLEnabled).append(this.httpServiceSSLRequireAuthentication, that.httpServiceSSLRequireAuthentication).append(this.sslRequireAuthentication, that.sslRequireAuthentication).append(this.sslWebServiceRequireAuthentication, that.sslWebServiceRequireAuthentication).append(this.lockMemory, that.lockMemory).append(this.modifiable, that.modifiable).append((Object)this.name, (Object)that.name).append((Object)this.roles, (Object)that.roles).append((Object)this.mcastAddress, (Object)that.mcastAddress).append((Object)this.bindAddress, (Object)that.bindAddress).append((Object)this.serverBindAddress, (Object)that.serverBindAddress).append((Object)this.locators, (Object)that.locators).append((Object)this.logFile, (Object)that.logFile).append((Object)this.deployWorkingDir, (Object)that.deployWorkingDir).append((Object)this.startLocator, (Object)that.startLocator).append((Object)this.statisticArchiveFile, (Object)that.statisticArchiveFile).append((Object)this.cacheXmlFile, (Object)that.cacheXmlFile).append((Object)this.clusterSSLProtocols, (Object)that.clusterSSLProtocols).append((Object)this.clusterSSLCiphers, (Object)that.clusterSSLCiphers).append((Object)this.clusterSSLKeyStore, (Object)that.clusterSSLKeyStore).append((Object)this.clusterSSLKeyStoreType, (Object)that.clusterSSLKeyStoreType).append((Object)this.clusterSSLKeyStorePassword, (Object)that.clusterSSLKeyStorePassword).append((Object)this.clusterSSLTrustStore, (Object)that.clusterSSLTrustStore).append((Object)this.clusterSSLTrustStorePassword, (Object)that.clusterSSLTrustStorePassword).append((Object)this.clusterSSLAlias, (Object)that.clusterSSLAlias).append((Object)this.mcastFlowControl, (Object)that.mcastFlowControl).append(this.membershipPortRange, that.membershipPortRange).append((Object)this.clientConflation, (Object)that.clientConflation).append((Object)this.durableClientId, (Object)that.durableClientId).append((Object)this.securityClientAuthInit, (Object)that.securityClientAuthInit).append((Object)this.securityClientAuthenticator, (Object)that.securityClientAuthenticator).append((Object)this.securityManager, (Object)that.securityManager).append((Object)this.postProcessor, (Object)that.postProcessor).append((Object)this.securityClientDHAlgo, (Object)that.securityClientDHAlgo).append((Object)this.securityPeerAuthInit, (Object)that.securityPeerAuthInit).append((Object)this.securityPeerAuthenticator, (Object)that.securityPeerAuthenticator).append((Object)this.securityClientAccessor, (Object)that.securityClientAccessor).append((Object)this.securityClientAccessorPP, (Object)that.securityClientAccessorPP).append((Object)this.securityLogFile, (Object)that.securityLogFile).append((Object)this.security, (Object)that.security).append((Object)this.userDefinedProps, (Object)that.userDefinedProps).append((Object)this.props, (Object)that.props).append((Object)this.remoteLocators, (Object)that.remoteLocators).append((Object)this.redundancyZone, (Object)that.redundancyZone).append((Object)this.sslProperties, (Object)that.sslProperties).append((Object)this.clusterSSLProperties, (Object)that.clusterSSLProperties).append((Object)this.groups, (Object)that.groups).append((Object)this.clusterConfigDir, (Object)that.clusterConfigDir).append((Object)this.httpServiceBindAddress, (Object)that.httpServiceBindAddress).append((Object)this.memcachedProtocol, (Object)that.memcachedProtocol).append((Object)this.memcachedBindAddress, (Object)that.memcachedBindAddress).append((Object)this.redisBindAddress, (Object)that.redisBindAddress).append((Object)this.redisPassword, (Object)that.redisPassword).append((Object)this.jmxManagerBindAddress, (Object)that.jmxManagerBindAddress).append((Object)this.jmxManagerHostnameForClients, (Object)that.jmxManagerHostnameForClients).append((Object)this.jmxManagerPasswordFile, (Object)that.jmxManagerPasswordFile).append((Object)this.jmxManagerAccessFile, (Object)that.jmxManagerAccessFile).append((Object)this.jmxManagerSslProtocols, (Object)that.jmxManagerSslProtocols).append((Object)this.jmxManagerSslCiphers, (Object)that.jmxManagerSslCiphers).append((Object)this.jmxManagerSslProperties, (Object)that.jmxManagerSslProperties).append((Object)this.jmxManagerSSLKeyStore, (Object)that.jmxManagerSSLKeyStore).append((Object)this.jmxManagerSSLKeyStoreType, (Object)that.jmxManagerSSLKeyStoreType).append((Object)this.jmxManagerSSLKeyStorePassword, (Object)that.jmxManagerSSLKeyStorePassword).append((Object)this.jmxManagerSSLTrustStore, (Object)that.jmxManagerSSLTrustStore).append((Object)this.jmxManagerSSLTrustStorePassword, (Object)that.jmxManagerSSLTrustStorePassword).append((Object)this.jmxManagerSSLAlias, (Object)that.jmxManagerSSLAlias).append((Object)this.serverSslProtocols, (Object)that.serverSslProtocols).append((Object)this.serverSslCiphers, (Object)that.serverSslCiphers).append((Object)this.serverSslProperties, (Object)that.serverSslProperties).append((Object)this.serverSSLKeyStore, (Object)that.serverSSLKeyStore).append((Object)this.serverSSLKeyStoreType, (Object)that.serverSSLKeyStoreType).append((Object)this.serverSSLKeyStorePassword, (Object)that.serverSSLKeyStorePassword).append((Object)this.serverSSLTrustStore, (Object)that.serverSSLTrustStore).append((Object)this.serverSSLTrustStorePassword, (Object)that.serverSSLTrustStorePassword).append((Object)this.serverSSLAlias, (Object)that.serverSSLAlias).append((Object)this.gatewaySslProtocols, (Object)that.gatewaySslProtocols).append((Object)this.gatewaySslCiphers, (Object)that.gatewaySslCiphers).append((Object)this.gatewaySslProperties, (Object)that.gatewaySslProperties).append((Object)this.gatewaySSLKeyStore, (Object)that.gatewaySSLKeyStore).append((Object)this.gatewaySSLKeyStoreType, (Object)that.gatewaySSLKeyStoreType).append((Object)this.gatewaySSLKeyStorePassword, (Object)that.gatewaySSLKeyStorePassword).append((Object)this.gatewaySSLTrustStore, (Object)that.gatewaySSLTrustStore).append((Object)this.gatewaySSLTrustStorePassword, (Object)that.gatewaySSLTrustStorePassword).append((Object)this.gatewaySSLAlias, (Object)that.gatewaySSLAlias).append((Object)this.httpServiceSSLProtocols, (Object)that.httpServiceSSLProtocols).append((Object)this.httpServiceSSLCiphers, (Object)that.httpServiceSSLCiphers).append((Object)this.httpServiceSSLProperties, (Object)that.httpServiceSSLProperties).append((Object)this.httpServiceSSLKeyStore, (Object)that.httpServiceSSLKeyStore).append((Object)this.httpServiceSSLKeyStoreType, (Object)that.httpServiceSSLKeyStoreType).append((Object)this.httpServiceSSLKeyStorePassword, (Object)that.httpServiceSSLKeyStorePassword).append((Object)this.httpServiceSSLTrustStore, (Object)that.httpServiceSSLTrustStore).append((Object)this.httpServiceSSLTrustStorePassword, (Object)that.httpServiceSSLTrustStorePassword).append((Object)this.httpServiceSSLAlias, (Object)that.httpServiceSSLAlias).append((Object[])this.securableCommunicationChannels, (Object[])that.securableCommunicationChannels).append((Object)this.sslProtocols, (Object)that.sslProtocols).append((Object)this.sslCiphers, (Object)that.sslCiphers).append((Object)this.sslKeyStore, (Object)that.sslKeyStore).append((Object)this.sslKeyStoreType, (Object)that.sslKeyStoreType).append((Object)this.sslKeyStorePassword, (Object)that.sslKeyStorePassword).append((Object)this.sslTrustStore, (Object)that.sslTrustStore).append((Object)this.sslTrustStorePassword, (Object)that.sslTrustStorePassword).append((Object)this.locatorSSLAlias, (Object)that.locatorSSLAlias).append((Object)this.sslDefaultAlias, (Object)that.sslDefaultAlias).append(this.sourceMap, that.sourceMap).append((Object)this.userCommandPackages, (Object)that.userCommandPackages).append((Object)this.offHeapMemorySize, (Object)that.offHeapMemorySize).append((Object)this.shiroInit, (Object)that.shiroInit).append(this.threadMonitorEnabled, that.threadMonitorEnabled).append(this.threadMonitorInterval, that.threadMonitorInterval).append(this.threadMonitorTimeLimit, that.threadMonitorTimeLimit).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.tcpPort).append(this.mcastPort).append(this.mcastTtl).append(this.socketLeaseTime).append(this.socketBufferSize).append(this.conserveSockets).append((Object)this.roles).append((Object)this.mcastAddress).append((Object)this.bindAddress).append((Object)this.serverBindAddress).append((Object)this.locators).append(this.locatorWaitTime).append((Object)this.logFile).append((Object)this.deployWorkingDir).append(this.logLevel).append((Object)this.startLocator).append(this.startLocatorPort).append(this.statisticSamplingEnabled).append(this.statisticSampleRate).append((Object)this.statisticArchiveFile).append(this.ackWaitThreshold).append(this.ackForceDisconnectThreshold).append((Object)this.cacheXmlFile).append(this.archiveDiskSpaceLimit).append(this.archiveFileSizeLimit).append(this.logDiskSpaceLimit).append(this.logFileSizeLimit).append(this.clusterSSLEnabled).append((Object)this.clusterSSLProtocols).append((Object)this.clusterSSLCiphers).append(this.clusterSSLRequireAuthentication).append((Object)this.clusterSSLKeyStore).append((Object)this.clusterSSLKeyStoreType).append((Object)this.clusterSSLKeyStorePassword).append((Object)this.clusterSSLTrustStore).append((Object)this.clusterSSLTrustStorePassword).append((Object)this.clusterSSLAlias).append(this.mcastSendBufferSize).append(this.mcastRecvBufferSize).append((Object)this.mcastFlowControl).append(this.udpSendBufferSize).append(this.udpRecvBufferSize).append(this.udpFragmentSize).append(this.disableTcp).append(this.disableJmx).append(this.enableTimeStatistics).append(this.memberTimeout).append(this.membershipPortRange).append(this.maxWaitTimeForReconnect).append(this.maxNumReconnectTries).append(this.asyncDistributionTimeout).append(this.asyncQueueTimeout).append(this.asyncMaxQueueSize).append((Object)this.clientConflation).append((Object)this.durableClientId).append(this.durableClientTimeout).append((Object)this.securityClientAuthInit).append((Object)this.securityClientAuthenticator).append((Object)this.securityManager).append((Object)this.postProcessor).append((Object)this.securityClientDHAlgo).append((Object)this.securityPeerAuthInit).append((Object)this.securityPeerAuthenticator).append((Object)this.securityClientAccessor).append((Object)this.securityClientAccessorPP).append(this.securityLogLevel).append(this.enableNetworkPartitionDetection).append(this.disableAutoReconnect).append((Object)this.securityLogFile).append(this.securityPeerMembershipTimeout).append((Object)this.security).append((Object)this.userDefinedProps).append(this.removeUnresponsiveClient).append(this.deltaPropagation).append((Object)this.props).append(this.distributedSystemId).append((Object)this.remoteLocators).append(this.enforceUniqueHost).append((Object)this.redundancyZone).append((Object)this.sslProperties).append((Object)this.clusterSSLProperties).append((Object)this.groups).append(this.enableSharedConfiguration).append(this.useSharedConfiguration).append(this.loadSharedConfigurationFromDir).append((Object)this.clusterConfigDir).append(this.httpServicePort).append((Object)this.httpServiceBindAddress).append(this.startDevRestApi).append(this.memcachedPort).append((Object)this.memcachedProtocol).append((Object)this.memcachedBindAddress).append(this.distributedTransactions).append(this.redisPort).append((Object)this.redisBindAddress).append((Object)this.redisPassword).append(this.jmxManager).append(this.jmxManagerStart).append(this.jmxManagerPort).append((Object)this.jmxManagerBindAddress).append((Object)this.jmxManagerHostnameForClients).append((Object)this.jmxManagerPasswordFile).append((Object)this.jmxManagerAccessFile).append(this.jmxManagerHttpPort).append(this.jmxManagerUpdateRate).append(this.jmxManagerSSLEnabled).append(this.jmxManagerSslRequireAuthentication).append((Object)this.jmxManagerSslProtocols).append((Object)this.jmxManagerSslCiphers).append((Object)this.jmxManagerSslProperties).append((Object)this.jmxManagerSSLKeyStore).append((Object)this.jmxManagerSSLKeyStoreType).append((Object)this.jmxManagerSSLKeyStorePassword).append((Object)this.jmxManagerSSLTrustStore).append((Object)this.jmxManagerSSLTrustStorePassword).append((Object)this.jmxManagerSSLAlias).append(this.serverSSLEnabled).append(this.serverSslRequireAuthentication).append((Object)this.serverSslProtocols).append((Object)this.serverSslCiphers).append((Object)this.serverSslProperties).append((Object)this.serverSSLKeyStore).append((Object)this.serverSSLKeyStoreType).append((Object)this.serverSSLKeyStorePassword).append((Object)this.serverSSLTrustStore).append((Object)this.serverSSLTrustStorePassword).append((Object)this.serverSSLAlias).append(this.gatewaySSLEnabled).append(this.gatewaySslRequireAuthentication).append((Object)this.gatewaySslProtocols).append((Object)this.gatewaySslCiphers).append((Object)this.gatewaySslProperties).append((Object)this.gatewaySSLKeyStore).append((Object)this.gatewaySSLKeyStoreType).append((Object)this.gatewaySSLKeyStorePassword).append((Object)this.gatewaySSLTrustStore).append((Object)this.gatewaySSLTrustStorePassword).append((Object)this.gatewaySSLAlias).append(this.httpServiceSSLEnabled).append(this.httpServiceSSLRequireAuthentication).append((Object)this.httpServiceSSLProtocols).append((Object)this.httpServiceSSLCiphers).append((Object)this.httpServiceSSLProperties).append((Object)this.httpServiceSSLKeyStore).append((Object)this.httpServiceSSLKeyStoreType).append((Object)this.httpServiceSSLKeyStorePassword).append((Object)this.httpServiceSSLTrustStore).append((Object)this.httpServiceSSLTrustStorePassword).append((Object)this.httpServiceSSLAlias).append((Object[])this.securableCommunicationChannels).append((Object)this.sslProtocols).append((Object)this.sslCiphers).append(this.sslRequireAuthentication).append((Object)this.sslKeyStore).append((Object)this.sslKeyStoreType).append((Object)this.sslKeyStorePassword).append((Object)this.sslTrustStore).append((Object)this.sslTrustStorePassword).append(this.sslWebServiceRequireAuthentication).append((Object)this.locatorSSLAlias).append((Object)this.sslDefaultAlias).append(this.sourceMap).append((Object)this.userCommandPackages).append((Object)this.offHeapMemorySize).append(this.lockMemory).append((Object)this.shiroInit).append(this.modifiable).append(this.threadMonitorEnabled).append(this.threadMonitorInterval).append(this.threadMonitorTimeLimit).toHashCode();
    }

    void checkForDisallowedDefaults() {
        if (Boolean.getBoolean("gemfire.disallowMcastDefaults") && this.getMcastPort() != 0 && this.getMcastAddress().equals(DistributionConfig.DEFAULT_MCAST_ADDRESS) && this.getMcastPort() == 0) {
            throw new IllegalStateException("gemfire.disallowMcastDefaults set and default address and port are being used");
        }
    }

    @Override
    public int[] getMembershipPortRange() {
        return this.membershipPortRange;
    }

    @Override
    public void setMembershipPortRange(int[] range) {
        this.membershipPortRange = range;
    }

    @Override
    public void setRemoteLocators(String locators) {
        this.remoteLocators = locators;
    }

    @Override
    public String getRemoteLocators() {
        return this.remoteLocators;
    }

    public Map getProps() {
        return this.props;
    }

    @Override
    public int getMemcachedPort() {
        return this.memcachedPort;
    }

    @Override
    public void setMemcachedPort(int value) {
        this.memcachedPort = value;
    }

    @Override
    public String getMemcachedProtocol() {
        return this.memcachedProtocol;
    }

    @Override
    public void setMemcachedProtocol(String protocol) {
        this.memcachedProtocol = protocol;
    }

    @Override
    public int getRedisPort() {
        return this.redisPort;
    }

    @Override
    public void setRedisPort(int value) {
        this.redisPort = value;
    }

    @Override
    public String getRedisBindAddress() {
        return this.redisBindAddress;
    }

    @Override
    public void setRedisBindAddress(String bindAddress) {
        this.redisBindAddress = bindAddress;
    }

    @Override
    public String getRedisPassword() {
        return this.redisPassword;
    }

    @Override
    public void setRedisPassword(String password) {
        this.redisPassword = password;
    }

    @Override
    public String getOffHeapMemorySize() {
        return this.offHeapMemorySize;
    }

    @Override
    public void setOffHeapMemorySize(String value) {
        this.offHeapMemorySize = value;
    }

    @Override
    public String getMemcachedBindAddress() {
        return this.memcachedBindAddress;
    }

    @Override
    public void setMemcachedBindAddress(String bindAddress) {
        this.memcachedBindAddress = bindAddress;
    }

    @Override
    public void setEnableClusterConfiguration(boolean newValue) {
        this.enableSharedConfiguration = newValue;
    }

    @Override
    public boolean getEnableClusterConfiguration() {
        return this.enableSharedConfiguration;
    }

    @Override
    public void setUseSharedConfiguration(boolean newValue) {
        this.useSharedConfiguration = newValue;
    }

    @Override
    public boolean getUseSharedConfiguration() {
        return this.useSharedConfiguration;
    }

    @Override
    public void setLoadClusterConfigFromDir(boolean newValue) {
        this.loadSharedConfigurationFromDir = newValue;
    }

    @Override
    public boolean getLoadClusterConfigFromDir() {
        return this.loadSharedConfigurationFromDir;
    }

    @Override
    public void setClusterConfigDir(String clusterConfigDir) {
        this.clusterConfigDir = clusterConfigDir;
    }

    @Override
    public String getClusterConfigDir() {
        return this.clusterConfigDir;
    }

    @Override
    public boolean getServerSSLEnabled() {
        return this.serverSSLEnabled;
    }

    @Override
    public void setServerSSLEnabled(boolean enabled) {
        this.serverSSLEnabled = enabled;
    }

    @Override
    public boolean getServerSSLRequireAuthentication() {
        return this.serverSslRequireAuthentication;
    }

    @Override
    public void setServerSSLRequireAuthentication(boolean enabled) {
        this.serverSslRequireAuthentication = enabled;
    }

    @Override
    public String getServerSSLProtocols() {
        return this.serverSslProtocols;
    }

    @Override
    public void setServerSSLProtocols(String protocols) {
        this.serverSslProtocols = protocols;
    }

    @Override
    public String getServerSSLCiphers() {
        return this.serverSslCiphers;
    }

    @Override
    public void setServerSSLCiphers(String ciphers) {
        this.serverSslCiphers = ciphers;
    }

    @Override
    public void setServerSSLKeyStore(String keyStore) {
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStore", keyStore);
        this.serverSSLKeyStore = keyStore;
    }

    @Override
    public void setServerSSLKeyStoreType(String keyStoreType) {
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        this.serverSSLKeyStoreType = keyStoreType;
    }

    @Override
    public void setServerSSLKeyStorePassword(String keyStorePassword) {
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.serverSSLKeyStorePassword = keyStorePassword;
    }

    @Override
    public void setServerSSLTrustStore(String trustStore) {
        this.getServerSSLProperties().setProperty("javax.net.ssl.trustStore", trustStore);
        this.serverSSLTrustStore = trustStore;
    }

    @Override
    public void setServerSSLTrustStorePassword(String trusStorePassword) {
        this.getServerSSLProperties().setProperty("javax.net.ssl.trustStorePassword", trusStorePassword);
        this.serverSSLTrustStorePassword = trusStorePassword;
    }

    @Override
    public String getServerSSLKeyStore() {
        return this.serverSSLKeyStore;
    }

    @Override
    public String getServerSSLKeyStoreType() {
        return this.serverSSLKeyStoreType;
    }

    @Override
    public String getServerSSLKeyStorePassword() {
        return this.serverSSLKeyStorePassword;
    }

    @Override
    public String getServerSSLTrustStore() {
        return this.serverSSLTrustStore;
    }

    @Override
    public String getServerSSLTrustStorePassword() {
        return this.serverSSLTrustStorePassword;
    }

    @Override
    public Properties getServerSSLProperties() {
        return this.serverSslProperties;
    }

    @Override
    public boolean getGatewaySSLEnabled() {
        return this.gatewaySSLEnabled;
    }

    @Override
    public void setGatewaySSLEnabled(boolean enabled) {
        this.gatewaySSLEnabled = enabled;
    }

    @Override
    public boolean getGatewaySSLRequireAuthentication() {
        return this.gatewaySslRequireAuthentication;
    }

    @Override
    public void setGatewaySSLRequireAuthentication(boolean enabled) {
        this.gatewaySslRequireAuthentication = enabled;
    }

    @Override
    public String getGatewaySSLProtocols() {
        return this.gatewaySslProtocols;
    }

    @Override
    public void setGatewaySSLProtocols(String protocols) {
        this.gatewaySslProtocols = protocols;
    }

    @Override
    public String getGatewaySSLCiphers() {
        return this.gatewaySslCiphers;
    }

    @Override
    public void setGatewaySSLCiphers(String ciphers) {
        this.gatewaySslCiphers = ciphers;
    }

    @Override
    public void setGatewaySSLKeyStore(String keyStore) {
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStore", keyStore);
        this.gatewaySSLKeyStore = keyStore;
    }

    @Override
    public void setGatewaySSLKeyStoreType(String keyStoreType) {
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        this.gatewaySSLKeyStoreType = keyStoreType;
    }

    @Override
    public void setGatewaySSLKeyStorePassword(String keyStorePassword) {
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.gatewaySSLKeyStorePassword = keyStorePassword;
    }

    @Override
    public void setGatewaySSLTrustStore(String trustStore) {
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.trustStore", trustStore);
        this.gatewaySSLTrustStore = trustStore;
    }

    @Override
    public void setGatewaySSLTrustStorePassword(String trusStorePassword) {
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.trustStorePassword", trusStorePassword);
        this.gatewaySSLTrustStorePassword = trusStorePassword;
    }

    @Override
    public String getGatewaySSLKeyStore() {
        return this.gatewaySSLKeyStore;
    }

    @Override
    public String getGatewaySSLKeyStoreType() {
        return this.gatewaySSLKeyStoreType;
    }

    @Override
    public String getGatewaySSLKeyStorePassword() {
        return this.gatewaySSLKeyStorePassword;
    }

    @Override
    public String getGatewaySSLTrustStore() {
        return this.gatewaySSLTrustStore;
    }

    @Override
    public String getGatewaySSLTrustStorePassword() {
        return this.gatewaySSLTrustStorePassword;
    }

    @Override
    public Properties getGatewaySSLProperties() {
        return this.gatewaySslProperties;
    }

    @Override
    public boolean getHttpServiceSSLEnabled() {
        return this.httpServiceSSLEnabled;
    }

    @Override
    public void setHttpServiceSSLEnabled(boolean httpServiceSSLEnabled) {
        this.httpServiceSSLEnabled = httpServiceSSLEnabled;
    }

    @Override
    public boolean getHttpServiceSSLRequireAuthentication() {
        return this.httpServiceSSLRequireAuthentication;
    }

    @Override
    public void setHttpServiceSSLRequireAuthentication(boolean httpServiceSSLRequireAuthentication) {
        this.httpServiceSSLRequireAuthentication = httpServiceSSLRequireAuthentication;
    }

    @Override
    public String getHttpServiceSSLProtocols() {
        return this.httpServiceSSLProtocols;
    }

    @Override
    public void setHttpServiceSSLProtocols(String protocols) {
        this.httpServiceSSLProtocols = protocols;
    }

    @Override
    public String getHttpServiceSSLCiphers() {
        return this.httpServiceSSLCiphers;
    }

    @Override
    public void setHttpServiceSSLCiphers(String ciphers) {
        this.httpServiceSSLCiphers = ciphers;
    }

    @Override
    public String getHttpServiceSSLKeyStore() {
        return this.httpServiceSSLKeyStore;
    }

    @Override
    public void setHttpServiceSSLKeyStore(String keyStore) {
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStore", keyStore);
        this.httpServiceSSLKeyStore = keyStore;
    }

    @Override
    public String getHttpServiceSSLKeyStoreType() {
        return this.httpServiceSSLKeyStoreType;
    }

    @Override
    public void setHttpServiceSSLKeyStoreType(String keyStoreType) {
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStoreType", keyStoreType);
        this.httpServiceSSLKeyStoreType = keyStoreType;
    }

    @Override
    public String getHttpServiceSSLKeyStorePassword() {
        return this.httpServiceSSLKeyStorePassword;
    }

    @Override
    public void setHttpServiceSSLKeyStorePassword(String keyStorePassword) {
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        this.httpServiceSSLKeyStorePassword = keyStorePassword;
    }

    @Override
    public String getHttpServiceSSLTrustStore() {
        return this.httpServiceSSLTrustStore;
    }

    @Override
    public void setHttpServiceSSLTrustStore(String trustStore) {
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.trustStore", trustStore);
        this.httpServiceSSLTrustStore = trustStore;
    }

    @Override
    public String getHttpServiceSSLTrustStorePassword() {
        return this.httpServiceSSLTrustStorePassword;
    }

    @Override
    public void setHttpServiceSSLTrustStorePassword(String trustStorePassword) {
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        this.httpServiceSSLTrustStorePassword = trustStorePassword;
    }

    @Override
    public Properties getHttpServiceSSLProperties() {
        return this.httpServiceSSLProperties;
    }

    @Override
    public ConfigSource getConfigSource(String attName) {
        return this.sourceMap.get(attName);
    }

    @Override
    public boolean getDistributedTransactions() {
        return this.distributedTransactions;
    }

    @Override
    public void setDistributedTransactions(boolean value) {
        this.distributedTransactions = value;
    }

    @Override
    public boolean getThreadMonitorEnabled() {
        return this.threadMonitorEnabled;
    }

    @Override
    public void setThreadMonitorEnabled(boolean newValue) {
        this.threadMonitorEnabled = newValue;
    }

    @Override
    public int getThreadMonitorInterval() {
        return this.threadMonitorInterval;
    }

    @Override
    public void setThreadMonitorInterval(int newValue) {
        this.threadMonitorInterval = newValue;
    }

    @Override
    public int getThreadMonitorTimeLimit() {
        return this.threadMonitorTimeLimit;
    }

    @Override
    public void setThreadMonitorTimeLimit(int newValue) {
        this.threadMonitorTimeLimit = newValue;
    }
}

