/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.geode.distributed.internal.ConnectionConfig;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.membership.QuorumChecker;

public class ConnectionConfigImpl
implements ConnectionConfig {
    private final boolean isReconnecting;
    private final QuorumChecker quorumChecker;
    private final DistributionConfigImpl distributionConfig;

    ConnectionConfigImpl(Properties properties) {
        this.isReconnecting = ConnectionConfigImpl.convert(properties.get("ds-reconnecting"), Boolean.class, () -> Boolean.FALSE);
        this.quorumChecker = ConnectionConfigImpl.convert(properties.get("ds-quorum-checker"), QuorumChecker.class, () -> null);
        this.distributionConfig = ConnectionConfigImpl.convert(properties.get("ds-config"), DistributionConfigImpl.class, () -> new DistributionConfigImpl(ConnectionConfigImpl.removeNonUserProperties(properties)));
    }

    @Override
    public boolean isReconnecting() {
        return this.isReconnecting;
    }

    @Override
    public QuorumChecker quorumChecker() {
        return this.quorumChecker;
    }

    @Override
    public DistributionConfig distributionConfig() {
        return this.distributionConfig;
    }

    private static Properties removeNonUserProperties(Properties properties) {
        Properties cleanedProperties = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)cleanedProperties::put));
        cleanedProperties.remove("ds-quorum-checker");
        cleanedProperties.remove("ds-reconnecting");
        cleanedProperties.remove("ds-config");
        return cleanedProperties;
    }

    private static <T> T convert(Object object, Class<T> type, Supplier<T> defaultValueSupplier) {
        return type.isInstance(object) ? type.cast(object) : defaultValueSupplier.get();
    }
}

