/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.NameNotFoundException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AttributeDescriptor;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIndexOperation;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;

public class PathUtils {
    public static String[] tokenizePath(String path) {
        ArrayList<String> alist = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        while (tokenizer.hasMoreTokens()) {
            alist.add(tokenizer.nextToken());
        }
        return alist.toArray(new String[alist.size()]);
    }

    public static String buildPathString(String[] path) {
        Support.assertArg(path != null && path.length > 0, "path should not be null or empty");
        StringBuffer buf = new StringBuffer();
        buf.append(path[0]);
        for (int i = 1; i < path.length; ++i) {
            buf.append('.');
            buf.append(path[i]);
        }
        return buf.toString();
    }

    public static Object evaluateAttribute(ExecutionContext context, Object target, String attribute) throws NameNotFoundException, QueryInvocationTargetException {
        if (target instanceof Struct) {
            Struct struct = (Struct)target;
            try {
                return struct.get(attribute);
            }
            catch (Exception e) {
                throw new NameNotFoundException(attribute);
            }
        }
        try {
            return new AttributeDescriptor(context.getCache().getPdxRegistry(), context.getCache().getQueryService().getMethodInvocationAuthorizer(), attribute).read(target);
        }
        catch (NameNotFoundException nfe) {
            if (DefaultQueryService.QUERY_HETEROGENEOUS_OBJECTS || DefaultQueryService.TEST_QUERY_HETEROGENEOUS_OBJECTS) {
                return QueryService.UNDEFINED;
            }
            throw nfe;
        }
    }

    public static ObjectType[] calculateTypesAlongPath(ExecutionContext context, ObjectType initialType, String[] pathArray) throws NameNotFoundException {
        ObjectType[] types = new ObjectType[pathArray.length + 1];
        types[0] = initialType;
        for (int i = 1; i < types.length; ++i) {
            ObjectType currentType = types[i - 1];
            Member member = new AttributeDescriptor(context.getCache().getPdxRegistry(), context.getCache().getQueryService().getMethodInvocationAuthorizer(), pathArray[i - 1]).getReadMember(currentType.resolveClass());
            if (member instanceof Field) {
                types[i] = TypeUtils.getObjectType(((Field)member).getType());
                continue;
            }
            if (!(member instanceof Method)) continue;
            types[i] = TypeUtils.getObjectType(((Method)member).getReturnType());
        }
        return types;
    }

    public static ObjectType computeElementTypeOfExpression(ExecutionContext context, CompiledValue expr) throws AmbiguousNameException {
        try {
            ObjectType type = TypeUtils.OBJECT_TYPE;
            ArrayList<String> exprSteps = new ArrayList<String>();
            while (true) {
                if (expr instanceof CompiledPath) {
                    CompiledPath path = (CompiledPath)expr;
                    exprSteps.add(0, path.getTailID());
                    expr = path.getReceiver();
                    continue;
                }
                if (expr instanceof CompiledOperation) {
                    CompiledOperation operation = (CompiledOperation)expr;
                    if (operation.getArguments().size() > 0) {
                        return TypeUtils.OBJECT_TYPE;
                    }
                    exprSteps.add(0, operation.getMethodName() + "()");
                    expr = operation.getReceiver(context);
                    if (expr != null) continue;
                    expr = context.resolveImplicitOperationName(operation.getMethodName(), operation.getArguments().size(), true);
                    continue;
                }
                if (!(expr instanceof CompiledID)) break;
                expr = context.resolve(((CompiledID)expr).getId());
            }
            if (expr instanceof CompiledRegion) {
                QRegion qrgn = (QRegion)((CompiledRegion)expr).evaluate(context);
                type = qrgn.getCollectionType();
            } else if (expr instanceof RuntimeIterator) {
                type = ((RuntimeIterator)expr).getElementType();
            } else {
                return TypeUtils.OBJECT_TYPE;
            }
            if (!TypeUtils.OBJECT_TYPE.equals(type)) {
                Class<?> clazz = type.resolveClass();
                for (int i = 0; i < exprSteps.size(); ++i) {
                    Member member;
                    String stepStr = (String)exprSteps.get(i);
                    if (stepStr.endsWith("()")) {
                        stepStr = stepStr.substring(0, stepStr.length() - 2);
                        member = clazz.getMethod(stepStr, null);
                    } else {
                        member = new AttributeDescriptor(context.getCache().getPdxRegistry(), context.getCache().getQueryService().getMethodInvocationAuthorizer(), stepStr).getReadMember(clazz);
                    }
                    if (member instanceof Field) {
                        clazz = ((Field)member).getType();
                    } else if (member instanceof Method) {
                        clazz = ((Method)member).getReturnType();
                    }
                    type = TypeUtils.getObjectType(clazz);
                }
                return type;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NameResolutionException nameResolutionException) {
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return TypeUtils.OBJECT_TYPE;
    }

    public static List<CompiledValue> collectCompiledValuesInThePath(CompiledValue expr, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException {
        boolean toContinue = true;
        ArrayList<CompiledValue> retList = new ArrayList<CompiledValue>();
        int exprType = expr.getType();
        while (toContinue) {
            switch (exprType) {
                case 36: {
                    retList.add(expr);
                    toContinue = false;
                    break;
                }
                case 54: {
                    retList.add(expr);
                    CompiledOperation operation = (CompiledOperation)expr;
                    expr = operation.getReceiver(null);
                    if (expr != null) break;
                    expr = operation;
                    toContinue = false;
                    break;
                }
                case -5: {
                    retList.add(expr);
                    expr = ((CompiledPath)expr).getReceiver();
                    break;
                }
                case 49: {
                    retList.add(expr);
                    toContinue = false;
                    break;
                }
                case 24: {
                    retList.add(expr);
                    expr = ((CompiledIndexOperation)expr).getReceiver();
                    break;
                }
                case 35: {
                    CompiledID cid = (CompiledID)expr;
                    expr = context.resolve(cid.getId());
                    break;
                }
                default: {
                    toContinue = false;
                }
            }
            if (!toContinue) continue;
            exprType = expr.getType();
        }
        return retList;
    }
}

