/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.pdx.internal.PdxString;

public class Functions {
    public static final int ELEMENT = 1;

    public static Object nvl(CompiledValue arg1, CompiledValue arg2, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object value = arg1.evaluate(context);
        if (value == null) {
            return arg2.evaluate(context);
        }
        return value;
    }

    public static Date to_date(CompiledValue cv1, CompiledValue cv2, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object value1 = cv1.evaluate(context);
        Object value2 = cv2.evaluate(context);
        if (!(value1 instanceof String) || !(value2 instanceof String)) {
            throw new QueryInvalidException("Parameters to the to_date function should be strictly simple strings");
        }
        String dateStr = (String)value1;
        String format = (String)value2;
        Date dt = null;
        try {
            SimpleDateFormat sdf1 = new SimpleDateFormat(format);
            dt = sdf1.parse(dateStr);
        }
        catch (Exception ex) {
            throw new QueryInvalidException(String.format("Malformed date format string as the format is %s", format), ex);
        }
        return dt;
    }

    public static Object element(Object arg, ExecutionContext context) throws FunctionDomainException, TypeMismatchException {
        if (arg == null || arg == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (arg instanceof Collection) {
            Collection c = (Collection)arg;
            if (context.isDistinct() && ((DefaultQuery)context.getQuery()).isRemoteQuery()) {
                HashSet tempResults = new HashSet();
                for (Object o : c) {
                    if (o instanceof PdxString) {
                        o = ((PdxString)o).toString();
                    }
                    tempResults.add(o);
                }
                c.clear();
                c.addAll(tempResults);
                tempResults = null;
            }
            Functions.checkSingleton(c.size());
            return c.iterator().next();
        }
        Class<?> clazz = arg.getClass();
        if (!clazz.isArray()) {
            throw new TypeMismatchException(String.format("The 'element' function cannot be applied to an object of type ' %s '", clazz.getName()));
        }
        if (arg instanceof Object[]) {
            Object[] a = (Object[])arg;
            if (((DefaultQuery)context.getQuery()).isRemoteQuery() && context.isDistinct()) {
                for (int i = 0; i < a.length; ++i) {
                    if (!(a[i] instanceof PdxString)) continue;
                    a[i] = ((PdxString)a[i]).toString();
                }
            }
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof int[]) {
            int[] a = (int[])arg;
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof long[]) {
            long[] a = (long[])arg;
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof boolean[]) {
            boolean[] a = (boolean[])arg;
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof byte[]) {
            byte[] a = (byte[])arg;
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof char[]) {
            char[] a = (char[])arg;
            Functions.checkSingleton(a.length);
            return new Character(a[0]);
        }
        if (arg instanceof double[]) {
            double[] a = (double[])arg;
            Functions.checkSingleton(a.length);
            return a[0];
        }
        if (arg instanceof float[]) {
            float[] a = (float[])arg;
            Functions.checkSingleton(a.length);
            return new Float(a[0]);
        }
        if (arg instanceof short[]) {
            short[] a = (short[])arg;
            Functions.checkSingleton(a.length);
            return new Short(a[0]);
        }
        throw new TypeMismatchException(String.format("The 'element' function cannot be applied to an object of type ' %s '", clazz.getName()));
    }

    private static void checkSingleton(int size) throws FunctionDomainException {
        if (size != 1) {
            throw new FunctionDomainException(String.format("element() applied to parameter of size %s", size));
        }
    }
}

