/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelException;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.InternalPool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.RegisterInstantiatorsOp;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class InstantiatorRecoveryListener
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger endpointCount = new AtomicInteger();
    protected final InternalPool pool;
    protected final ScheduledExecutorService background;
    protected final long pingInterval;
    protected final Object recoveryScheduledLock = new Object();
    protected boolean recoveryScheduled;

    public InstantiatorRecoveryListener(ScheduledExecutorService background, InternalPool pool) {
        this.pool = pool;
        this.pingInterval = pool.getPingInterval();
        this.background = background;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("InstantiatorRecoveryTask - EndpointCrashed. Now have {} endpoints", (Object)count);
        }
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("InstantiatorRecoveryTask - EndpointNoLongerInUse. Now have {} endpoints", (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        int count = this.endpointCount.incrementAndGet();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("InstantiatorRecoveryTask - EndpointNowInUse. Now have {} endpoints", (Object)count);
        }
        if (count == 1) {
            Object object = this.recoveryScheduledLock;
            synchronized (object) {
                if (!this.recoveryScheduled) {
                    try {
                        this.recoveryScheduled = true;
                        this.background.execute(new RecoveryTask());
                        if (isDebugEnabled) {
                            logger.debug("InstantiatorRecoveryTask - Scheduled Recovery Task");
                        }
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class RecoveryTask
    extends PoolImpl.PoolTask {
        protected RecoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            if (InstantiatorRecoveryListener.this.pool.getCancelCriterion().isCancelInProgress()) {
                return;
            }
            Object object = InstantiatorRecoveryListener.this.recoveryScheduledLock;
            synchronized (object) {
                InstantiatorRecoveryListener.this.recoveryScheduled = false;
            }
            Object[] objects = InternalInstantiator.getInstantiatorsForSerialization();
            if (objects.length == 0) {
                return;
            }
            EventID eventId = InternalInstantiator.generateEventId();
            if (eventId == null) {
                InstantiatorRecoveryListener.this.background.schedule(new RecoveryTask(), InstantiatorRecoveryListener.this.pingInterval, TimeUnit.MILLISECONDS);
                InstantiatorRecoveryListener.this.recoveryScheduled = true;
            } else {
                try {
                    RegisterInstantiatorsOp.execute((ExecutablePool)InstantiatorRecoveryListener.this.pool, objects, eventId);
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (RejectedExecutionException e) {
                    InstantiatorRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                    throw e;
                }
                catch (Exception e) {
                    InstantiatorRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) {
                        logger.warn("InstantiatorRecoveryTask - Error ClassNotFoundException: {}", (Object)cause.getMessage());
                    } else {
                        logger.warn("InstantiatorRecoveryTask - Error recovering instantiators:", (Throwable)e);
                    }
                }
                finally {
                    InstantiatorRecoveryListener.this.pool.releaseThreadLocalConnection();
                }
            }
        }
    }
}

