/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExecuteFunctionHelper;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerRegionFunctionExecutor;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteRegionFunctionOp {
    private static final Logger logger = LogService.getLogger();

    private ExecuteRegionFunctionOp() {
    }

    public static void execute(ExecutablePool pool, String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, int mRetryAttempts) {
        ExecuteRegionFunctionOpImpl op = new ExecuteRegionFunctionOpImpl(region, function, serverRegionExecutor, resultCollector, hasResult, new HashSet<String>());
        int retryAttempts = 0;
        boolean reexecute = false;
        boolean reexecuteForServ = false;
        HashSet<String> failedNodes = new HashSet<String>();
        ExecuteRegionFunctionOpImpl reexecOp = null;
        int maxRetryAttempts = 0;
        if (function.isHA()) {
            maxRetryAttempts = mRetryAttempts;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            try {
                if (reexecuteForServ) {
                    reexecOp = new ExecuteRegionFunctionOpImpl(op, 1, failedNodes);
                    pool.execute(reexecOp, 0);
                } else {
                    pool.execute(op, 0);
                }
                reexecute = false;
                reexecuteForServ = false;
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#execute : Received InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
                Set<String> failedNodesIds = e.getFailedNodeSet();
                failedNodes.clear();
                if (failedNodesIds == null) continue;
                failedNodes.addAll(failedNodesIds);
            }
            catch (ServerConnectivityException se) {
                ++retryAttempts;
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#execute : Received ServerConnectivityException. The exception is {} The retryattempt is : {} maxRetryAttempts {}", (Object)se, (Object)retryAttempts, (Object)maxRetryAttempts);
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (retryAttempts > maxRetryAttempts && maxRetryAttempts != -1) {
                    throw se;
                }
                reexecuteForServ = true;
                resultCollector.clearResults();
                failedNodes.clear();
            }
        } while (reexecuteForServ);
        if (reexecute && function.isHA()) {
            ExecuteRegionFunctionOp.reexecute(pool, region, function, serverRegionExecutor, resultCollector, hasResult, failedNodes, maxRetryAttempts - 1);
        }
    }

    public static void execute(ExecutablePool pool, String region, String function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, int mRetryAttempts, boolean isHA, boolean optimizeForWrite) {
        ExecuteRegionFunctionOpImpl op = new ExecuteRegionFunctionOpImpl(region, function, serverRegionExecutor, resultCollector, hasResult, new HashSet<String>(), isHA, optimizeForWrite, true);
        int retryAttempts = 0;
        boolean reexecute = false;
        boolean reexecuteForServ = false;
        HashSet<String> failedNodes = new HashSet<String>();
        ExecuteRegionFunctionOpImpl reexecOp = null;
        int maxRetryAttempts = 0;
        if (isHA) {
            maxRetryAttempts = mRetryAttempts;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            try {
                if (reexecuteForServ) {
                    reexecOp = new ExecuteRegionFunctionOpImpl(op, 1, failedNodes);
                    pool.execute(reexecOp, 0);
                } else {
                    pool.execute(op, 0);
                }
                reexecute = false;
                reexecuteForServ = false;
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#execute : Received InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
                Set<String> failedNodesIds = e.getFailedNodeSet();
                failedNodes.clear();
                if (failedNodesIds == null) continue;
                failedNodes.addAll(failedNodesIds);
            }
            catch (ServerConnectivityException se) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#execute : Received ServerConnectivityException. The exception is {} The retryattempt is : {} maxRetryAttempts {}", (Object)se, (Object)retryAttempts, (Object)maxRetryAttempts);
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (++retryAttempts > maxRetryAttempts && maxRetryAttempts != -1) {
                    throw se;
                }
                reexecute = true;
                resultCollector.clearResults();
                failedNodes.clear();
            }
        } while (reexecuteForServ);
        if (reexecute && isHA) {
            ExecuteRegionFunctionOp.reexecute(pool, region, function, serverRegionExecutor, resultCollector, hasResult, failedNodes, maxRetryAttempts - 1, isHA, optimizeForWrite);
        }
    }

    public static void reexecute(ExecutablePool pool, String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, Set<String> failedNodes, int maxRetryAttempts) {
        ExecuteRegionFunctionOpImpl op = new ExecuteRegionFunctionOpImpl(region, function, serverRegionExecutor, resultCollector, hasResult, new HashSet<String>());
        boolean reexecute = true;
        int retryAttempts = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            reexecute = false;
            ExecuteRegionFunctionOpImpl reExecuteOp = new ExecuteRegionFunctionOpImpl(op, 1, failedNodes);
            if (isDebugEnabled) {
                logger.debug("ExecuteRegionFunction#reexecute: Sending Function Execution Message: {} to Server using pool: {} with failed nodes: {}", (Object)reExecuteOp.getMessage(), (Object)pool, failedNodes);
            }
            try {
                pool.execute(reExecuteOp, 0);
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#reexecute : Received InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
                Set<String> failedNodesIds = e.getFailedNodeSet();
                failedNodes.clear();
                if (failedNodesIds == null) continue;
                failedNodes.addAll(failedNodesIds);
            }
            catch (ServerConnectivityException se) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#reexecute : Received ServerConnectivity Exception.");
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (++retryAttempts > maxRetryAttempts && maxRetryAttempts != -2) {
                    throw se;
                }
                reexecute = true;
                resultCollector.clearResults();
                failedNodes.clear();
            }
        } while (reexecute);
    }

    public static void reexecute(ExecutablePool pool, String region, String function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector resultCollector, byte hasResult, Set<String> failedNodes, int maxRetryAttempts, boolean isHA, boolean optimizeForWrite) {
        ExecuteRegionFunctionOpImpl op = new ExecuteRegionFunctionOpImpl(region, function, serverRegionExecutor, resultCollector, hasResult, new HashSet<String>(), isHA, optimizeForWrite, true);
        boolean reexecute = true;
        int retryAttempts = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            reexecute = false;
            ExecuteRegionFunctionOpImpl reExecuteOp = new ExecuteRegionFunctionOpImpl(op, 1, failedNodes);
            if (isDebugEnabled) {
                logger.debug("ExecuteRegionFunction#reexecute : Sending Function Execution Message: {} to Server using pool: {}", (Object)reExecuteOp.getMessage(), (Object)pool);
            }
            try {
                pool.execute(reExecuteOp, 0);
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#reexecute : Received InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
                Set<String> failedNodesIds = e.getFailedNodeSet();
                failedNodes.clear();
                if (failedNodesIds == null) continue;
                failedNodes.addAll(failedNodesIds);
            }
            catch (ServerConnectivityException se) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteRegionFunctionOp#reexecute : Received ServerConnectivityException. The exception is {} The retryattempt is : {} maxRetryAttempts {}", (Object)se, (Object)retryAttempts, (Object)maxRetryAttempts);
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (++retryAttempts > maxRetryAttempts && maxRetryAttempts != -2) {
                    throw se;
                }
                reexecute = true;
                resultCollector.clearResults();
                failedNodes.clear();
            }
        } while (reexecute);
    }

    static class ExecuteRegionFunctionOpImpl
    extends AbstractOp {
        private final ResultCollector resultCollector;
        private Function function;
        private byte isReExecute = 0;
        private final String regionName;
        private final ServerRegionFunctionExecutor executor;
        private final byte hasResult;
        private Set<String> failedNodes = new HashSet<String>();
        private final String functionId;
        private final boolean executeOnBucketSet;
        private final boolean isHA;
        private FunctionException functionException;

        public ExecuteRegionFunctionOpImpl(String region, Function function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, byte hasResult, Set<String> removedNodes) {
            super(59, 8 + serverRegionExecutor.getFilter().size() + removedNodes.size());
            Set routingObjects = serverRegionExecutor.getFilter();
            Object args = serverRegionExecutor.getArguments();
            byte functionState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.addBytes(functionState);
            this.getMessage().addStringPart(region);
            if (serverRegionExecutor.isFnSerializationReqd()) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, this.isReExecute);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
            this.resultCollector = rc;
            this.regionName = region;
            this.function = function;
            this.functionId = function.getId();
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.failedNodes = removedNodes;
            this.isHA = function.isHA();
        }

        ExecuteRegionFunctionOpImpl() {
            super(59, 0);
            this.resultCollector = null;
            this.function = null;
            this.isReExecute = 0;
            this.regionName = "";
            this.executor = null;
            this.hasResult = 0;
            this.failedNodes = null;
            this.functionId = null;
            this.executeOnBucketSet = true;
            this.isHA = true;
        }

        public ExecuteRegionFunctionOpImpl(String region, String function, ServerRegionFunctionExecutor serverRegionExecutor, ResultCollector rc, byte hasResult, Set<String> removedNodes, boolean isHA, boolean optimizeForWrite, boolean calculateFnState) {
            super(59, 8 + serverRegionExecutor.getFilter().size() + removedNodes.size());
            Set routingObjects = serverRegionExecutor.getFilter();
            byte functionState = hasResult;
            if (calculateFnState) {
                functionState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            }
            Object args = serverRegionExecutor.getArguments();
            MemberMappedArgument memberMappedArg = serverRegionExecutor.getMemberMappedArgument();
            this.addBytes(functionState);
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(function);
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.executeOnBucketSet = serverRegionExecutor.getExecuteOnBucketSetFlag();
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, this.isReExecute);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
            this.resultCollector = rc;
            this.regionName = region;
            this.functionId = function;
            this.executor = serverRegionExecutor;
            this.hasResult = functionState;
            this.failedNodes = removedNodes;
            this.isHA = isHA;
        }

        public ExecuteRegionFunctionOpImpl(ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl newop) {
            this(newop.getRegionName(), newop.getFunctionId(), newop.getExecutor(), newop.getResultCollector(), newop.getHasResult(), new HashSet<String>(), newop.isHA(), newop.optimizeForWrite(), false);
        }

        public ExecuteRegionFunctionOpImpl(ExecuteRegionFunctionOpImpl op, byte isReExecute, Set<String> removedNodes) {
            super(59, 8 + op.executor.getFilter().size() + removedNodes.size());
            this.isReExecute = isReExecute;
            this.resultCollector = op.resultCollector;
            this.function = op.function;
            this.functionId = op.functionId;
            this.regionName = op.regionName;
            this.executor = op.executor;
            this.hasResult = op.hasResult;
            this.failedNodes = op.failedNodes;
            this.executeOnBucketSet = op.executeOnBucketSet;
            this.isHA = op.isHA;
            if (isReExecute == 1) {
                this.resultCollector.endResults();
                this.resultCollector.clearResults();
            }
            Set routingObjects = this.executor.getFilter();
            Object args = this.executor.getArguments();
            MemberMappedArgument memberMappedArg = this.executor.getMemberMappedArgument();
            this.getMessage().clear();
            this.addBytes(this.hasResult);
            this.getMessage().addStringPart(this.regionName);
            if (this.executor.isFnSerializationReqd()) {
                this.getMessage().addStringOrObjPart(this.function);
            } else {
                this.getMessage().addStringOrObjPart(this.functionId);
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            byte flags = ExecuteFunctionHelper.createFlags(this.executeOnBucketSet, isReExecute);
            this.getMessage().addBytesPart(new byte[]{flags});
            this.getMessage().addIntPart(routingObjects.size());
            for (Object e : routingObjects) {
                this.getMessage().addStringOrObjPart(e);
            }
            this.getMessage().addIntPart(removedNodes.size());
            for (Object object : removedNodes) {
                this.getMessage().addStringOrObjPart(object);
            }
        }

        private void addBytes(byte functionStateOrHasResult) {
            if (ConnectionImpl.getClientFunctionTimeout() == 0) {
                this.getMessage().addBytesPart(new byte[]{functionStateOrHasResult});
            } else {
                byte[] bytes = new byte[5];
                bytes[0] = functionStateOrHasResult;
                Part.encodeInt(ConnectionImpl.getClientFunctionTimeout(), bytes, 1);
                this.getMessage().addBytesPart(bytes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage executeFunctionResponseMsg = (ChunkedMessage)msg;
            try {
                executeFunctionResponseMsg.readHeader();
                switch (executeFunctionResponseMsg.getMessageType()) {
                    case 60: {
                        String s;
                        boolean isDebugEnabled = logger.isDebugEnabled();
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_RESULT. The number of parts are : {}", (Object)executeFunctionResponseMsg.getNumberOfParts());
                        }
                        boolean throwServerOp = false;
                        do {
                            DistributedMember memberID;
                            executeFunctionResponseMsg.receiveChunk();
                            Object resultResponse = executeFunctionResponseMsg.getPart(0).getObject();
                            Object result = resultResponse instanceof ArrayList ? ((ArrayList)resultResponse).get(0) : resultResponse;
                            if (result instanceof FunctionException) {
                                FunctionException ex = (FunctionException)result;
                                if (ex instanceof InternalFunctionException) {
                                    Throwable cause = ex.getCause();
                                    memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.resultCollector.addResult(memberID, cause);
                                    FunctionStats.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                                    continue;
                                }
                                if (((FunctionException)result).getCause() instanceof InternalFunctionInvocationTargetException) {
                                    InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                    this.failedNodes.addAll(ifite.getFailedNodeSet());
                                    this.addFunctionException((FunctionException)result);
                                    continue;
                                }
                                this.addFunctionException((FunctionException)result);
                                continue;
                            }
                            if (result instanceof Throwable) {
                                Throwable t = (Throwable)result;
                                if (this.functionException == null) {
                                    FunctionInvocationTargetException fite;
                                    if (result instanceof BucketMovedException) {
                                        fite = this.isHA ? new InternalFunctionInvocationTargetException(((BucketMovedException)result).getMessage()) : new FunctionInvocationTargetException(((BucketMovedException)result).getMessage());
                                        this.functionException = new FunctionException(fite);
                                        this.functionException.addException(fite);
                                        continue;
                                    }
                                    if (result instanceof CacheClosedException) {
                                        fite = this.isHA ? new InternalFunctionInvocationTargetException(((CacheClosedException)result).getMessage()) : new FunctionInvocationTargetException(((CacheClosedException)result).getMessage());
                                        if (resultResponse instanceof ArrayList) {
                                            memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                            this.failedNodes.add(memberID.getId());
                                        }
                                        this.functionException = new FunctionException(fite);
                                        this.functionException.addException(fite);
                                        continue;
                                    }
                                    throwServerOp = true;
                                    this.functionException = new FunctionException(t);
                                    this.functionException.addException(t);
                                    continue;
                                }
                                this.functionException.addException(t);
                                continue;
                            }
                            DistributedMember memberID2 = (DistributedMember)((ArrayList)resultResponse).get(1);
                            this.resultCollector.addResult(memberID2, result);
                            FunctionStats.getFunctionStats(this.functionId, this.executor.getRegion().getSystem()).incResultsReceived();
                        } while (!executeFunctionResponseMsg.isLastChunk());
                        if (isDebugEnabled) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received all the results from server successfully.");
                        }
                        if (this.isHA && throwServerOp) {
                            s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, this.functionException);
                        }
                        if (this.functionException != null) {
                            throw this.functionException;
                        }
                        this.resultCollector.endResults();
                        s = null;
                        return s;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXCEPTION. The number of parts are : {}", (Object)executeFunctionResponseMsg.getNumberOfParts());
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        Part part0 = executeFunctionResponseMsg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof FunctionException) {
                            FunctionException ex = (FunctionException)obj;
                            if (((FunctionException)obj).getCause() instanceof InternalFunctionInvocationTargetException) {
                                InternalFunctionInvocationTargetException ifite = (InternalFunctionInvocationTargetException)ex.getCause();
                                this.failedNodes.addAll(ifite.getFailedNodeSet());
                            }
                            throw ex;
                        }
                        if (obj instanceof Throwable) {
                            String s = "While performing a remote " + this.getOpName();
                            throw new ServerOperationException(s, (Throwable)obj);
                        }
                        break;
                    }
                    case 61: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteRegionFunctionOpImpl#processResponse: received message of type EXECUTE_REGION_FUNCTION_ERROR");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        String errorMessage = executeFunctionResponseMsg.getPart(0).getString();
                        throw new ServerOperationException(errorMessage);
                    }
                    default: {
                        throw new InternalGemFireError("Unknown message type " + executeFunctionResponseMsg.getMessageType());
                    }
                }
            }
            finally {
                executeFunctionResponseMsg.clear();
            }
            return null;
        }

        void addFunctionException(FunctionException result) {
            if (result.getCause() instanceof FunctionInvocationTargetException) {
                if (this.functionException == null) {
                    this.functionException = result;
                }
                this.functionException.addException(result.getCause());
            } else if (result instanceof FunctionInvocationTargetException) {
                if (this.functionException == null) {
                    this.functionException = new FunctionException(result);
                }
                this.functionException.addException(result);
            } else {
                if (this.functionException == null) {
                    this.functionException = result;
                }
                this.functionException.addException(result);
            }
        }

        FunctionException getFunctionException() {
            return this.functionException;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 61;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        protected String getOpName() {
            return "executeRegionFunction";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }
    }
}

