/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.CloseConnectionOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.ExecuteFunctionOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionOp;
import org.apache.geode.cache.client.internal.ExecuteRegionFunctionSingleHopOp;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.ClientSideHandshake;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

public class ConnectionImpl
implements Connection {
    public static final int DEFAULT_CLIENT_FUNCTION_TIMEOUT = 0;
    private static final String CLIENT_FUNCTION_TIMEOUT_SYSTEM_PROPERTY = "gemfire.CLIENT_FUNCTION_TIMEOUT";
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    private static boolean TEST_DURABLE_CLIENT_CRASH = false;
    private Socket theSocket;
    private ByteBuffer commBuffer;
    private ByteBuffer commBufferForAsyncRead;
    private ServerQueueStatus status;
    private volatile boolean connectFinished;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private Endpoint endpoint;
    private short wanSiteVersion = (short)-1;
    private final InternalDistributedSystem ds;
    private OutputStream out;
    private InputStream in;
    private long connectionID = 26739L;
    private ClientSideHandshake handshake;

    public ConnectionImpl(InternalDistributedSystem ds, CancelCriterion cancelCriterion) {
        this.ds = ds;
    }

    public static int getClientFunctionTimeout() {
        int time = Integer.getInteger(CLIENT_FUNCTION_TIMEOUT_SYSTEM_PROPERTY, 0);
        return time >= 0 ? time : 0;
    }

    public ServerQueueStatus connect(EndpointManager endpointManager, ServerLocation location, ClientSideHandshake handshake, int socketBufferSize, int handshakeTimeout, int readTimeout, CommunicationMode communicationMode, GatewaySender sender, SocketCreator sc) throws IOException {
        this.theSocket = sc.connectForClient(location.getHostName(), location.getPort(), handshakeTimeout, socketBufferSize);
        this.theSocket.setTcpNoDelay(true);
        this.theSocket.setSendBufferSize(socketBufferSize);
        this.verifySocketBufferSize(socketBufferSize, this.theSocket.getReceiveBufferSize(), "receive");
        this.verifySocketBufferSize(socketBufferSize, this.theSocket.getSendBufferSize(), "send");
        this.theSocket.setSoTimeout(handshakeTimeout);
        this.out = this.theSocket.getOutputStream();
        this.in = this.theSocket.getInputStream();
        this.status = handshake.handshakeWithServer(this, location, communicationMode);
        this.commBuffer = ServerConnection.allocateCommBuffer(socketBufferSize, this.theSocket);
        if (sender != null) {
            this.commBufferForAsyncRead = ServerConnection.allocateCommBuffer(socketBufferSize, this.theSocket);
        }
        this.theSocket.setSoTimeout(readTimeout);
        this.endpoint = endpointManager.referenceEndpoint(location, this.status.getMemberId());
        this.connectFinished = true;
        this.endpoint.getStats().incConnections(1);
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean keepAlive) throws Exception {
        try {
            boolean sendCloseMsg;
            block8: {
                boolean bl = sendCloseMsg = !TEST_DURABLE_CLIENT_CRASH;
                if (sendCloseMsg) {
                    try {
                        this.ds.getDistributionManager();
                    }
                    catch (CancelException e) {
                        Throwable t = e.getCause();
                        if (!(t instanceof ForcedDisconnectException)) break block8;
                        sendCloseMsg = false;
                    }
                }
            }
            if (sendCloseMsg) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing connection {} with keepAlive: {}", (Object)this, (Object)keepAlive);
                }
                CloseConnectionOp.execute(this, keepAlive);
            }
        }
        finally {
            this.destroy();
        }
    }

    @Override
    public void emergencyClose() {
        this.commBuffer = null;
        try {
            this.theSocket.close();
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    @Override
    public void destroy() {
        block7: {
            if (!this.destroyed.compareAndSet(false, true)) {
                return;
            }
            if (this.endpoint != null) {
                if (this.connectFinished) {
                    this.endpoint.getStats().incConnections(-1);
                }
                this.endpoint.removeReference();
            }
            try {
                if (this.theSocket != null) {
                    if (!(this.theSocket instanceof SSLSocket)) {
                        this.theSocket.getOutputStream().flush();
                        this.theSocket.shutdownOutput();
                    }
                    this.theSocket.close();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        this.releaseCommBuffers();
    }

    private void releaseCommBuffers() {
        ByteBuffer bb = this.commBuffer;
        if (bb != null) {
            this.commBuffer = null;
            ServerConnection.releaseCommBuffer(bb);
        }
        if ((bb = this.commBufferForAsyncRead) != null) {
            this.commBufferForAsyncRead = null;
            ServerConnection.releaseCommBuffer(bb);
        }
    }

    @Override
    public ByteBuffer getCommBuffer() throws SocketException {
        if (this.isDestroyed()) {
            throw new SocketException("socket was closed");
        }
        return this.commBuffer;
    }

    @Override
    public ServerLocation getServer() {
        return this.endpoint.getLocation();
    }

    @Override
    public Socket getSocket() {
        return this.theSocket;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public ConnectionStats getStats() {
        return this.endpoint.getStats();
    }

    public String toString() {
        return "Connection[" + this.endpoint + "]@" + this.hashCode();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ServerQueueStatus getQueueStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Op op) throws Exception {
        Object result;
        if (op instanceof AbstractOp && ((AbstractOp)op).isGatewaySenderOp()) {
            Object result2 = op.attempt(this);
            this.endpoint.updateLastExecute();
            return result2;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (op instanceof ExecuteFunctionOp.ExecuteFunctionOpImpl || op instanceof ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl || op instanceof ExecuteRegionFunctionSingleHopOp.ExecuteRegionFunctionSingleHopOpImpl) {
                int earliertimeout = this.getSocket().getSoTimeout();
                this.getSocket().setSoTimeout(ConnectionImpl.getClientFunctionTimeout());
                try {
                    result = op.attempt(this);
                }
                finally {
                    this.getSocket().setSoTimeout(earliertimeout);
                }
            } else {
                result = op.attempt(this);
            }
        }
        this.endpoint.updateLastExecute();
        return result;
    }

    public static void loadEmergencyClasses() {
    }

    @Override
    public short getWanSiteVersion() {
        return this.wanSiteVersion;
    }

    @Override
    public void setWanSiteVersion(short wanSiteVersion) {
        this.wanSiteVersion = wanSiteVersion;
    }

    @Override
    public int getDistributedSystemId() {
        return this.ds.getDistributionManager().getDistributedSystemId();
    }

    @Override
    public void setConnectionID(long id) {
        this.connectionID = id;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    protected byte[] encryptBytes(byte[] messageBytes) throws Exception {
        return this.handshake.getEncryptor().encryptBytes(messageBytes);
    }

    protected byte[] decryptBytes(byte[] messageBytes) throws Exception {
        return this.handshake.getEncryptor().decryptBytes(messageBytes);
    }

    protected void setHandshake(ClientSideHandshake handshake) {
        this.handshake = handshake;
    }

    public static void setTEST_DURABLE_CLIENT_CRASH(boolean v) {
        TEST_DURABLE_CLIENT_CRASH = v;
    }

    public ByteBuffer getCommBufferForAsyncRead() throws SocketException {
        if (this.isDestroyed()) {
            throw new SocketException("socket was closed");
        }
        return this.commBufferForAsyncRead;
    }

    private void verifySocketBufferSize(int requestedBufferSize, int actualBufferSize, String type) {
        if (actualBufferSize < requestedBufferSize) {
            logger.info("Socket {} buffer size is {} instead of the requested {}.", new Object[]{type, actualBufferSize, requestedBufferSize});
        }
    }
}

