/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.util.Hex;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxSerializationException;
import org.apache.geode.pdx.WritablePdxInstance;
import org.apache.geode.pdx.internal.DefaultPdxField;
import org.apache.geode.pdx.internal.InternalPdxInstance;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxInputStream;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxReaderImpl;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxUnreadData;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.pdx.internal.WritablePdxInstanceImpl;

public class PdxInstanceImpl
extends PdxReaderImpl
implements InternalPdxInstance {
    private static final long serialVersionUID = -1669268527103938431L;
    private static final boolean USE_STATIC_MAPPER = Boolean.getBoolean("PdxInstance.use-static-mapper");
    @Immutable
    private static final ObjectMapper mapper = USE_STATIC_MAPPER ? PdxInstanceImpl.createObjectMapper() : null;
    private volatile transient Object cachedObjectForm;
    private static final int UNUSED_HASH_CODE = 0;
    private volatile transient int cachedHashCode = 0;
    private static final ThreadLocal<Boolean> pdxGetObjectInProgress = new ThreadLocal();

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("MM/dd/yyyy"));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return mapper;
    }

    public PdxInstanceImpl(PdxType pdxType, DataInput in, int len) {
        super(pdxType, PdxInstanceImpl.createDis(in, len));
    }

    protected PdxInstanceImpl(PdxReaderImpl original) {
        super(original);
    }

    private static PdxInputStream createDis(DataInput in, int len) {
        PdxInputStream dis;
        if (in instanceof PdxInputStream) {
            dis = new PdxInputStream((ByteBufferInputStream)in, len);
            try {
                int bytesSkipped = in.skipBytes(len);
                for (int bytesRemaining = len - bytesSkipped; bytesRemaining > 0; --bytesRemaining) {
                    in.readByte();
                }
            }
            catch (IOException ex) {
                throw new PdxSerializationException("Could not deserialize PDX", ex);
            }
        }
        byte[] bytes = new byte[len];
        try {
            in.readFully(bytes);
        }
        catch (IOException ex) {
            throw new PdxSerializationException("Could not deserialize PDX", ex);
        }
        dis = new PdxInputStream(bytes);
        return dis;
    }

    public static boolean getPdxReadSerialized() {
        return pdxGetObjectInProgress.get() == null;
    }

    public static void setPdxReadSerialized(boolean readSerialized) {
        if (!readSerialized) {
            pdxGetObjectInProgress.set(true);
        } else {
            pdxGetObjectInProgress.remove();
        }
    }

    @Override
    public Object getField(String fieldName) {
        return this.getUnmodifiableReader(fieldName).readField(fieldName);
    }

    private PdxWriterImpl convertToTypeWithNoDeletedFields(PdxReaderImpl ur) {
        PdxOutputStream os = new PdxOutputStream();
        PdxType pt = new PdxType(ur.getPdxType().getClassName(), !ur.getPdxType().getNoDomainClass());
        GemFireCacheImpl cache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        TypeRegistry tr = cache.getPdxRegistry();
        PdxWriterImpl writer = new PdxWriterImpl(pt, tr, os);
        for (PdxField field : pt.getFields()) {
            if (field.isDeleted()) continue;
            writer.writeRawField(field, ur.getRaw(field));
        }
        writer.completeByteStreamGeneration();
        return writer;
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        PdxReaderImpl ur = this.getUnmodifiableReader();
        if (ur.getPdxType().getHasDeletedField()) {
            PdxWriterImpl writer = this.convertToTypeWithNoDeletedFields(ur);
            writer.sendTo(out);
        } else {
            out.write(DSCODE.PDX.toByte());
            out.writeInt(ur.basicSize());
            out.writeInt(ur.getPdxType().getTypeId());
            ur.basicSendTo(out);
        }
    }

    @Override
    public byte[] toBytes() {
        PdxReaderImpl ur = this.getUnmodifiableReader();
        if (ur.getPdxType().getHasDeletedField()) {
            PdxWriterImpl writer = this.convertToTypeWithNoDeletedFields(ur);
            return writer.toByteArray();
        }
        byte[] result = new byte[9 + ur.basicSize()];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.put(DSCODE.PDX.toByte());
        bb.putInt(ur.basicSize());
        bb.putInt(ur.getPdxType().getTypeId());
        ur.basicSendTo(bb);
        return result;
    }

    @Override
    public Object getCachedObject() {
        Object result = this.cachedObjectForm;
        if (result == null) {
            this.cachedObjectForm = result = this.getObject();
        }
        return result;
    }

    private String extractTypeMetaData() {
        Object type = this.getField("@type");
        if (type != null) {
            if (type instanceof String) {
                return (String)type;
            }
            throw new PdxSerializationException("Could not deserialize as invalid className found");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        if (this.getPdxType().getNoDomainClass()) {
            String className;
            if (this.getClassName().equals("__GEMFIRE_JSON") && StringUtils.isNotBlank((CharSequence)(className = this.extractTypeMetaData()))) {
                try {
                    String JSON = JSONFormatter.toJSON(this);
                    ObjectMapper objMapper = USE_STATIC_MAPPER ? mapper : PdxInstanceImpl.createObjectMapper();
                    Object classInstance = objMapper.readValue(JSON, ClassPathLoader.getLatest().forName(className));
                    return classInstance;
                }
                catch (Exception e) {
                    throw new PdxSerializationException("Could not deserialize as java class '" + className + "' could not be resolved", e);
                }
            }
            return this;
        }
        boolean wouldReadSerialized = PdxInstanceImpl.getPdxReadSerialized();
        if (!wouldReadSerialized) {
            return this.getUnmodifiableReader().basicGetObject();
        }
        PdxInstanceImpl.setPdxReadSerialized(false);
        try {
            Object object = this.getUnmodifiableReader().basicGetObject();
            return object;
        }
        finally {
            PdxInstanceImpl.setPdxReadSerialized(true);
        }
    }

    @Override
    public int hashCode() {
        int result;
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        PdxReaderImpl ur = this.getUnmodifiableReader();
        SortedSet<PdxField> fields = ur.getPdxType().getSortedIdentityFields();
        int hashCode = 1;
        block5: for (PdxField ft : fields) {
            switch (ft.getFieldType()) {
                case CHAR: 
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BOOLEAN_ARRAY: 
                case CHAR_ARRAY: 
                case BYTE_ARRAY: 
                case SHORT_ARRAY: 
                case INT_ARRAY: 
                case LONG_ARRAY: 
                case FLOAT_ARRAY: 
                case DOUBLE_ARRAY: 
                case STRING_ARRAY: 
                case ARRAY_OF_BYTE_ARRAYS: {
                    ByteBufferInputStream.ByteSource buffer = ur.getRaw(ft);
                    if (buffer.equals(ByteBufferInputStream.ByteSourceFactory.create(ft.getFieldType().getDefaultBytes()))) continue block5;
                    hashCode = hashCode * 31 + buffer.hashCode();
                    break;
                }
                case OBJECT_ARRAY: {
                    Object[] oArray = ur.readObjectArray(ft);
                    if (oArray == null) continue block5;
                    hashCode = hashCode * 31 + Arrays.deepHashCode(oArray);
                    break;
                }
                case OBJECT: {
                    Object objectValue = ur.readObject(ft);
                    if (objectValue == null) break;
                    if (objectValue.getClass().isArray()) {
                        Class<?> myComponentType = objectValue.getClass().getComponentType();
                        if (myComponentType.isPrimitive()) {
                            ByteBufferInputStream.ByteSource buffer = this.getRaw(ft);
                            hashCode = hashCode * 31 + buffer.hashCode();
                            break;
                        }
                        hashCode = hashCode * 31 + Arrays.deepHashCode((Object[])objectValue);
                        break;
                    }
                    hashCode = hashCode * 31 + objectValue.hashCode();
                    break;
                }
                default: {
                    throw new InternalGemFireException("Unhandled field type " + (Object)((Object)ft.getFieldType()));
                }
            }
        }
        this.cachedHashCode = result = hashCode == 0 ? hashCode + 1 : hashCode;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        SortedSet<PdxField> otherFields;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PdxInstanceImpl)) {
            return false;
        }
        PdxInstanceImpl other = (PdxInstanceImpl)obj;
        PdxReaderImpl ur2 = other.getUnmodifiableReader();
        PdxReaderImpl ur1 = this.getUnmodifiableReader();
        if (!ur1.getPdxType().getClassName().equals(ur2.getPdxType().getClassName())) {
            return false;
        }
        SortedSet<PdxField> myFields = ur1.getPdxType().getSortedIdentityFields();
        if (!myFields.equals(otherFields = ur2.getPdxType().getSortedIdentityFields())) {
            if (ur1.getPdxType().getClassName().isEmpty()) {
                return false;
            }
            myFields = new TreeSet<PdxField>(myFields);
            otherFields = new TreeSet<PdxField>(otherFields);
            PdxInstanceImpl.addDefaultFields(myFields, otherFields);
            PdxInstanceImpl.addDefaultFields(otherFields, myFields);
        }
        Iterator myFieldIterator = myFields.iterator();
        Iterator otherFieldIterator = otherFields.iterator();
        block5: while (myFieldIterator.hasNext()) {
            PdxField myType = (PdxField)myFieldIterator.next();
            PdxField otherType = (PdxField)otherFieldIterator.next();
            switch (myType.getFieldType()) {
                case CHAR: 
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BOOLEAN_ARRAY: 
                case CHAR_ARRAY: 
                case BYTE_ARRAY: 
                case SHORT_ARRAY: 
                case INT_ARRAY: 
                case LONG_ARRAY: 
                case FLOAT_ARRAY: 
                case DOUBLE_ARRAY: 
                case STRING_ARRAY: 
                case ARRAY_OF_BYTE_ARRAYS: {
                    ByteBufferInputStream.ByteSource otherBuffer;
                    ByteBufferInputStream.ByteSource myBuffer = ur1.getRaw(myType);
                    if (myBuffer.equals(otherBuffer = ur2.getRaw(otherType))) continue block5;
                    return false;
                }
                case OBJECT_ARRAY: {
                    Object[] otherArray;
                    Object[] myArray = ur1.readObjectArray(myType);
                    if (Arrays.deepEquals(myArray, otherArray = ur2.readObjectArray(otherType))) continue block5;
                    return false;
                }
                case OBJECT: {
                    Object otherObject;
                    Object myObject = ur1.readObject(myType);
                    if (myObject == (otherObject = ur2.readObject(otherType))) continue block5;
                    if (myObject == null) {
                        return false;
                    }
                    if (otherObject == null) {
                        return false;
                    }
                    if (myObject.getClass().isArray()) {
                        ByteBufferInputStream.ByteSource otherBuffer;
                        ByteBufferInputStream.ByteSource myBuffer;
                        Class<?> otherComponentType;
                        Class<?> myComponentType = myObject.getClass().getComponentType();
                        if (!myComponentType.equals(otherComponentType = otherObject.getClass().getComponentType())) {
                            return false;
                        }
                        if (!(myComponentType.isPrimitive() ? !(myBuffer = this.getRaw(myType)).equals(otherBuffer = other.getRaw(otherType)) : !Arrays.deepEquals((Object[])myObject, (Object[])otherObject))) continue block5;
                        return false;
                    }
                    if (myObject.equals(otherObject)) continue block5;
                    return false;
                }
                default: {
                    throw new InternalGemFireException("Unhandled field type " + (Object)((Object)myType.getFieldType()));
                }
            }
        }
        return true;
    }

    private static void addDefaultFields(SortedSet<PdxField> myFields, SortedSet<PdxField> otherFields) {
        for (PdxField f : otherFields) {
            if (myFields.contains(f)) continue;
            myFields.add(new DefaultPdxField(f));
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        PdxReaderImpl ur = this.getUnmodifiableReader();
        result.append("PDX[").append(ur.getPdxType().getTypeId()).append(",").append(ur.getPdxType().getClassName()).append("]{");
        boolean firstElement = true;
        for (PdxField fieldType : ur.getPdxType().getSortedIdentityFields()) {
            if (firstElement) {
                firstElement = false;
            } else {
                result.append(", ");
            }
            result.append(fieldType.getFieldName());
            result.append("=");
            try {
                Object value = ur.readField(fieldType.getFieldName());
                if (value instanceof byte[]) {
                    result.append(Hex.toHex((byte[])value));
                    continue;
                }
                if (value.getClass().isArray()) {
                    if (value instanceof short[]) {
                        result.append(Arrays.toString((short[])value));
                        continue;
                    }
                    if (value instanceof int[]) {
                        result.append(Arrays.toString((int[])value));
                        continue;
                    }
                    if (value instanceof long[]) {
                        result.append(Arrays.toString((long[])value));
                        continue;
                    }
                    if (value instanceof char[]) {
                        result.append(Arrays.toString((char[])value));
                        continue;
                    }
                    if (value instanceof float[]) {
                        result.append(Arrays.toString((float[])value));
                        continue;
                    }
                    if (value instanceof double[]) {
                        result.append(Arrays.toString((double[])value));
                        continue;
                    }
                    if (value instanceof boolean[]) {
                        result.append(Arrays.toString((boolean[])value));
                        continue;
                    }
                    result.append(Arrays.deepToString((Object[])value));
                    continue;
                }
                result.append(value);
            }
            catch (RuntimeException e) {
                result.append(e);
            }
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public List<String> getFieldNames() {
        return this.getPdxType().getFieldNames();
    }

    @Override
    PdxUnreadData getReadUnreadFieldsCalled() {
        return null;
    }

    protected void clearCachedState() {
        this.cachedHashCode = 0;
        this.cachedObjectForm = null;
    }

    @Override
    public WritablePdxInstance createWriter() {
        if (this.isEnum()) {
            throw new IllegalStateException("PdxInstances that are an enum can not be modified.");
        }
        return new WritablePdxInstanceImpl(this.getUnmodifiableReader());
    }

    protected PdxReaderImpl getUnmodifiableReader() {
        return this;
    }

    protected PdxReaderImpl getUnmodifiableReader(String fieldName) {
        return this;
    }

    @Override
    public synchronized String readString(String fieldName) {
        return super.readString(fieldName);
    }

    @Override
    public synchronized Object readObject(String fieldName) {
        return super.readObject(fieldName);
    }

    @Override
    public synchronized Object readObject(PdxField ft) {
        return super.readObject(ft);
    }

    @Override
    public synchronized char[] readCharArray(String fieldName) {
        return super.readCharArray(fieldName);
    }

    @Override
    public synchronized boolean[] readBooleanArray(String fieldName) {
        return super.readBooleanArray(fieldName);
    }

    @Override
    public synchronized byte[] readByteArray(String fieldName) {
        return super.readByteArray(fieldName);
    }

    @Override
    public synchronized short[] readShortArray(String fieldName) {
        return super.readShortArray(fieldName);
    }

    @Override
    public synchronized int[] readIntArray(String fieldName) {
        return super.readIntArray(fieldName);
    }

    @Override
    public synchronized long[] readLongArray(String fieldName) {
        return super.readLongArray(fieldName);
    }

    @Override
    public synchronized float[] readFloatArray(String fieldName) {
        return super.readFloatArray(fieldName);
    }

    @Override
    public synchronized double[] readDoubleArray(String fieldName) {
        return super.readDoubleArray(fieldName);
    }

    @Override
    public synchronized String[] readStringArray(String fieldName) {
        return super.readStringArray(fieldName);
    }

    @Override
    public synchronized Object[] readObjectArray(String fieldName) {
        return super.readObjectArray(fieldName);
    }

    @Override
    public synchronized Object[] readObjectArray(PdxField ft) {
        return super.readObjectArray(ft);
    }

    @Override
    public synchronized byte[][] readArrayOfByteArrays(String fieldName) {
        return super.readArrayOfByteArrays(fieldName);
    }

    @Override
    public synchronized Object readField(String fieldName) {
        return super.readField(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Object basicGetObject() {
        DMStats stats = InternalDataSerializer.getDMStats(null);
        long start = stats.startPdxInstanceDeserialization();
        try {
            Object object = super.basicGetObject();
            return object;
        }
        finally {
            stats.endPdxInstanceDeserialization(start);
        }
    }

    @Override
    protected synchronized ByteBufferInputStream.ByteSource getRaw(PdxField ft) {
        return super.getRaw(ft);
    }

    @Override
    protected synchronized void basicSendTo(DataOutput out) throws IOException {
        super.basicSendTo(out);
    }

    @Override
    protected synchronized void basicSendTo(ByteBuffer bb) {
        super.basicSendTo(bb);
    }

    @Override
    public String getClassName() {
        return this.getPdxType().getClassName();
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public Object getRawField(String fieldName) {
        return this.getUnmodifiableReader(fieldName).readRawField(fieldName);
    }

    @Override
    public boolean isDeserializable() {
        if (this.getClassName().equals("__GEMFIRE_JSON")) {
            return true;
        }
        return !this.getPdxType().getNoDomainClass();
    }
}

